/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.hyperedges;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.bdd.conversion.CifBddLocationPointerManager;
import org.eclipse.escet.cif.bdd.spec.CifBddDiscVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddInputVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddLocPtrVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.varorder.hyperedges.HyperEdgeCreator;
import org.eclipse.escet.cif.bdd.varorder.hyperedges.VariableCollector;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.LinearizeProduct;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.output.BlackHoleOutputProvider;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class LinearizedHyperEdgeCreator
extends HyperEdgeCreator {
    public LinearizedHyperEdgeCreator(Specification spec, List<CifBddVariable> variables) {
        super(spec, variables);
    }

    @Override
    public List<BitSet> getHyperEdges() {
        Specification spec = (Specification)EMFHelper.deepclone((EObject)this.getSpecification());
        new ElimStateEvtExclInvs(new BlackHoleOutputProvider().getWarnOutput()).transform(spec);
        List automata = (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list());
        Assert.check((!automata.isEmpty() ? 1 : 0) != 0);
        List alphabets = CifEventUtils.getAllAlphabets((List)automata, null);
        Set events = alphabets.stream().map(a -> Sets.union((Set[])new Set[]{a.syncAlphabet, a.sendAlphabet, a.recvAlphabet})).reduce((eventSet1, eventSet2) -> Sets.union((Set)eventSet1, (Set)eventSet2)).get();
        List<Automaton> lpAuts = automata.stream().filter(aut -> aut.getLocations().size() > 1).collect(Collectors.toList());
        CifBddLocationPointerManager locPtrManager = new CifBddLocationPointerManager(lpAuts);
        List linearizedEdges = Lists.list();
        LinearizeProduct.linearizeEdges((List)automata, (List)alphabets, (List)Lists.set2list((Set)events), (LocationPointerManager)locPtrManager, (boolean)false, (boolean)true, (List)linearizedEdges);
        VariableMapping varMap = new VariableMapping(this.getVariables());
        List hyperEdges = Lists.listc((int)linearizedEdges.size());
        for (Edge edge : linearizedEdges) {
            VariableCollector varCollector = new VariableCollector();
            Set<PositionObject> edgeVars = Sets.set();
            for (Expression guard : edge.getGuards()) {
                varCollector.collectCifVarObjs(guard, edgeVars);
            }
            for (Update update : edge.getUpdates()) {
                varCollector.collectCifVarObjs(update, edgeVars);
            }
            edgeVars = varMap.mapVars(edgeVars);
            this.addHyperEdge(edgeVars, hyperEdges);
        }
        return hyperEdges;
    }

    private static class VariableMapping {
        private Map<String, PositionObject> mapping = Maps.map();

        /*
         * WARNING - void declaration
         */
        private VariableMapping(List<CifBddVariable> cifBddVars) {
            this.mapping = Maps.mapc((int)cifBddVars.size());
            for (CifBddVariable cifBddVar : cifBddVars) {
                DiscVariable obj;
                CifBddVariable cifBddVariable = cifBddVar;
                if (cifBddVariable instanceof CifBddDiscVariable) {
                    void cifBddDiscVar;
                    CifBddDiscVariable cfr_ignored_0 = (CifBddDiscVariable)cifBddVariable;
                    CifBddDiscVariable cfr_ignored_1 = (CifBddDiscVariable)cifBddVariable;
                    obj = cifBddDiscVar.var;
                } else {
                    CifBddVariable cifBddVariable2 = cifBddVar;
                    if (cifBddVariable2 instanceof CifBddInputVariable) {
                        void cifBddInputVar;
                        CifBddInputVariable cfr_ignored_2 = (CifBddInputVariable)cifBddVariable2;
                        CifBddInputVariable cfr_ignored_3 = (CifBddInputVariable)cifBddVariable2;
                        obj = cifBddInputVar.var;
                    } else {
                        CifBddVariable cifBddVariable3 = cifBddVar;
                        if (cifBddVariable3 instanceof CifBddLocPtrVariable) {
                            void cifBddLocPtrVar;
                            CifBddLocPtrVariable cfr_ignored_4 = (CifBddLocPtrVariable)cifBddVariable3;
                            CifBddLocPtrVariable cfr_ignored_5 = (CifBddLocPtrVariable)cifBddVariable3;
                            obj = cifBddLocPtrVar.aut;
                        } else {
                            throw new RuntimeException("Unknown CIF/BDD variable: " + String.valueOf(cifBddVar));
                        }
                    }
                }
                PositionObject prev = this.mapping.put(cifBddVar.rawName, (PositionObject)obj);
                Assert.check((prev == null ? 1 : 0) != 0);
            }
        }

        private Set<PositionObject> mapVars(Set<PositionObject> vars) {
            return vars.stream().map(v -> this.mapVar((PositionObject)v)).collect(Collectors.toCollection(() -> Sets.set()));
        }

        private PositionObject mapVar(PositionObject var) {
            String name = CifTextUtils.getAbsName((PositionObject)var, (boolean)false);
            PositionObject mappedVar = this.mapping.get(name);
            Assert.notNull((Object)mappedVar, (Object)name);
            return mappedVar;
        }
    }
}

