/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEvent;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIf;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIfEntry;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventSingle;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public abstract class SvgCodeGen {
    public static Set<Event> getSvgInEvents(List<SvgIn> svgIns, List<Event> events) {
        Set svgInEvents = Sets.set();
        for (SvgIn svgIn : svgIns) {
            SvgInEvent event = svgIn.getEvent();
            if (event == null) continue;
            if (event instanceof SvgInEventSingle) {
                SvgInEventSingle singleEvt = (SvgInEventSingle)event;
                Event evt = ((EventExpression)singleEvt.getEvent()).getEvent();
                svgInEvents.add(evt);
                continue;
            }
            if (event instanceof SvgInEventIf) {
                SvgInEventIf ifEvent = (SvgInEventIf)event;
                for (SvgInEventIfEntry entry : ifEvent.getEntries()) {
                    Event evt = ((EventExpression)entry.getEvent()).getEvent();
                    svgInEvents.add(evt);
                }
                continue;
            }
            throw new RuntimeException("Unknown SVG input mapping event: " + String.valueOf(event));
        }
        return svgInEvents;
    }

    /*
     * WARNING - void declaration
     */
    public static CifSvgDecls filterAndGroup(List<IoDecl> svgDecls, String svgAbsPath, Map<String, String> svgPathsRelToAbs) {
        CifSvgDecls cifSvgDecls = new CifSvgDecls();
        for (IoDecl ioDecl : svgDecls) {
            IoDecl ioDecl2 = ioDecl;
            if (ioDecl2 instanceof SvgCopy) {
                void svgCopy;
                SvgCopy cfr_ignored_0 = (SvgCopy)ioDecl2;
                SvgCopy cfr_ignored_1 = (SvgCopy)ioDecl2;
                if (!svgAbsPath.equals(svgPathsRelToAbs.get(svgCopy.getSvgFile().getPath()))) continue;
                cifSvgDecls.svgCopies.add((SvgCopy)svgCopy);
                continue;
            }
            IoDecl ioDecl3 = ioDecl;
            if (ioDecl3 instanceof SvgMove) {
                void svgMove;
                SvgMove cfr_ignored_2 = (SvgMove)ioDecl3;
                SvgMove cfr_ignored_3 = (SvgMove)ioDecl3;
                if (!svgAbsPath.equals(svgPathsRelToAbs.get(svgMove.getSvgFile().getPath()))) continue;
                cifSvgDecls.svgMoves.add((SvgMove)svgMove);
                continue;
            }
            IoDecl ioDecl4 = ioDecl;
            if (ioDecl4 instanceof SvgOut) {
                void svgOut;
                SvgOut cfr_ignored_4 = (SvgOut)ioDecl4;
                SvgOut cfr_ignored_5 = (SvgOut)ioDecl4;
                if (!svgAbsPath.equals(svgPathsRelToAbs.get(svgOut.getSvgFile().getPath()))) continue;
                cifSvgDecls.svgOuts.add((SvgOut)svgOut);
                continue;
            }
            IoDecl ioDecl5 = ioDecl;
            if (ioDecl5 instanceof SvgIn) {
                void svgIn;
                SvgIn cfr_ignored_6 = (SvgIn)ioDecl5;
                SvgIn cfr_ignored_7 = (SvgIn)ioDecl5;
                if (!svgAbsPath.equals(svgPathsRelToAbs.get(svgIn.getSvgFile().getPath()))) continue;
                cifSvgDecls.svgIns.add((SvgIn)svgIn);
                continue;
            }
            throw new RuntimeException("Unexpected CIF/SVG declaration: " + String.valueOf(ioDecl));
        }
        return cifSvgDecls;
    }

    protected static String evalSvgStringExpr(Expression expr) {
        try {
            return (String)CifEvalUtils.eval((Expression)expr, (boolean)false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
    }

    protected static double evalSvgNumberExpr(Expression expr) {
        try {
            Object rslt = CifEvalUtils.eval((Expression)expr, (boolean)false);
            if (rslt instanceof Integer) {
                return ((Integer)rslt).intValue();
            }
            if (rslt instanceof Double) {
                return (Double)rslt;
            }
            throw new RuntimeException("Number expected: " + String.valueOf(rslt));
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CifSvgDecls {
        public final List<SvgCopy> svgCopies = Lists.list();
        public final List<SvgMove> svgMoves = Lists.list();
        public final List<SvgOut> svgOuts = Lists.list();
        public final List<SvgIn> svgIns = Lists.list();

        public int size() {
            return this.svgCopies.size() + this.svgMoves.size() + this.svgOuts.size() + this.svgIns.size();
        }
    }
}

