/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.typeinfos;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprProperties;
import org.eclipse.escet.cif.codegen.ExpressionAnalysisSupport;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.typeinfos.NegateOperation;
import org.eclipse.escet.cif.codegen.typeinfos.OrderingOperations;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.java.Assert;

public abstract class IntTypeInfo
extends TypeInfo
implements NegateOperation,
OrderingOperations {
    public IntTypeInfo(CifType cifType) {
        super(cifType);
    }

    @Override
    public String makeTypeName() {
        return "I";
    }

    @Override
    public ExprCode convertLessThan(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, this.getBinaryExpressionTemplate(BinaryOperator.LESS_THAN, ctxt), dest, ctxt);
    }

    @Override
    public ExprCode convertLessEqual(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, this.getBinaryExpressionTemplate(BinaryOperator.LESS_EQUAL, ctxt), dest, ctxt);
    }

    @Override
    public ExprCode convertGreaterEqual(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, this.getBinaryExpressionTemplate(BinaryOperator.GREATER_EQUAL, ctxt), dest, ctxt);
    }

    @Override
    public ExprCode convertGreaterThan(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, this.getBinaryExpressionTemplate(BinaryOperator.GREATER_THAN, ctxt), dest, ctxt);
    }

    public abstract ExprCode convertLiteral(String var1, Destination var2, CodeContext var3);

    public ExprCode convertAddition(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        EnumSet<ExprProperties> properties = ExpressionAnalysisSupport.typeIsRanged(expr.getType()) ? EnumSet.noneOf(ExprProperties.class) : EnumSet.of(ExprProperties.RANGE_FAILURE);
        return this.convertAddition(expr, properties, dest, ctxt);
    }

    protected abstract ExprCode convertAddition(BinaryExpression var1, EnumSet<ExprProperties> var2, Destination var3, CodeContext var4);

    public ExprCode convertSubtraction(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        EnumSet<ExprProperties> properties = ExpressionAnalysisSupport.typeIsRanged(expr.getType()) ? EnumSet.noneOf(ExprProperties.class) : EnumSet.of(ExprProperties.RANGE_FAILURE);
        return this.convertSubtraction(expr, properties, dest, ctxt);
    }

    protected abstract ExprCode convertSubtraction(BinaryExpression var1, EnumSet<ExprProperties> var2, Destination var3, CodeContext var4);

    public ExprCode convertMultiplication(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        EnumSet<ExprProperties> properties = ExpressionAnalysisSupport.typeIsRanged(expr.getType()) ? EnumSet.noneOf(ExprProperties.class) : EnumSet.of(ExprProperties.RANGE_FAILURE);
        return this.convertMultiplication(expr, properties, dest, ctxt);
    }

    protected abstract ExprCode convertMultiplication(BinaryExpression var1, EnumSet<ExprProperties> var2, Destination var3, CodeContext var4);

    public ExprCode convertDiv(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
        Assert.check((ltype instanceof IntType && rtype instanceof IntType && ExpressionAnalysisSupport.checkExprIntType((Expression)expr) ? 1 : 0) != 0);
        EnumSet<ExprProperties> properties = EnumSet.noneOf(ExprProperties.class);
        if (ExpressionAnalysisSupport.typeAllowsMinInt(ltype) && ExpressionAnalysisSupport.typeAllowsMinusOne(rtype)) {
            properties.add(ExprProperties.RANGE_FAILURE);
        }
        if (ExpressionAnalysisSupport.typeAllowsZero(rtype)) {
            properties.add(ExprProperties.ZERO_DIVIDE_FAILURE);
        }
        return this.convertDiv(expr, properties, dest, ctxt);
    }

    protected abstract ExprCode convertDiv(BinaryExpression var1, EnumSet<ExprProperties> var2, Destination var3, CodeContext var4);

    public ExprCode convertMod(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
        Assert.check((ExpressionAnalysisSupport.checkExprIntType(expr.getLeft()) && rtype instanceof IntType && ExpressionAnalysisSupport.checkExprIntType((Expression)expr) ? 1 : 0) != 0);
        EnumSet<ExprProperties> properties = EnumSet.noneOf(ExprProperties.class);
        if (ExpressionAnalysisSupport.typeAllowsZero(rtype)) {
            properties.add(ExprProperties.ZERO_DIVIDE_FAILURE);
        }
        return this.convertMod(expr, properties, dest, ctxt);
    }

    protected abstract ExprCode convertMod(BinaryExpression var1, EnumSet<ExprProperties> var2, Destination var3, CodeContext var4);

    @Override
    public ExprCode convertNegate(UnaryExpression expr, Destination dest, CodeContext ctxt) {
        CifType resType = CifTypeUtils.normalizeType((CifType)expr.getType());
        Assert.check((boolean)ExpressionAnalysisSupport.checkExprIntType((Expression)expr));
        EnumSet<ExprProperties> properties = EnumSet.noneOf(ExprProperties.class);
        if (ExpressionAnalysisSupport.typeAllowsMinInt(resType)) {
            properties.add(ExprProperties.RANGE_FAILURE);
        }
        return this.convertIntNegate(expr.getChild(), properties, dest, ctxt);
    }

    protected abstract ExprCode convertIntNegate(Expression var1, EnumSet<ExprProperties> var2, Destination var3, CodeContext var4);

    public ExprCode convertAbsStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        EnumSet<ExprProperties> properties = EnumSet.noneOf(ExprProperties.class);
        if (ExpressionAnalysisSupport.typeAllowsMinInt(expression.getType())) {
            properties.add(ExprProperties.RANGE_FAILURE);
        }
        return this.convertAbsStdLib(expression, properties, dest, ctxt);
    }

    protected abstract ExprCode convertAbsStdLib(Expression var1, EnumSet<ExprProperties> var2, Destination var3, CodeContext var4);

    public abstract ExprCode convertMaximumStdLib(List<Expression> var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertMinimumStdLib(List<Expression> var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertSignStdLib(Expression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertPowerStdLib(List<Expression> var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertCeilStdLib(Expression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertFloorStdLib(Expression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertRoundStdLib(Expression var1, Destination var2, CodeContext var3);
}

