/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import java.util.List;
import org.eclipse.escet.cif.common.CifControllerPropertiesAnnotationUtils;
import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.boundedresponse.BoundedResponseCheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.confluence.ConfluenceCheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.finiteresponse.FiniteResponseCheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.nonblockingundercontrol.NonBlockingUnderControlCheckConclusion;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Assert;

public class ControllerCheckerResult {
    public final BoundedResponseCheckConclusion boundedResponseConclusion;
    public final ConfluenceCheckConclusion confluenceConclusion;
    public final FiniteResponseCheckConclusion finiteResponseConclusion;
    public final NonBlockingUnderControlCheckConclusion nonBlockingUnderControlConclusion;

    /*
     * WARNING - void declaration
     */
    public ControllerCheckerResult(List<CheckConclusion> conclusions) {
        Object boundedResponseConclusion = null;
        Object confluenceConclusion = null;
        FiniteResponseCheckConclusion finiteResponseConclusion = null;
        Object nonBlockingUnderControlConclusion = null;
        for (CheckConclusion conclusion : conclusions) {
            CheckConclusion checkConclusion = conclusion;
            if (checkConclusion instanceof BoundedResponseCheckConclusion) {
                void brConclusion;
                BoundedResponseCheckConclusion cfr_ignored_0 = (BoundedResponseCheckConclusion)checkConclusion;
                BoundedResponseCheckConclusion cfr_ignored_1 = (BoundedResponseCheckConclusion)checkConclusion;
                Assert.check((boundedResponseConclusion == null ? 1 : 0) != 0);
                boundedResponseConclusion = brConclusion;
                continue;
            }
            CheckConclusion checkConclusion2 = conclusion;
            if (checkConclusion2 instanceof ConfluenceCheckConclusion) {
                void cConclusion;
                ConfluenceCheckConclusion cfr_ignored_2 = (ConfluenceCheckConclusion)checkConclusion2;
                ConfluenceCheckConclusion cfr_ignored_3 = (ConfluenceCheckConclusion)checkConclusion2;
                Assert.check((confluenceConclusion == null ? 1 : 0) != 0);
                confluenceConclusion = cConclusion;
                continue;
            }
            CheckConclusion checkConclusion3 = conclusion;
            if (checkConclusion3 instanceof FiniteResponseCheckConclusion) {
                void frConclusion;
                FiniteResponseCheckConclusion cfr_ignored_4 = (FiniteResponseCheckConclusion)checkConclusion3;
                FiniteResponseCheckConclusion cfr_ignored_5 = (FiniteResponseCheckConclusion)checkConclusion3;
                Assert.check((finiteResponseConclusion == null ? 1 : 0) != 0);
                finiteResponseConclusion = frConclusion;
                continue;
            }
            CheckConclusion checkConclusion4 = conclusion;
            if (checkConclusion4 instanceof NonBlockingUnderControlCheckConclusion) {
                void nbucConclusion;
                NonBlockingUnderControlCheckConclusion cfr_ignored_6 = (NonBlockingUnderControlCheckConclusion)checkConclusion4;
                NonBlockingUnderControlCheckConclusion cfr_ignored_7 = (NonBlockingUnderControlCheckConclusion)checkConclusion4;
                Assert.check((nonBlockingUnderControlConclusion == null ? 1 : 0) != 0);
                nonBlockingUnderControlConclusion = nbucConclusion;
                continue;
            }
            throw new RuntimeException("Unknown conclusion: " + String.valueOf(conclusion));
        }
        this.boundedResponseConclusion = boundedResponseConclusion;
        this.confluenceConclusion = confluenceConclusion;
        this.finiteResponseConclusion = finiteResponseConclusion;
        this.nonBlockingUnderControlConclusion = nonBlockingUnderControlConclusion;
        if (boundedResponseConclusion != null && finiteResponseConclusion != null && finiteResponseConclusion.propertyHolds()) {
            Assert.check((boolean)boundedResponseConclusion.controllablesBound.isBounded());
        }
    }

    public boolean noFailureFound() {
        boolean result = true;
        result &= this.boundedResponseConclusion == null || this.boundedResponseConclusion.propertyHolds();
        result &= this.confluenceConclusion == null || this.confluenceConclusion.propertyHolds();
        result &= this.finiteResponseConclusion == null || this.finiteResponseConclusion.propertyHolds();
        return result &= this.nonBlockingUnderControlConclusion == null || this.nonBlockingUnderControlConclusion.propertyHolds();
    }

    public void updateSpecification(Specification spec) {
        if (this.boundedResponseConclusion != null) {
            Integer unctrlBound = this.boundedResponseConclusion.propertyHolds() ? Integer.valueOf(this.boundedResponseConclusion.uncontrollablesBound.getBound()) : null;
            Integer ctrlBound = this.boundedResponseConclusion.propertyHolds() ? Integer.valueOf(this.boundedResponseConclusion.controllablesBound.getBound()) : null;
            CifControllerPropertiesAnnotationUtils.setBoundedResponse((Specification)spec, (Integer)unctrlBound, (Integer)ctrlBound);
        }
        if (this.confluenceConclusion != null) {
            CifControllerPropertiesAnnotationUtils.setConfluence((Specification)spec, (boolean)this.confluenceConclusion.propertyHolds());
        }
        if (this.finiteResponseConclusion != null) {
            CifControllerPropertiesAnnotationUtils.setFiniteResponse((Specification)spec, (boolean)this.finiteResponseConclusion.propertyHolds());
        }
        if (this.nonBlockingUnderControlConclusion != null) {
            CifControllerPropertiesAnnotationUtils.setNonBlockingUnderControl((Specification)spec, (boolean)this.nonBlockingUnderControlConclusion.propertyHolds());
        }
    }
}

