/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.output.BlackHoleOutputProvider;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.WarnOutput;

public class ControllerCheckerSettings {
    private boolean checkBoundedResponse = true;
    private boolean checkConfluence = true;
    private boolean checkFiniteResponse = true;
    private boolean checkNonBlockingUnderControl = true;
    private boolean printFiniteResponseControlLoops = true;
    private Termination termination = Termination.NEVER;
    private DebugNormalOutput normalOutput = new BlackHoleOutputProvider().getNormalOutput();
    private DebugNormalOutput debugOutput = new BlackHoleOutputProvider().getDebugOutput();
    private WarnOutput warnOutput = new BlackHoleOutputProvider().getWarnOutput();

    public boolean getCheckBoundedResponse() {
        return this.checkBoundedResponse;
    }

    public void setCheckBoundedResponse(boolean checkBoundedResponse) {
        this.checkBoundedResponse = checkBoundedResponse;
    }

    public boolean getCheckConfluence() {
        return this.checkConfluence;
    }

    public void setCheckConfluence(boolean checkConfluence) {
        this.checkConfluence = checkConfluence;
    }

    public boolean getCheckFiniteResponse() {
        return this.checkFiniteResponse;
    }

    public void setCheckFiniteResponse(boolean checkFiniteResponse) {
        this.checkFiniteResponse = checkFiniteResponse;
    }

    public boolean getCheckNonBlockingUnderControl() {
        return this.checkNonBlockingUnderControl;
    }

    public void setCheckNonBlockingUnderControl(boolean checkNonBlockingUnderControl) {
        this.checkNonBlockingUnderControl = checkNonBlockingUnderControl;
    }

    public boolean getPrintFiniteResponseControlLoops() {
        return this.printFiniteResponseControlLoops;
    }

    public void setPrintFiniteResponseControlLoops(boolean printFiniteResponseControlLoops) {
        this.printFiniteResponseControlLoops = printFiniteResponseControlLoops;
    }

    public Termination getTermination() {
        return this.termination;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public DebugNormalOutput getNormalOutput() {
        return this.normalOutput;
    }

    public void setNormalOutput(DebugNormalOutput normalOutput) {
        this.normalOutput = normalOutput;
    }

    public DebugNormalOutput getDebugOutput() {
        return this.debugOutput;
    }

    public void setDebugOutput(DebugNormalOutput debugOutput) {
        this.debugOutput = debugOutput;
    }

    public WarnOutput getWarnOutput() {
        return this.warnOutput;
    }

    public void setWarnOutput(WarnOutput warnOutput) {
        this.warnOutput = warnOutput;
    }

    public int getNumberOfChecksEnabled() {
        int result = 0;
        if (this.checkBoundedResponse) {
            ++result;
        }
        if (this.checkConfluence) {
            ++result;
        }
        if (this.checkFiniteResponse) {
            ++result;
        }
        if (this.checkNonBlockingUnderControl) {
            ++result;
        }
        return result;
    }

    public void check() {
        if (this.getNumberOfChecksEnabled() == 0) {
            throw new InvalidOptionException("No checks enabled. Enable one of the checks for the controller properties checker to check.");
        }
    }
}

