/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.boundedresponse;

import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.boundedresponse.Bound;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.WarnOutput;

public class BoundedResponseCheckConclusion
implements CheckConclusion {
    public final Bound uncontrollablesBound;
    public final Bound controllablesBound;

    public BoundedResponseCheckConclusion(Bound uncontrollablesBound, Bound controllablesBound) {
        this.uncontrollablesBound = uncontrollablesBound;
        this.controllablesBound = controllablesBound;
    }

    @Override
    public boolean propertyHolds() {
        return this.uncontrollablesBound.isBounded() && this.controllablesBound.isBounded();
    }

    @Override
    public boolean hasDetails() {
        return true;
    }

    @Override
    public void printResult(DebugNormalOutput out, WarnOutput warn) {
        int bound;
        if (!this.uncontrollablesBound.hasInitialState() || !this.controllablesBound.hasInitialState()) {
            warn.line("The specification cannot be initialized.");
        }
        if (this.propertyHolds()) {
            out.line("[OK] The specification has bounded response:");
        } else {
            out.line("[ERROR] The specification does NOT have bounded response:");
        }
        out.line();
        out.inc();
        if (this.uncontrollablesBound.isBounded()) {
            bound = this.uncontrollablesBound.getBound();
            if (bound == 0) {
                out.line("- No transitions are possible for uncontrollable events.");
            } else {
                out.line("- At most %,d iteration%s needed for the event loop for uncontrollable events.", new Object[]{bound, bound == 1 ? " is" : "s are"});
            }
        } else {
            out.line("- An infinite sequence of transitions is possible for uncontrollable events.");
        }
        if (this.controllablesBound.isBounded()) {
            bound = this.controllablesBound.getBound();
            if (bound == 0) {
                out.line("- No transitions are possible for controllable events.");
            } else {
                out.line("- At most %,d iteration%s needed for the event loop for controllable events.", new Object[]{bound, bound == 1 ? " is" : "s are"});
            }
        } else {
            out.line("- An infinite sequence of transitions is possible for controllable events.");
        }
        out.dec();
    }
}

