/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.confluence;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDVarSet;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.checks.ControllerCheckerBddBasedCheck;
import org.eclipse.escet.cif.controllercheck.checks.confluence.ConfluenceCheckConclusion;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ConfluenceCheck
extends ControllerCheckerBddBasedCheck<ConfluenceCheckConclusion> {
    private static final boolean DEBUG_GLOBAL = false;
    private static final boolean DEBUG_INDENPENCE = false;
    private static final boolean DEBUG_REVERSIBLE = false;
    private static final boolean DEBUG_UPDATE_EQUIVALENCE = false;
    public static final String PROPERTY_NAME = "confluence";

    @Override
    public String getPropertyName() {
        return PROPERTY_NAME;
    }

    @Override
    public ConfluenceCheckConclusion performCheck(CifBddSpec cifBddSpec) {
        Termination termination = cifBddSpec.settings.getTermination();
        DebugNormalOutput out = cifBddSpec.settings.getNormalOutput();
        DebugNormalOutput dbg = cifBddSpec.settings.getDebugOutput();
        List controllableEvents = Lists.set2list((Set)cifBddSpec.controllables);
        if (controllableEvents.isEmpty()) {
            dbg.line("No controllable events. Confluence trivially holds.");
            return new ConfluenceCheckConclusion(List.of());
        }
        BDD zeroToOldVarRelations = this.createZeroToOldVarsRelations(cifBddSpec);
        Map<Event, CifBddEdge> eventToEdge = cifBddSpec.eventEdges.entrySet().stream().collect(Collectors.toMap(e -> (Event)e.getKey(), e -> (CifBddEdge)Lists.single((List)((List)e.getValue()))));
        List mutualExclusives = Lists.list();
        List updateEquivalents = Lists.list();
        List independents = Lists.list();
        List skippables = Lists.list();
        List reversibles = Lists.list();
        List cannotProves = Lists.list();
        int i = 0;
        while (i < controllableEvents.size()) {
            Event event1 = (Event)controllableEvents.get(i);
            String evt1Name = CifTextUtils.getAbsName((PositionObject)event1);
            CifBddEdge edge1 = eventToEdge.get(event1);
            int j = i + 1;
            while (j < controllableEvents.size()) {
                Event event2 = (Event)controllableEvents.get(j);
                String evt2Name = CifTextUtils.getAbsName((PositionObject)event2);
                CifBddEdge edge2 = eventToEdge.get(event2);
                if (termination.isRequested()) {
                    return null;
                }
                BDD commonEnabledGuards = edge1.guard.and(edge2.guard);
                if (commonEnabledGuards.isZero()) {
                    mutualExclusives.add(this.makeSortedPair(evt1Name, evt2Name));
                } else {
                    if (termination.isRequested()) {
                        return null;
                    }
                    commonEnabledGuards = zeroToOldVarRelations.id().andWith(commonEnabledGuards);
                    if (termination.isRequested()) {
                        return null;
                    }
                    BDD commonEnabledZeroStates = commonEnabledGuards.exist(cifBddSpec.varSetOld);
                    if (termination.isRequested()) {
                        return null;
                    }
                    BDD event1Done = edge1.apply(commonEnabledGuards.id(), CifBddEdgeApplyDirection.FORWARD, null);
                    BDD event2Done = edge2.apply(commonEnabledGuards.id(), CifBddEdgeApplyDirection.FORWARD, null);
                    if (!event1Done.isZero() && event1Done.equals((Object)event2Done) && this.allStatesCovered(commonEnabledZeroStates, event1Done, cifBddSpec.varSetOld)) {
                        updateEquivalents.add(this.makeSortedPair(evt1Name, evt2Name));
                        commonEnabledGuards.free();
                        commonEnabledZeroStates.free();
                        event1Done.free();
                        event2Done.free();
                    } else {
                        if (termination.isRequested()) {
                            return null;
                        }
                        BDD event1Enabled2 = event1Done.and(edge2.guard);
                        BDD event12Done = event1Enabled2.isZero() ? cifBddSpec.factory.zero() : edge2.apply(event1Enabled2.id(), CifBddEdgeApplyDirection.FORWARD, null);
                        event1Enabled2.free();
                        if (termination.isRequested()) {
                            return null;
                        }
                        BDD event2Enabled1 = event2Done.and(edge1.guard);
                        BDD event21Done = event2Enabled1.isZero() ? cifBddSpec.factory.zero() : edge1.apply(event2Enabled1.id(), CifBddEdgeApplyDirection.FORWARD, null);
                        event2Enabled1.free();
                        if (!event12Done.isZero() && event12Done.equals((Object)event21Done) && this.allStatesCovered(commonEnabledZeroStates, event12Done, cifBddSpec.varSetOld)) {
                            independents.add(this.makeSortedPair(evt1Name, evt2Name));
                            commonEnabledGuards.free();
                            commonEnabledZeroStates.free();
                            event1Done.free();
                            event2Done.free();
                            event12Done.free();
                            event21Done.free();
                        } else {
                            if (termination.isRequested()) {
                                return null;
                            }
                            if (!event21Done.isZero() && event1Done.equals((Object)event21Done) && this.allStatesCovered(commonEnabledZeroStates, event1Done, cifBddSpec.varSetOld)) {
                                skippables.add(this.makeSortedPair(evt1Name, evt2Name));
                                commonEnabledGuards.free();
                                commonEnabledZeroStates.free();
                                event1Done.free();
                                event2Done.free();
                                event12Done.free();
                                event21Done.free();
                            } else {
                                if (termination.isRequested()) {
                                    return null;
                                }
                                if (!event12Done.isZero() && event2Done.equals((Object)event12Done) && this.allStatesCovered(commonEnabledZeroStates, event2Done, cifBddSpec.varSetOld)) {
                                    skippables.add(this.makeSortedPair(evt1Name, evt2Name));
                                    commonEnabledGuards.free();
                                    commonEnabledZeroStates.free();
                                    event1Done.free();
                                    event2Done.free();
                                    event12Done.free();
                                    event21Done.free();
                                } else {
                                    if (termination.isRequested()) {
                                        return null;
                                    }
                                    boolean foundReversible = false;
                                    int k = 0;
                                    while (k < controllableEvents.size()) {
                                        Event event3 = (Event)controllableEvents.get(k);
                                        if (event3 != event1 && event3 != event2) {
                                            if (termination.isRequested()) {
                                                return null;
                                            }
                                            String evt3Name = CifTextUtils.getAbsName((PositionObject)event3);
                                            CifBddEdge edge3 = eventToEdge.get(event3);
                                            if (!event21Done.isZero()) {
                                                BDD event21Enabled3 = event21Done.and(edge3.guard);
                                                BDD event213Done = event21Enabled3.isZero() ? cifBddSpec.factory.zero() : edge3.apply(event21Enabled3.id(), CifBddEdgeApplyDirection.FORWARD, null);
                                                event21Enabled3.free();
                                                if (!event213Done.isZero() && event213Done.equals((Object)event1Done) && this.allStatesCovered(commonEnabledZeroStates, event1Done, cifBddSpec.varSetOld)) {
                                                    foundReversible = true;
                                                    event213Done.free();
                                                    break;
                                                }
                                                event213Done.free();
                                            }
                                            if (termination.isRequested()) {
                                                return null;
                                            }
                                            if (!event12Done.isZero()) {
                                                BDD event12Enabled3 = event12Done.and(edge3.guard);
                                                BDD event123Done = event12Enabled3.isZero() ? cifBddSpec.factory.zero() : edge3.apply(event12Enabled3.id(), CifBddEdgeApplyDirection.FORWARD, null);
                                                event12Enabled3.free();
                                                if (!event123Done.isZero() && event123Done.equals((Object)event2Done) && this.allStatesCovered(commonEnabledZeroStates, event2Done, cifBddSpec.varSetOld)) {
                                                    foundReversible = true;
                                                    event123Done.free();
                                                    break;
                                                }
                                                event123Done.free();
                                            }
                                            if (termination.isRequested()) {
                                                return null;
                                            }
                                        }
                                        ++k;
                                    }
                                    commonEnabledGuards.free();
                                    commonEnabledZeroStates.free();
                                    event1Done.free();
                                    event2Done.free();
                                    event12Done.free();
                                    event21Done.free();
                                    if (foundReversible) {
                                        reversibles.add(this.makeSortedPair(evt1Name, evt2Name));
                                    } else {
                                        cannotProves.add(this.makeSortedPair(evt1Name, evt2Name));
                                    }
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (termination.isRequested()) {
            return null;
        }
        zeroToOldVarRelations.free();
        boolean needEmptyLine = false;
        needEmptyLine = this.dumpMatches(mutualExclusives, "Mutual exclusive event pairs", out, needEmptyLine);
        needEmptyLine = this.dumpMatches(updateEquivalents, "Update equivalent event pairs", out, needEmptyLine);
        needEmptyLine = this.dumpMatches(independents, "Independent event pairs", out, needEmptyLine);
        needEmptyLine = this.dumpMatches(skippables, "Skippable event pairs", out, needEmptyLine);
        needEmptyLine = this.dumpMatches(reversibles, "Reversible event pairs", out, needEmptyLine);
        if (mutualExclusives.isEmpty() && updateEquivalents.isEmpty() && independents.isEmpty() && skippables.isEmpty() && reversibles.isEmpty()) {
            dbg.line("No proven pairs.");
        }
        dbg.line();
        if (cannotProves.isEmpty()) {
            dbg.line("All pairs proven. Confluence holds.");
        } else {
            dbg.line("Some pairs unproven. Confluence may not hold.");
        }
        return new ConfluenceCheckConclusion(cannotProves);
    }

    private BDD createZeroToOldVarsRelations(CifBddSpec cifBddSpec) {
        Map domains0 = Maps.mapc((int)cifBddSpec.variables.length);
        CifBddVariable[] cifBddVariableArray = cifBddSpec.variables;
        int n = cifBddSpec.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CifBddVariable var = cifBddVariableArray[n2];
            BigInteger size = var.domain.size();
            BDDDomain domain0 = cifBddSpec.factory.extDomain(size);
            Assert.areEqual((Object)var.domain.varNum(), (Object)domain0.varNum());
            domains0.put(var, domain0);
            ++n2;
        }
        Assert.areEqual((Object)(cifBddSpec.factory.varNum() % 3), (Object)0);
        return domains0.entrySet().stream().map(entry -> ((CifBddVariable)entry.getKey()).domain.buildEquals((BDDDomain)entry.getValue())).reduce(cifBddSpec.factory.one(), BDD::andWith);
    }

    private boolean allStatesCovered(BDD commonEnabledZeroStates, BDD resultStates, BDDVarSet varSetOld) {
        BDD zeroResultStates = resultStates.exist(varSetOld);
        boolean result = commonEnabledZeroStates.equals((Object)zeroResultStates);
        zeroResultStates.free();
        return result;
    }

    private Pair<String, String> makeSortedPair(String evt1Name, String evt2Name) {
        if (Strings.SORTER.compare(evt1Name, evt2Name) < 0) {
            return new Pair((Object)evt1Name, (Object)evt2Name);
        }
        return new Pair((Object)evt2Name, (Object)evt1Name);
    }

    private boolean dumpMatches(List<Pair<String, String>> pairs, String reasonText, DebugNormalOutput out, boolean needEmptyLine) {
        if (pairs.isEmpty()) {
            return needEmptyLine;
        }
        pairs.sort(Comparator.comparing(p -> (String)p.left, Strings.SORTER).thenComparing(p -> (String)p.right, Strings.SORTER));
        if (needEmptyLine) {
            out.line();
        }
        out.line(reasonText + ":");
        out.inc();
        out.line(pairs.stream().map(Pair::toString).collect(Collectors.joining(", ")));
        out.dec();
        return true;
    }
}

