/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.ciftodmm;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class Labels {
    private static final String REQUIREMENT_GROUP_PREFIX = "RG";
    private static final String PLANT_GROUP_PREFIX = "PG";

    private Labels() {
    }

    public static Label makePlantGroupLabel(int n) {
        return new Label(PLANT_GROUP_PREFIX + Integer.toString(n + 1));
    }

    public static Label makeRequirementGroupLabel(int n) {
        return new Label(REQUIREMENT_GROUP_PREFIX + Integer.toString(n + 1));
    }

    /*
     * WARNING - void declaration
     */
    public static Label makeLabel(PositionObject element) {
        PositionObject positionObject = element;
        if (positionObject instanceof Automaton) {
            void aut;
            Automaton automaton = (Automaton)positionObject;
            Automaton cfr_ignored_0 = (Automaton)positionObject;
            return new AutomatonLabel((Automaton)aut);
        }
        PositionObject positionObject2 = element;
        if (positionObject2 instanceof Invariant) {
            void inv;
            Invariant invariant = (Invariant)positionObject2;
            Invariant cfr_ignored_1 = (Invariant)positionObject2;
            return new InvariantLabel((Invariant)inv);
        }
        PositionObject positionObject3 = element;
        if (positionObject3 instanceof InputVariable) {
            void inpVar;
            InputVariable inputVariable = (InputVariable)positionObject3;
            InputVariable cfr_ignored_2 = (InputVariable)positionObject3;
            return new InputVarLabel((InputVariable)inpVar);
        }
        PositionObject positionObject4 = element;
        if (positionObject4 instanceof DiscVariable) {
            void discVar;
            DiscVariable discVariable = (DiscVariable)positionObject4;
            DiscVariable cfr_ignored_3 = (DiscVariable)positionObject4;
            return new DiscVarLabel((DiscVariable)discVar);
        }
        PositionObject positionObject5 = element;
        if (positionObject5 instanceof Event) {
            void event;
            Event event2 = (Event)positionObject5;
            Event cfr_ignored_4 = (Event)positionObject5;
            return new EventLabel((Event)event);
        }
        PositionObject positionObject6 = element;
        if (positionObject6 instanceof Location) {
            void loc;
            Location location = (Location)positionObject6;
            Location cfr_ignored_5 = (Location)positionObject6;
            return new LocationLabel((Location)loc);
        }
        throw new AssertionError((Object)("Unexpected position object class encountered: " + String.valueOf(element)));
    }

    /*
     * WARNING - void declaration
     */
    public static PositionObject unwrapLabel(Label label) {
        Label label2 = label;
        if (label2 instanceof AutomatonLabel) {
            void autLabel;
            AutomatonLabel automatonLabel = (AutomatonLabel)label2;
            AutomatonLabel cfr_ignored_0 = (AutomatonLabel)label2;
            return autLabel.automaton;
        }
        Label label3 = label;
        if (label3 instanceof InvariantLabel) {
            void invLabel;
            InvariantLabel invariantLabel = (InvariantLabel)label3;
            InvariantLabel cfr_ignored_1 = (InvariantLabel)label3;
            return invLabel.invariant;
        }
        Label label4 = label;
        if (label4 instanceof InputVarLabel) {
            void inpVarLabel;
            InputVarLabel inputVarLabel = (InputVarLabel)label4;
            InputVarLabel cfr_ignored_2 = (InputVarLabel)label4;
            return inpVarLabel.inputVar;
        }
        Label label5 = label;
        if (label5 instanceof DiscVarLabel) {
            void discVarLabel;
            DiscVarLabel discVarLabel2 = (DiscVarLabel)label5;
            DiscVarLabel cfr_ignored_3 = (DiscVarLabel)label5;
            return discVarLabel.discVar;
        }
        Label label6 = label;
        if (label6 instanceof EventLabel) {
            void eventLabel;
            EventLabel eventLabel2 = (EventLabel)label6;
            EventLabel cfr_ignored_4 = (EventLabel)label6;
            return eventLabel.event;
        }
        Label label7 = label;
        if (label7 instanceof LocationLabel) {
            void locLabel;
            LocationLabel locationLabel = (LocationLabel)label7;
            LocationLabel cfr_ignored_5 = (LocationLabel)label7;
            return locLabel.location;
        }
        throw new AssertionError((Object)("Unexpected label class encountered: " + String.valueOf(label)));
    }

    public static class AutomatonLabel
    extends Label {
        public final Automaton automaton;

        public AutomatonLabel(Automaton automaton) {
            super(CifTextUtils.getAbsName((PositionObject)automaton, (boolean)false));
            this.automaton = automaton;
        }
    }

    public static class DiscVarLabel
    extends Label {
        public final DiscVariable discVar;

        public DiscVarLabel(DiscVariable discVar) {
            super(CifTextUtils.getAbsName((PositionObject)discVar, (boolean)false));
            this.discVar = discVar;
        }
    }

    public static class EventLabel
    extends Label {
        public final Event event;

        public EventLabel(Event event) {
            super(CifTextUtils.getAbsName((PositionObject)event, (boolean)false));
            this.event = event;
        }
    }

    public static class InputVarLabel
    extends Label {
        public final InputVariable inputVar;

        public InputVarLabel(InputVariable inputVar) {
            super(CifTextUtils.getAbsName((PositionObject)inputVar, (boolean)false));
            this.inputVar = inputVar;
        }
    }

    public static class InvariantLabel
    extends Label {
        public final Invariant invariant;

        public InvariantLabel(Invariant invariant) {
            super(invariant.getName() == null ? CifTextUtils.invToStr((Invariant)invariant, (boolean)true) : CifTextUtils.getAbsName((PositionObject)invariant, (boolean)false));
            this.invariant = invariant;
        }
    }

    public static class LocationLabel
    extends Label {
        public final Location location;

        public LocationLabel(Location location) {
            super(CifTextUtils.getLocationText1((Location)location));
            this.location = location;
        }
    }
}

