/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.generators.ContinuousVariablesGenerator;
import org.eclipse.escet.cif.plcgen.generators.DocumentingSupport;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcCodeStorage;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcRealLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcFuncApplStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultContinuousVariablesGenerator
implements ContinuousVariablesGenerator {
    private final PlcTarget target;
    private final Map<ContVariable, ContinuousVariablesGenerator.PlcTimerCodeGenerator> timers = Maps.map();

    public DefaultContinuousVariablesGenerator(PlcTarget target) {
        this.target = target;
    }

    @Override
    public void addVariable(ContVariable contVar) {
        CifDataProvider cifDataProvider = this.target.getCodeStorage().getExprGenerator().getScopeCifDataProvider();
        PlcTimerGen timerData = new PlcTimerGen(this.target, contVar, cifDataProvider.getAddressableForContvar(contVar, false));
        this.timers.put(contVar, timerData);
    }

    @Override
    public void process() {
        List<PlcStatement> updateContVarsRemainingTime = this.timers.values().stream().flatMap(timer -> timer.generateRemainingUpdate().stream()).toList();
        PlcCodeStorage codeStorage = this.target.getCodeStorage();
        if (!updateContVarsRemainingTime.isEmpty()) {
            codeStorage.storeUpdateContvarsRemainingTimeCode(updateContVarsRemainingTime);
        }
    }

    @Override
    public ContinuousVariablesGenerator.PlcTimerCodeGenerator getPlcTimerCodeGen(ContVariable cvar) {
        ContinuousVariablesGenerator.PlcTimerCodeGenerator timerCodegen = this.timers.get(cvar);
        Assert.notNull((Object)timerCodegen);
        return timerCodegen;
    }

    public static class PlcTimerGen
    implements ContinuousVariablesGenerator.PlcTimerCodeGenerator {
        private final PlcTarget target;
        private final PlcFunctionAppls plcFuncAppls;
        public final ContVariable contVar;
        public final PlcDataVariable tonVar;
        public final PlcVarExpression plcContVar;
        private final PlcBasicVariable presetVar;

        public PlcTimerGen(PlcTarget target, ContVariable contVar, PlcVarExpression plcContVar) {
            this.target = target;
            this.plcFuncAppls = new PlcFunctionAppls(target);
            this.contVar = contVar;
            this.plcContVar = plcContVar;
            NameGenerator nameGen = target.getNameGenerator();
            PlcCodeStorage codeStorage = target.getCodeStorage();
            String baseName = nameGen.generateGlobalNames(Set.of("ton_", "preset_"), (PositionObject)contVar);
            this.presetVar = codeStorage.addStateVariable("preset_" + baseName, PlcElementaryType.TIME_TYPE);
            String tonVarName = "ton_" + baseName;
            this.tonVar = new PlcDataVariable(target.getUsageVariableText(PlcVariablePurpose.TIMER_VAR, tonVarName), tonVarName, this.plcFuncAppls.getTonFuncBlockType(), null, null);
            codeStorage.addTimerVariable(this.tonVar);
        }

        @Override
        public List<PlcStatement> generateRemainingUpdate() {
            ExprGenerator exprGen = this.target.getCodeStorage().getExprGenerator();
            PlcBasicVariable v = exprGen.getTempVariable("curValue", PlcElementaryType.TIME_TYPE);
            PlcBasicVariable b = exprGen.getTempVariable("timeOut", PlcElementaryType.BOOL_TYPE);
            List statements = Lists.listc((int)3);
            statements.add(new PlcCommentLine(Strings.fmt((String)"Update remaining time of %s.", (Object[])new Object[]{DocumentingSupport.getDescription((PositionObject)this.contVar)})));
            List<PlcNamedValue> arguments = List.of(new PlcNamedValue("PT", new PlcVarExpression(this.presetVar, new PlcVarExpression.PlcProjection[0])), new PlcNamedValue("IN", new PlcBoolLiteral(true)), new PlcNamedValue("Q", new PlcVarExpression(b, new PlcVarExpression.PlcProjection[0])), new PlcNamedValue("ET", new PlcVarExpression(v, new PlcVarExpression.PlcProjection[0])));
            statements.add(new PlcFuncApplStatement(this.plcFuncAppls.funcBlockAppl(this.tonVar, arguments)));
            PlcExpression subExpr = this.plcFuncAppls.subtractFuncAppl(new PlcVarExpression(this.presetVar, new PlcVarExpression.PlcProjection[0]), new PlcVarExpression(v, new PlcVarExpression.PlcProjection[0]));
            subExpr = this.atLeast0(this.timeToReal(subExpr, (PlcElementaryType)this.plcContVar.type));
            PlcFuncAppl selExpr = this.plcFuncAppls.selFuncAppl(new PlcVarExpression(b, new PlcVarExpression.PlcProjection[0]), subExpr, this.target.makeStdReal("0.0"));
            statements.add(new PlcAssignmentStatement(this.plcContVar, (PlcExpression)selExpr));
            return statements;
        }

        @Override
        public List<PlcStatement> generateAssignPreset() {
            List statements = Lists.listc((int)4);
            statements.add(new PlcCommentLine("Reset timer of \"" + this.plcContVar.variable.varName + "\"."));
            statements.add(new PlcAssignmentStatement(this.presetVar, this.realToTime(this.plcContVar)));
            List<PlcNamedValue> arguments = List.of(new PlcNamedValue("PT", new PlcVarExpression(this.presetVar, new PlcVarExpression.PlcProjection[0])), new PlcNamedValue("IN", new PlcBoolLiteral(false)));
            statements.add(new PlcFuncApplStatement(this.plcFuncAppls.funcBlockAppl(this.tonVar, arguments)));
            arguments = List.of(new PlcNamedValue("PT", new PlcVarExpression(this.presetVar, new PlcVarExpression.PlcProjection[0])), new PlcNamedValue("IN", new PlcBoolLiteral(true)));
            statements.add(new PlcFuncApplStatement(this.plcFuncAppls.funcBlockAppl(this.tonVar, arguments)));
            return statements;
        }

        private PlcExpression timeToReal(PlcExpression timeMillis, PlcElementaryType destRealType) {
            PlcElementaryType maxIntType = (PlcElementaryType)Lists.last(this.target.getSupportedIntegerTypes());
            PlcFuncAppl intMillis = this.plcFuncAppls.castFunctionAppl(timeMillis, maxIntType);
            PlcFuncAppl realMillis = this.plcFuncAppls.castFunctionAppl(intMillis, destRealType);
            PlcRealLiteral real1000 = new PlcRealLiteral("1000.0", destRealType);
            return this.plcFuncAppls.divideFuncAppl(realMillis, real1000);
        }

        private PlcExpression realToTime(PlcExpression realSecs) {
            PlcElementaryType maxIntType = (PlcElementaryType)Lists.last(this.target.getSupportedIntegerTypes());
            PlcRealLiteral real1000 = new PlcRealLiteral("1000.0", realSecs.type);
            PlcFuncAppl realMillis = this.plcFuncAppls.multiplyFuncAppl(realSecs, real1000);
            PlcFuncAppl intMillis = this.plcFuncAppls.castFunctionAppl(realMillis, maxIntType);
            return this.plcFuncAppls.castFunctionAppl(intMillis, PlcElementaryType.TIME_TYPE);
        }

        private PlcExpression atLeast0(PlcExpression value) {
            if (PlcElementaryType.isRealType(value.type)) {
                PlcRealLiteral zero = new PlcRealLiteral("0.0", value.type);
                return this.plcFuncAppls.maxFuncAppl(value, zero);
            }
            throw new AssertionError((Object)("Unexpected type encountered: \"" + String.valueOf(value.type) + "\"."));
        }
    }
}

