/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.TypeEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcCodeStorage;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultTypeGenerator
implements TypeGenerator {
    private final PlcTarget target;
    private final PlcElementaryType standardIntType;
    private final PlcElementaryType standardRealType;
    private final ConvertEnums selectedEnumConversion;
    private final Map<TypeEqHashWrap, PlcStructType> structTypes = Maps.map();
    private final Map<EnumDecl, EnumDeclData> enumTypes = Maps.map();

    public DefaultTypeGenerator(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.standardIntType = target.getStdIntegerType();
        this.standardRealType = target.getStdRealType();
        this.selectedEnumConversion = target.getActualEnumerationsConversion();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PlcType convertType(CifType type) {
        if (type instanceof BoolType) {
            return PlcElementaryType.BOOL_TYPE;
        }
        if (type instanceof IntType) {
            return this.standardIntType;
        }
        if (type instanceof RealType) {
            return this.standardRealType;
        }
        CifType cifType = type;
        if (cifType instanceof TypeRef) {
            void typeRef;
            TypeRef typeRef2 = (TypeRef)cifType;
            TypeRef cfr_ignored_0 = (TypeRef)cifType;
            return this.convertType(typeRef.getType().getType());
        }
        CifType cifType2 = type;
        if (cifType2 instanceof TupleType) {
            void tupleType;
            TupleType tupleType2 = (TupleType)cifType2;
            TupleType cfr_ignored_1 = (TupleType)cifType2;
            return this.convertTupleType((TupleType)tupleType);
        }
        CifType cifType3 = type;
        if (cifType3 instanceof EnumType) {
            void enumType;
            EnumType enumType2 = (EnumType)cifType3;
            EnumType cfr_ignored_2 = (EnumType)cifType3;
            EnumDeclData declData = this.getOrCreateConvertedEnumDecl(enumType.getEnum());
            return declData.plcEnumType;
        }
        CifType cifType4 = type;
        if (cifType4 instanceof ListType) {
            void arrayType;
            ListType declData = (ListType)cifType4;
            ListType cfr_ignored_3 = (ListType)cifType4;
            int size = arrayType.getLower();
            Assert.check((boolean)CifTypeUtils.isArrayType((ListType)arrayType));
            Assert.check((!(arrayType.getElementType() instanceof ListType) ? 1 : 0) != 0);
            PlcType elemType = this.convertType(arrayType.getElementType());
            return new PlcArrayType(0, size == 0 ? 0 : size - 1, elemType);
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    @Override
    public PlcStructType convertTupleType(TupleType tupleType) {
        TypeEqHashWrap typeWrap = new TypeEqHashWrap((CifType)tupleType, true, false);
        PlcStructType structType = this.structTypes.get(typeWrap);
        if (structType == null) {
            structType = this.makePlcStructType(tupleType);
            this.structTypes.put(typeWrap, structType);
        }
        return structType;
    }

    /*
     * WARNING - void declaration
     */
    private PlcStructType makePlcStructType(TupleType tupleType) {
        String typeName;
        EList tupleFields = tupleType.getFields();
        List structFields = Lists.listc((int)tupleFields.size());
        int fieldNumber = 1;
        for (Field field : tupleFields) {
            String fieldName = "field" + String.valueOf(fieldNumber);
            PlcType ftype = this.convertType(field.getType());
            structFields.add(new PlcStructField(fieldName, ftype));
            ++fieldNumber;
        }
        EObject eObject = tupleType.eContainer();
        if (eObject instanceof TypeDecl) {
            void typeDecl;
            TypeDecl typeDecl2 = (TypeDecl)eObject;
            TypeDecl cfr_ignored_0 = (TypeDecl)eObject;
            structName = CifTextUtils.getAbsName((PositionObject)typeDecl, (boolean)false);
            typeName = this.target.getNameGenerator().generateGlobalName((String)structName, true);
        } else {
            structName = "TupleStruct" + tupleType.getFields().size();
            typeName = this.target.getNameGenerator().generateGlobalName((String)structName, false);
        }
        PlcStructType structType = new PlcStructType(typeName, structFields);
        this.target.getCodeStorage().addDeclaredType(structType);
        return structType;
    }

    @Override
    public void convertEnumDecl(EnumDecl enumDecl) {
        this.getOrCreateConvertedEnumDecl(enumDecl);
    }

    @Override
    public PlcExpression convertEnumLiteral(EnumLiteral enumLit) {
        EnumDecl enumDecl = (EnumDecl)enumLit.eContainer();
        EnumDeclData declData = this.getOrCreateConvertedEnumDecl(enumDecl);
        return declData.getLiteralValue(enumDecl.getLiterals().indexOf((Object)enumLit));
    }

    private EnumDeclData getOrCreateConvertedEnumDecl(EnumDecl enumDecl) {
        return this.enumTypes.computeIfAbsent(enumDecl, key -> switch (this.selectedEnumConversion) {
            case ConvertEnums.CONSTS -> this.convertToPlcConstants(enumDecl);
            case ConvertEnums.INTS -> this.convertToPlcIntegers(enumDecl);
            case ConvertEnums.KEEP -> this.convertToPlcEnumType(enumDecl);
            default -> throw new AssertionError((Object)("Unexpected enumeration conversion \"" + String.valueOf((Object)this.selectedEnumConversion) + "\" found."));
        });
    }

    private EnumDeclData convertToPlcEnumType(EnumDecl enumDecl) {
        NameGenerator nameGenerator = this.target.getNameGenerator();
        String typeName = nameGenerator.generateGlobalName((PositionObject)enumDecl);
        List<String> literalNames = enumDecl.getLiterals().stream().map(lit -> nameGenerator.generateGlobalName((PositionObject)lit)).toList();
        PlcEnumType plcEnumType = new PlcEnumType(typeName, literalNames);
        PlcExpression[] litValues = (PlcExpression[])plcEnumType.literals.toArray(PlcExpression[]::new);
        this.target.getCodeStorage().addDeclaredType(plcEnumType);
        return new EnumDeclData(plcEnumType, litValues);
    }

    private EnumDeclData convertToPlcConstants(EnumDecl enumDecl) {
        NameGenerator nameGenerator = this.target.getNameGenerator();
        PlcCodeStorage codeStorage = this.target.getCodeStorage();
        int numLiterals = enumDecl.getLiterals().size();
        PlcElementaryType valueType = PlcElementaryType.getTypeByRequiredCount(numLiterals, this.target.getSupportedBitStringTypes());
        PlcExpression[] litValues = new PlcExpression[numLiterals];
        int idx = 0;
        while (idx < numLiterals) {
            String name = nameGenerator.generateGlobalName((PositionObject)enumDecl.getLiterals().get(idx));
            String targetText = this.target.getUsageVariableText(PlcVariablePurpose.CONSTANT, name);
            PlcDataVariable constVar = new PlcDataVariable(targetText, name, valueType, null, new PlcIntLiteral(idx, valueType));
            codeStorage.addConstant(constVar);
            litValues[idx] = new PlcVarExpression((PlcBasicVariable)constVar, new PlcVarExpression.PlcProjection[0]);
            ++idx;
        }
        return new EnumDeclData(valueType, litValues);
    }

    private EnumDeclData convertToPlcIntegers(EnumDecl enumDecl) {
        int numLiterals = enumDecl.getLiterals().size();
        PlcElementaryType valueType = PlcElementaryType.getTypeByRequiredCount(numLiterals, this.target.getSupportedBitStringTypes());
        PlcExpression[] litValues = (PlcExpression[])IntStream.range(0, numLiterals).mapToObj(idx -> new PlcIntLiteral(idx, valueType)).toArray(PlcExpression[]::new);
        return new EnumDeclData(valueType, litValues);
    }

    private static class EnumDeclData {
        public final PlcType plcEnumType;
        private final PlcExpression[] literalValues;

        private EnumDeclData(PlcType plcEnumType, PlcExpression[] literalValues) {
            this.plcEnumType = plcEnumType;
            this.literalValues = literalValues;
        }

        public PlcExpression getLiteralValue(int litIndex) {
            return this.literalValues[litIndex];
        }
    }
}

