/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.model;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.input.AutomaticInputComponent;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.InputComponent;
import org.eclipse.escet.cif.simulator.input.InteractiveConsoleInputComponent;
import org.eclipse.escet.cif.simulator.input.InteractiveGuiInputComponent;
import org.eclipse.escet.cif.simulator.input.SvgInputComponent;
import org.eclipse.escet.cif.simulator.input.trace.TraceInputComponent;
import org.eclipse.escet.cif.simulator.options.CompleteModeOption;
import org.eclipse.escet.cif.simulator.options.DistributionSeedOption;
import org.eclipse.escet.cif.simulator.options.EnvironmentEventsOption;
import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.cif.simulator.options.InputMode;
import org.eclipse.escet.cif.simulator.options.InputModeOption;
import org.eclipse.escet.cif.simulator.options.MaxTimePointTolOption;
import org.eclipse.escet.cif.simulator.output.DebugOutputType;
import org.eclipse.escet.cif.simulator.output.NormalOutputOption;
import org.eclipse.escet.cif.simulator.output.NormalOutputType;
import org.eclipse.escet.cif.simulator.output.print.RuntimePrintDecls;
import org.eclipse.escet.cif.simulator.output.svgviz.RuntimeCifSvgDecls;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeAutomaton;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEdge;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEvent;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeReceiveEdge;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSendEdge;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSyncEdge;
import org.eclipse.escet.cif.simulator.runtime.ode.OdeSolver;
import org.eclipse.escet.cif.simulator.runtime.ode.OdeStateEvent;
import org.eclipse.escet.cif.simulator.runtime.ode.Trajectories;
import org.eclipse.escet.cif.simulator.runtime.transitions.ActualTargetTime;
import org.eclipse.escet.cif.simulator.runtime.transitions.CommunicationTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;

public abstract class RuntimeSpec<S extends RuntimeState> {
    public ClassLoader resourceClassLoader;
    public final InputComponent<S> input;
    public final boolean complete;
    private final Double modelTimeDelta;
    public CifSimulatorContext ctxt;
    public final int maxTimePointTol;
    public final List<RuntimeAutomaton<S>> automata = Lists.list();
    public final List<RuntimeStateObjectMeta> stateObjectsMeta = Lists.list();
    public final List<RuntimeEvent<S>> events = Lists.list();
    public final List<List<List<RuntimeEdge<S>>>> syncData = Lists.list();
    public final List<List<RuntimeEdge<S>>> sendData = Lists.list();
    public final List<List<RuntimeEdge<S>>> recvData = Lists.list();
    public final List<List<RuntimeEdge<S>>> tauData = Lists.list();
    public final List<Transition<S>> transitions = Lists.listc((int)32);
    public boolean[] channels;
    public boolean[] urgent;
    public boolean[] disabledEvents;
    private Integer seed;

    public RuntimeSpec() {
        InputMode imode = InputModeOption.getInputMode();
        switch (imode) {
            case AUTO: {
                this.input = new AutomaticInputComponent(this);
                break;
            }
            case TRACE: {
                this.input = new TraceInputComponent(this);
                break;
            }
            case CONSOLE: {
                AppStreams streams = AppEnv.getStreams();
                this.input = new InteractiveConsoleInputComponent(this, streams);
                break;
            }
            case GUI: {
                this.input = new InteractiveGuiInputComponent(this);
                break;
            }
            case SVG: {
                this.input = new SvgInputComponent(this);
                break;
            }
            default: {
                throw new RuntimeException("Unknown input mode: " + String.valueOf((Object)imode));
            }
        }
        this.complete = CompleteModeOption.isEnabled();
        this.modelTimeDelta = FrameRateOption.getModelTimeDelta();
        this.seed = DistributionSeedOption.getInitialSeed();
        this.maxTimePointTol = MaxTimePointTolOption.getMaxTimePointTol();
        AppEnv.setProperty((String)"org.eclipse.escet.cif.simulator.distributions.seed", (String)(this.seed == null ? "n/a" : this.seed.toString()));
    }

    public void init(CifSimulatorContext ctxt) {
        this.ctxt = ctxt;
        OdeSolver<S> solver = this.getOdeSolver();
        solver.ctxt = ctxt;
        solver.debug = ctxt.debug.contains((Object)DebugOutputType.ODE);
        solver.dbg = solver.debug ? ctxt.appEnvData.getStreams().out : null;
        this.initEvents();
        Assert.check((boolean)((RuntimeEvent)Lists.last(this.events)).isTauEvent);
        this.initEventData();
        Assert.check((this.syncData.size() == this.events.size() - 1 ? 1 : 0) != 0);
        Assert.check((this.sendData.size() == this.events.size() - 1 ? 1 : 0) != 0);
        Assert.check((this.recvData.size() == this.events.size() - 1 ? 1 : 0) != 0);
        this.channels = new boolean[this.events.size()];
        int i = 0;
        while (i < this.sendData.size()) {
            this.channels[i] = this.sendData.get(i) != null;
            ++i;
        }
        this.channels[this.channels.length - 1] = false;
        this.urgent = EnvironmentEventsOption.getUrgentEvents(this);
        this.disabledEvents = new boolean[this.events.size()];
        this.initAutomata();
        this.initStateObjectsMeta();
        Collections.sort(this.stateObjectsMeta, RuntimeStateObjectMeta.SORTER);
        RuntimeStateObjectMeta timeObjMeta = new RuntimeStateObjectMeta(0, StateObjectType.TIME, "time");
        this.stateObjectsMeta.add(0, timeObjMeta);
        this.input.init();
    }

    public int getNextSeed() {
        if (this.seed == null) {
            this.seed = new Random().nextInt(0x40000000) + 1;
            if (NormalOutputOption.doPrint(NormalOutputType.SEEDS)) {
                OutputProvider.out((String)"Using seed %d for the first random generator for a stochastic distribution.", (Object[])new Object[]{this.seed});
            }
            AppEnv.setProperty((String)"org.eclipse.escet.cif.simulator.distributions.seed", (String)this.seed.toString());
        }
        int rslt = this.seed;
        this.seed = this.seed + 1;
        if (this.seed > 0x40000000) {
            this.seed = 1;
        }
        return rslt;
    }

    protected abstract void initAutomata();

    protected abstract void initStateObjectsMeta();

    protected abstract void initEvents();

    protected abstract void initEventData();

    public abstract S createInitialState(RuntimeSpec<?> var1);

    protected abstract S copyState(S var1);

    public abstract boolean hasTauEdge();

    protected abstract boolean evalInitPreds(S var1);

    protected abstract boolean evalStateInvPreds(S var1, boolean var2);

    protected abstract boolean evalUrgLocs(S var1);

    protected abstract boolean evalUrgEdges(S var1);

    protected abstract List<OdeStateEvent<S>> getOdeStateEvents(S var1);

    public abstract OdeSolver<S> getOdeSolver();

    public abstract List<RuntimeCifSvgDecls> getCifSvgDecls();

    public abstract List<RuntimePrintDecls> getPrintDecls();

    public void calcTransitions(S source, Double endTime, Double maxDelay) {
        this.transitions.clear();
        this.input.updateDisabledEvents(source, this.disabledEvents);
        boolean timeAllowed = true;
        int eventIdx = 0;
        while (eventIdx < this.events.size()) {
            this.ctxt.checkTermination();
            if (!this.disabledEvents[eventIdx]) {
                boolean anyTransitions = this.calcEventTransitions(source, eventIdx);
                if (anyTransitions && this.urgent[eventIdx]) {
                    timeAllowed = false;
                }
                if (anyTransitions && !this.complete) {
                    return;
                }
            }
            ++eventIdx;
        }
        if (timeAllowed) {
            this.calcTimeTransition(source, endTime, maxDelay);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean calcEventTransitions(S source, int eventIdx) {
        Object iter;
        RuntimeEvent<S> event = this.events.get(eventIdx);
        boolean proceed = event.fillData(source);
        if (!proceed) {
            return false;
        }
        proceed = event.allowedByInvs(source);
        if (!proceed) {
            return false;
        }
        boolean isChannel = this.channels[eventIdx];
        if (event.isTauEvent) {
            iter = this.tauData.iterator();
        } else if (isChannel) {
            List<List<RuntimeEdge<S>>> syncs = this.syncData.get(eventIdx);
            List<RuntimeEdge<S>> sends = this.sendData.get(eventIdx);
            List<RuntimeEdge<S>> recvs = this.recvData.get(eventIdx);
            int count = sends.size() * recvs.size();
            for (List<RuntimeEdge<S>> list : syncs) {
                count *= list.size();
            }
            Assert.check((count > 0 ? 1 : 0) != 0);
            if (count == 1) {
                List list = Lists.listc((int)(syncs.size() + 2));
                list.add((RuntimeEdge)Lists.first(sends));
                list.add((RuntimeEdge)Lists.first(recvs));
                for (List<RuntimeEdge<S>> edgeList : syncs) {
                    list.add((RuntimeEdge)Lists.first(edgeList));
                }
                iter = Lists.list((Object)list).iterator();
            } else {
                List list = Lists.listc((int)(syncs.size() + 2));
                list.add(sends);
                list.add(recvs);
                list.addAll(syncs);
                iter = new ListProductIterator(list);
            }
        } else {
            List<List<RuntimeEdge<S>>> data = this.syncData.get(eventIdx);
            int count = 1;
            for (List<RuntimeEdge<S>> edges : data) {
                count *= edges.size();
            }
            Assert.check((count > 0 ? 1 : 0) != 0);
            if (count == 1) {
                void var11_24;
                int autCount = data.size();
                List edges = Lists.listc((int)autCount);
                boolean bl = false;
                while (var11_24 < autCount) {
                    edges.add((RuntimeEdge)Lists.first(data.get((int)var11_24)));
                    ++var11_24;
                }
                iter = Lists.list((Object)edges).iterator();
            } else {
                iter = new ListProductIterator(data);
            }
        }
        boolean anyTransitions = false;
        while (iter.hasNext()) {
            void var11_27;
            this.ctxt.checkTermination();
            List<RuntimeEdge<S>> edges = iter.next();
            S target = this.copyState(source);
            Object sendValue = null;
            boolean bl = false;
            if (isChannel) {
                RuntimeSendEdge sndEdge = (RuntimeSendEdge)edges.get(0);
                RuntimeReceiveEdge rcvEdge = (RuntimeReceiveEdge)edges.get(1);
                this.ctxt.checkTermination();
                sendValue = sndEdge.evalSendValue(source);
                sndEdge.update(source, target);
                rcvEdge.update(source, target, sendValue);
                int n = 2;
            }
            while (var11_27 < edges.size()) {
                RuntimeSyncEdge syncEdge = (RuntimeSyncEdge)edges.get((int)var11_27);
                this.ctxt.checkTermination();
                syncEdge.update(source, target);
                ++var11_27;
            }
            boolean invs = this.evalStateInvPreds(target, false);
            if (!invs) continue;
            EventTransition trans = isChannel ? new CommunicationTransition<S>(source, event, target, sendValue) : new EventTransition(source, event, target);
            this.transitions.add(trans);
            anyTransitions = true;
            if (this.complete) continue;
            return true;
        }
        return anyTransitions;
    }

    public void calcTimeTransition(S source, Double endTime, Double maxDelay) {
        double maxTime;
        if (maxDelay != null && maxDelay == 0.0) {
            return;
        }
        if (this.evalUrgLocs(source)) {
            return;
        }
        if (this.evalUrgEdges(source)) {
            return;
        }
        OdeSolver<S> solver = this.getOdeSolver();
        List<OdeStateEvent<S>> events = this.getOdeStateEvents(source);
        if (endTime == null && maxDelay == null) {
            maxTime = ((RuntimeState)source).getTime() + 100.0;
        } else if (endTime == null && maxDelay != null) {
            maxTime = ((RuntimeState)source).getTime() + maxDelay;
        } else if (endTime != null && maxDelay == null) {
            maxTime = endTime;
        } else if (endTime != null && maxDelay != null) {
            maxTime = ((RuntimeState)source).getTime() + maxDelay;
            if (endTime < maxTime) {
                maxTime = endTime;
            }
        } else {
            throw new RuntimeException();
        }
        if (Double.isInfinite(maxTime)) {
            String msg = "The maximum end time for the next time transition is \"+inf\", which is not supported. This indicates an overflow. It might be possible to prevent this by setting a shorter maximum delay for time transitions.";
            throw new UnsupportedException(msg);
        }
        Trajectories trajectories = solver.solveIVP(source, events, maxTime);
        if (trajectories == null) {
            return;
        }
        TimeTransition<S> trans = new TimeTransition<S>(this, source, trajectories);
        this.transitions.add(trans);
    }

    public ActualTargetTime takeTimeTransition(TimeTransition<S> transition, ChosenTargetTime chosenTargetTime) {
        if (this.modelTimeDelta == null) {
            return new ActualTargetTime(chosenTargetTime);
        }
        double startTime = transition.source.getTime();
        double endTime = chosenTargetTime.targetTime;
        double modelDelta = this.modelTimeDelta;
        double nextTime = FastMath.floor((double)(startTime / modelDelta)) + 1.0;
        if (Precision.equals((double)(nextTime *= modelDelta), (double)startTime, (int)1)) {
            nextTime += modelDelta;
        }
        while (true) {
            this.ctxt.checkTermination();
            if (this.ctxt.realTime && !this.ctxt.testMode && !this.ctxt.provider.supportsRealTimeSimulation()) {
                throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
            }
            if (nextTime >= endTime) {
                return new ActualTargetTime(chosenTargetTime);
            }
            S istate = transition.getTargetState(nextTime, true);
            if ((nextTime = ((RuntimeState)istate).getTime()) >= endTime) continue;
            this.ctxt.provider.intermediateTrajectoryState((RuntimeState)istate);
            if (this.input.interruptTimeTrans()) {
                return new ActualTargetTime(chosenTargetTime, nextTime);
            }
            nextTime += modelDelta;
        }
    }
}

