/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.automata.AAssignmentUpdate;
import org.eclipse.escet.cif.parser.ast.automata.AElifUpdate;
import org.eclipse.escet.cif.parser.ast.automata.AIfUpdate;
import org.eclipse.escet.cif.parser.ast.automata.AUpdate;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.ExprContext;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;

public class CifUpdateTypeChecker {
    private CifUpdateTypeChecker() {
    }

    public static Update typeCheckUpdate(AUpdate astUpdate, ParentScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        if (astUpdate instanceof AAssignmentUpdate) {
            return CifUpdateTypeChecker.typeCheckAssignment((AAssignmentUpdate)astUpdate, scope, context, tchecker);
        }
        if (astUpdate instanceof AIfUpdate) {
            return CifUpdateTypeChecker.typeCheckIfUpdate((AIfUpdate)astUpdate, scope, context, tchecker);
        }
        throw new RuntimeException("Unknown update: " + String.valueOf(astUpdate));
    }

    private static Assignment typeCheckAssignment(AAssignmentUpdate astUpdate, ParentScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        Assignment asgn = CifConstructors.newAssignment();
        asgn.setPosition(astUpdate.createPosition());
        Expression addr = CifExprsTypeChecker.transExpression(astUpdate.addressable, CifExprsTypeChecker.NO_TYPE_HINT, scope, context, tchecker);
        asgn.setAddressable(addr);
        Expression value = CifExprsTypeChecker.transExpression(astUpdate.value, addr.getType(), scope, context, tchecker);
        asgn.setValue(value);
        CifType valueType = value.getType();
        CifType addrType = addr.getType();
        if (!CifTypeUtils.checkTypeCompat((CifType)addrType, (CifType)valueType, (RangeCompat)RangeCompat.OVERLAP)) {
            tchecker.addProblem(ErrMsg.ASGN_TYPE_VALUE_MISMATCH, astUpdate.position, CifTextUtils.typeToStr((CifType)valueType), CifTextUtils.typeToStr((CifType)addrType));
        }
        return asgn;
    }

    private static IfUpdate typeCheckIfUpdate(AIfUpdate astUpdate, ParentScope<?> scope, ExprContext context, CifTypeChecker tchecker) {
        IfUpdate update = CifConstructors.newIfUpdate();
        update.setPosition(astUpdate.createPosition());
        EList guards = update.getGuards();
        for (AExpression g : astUpdate.guards) {
            Expression guard = CifExprsTypeChecker.transExpression(g, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, scope, context, tchecker);
            CifType t = guard.getType();
            CifType nt = CifTypeUtils.normalizeType((CifType)t);
            if (!(nt instanceof BoolType)) {
                tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, guard.getPosition(), CifTextUtils.typeToStr((CifType)t));
            }
            guards.add(guard);
        }
        EList thens = update.getThens();
        for (AUpdate then1 : astUpdate.thens) {
            Update then2 = CifUpdateTypeChecker.typeCheckUpdate(then1, scope, context, tchecker);
            thens.add(then2);
        }
        EList elses = update.getElses();
        for (AUpdate else1 : astUpdate.elses) {
            Update else2 = CifUpdateTypeChecker.typeCheckUpdate(else1, scope, context, tchecker);
            elses.add(else2);
        }
        EList elifs = update.getElifs();
        for (AElifUpdate elif1 : astUpdate.elifs) {
            ElifUpdate elif2 = CifConstructors.newElifUpdate();
            elif2.setPosition(elif1.createPosition());
            elifs.add(elif2);
            guards = elif2.getGuards();
            for (AExpression g : elif1.guards) {
                Expression guard = CifExprsTypeChecker.transExpression(g, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, scope, context, tchecker);
                CifType t = guard.getType();
                CifType nt = CifTypeUtils.normalizeType((CifType)t);
                if (!(nt instanceof BoolType)) {
                    tchecker.addProblem(ErrMsg.GUARD_NON_BOOL, guard.getPosition(), CifTextUtils.typeToStr((CifType)t));
                }
                guards.add(guard);
            }
            EList elifThens = elif2.getThens();
            for (AUpdate then1 : elif1.thens) {
                Update then2 = CifUpdateTypeChecker.typeCheckUpdate(then1, scope, context, tchecker);
                elifThens.add(then2);
            }
        }
        return update;
    }
}

