/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.eclipse.themes.EclipseThemePreferenceChangeListener;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;
import org.eclipse.escet.common.typechecker.TypeChecker;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.Parser;
import org.eclipse.escet.setext.runtime.SyntaxWarning;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;
import org.eclipse.escet.setext.texteditorbase.ColorManager;
import org.eclipse.escet.setext.texteditorbase.GenericSourceViewerConfiguration;
import org.eclipse.escet.setext.texteditorbase.GenericTextEditorFolding;
import org.eclipse.escet.setext.texteditorbase.scanners.GenericPartitionScanner;
import org.eclipse.escet.setext.texteditorbase.themes.AutoDarkLightTheme;
import org.eclipse.escet.setext.texteditorbase.themes.TextEditorTheme;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class GenericTextEditor<T1, T2, TT extends Enum<TT>>
extends TextEditor
implements IDocumentListener,
IPartListener {
    private static final boolean DEBUG_TIMING = false;
    private static final boolean DEBUG_SCANNER = false;
    private static final boolean DEBUG_PARSER = false;
    private static final String PRESENTATION_ACTION_SET_ID = "org.eclipse.ui.edit.text.actionSet.presentation";
    public final String singleLineCommentChars;
    public static final boolean CONTINUOUS_VALIDATION = true;
    private final ColorManager colorManager;
    private final GenericPartitionScanner scanner;
    private final Function<TextEditorTheme<TT>, GenericSourceViewerConfiguration> sourceViewerConfigCreator;
    private final TextEditorTheme<TT> darkTheme;
    private final TextEditorTheme<TT> lightTheme;
    private final EclipseThemePreferenceChangeListener themeListener;
    private final Class<? extends Parser<T1>> parserClass;
    private final Class<? extends TypeChecker<T1, T2>> typeCheckerClass;
    private final String syntaxProblemMarkerId;
    private final String semanticProblemMarkerId;
    private final GenericTextEditorFolding folding = new GenericTextEditorFolding(this);
    private IFileEditorInput input;
    protected final Object validationLock = new Object();
    protected final AtomicInteger validationCount = new AtomicInteger(0);

    public GenericTextEditor(GenericPartitionScanner scanner, Function<TextEditorTheme<TT>, GenericSourceViewerConfiguration> sourceViewerConfigCreator, TextEditorTheme<TT> darkTheme, TextEditorTheme<TT> lightTheme, Class<? extends Parser<T1>> parserClass, Class<? extends TypeChecker<T1, T2>> typeCheckerClass, String syntaxProblemMarkerId, String semanticProblemMarkerId, String singleLineCommentChars) {
        this.scanner = scanner;
        this.sourceViewerConfigCreator = sourceViewerConfigCreator;
        this.darkTheme = darkTheme;
        this.lightTheme = lightTheme;
        this.parserClass = parserClass;
        this.typeCheckerClass = typeCheckerClass;
        this.syntaxProblemMarkerId = syntaxProblemMarkerId;
        this.semanticProblemMarkerId = semanticProblemMarkerId;
        this.singleLineCommentChars = singleLineCommentChars;
        this.colorManager = new ColorManager();
        TextEditorTheme<TT> configuredTheme = this.getConfiguredTheme();
        GenericSourceViewerConfiguration sourceViewerConfig = this.createThemedSourceViewerConfig(configuredTheme);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)sourceViewerConfig);
        this.themeListener = new EclipseThemePreferenceChangeListener(this::handleThemeChange);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IWorkbenchPage page = site.getPage();
        page.showActionSet(PRESENTATION_ACTION_SET_ID);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        if (this.input != null) {
            Assert.check((boolean)(newInput instanceof IFileEditorInput));
            IFileEditorInput newFileInput = (IFileEditorInput)newInput;
            String newFileName = newFileInput.getName();
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor editor = registry.getDefaultEditor(newFileName);
            String curEditorId = this.getEditorSite().getId();
            String newEditorId = editor.getId();
            boolean sameEditor = curEditorId.equals(newEditorId);
            if (!sameEditor) {
                IFile newFile = newFileInput.getFile();
                try {
                    newFile.deleteMarkers(null, true, 0);
                }
                catch (CoreException ex) {
                    String msg = "Failed to delete problem markers.";
                    throw new RuntimeException(msg, ex);
                }
            }
            this.close(true);
            this.folding.save(newFileInput);
            this.getSite().getPage().openEditor(newInput, editor.getId());
            return;
        }
        super.doSetInput(newInput);
        IDocument document = this.getDocumentProvider().getDocument((Object)newInput);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)this.scanner, this.scanner.getTypes());
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        Assert.notNull((Object)newInput);
        if (!(newInput instanceof IFileEditorInput)) {
            String loc = newInput instanceof FileStoreEditorInput ? ((FileStoreEditorInput)newInput).getURI().toString() : newInput.getName();
            String title = Strings.fmt((String)"Could not open an editor for \"%s\": it is not a file, the file is not on a local file system, or the file is not part of any workspace project.", (Object[])new Object[]{loc});
            String pluginName = ((Object)((Object)this)).getClass().getName();
            Status status = new Status(4, pluginName, title);
            throw new CoreException((IStatus)status);
        }
        this.input = (IFileEditorInput)newInput;
        this.getDocumentProvider().getDocument((Object)newInput).addDocumentListener((IDocumentListener)this);
        this.folding.load();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.folding.createPartControl(this.getSourceViewer(), this.getAnnotationAccess(), this.getSharedColors());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    private TextEditorTheme<TT> getConfiguredTheme() {
        String themeName = Platform.getPreferencesService().getString("org.eclipse.ui.editors", ((Object)((Object)this)).getClass().getPackageName() + ".theme", "auto", null);
        if (themeName.equals("dark")) {
            return this.darkTheme;
        }
        if (themeName.equals("light")) {
            return this.lightTheme;
        }
        return new AutoDarkLightTheme<TT>(this.darkTheme, this.lightTheme);
    }

    private void retheme(TextEditorTheme<TT> theme) {
        ISourceViewer viewer = this.getSourceViewer();
        Assert.check((boolean)(viewer instanceof ISourceViewerExtension2));
        ISourceViewerExtension2 viewer2 = (ISourceViewerExtension2)viewer;
        viewer2.unconfigure();
        viewer.configure((SourceViewerConfiguration)this.createThemedSourceViewerConfig(theme));
    }

    private GenericSourceViewerConfiguration createThemedSourceViewerConfig(TextEditorTheme<TT> theme) {
        GenericSourceViewerConfiguration sourceViewerConfig = this.sourceViewerConfigCreator.apply(theme);
        sourceViewerConfig.setColorManager(this.colorManager);
        sourceViewerConfig.setPartitionScanner(this.scanner);
        sourceViewerConfig.setPreferenceStore(this.getPreferenceStore());
        return sourceViewerConfig;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (event.getProperty().equals(((Object)((Object)this)).getClass().getPackageName() + ".theme")) {
            TextEditorTheme<TT> theme = this.getConfiguredTheme();
            this.retheme(theme);
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    private void handleThemeChange(IEclipsePreferences.PreferenceChangeEvent event) {
        TextEditorTheme<TT> theme = this.getConfiguredTheme();
        this.retheme(theme);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.stripTrailingWhitespace();
        this.addNewLineAtEof();
        super.doSave(progressMonitor);
    }

    public void doSaveAs() {
        this.stripTrailingWhitespace();
        this.addNewLineAtEof();
        super.doSaveAs();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        DelayedValidate t = new DelayedValidate(this.validationCount.incrementAndGet());
        t.setName(Strings.fmt((String)"%s-DelayedValidateThread-%d", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), t.getId()}));
        t.start();
    }

    protected void handleEditorInputChanged() {
        super.handleEditorInputChanged();
        this.validate(true);
    }

    public String getValidationCrashIssueReportingInstructions() {
        return "Validation crashed. Please report this to the Eclipse ESCET development team at https://gitlab.eclipse.org/eclipse/escet/escet/-/issues. For more information, see https://eclipse.dev/escet/contact-and-support.html. We appreciate you taking the effort to report issues to us!";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(boolean acquireLock) {
        if (acquireLock) {
            Object object = this.validationLock;
            synchronized (object) {
                this.validate(false);
                return;
            }
        }
        try {
            this.validateInternal();
        }
        catch (Throwable ex) {
            String title = this.getValidationCrashIssueReportingInstructions();
            Status status = new Status(4, ((Object)((Object)this)).getClass(), 0, title, ex);
            int style = 3;
            StatusManager.getManager().handle((IStatus)status, style);
        }
    }

    private void validateInternal() {
        Assert.notNull((Object)this.input);
        long startTime = System.nanoTime();
        IDocumentProvider docProvider = this.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        final IDocument document = docProvider.getDocument((Object)this.input);
        if (document == null) {
            return;
        }
        IFile file = this.input.getFile();
        if (!file.exists()) {
            return;
        }
        final Display display = this.getSite().getShell().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        final String[] text = new String[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                text[0] = document.get();
            }
        });
        try {
            file.deleteMarkers(this.syntaxProblemMarkerId, true, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            file.deleteMarkers(this.semanticProblemMarkerId, true, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        IPath fileLocation = file.getLocation();
        if (fileLocation == null) {
            return;
        }
        String absPath = fileLocation.toOSString();
        Object parseRslt = null;
        if (this.parserClass != null) {
            Parser<T1> parser;
            block36: {
                try {
                    parser = this.parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Failed to create parser.", e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Failed to create parser.", e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Failed to create parser.", e);
                }
                parser.foldRanges = Lists.list();
                DebugMode debugMode = DebugMode.getDebugMode((boolean)false, (boolean)false);
                if (debugMode != DebugMode.NONE) {
                    AppEnv.registerSimple();
                    Options.set(OutputModeOption.class, (Object)OutputMode.NORMAL);
                }
                try {
                    try {
                        parseRslt = parser.parseString(text[0], absPath, debugMode);
                    }
                    catch (SyntaxException ex) {
                        this.addMarker(document, file, ex.getPosition(), ex.getMessage(), this.syntaxProblemMarkerId, 2);
                        if (debugMode != DebugMode.NONE) {
                            AppEnv.unregisterApplication();
                        }
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    if (debugMode != DebugMode.NONE) {
                        AppEnv.unregisterApplication();
                    }
                    throw throwable;
                }
                if (debugMode != DebugMode.NONE) {
                    AppEnv.unregisterApplication();
                }
            }
            for (SyntaxWarning warning : parser.getWarnings()) {
                this.addMarker(document, file, warning.position, warning.message, this.syntaxProblemMarkerId, 1);
            }
            if (parseRslt != null) {
                this.folding.fixFolds(parser.foldRanges, text[0]);
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        GenericTextEditor.this.folding.updateFolds(parser.foldRanges, text[0]);
                    }
                });
            }
        }
        TypeChecker<T1, T2> tchecker = null;
        try {
            if (parseRslt != null && this.typeCheckerClass != null) {
                tchecker = this.typeCheckerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate type checker: " + String.valueOf(this.typeCheckerClass), e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to instantiate type checker: " + String.valueOf(this.typeCheckerClass), e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to instantiate type checker: " + String.valueOf(this.typeCheckerClass), e);
        }
        if (tchecker != null) {
            tchecker.setSourceFilePath(absPath);
            tchecker.typeCheck(parseRslt);
            for (SemanticProblem problem : tchecker.getProblems()) {
                this.addMarker(document, file, problem.position, problem.message, this.semanticProblemMarkerId, switch (problem.severity) {
                    case SemanticProblemSeverity.WARNING -> 1;
                    case SemanticProblemSeverity.ERROR -> 2;
                    default -> {
                        String msg = "Unknown severity: " + String.valueOf(problem.severity);
                        throw new RuntimeException(msg);
                    }
                });
            }
        }
    }

    private void addMarker(IDocument document, IFile file, TextPosition position, String msg, String markerId, int severity) {
        int start = position.startOffset;
        int end = position.endOffset + 1;
        if (end >= document.getLength()) {
            Assert.check((start >= 0 ? 1 : 0) != 0);
            end = document.getLength();
            if (start >= end) {
                start = end - 1;
            }
            if (start < 0) {
                start = 0;
                end = 1;
            }
        }
        Assert.check((start < end ? 1 : 0) != 0);
        Map map = Maps.map();
        map.put("lineNumber", position.startLine);
        map.put("message", msg);
        map.put("location", Strings.fmt((String)"line %d, column %d", (Object[])new Object[]{position.startLine, position.startColumn}));
        map.put("severity", severity);
        map.put("charStart", start);
        map.put("charEnd", end);
        try {
            MarkerUtilities.createMarker((IResource)file, (Map)map, (String)markerId);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void stripTrailingWhitespace() {
        Assert.notNull((Object)this.input);
        IDocument document = this.getDocumentProvider().getDocument((Object)this.input);
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
        int offset = 0;
        String searchPattern = "[ \t]+$";
        while (offset < document.getLength()) {
            IRegion region;
            try {
                region = adapter.find(offset, searchPattern, true, false, false, true);
            }
            catch (BadLocationException ex) {
                String msg = "Strip trailing whitespace find failure.";
                throw new RuntimeException(msg, ex);
            }
            if (region == null) break;
            try {
                adapter.replace("", false);
            }
            catch (BadLocationException ex) {
                String msg = "Strip trailing whitespace replace failure.";
                throw new RuntimeException(msg, ex);
            }
            offset = region.getOffset();
        }
    }

    protected void addNewLineAtEof() {
        String nlChars;
        Assert.notNull((Object)this.input);
        IDocument document = this.getDocumentProvider().getDocument((Object)this.input);
        int size = document.getLength();
        if (size == 0) {
            return;
        }
        String lastLine = null;
        int lineCount = document.getNumberOfLines();
        try {
            int lastOffset = document.getLineOffset(lineCount - 1);
            int lastLength = document.getLineLength(lineCount - 1);
            lastLine = document.get(lastOffset, lastLength);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        if (lastLine.isEmpty()) {
            return;
        }
        try {
            nlChars = document.getLineDelimiter(0);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        if (nlChars == null) {
            nlChars = Strings.NL;
        }
        try {
            document.replace(size - lastLine.length(), lastLine.length(), lastLine + nlChars);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part != this) {
            return;
        }
        this.validate(true);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part != this) {
            return;
        }
        IPartService ps = this.getSite().getWorkbenchWindow().getPartService();
        ps.removePartListener((IPartListener)this);
        this.themeListener.unregister();
        this.folding.save(this.input);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private class DelayedValidate
    extends Thread {
        private final int cnt;

        public DelayedValidate(int cnt) {
            this.cnt = cnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected thread interrupt.", e);
            }
            Object object = GenericTextEditor.this.validationLock;
            synchronized (object) {
                if (GenericTextEditor.this.validationCount.get() != this.cnt) {
                    return;
                }
                GenericTextEditor.this.validate(false);
            }
        }
    }
}

