/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CompDefNoSpecificParamsCheck
extends CifCheck {
    private final EnumSet<NoSpecificCompDefParam> disalloweds;

    public CompDefNoSpecificParamsCheck(NoSpecificCompDefParam ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public CompDefNoSpecificParamsCheck(EnumSet<NoSpecificCompDefParam> disalloweds) {
        this.disalloweds = disalloweds;
    }

    protected void preprocessAlgParameter(AlgParameter param, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificCompDefParam.ALGEBRAIC)) {
            violations.add((PositionObject)param, "A component definition has an algebraic parameter", new Object[0]);
        }
    }

    protected void preprocessComponentParameter(ComponentParameter param, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificCompDefParam.COMPONENT)) {
            violations.add((PositionObject)param, "A component definition has a component parameter", new Object[0]);
        }
    }

    protected void preprocessEventParameter(EventParameter param, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificCompDefParam.EVENT)) {
            violations.add((PositionObject)param, "A component definition has an event parameter", new Object[0]);
        }
    }

    protected void preprocessLocationParameter(LocationParameter param, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificCompDefParam.LOCATION)) {
            violations.add((PositionObject)param, "A component definition has a location parameter", new Object[0]);
        }
    }

    public static enum NoSpecificCompDefParam {
        ALGEBRAIC,
        COMPONENT,
        EVENT,
        LOCATION;

    }
}

