/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.bundle.BundleFragment;
import org.eclipse.pde.internal.core.bundle.BundlePlugin;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.plugin.Fragment;
import org.eclipse.pde.internal.core.plugin.Plugin;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.osgi.resource.Resource;

public class ClasspathUtilCore {
    public static void addLibraries(IPluginModelBase model, ArrayList<IClasspathEntry> result) {
        for (ClasspathLibrary library : ClasspathUtilCore.collectLibraries(model)) {
            IClasspathEntry entry = library.createClasspathEntry();
            if (result.contains(entry)) continue;
            result.add(entry);
        }
    }

    public static Collection<ClasspathLibrary> collectLibraries(IPluginModelBase model) {
        if (new File(model.getInstallLocation()).isFile()) {
            return Collections.singleton(new ClasspathLibrary(IPath.fromOSString((String)model.getInstallLocation()), model, null));
        }
        return ClasspathUtilCore.collectLibraryEntries(model);
    }

    private static Collection<ClasspathLibrary> collectLibraryEntries(IPluginModelBase model) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        ArrayList<ClasspathLibrary> entries = new ArrayList<ClasspathLibrary>();
        IPluginLibrary[] iPluginLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary library = iPluginLibraryArray[n2];
            if (!"resource".equals(library.getType())) {
                ClasspathUtilCore.addLibraryEntry(library, entries);
            }
            ++n2;
        }
        return entries;
    }

    public static Stream<IClasspathEntry> classpathEntriesForBundle(String id) {
        IPluginModelBase model = PluginRegistry.findModel(id);
        if (model != null && model.isEnabled()) {
            IResource resource = model.getUnderlyingResource();
            if (resource != null && PluginProject.isJavaProject(resource.getProject())) {
                IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
                return Stream.of(JavaCore.newProjectEntry((IPath)javaProject.getPath()));
            }
            String location = model.getInstallLocation();
            if (location == null) {
                return Stream.empty();
            }
            boolean isJarShape = new File(location).isFile();
            IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
            if (isJarShape || libraries.length == 0) {
                return Stream.of(ClasspathUtilCore.getEntryForPath(IPath.fromOSString((String)location)));
            }
            return Arrays.stream(libraries).filter(library -> !"resource".equals(library.getType())).map(library -> {
                String name = library.getName();
                String expandedName = ClasspathUtilCore.expandLibraryName(name);
                return ClasspathUtilCore.getPath(model, expandedName, isJarShape);
            }).filter(Objects::nonNull).map(ClasspathUtilCore::getEntryForPath);
        }
        return Optional.ofNullable(Platform.getBundle((String)id)).map(bundle -> (File)bundle.adapt(File.class)).filter(File::exists).map(File::toPath).map(Path::normalize).map(path -> IPath.fromOSString((String)path.toString())).map(ClasspathUtilCore::getEntryForPath).stream();
    }

    public static boolean isEntryForModel(IClasspathEntry entry, IPluginModelBase projectModel) {
        IResource resource;
        if (entry.getEntryKind() == 2 && (resource = projectModel.getUnderlyingResource()) != null) {
            return resource.getProject().getFullPath().equals((Object)entry.getPath());
        }
        return false;
    }

    private static IClasspathEntry getEntryForPath(IPath path) {
        return JavaCore.newLibraryEntry((IPath)path, (IPath)path, (IPath)IPath.ROOT, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
    }

    private static void addLibraryEntry(IPluginLibrary library, Collection<ClasspathLibrary> entries) {
        String name = library.getName();
        String expandedName = ClasspathUtilCore.expandLibraryName(name);
        IPluginModelBase model = library.getPluginModel();
        IPath path = ClasspathUtilCore.getPath(model, expandedName);
        if (path == null) {
            if (model.isFragmentModel() || !ClasspathUtilCore.containsVariables(name)) {
                return;
            }
            model = ClasspathUtilCore.resolveLibraryInFragments(library, expandedName);
            if (model == null) {
                return;
            }
            path = ClasspathUtilCore.getPath(model, expandedName);
        }
        entries.add(new ClasspathLibrary(path, model, expandedName));
    }

    public static boolean hasExtensibleAPI(IPluginModelBase model) {
        IPluginBase pluginBase = model.getPluginBase();
        if (pluginBase instanceof IPlugin) {
            return ClasspathUtilCore.hasExtensibleAPI((IPlugin)pluginBase);
        }
        return false;
    }

    public static boolean isPatchFragment(Resource desc) {
        IPluginModelBase model = PluginRegistry.findModel(desc);
        return model instanceof IFragmentModel ? ClasspathUtilCore.isPatchFragment(((IFragmentModel)model).getFragment()) : false;
    }

    public static boolean isPatchFragment(IPluginModelBase model) {
        IPluginBase pluginBase = model.getPluginBase();
        if (pluginBase instanceof IFragment) {
            return ClasspathUtilCore.isPatchFragment((IFragment)pluginBase);
        }
        return false;
    }

    private static boolean hasExtensibleAPI(IPlugin plugin) {
        if (plugin instanceof Plugin) {
            return ((Plugin)plugin).hasExtensibleAPI();
        }
        if (plugin instanceof BundlePlugin) {
            return ((BundlePlugin)plugin).hasExtensibleAPI();
        }
        return false;
    }

    private static boolean isPatchFragment(IFragment fragment) {
        if (fragment instanceof Fragment) {
            return ((Fragment)fragment).isPatch();
        }
        if (fragment instanceof BundleFragment) {
            return ((BundleFragment)fragment).isPatch();
        }
        return false;
    }

    public static boolean hasBundleStructure(IPluginModelBase model) {
        if (model.getUnderlyingResource() != null) {
            return model instanceof IBundlePluginModelBase;
        }
        IPluginBase plugin = model.getPluginBase();
        if (plugin instanceof PluginBase) {
            return ((PluginBase)plugin).hasBundleStructure();
        }
        return false;
    }

    public static boolean containsVariables(String name) {
        return name.contains("$os$") || name.contains("$ws$") || name.contains("$nl$") || name.contains("$arch$");
    }

    public static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.contains("$ws$")) {
            source = source.replaceAll("\\$ws\\$", "ws/" + TargetPlatform.getWS());
        }
        if (source.contains("$os$")) {
            source = source.replaceAll("\\$os\\$", "os/" + TargetPlatform.getOS());
        }
        if (source.contains("$nl$")) {
            source = source.replaceAll("\\$nl\\$", "nl/" + TargetPlatform.getNL());
        }
        if (source.contains("$arch$")) {
            source = source.replaceAll("\\$arch\\$", "arch/" + TargetPlatform.getOSArch());
        }
        return source;
    }

    public static IPath getSourceAnnotation(IPluginModelBase model, String libraryName) {
        return ClasspathUtilCore.getSourceAnnotation(model, libraryName, false);
    }

    public static IPath getSourceAnnotation(IPluginModelBase model, String libraryName, boolean isJarShape) {
        String newlibraryName = TargetWeaver.getWeavedSourceLibraryName(model, libraryName);
        String zipName = ClasspathUtilCore.getSourceZipName(newlibraryName);
        IPath path = ClasspathUtilCore.getPath(model, zipName, isJarShape);
        if (path == null) {
            SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
            path = manager.findSourcePath(model.getPluginBase(), IPath.fromOSString((String)zipName));
        }
        return path;
    }

    public static String getSourceZipName(String libraryName) {
        int dot = libraryName.lastIndexOf(46);
        return dot != -1 ? libraryName.substring(0, dot) + "src.zip" : libraryName;
    }

    private static IPluginModelBase resolveLibraryInFragments(IPluginLibrary library, String libraryName) {
        IFragmentModel[] fragments;
        IFragmentModel[] iFragmentModelArray = fragments = PDEManager.findFragmentsFor(library.getPluginModel());
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IFragmentModel fragment = iFragmentModelArray[n2];
            IPath path = ClasspathUtilCore.getPath(fragment, libraryName);
            if (path != null) {
                return fragment;
            }
            ++n2;
        }
        return null;
    }

    public static IPath getPath(IPluginModelBase model, String libraryName) {
        return ClasspathUtilCore.getPath(model, libraryName, false);
    }

    public static IPath getPath(IPluginModelBase model, String libraryName, boolean installLocationIsFile) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IResource jarFile = resource.getProject().findMember(libraryName);
            if (jarFile != null) {
                return jarFile.getFullPath();
            }
        } else {
            File file = new File(libraryName);
            if (file.isAbsolute()) {
                if (file.exists()) {
                    return IPath.fromOSString((String)libraryName);
                }
                return null;
            }
            if (!installLocationIsFile && (file = new File(model.getInstallLocation(), libraryName)).exists()) {
                return IPath.fromOSString((String)file.getAbsolutePath());
            }
        }
        return null;
    }

    public static IBuild getBuild(IPluginModelBase model) throws CoreException {
        IBuildModel buildModel = PluginRegistry.createBuildModel(model);
        return buildModel != null ? buildModel.getBuild() : null;
    }

    public static String getFilename(IPluginModelBase model) {
        return IPath.fromOSString((String)model.getInstallLocation()).lastSegment();
    }

    public static class ClasspathLibrary {
        private final IPath fPath;
        private final IPluginModelBase fModel;
        private final String fLibraryName;

        public ClasspathLibrary(IPath path, IPluginModelBase model, String libraryName) {
            this.fPath = path;
            this.fModel = model;
            this.fLibraryName = libraryName;
        }

        public IPath getPath() {
            return this.fPath;
        }

        public IClasspathEntry createClasspathEntry() {
            IPath sourcePath = this.findSourcePath();
            return JavaCore.newLibraryEntry((IPath)this.fPath, (IPath)sourcePath, null, (boolean)false);
        }

        private IPath findSourcePath() {
            if (this.fLibraryName == null) {
                IPath sourcePath = ClasspathUtilCore.getSourceAnnotation(this.fModel, ".");
                if (sourcePath == null) {
                    sourcePath = this.fPath;
                }
                return sourcePath;
            }
            return ClasspathUtilCore.getSourceAnnotation(this.fModel, this.fLibraryName);
        }
    }
}

