/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.parser.ast.ACompDefDecl;
import org.eclipse.escet.cif.parser.ast.automata.AAutomatonBody;
import org.eclipse.escet.cif.parser.ast.automata.ALocation;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.declwrap.AlgParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EventParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.LocationParamDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.AutScope;
import org.eclipse.escet.cif.typechecker.scopes.CompParamScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class AutDefScope
extends ParentScope<ComponentDef> {
    private final ACompDefDecl autDefDecl;
    private final List<ALocation> astLocs;

    public AutDefScope(ComponentDef obj, ACompDefDecl autDefDecl, ParentScope<?> parent, CifTypeChecker tchecker) {
        super(obj, parent, tchecker);
        this.autDefDecl = autDefDecl;
        this.astLocs = ((AAutomatonBody)autDefDecl.body).locations;
        Assert.check((boolean)(obj.getBody() instanceof Automaton));
    }

    @Override
    protected String getScopeTypeName() {
        return "autdef";
    }

    @Override
    protected ComplexComponent getComplexComponent() {
        return ((ComponentDef)this.obj).getBody();
    }

    @Override
    protected Group getGroup() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ComponentDef getComponentDef() {
        return (ComponentDef)this.obj;
    }

    @Override
    public Automaton getAutomaton() {
        return (Automaton)((ComponentDef)this.obj).getBody();
    }

    @Override
    public List<ALocation> getAstLocs() {
        return this.astLocs;
    }

    @Override
    public void addChildScope(SymbolScope<?> scope) {
        Assert.check((boolean)(scope instanceof CompParamScope));
        super.addChildScope(scope);
    }

    @Override
    protected boolean isSubScope() {
        return false;
    }

    @Override
    protected boolean isRootScope() {
        return false;
    }

    @Override
    public String getName() {
        return ((ComponentDef)this.obj).getBody().getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)((ComponentDef)this.obj).getBody());
    }

    @Override
    public String getAbsText() {
        return Strings.fmt((String)"automaton definition \"%s\"", (Object[])new Object[]{this.getAbsName()});
    }

    public void tcheckFullParams() {
        AutDefScope.tcheckFullParams(this);
    }

    public static void tcheckFullParams(ParentScope<?> compDefScope) {
        compDefScope.tcheckForUse();
        boolean failed = false;
        for (DeclWrap<?> declWrap : compDefScope.declarations.values()) {
            if (!(declWrap instanceof AlgParamDeclWrap) && !(declWrap instanceof EventParamDeclWrap) && !(declWrap instanceof LocationParamDeclWrap)) continue;
            try {
                declWrap.tcheckFull();
            }
            catch (SemanticException ex) {
                failed = true;
            }
        }
        for (SymbolScope symbolScope : compDefScope.children.values()) {
            if (!(symbolScope instanceof CompParamScope)) continue;
            try {
                symbolScope.tcheckFull();
            }
            catch (SemanticException ex) {
                failed = true;
            }
        }
        if (failed) {
            throw new SemanticException();
        }
    }

    @Override
    protected void tcheckScopeFull() {
        AutScope.typeCheckAutomaton((AAutomatonBody)this.autDefDecl.body, this.getAutomaton(), this, this.tchecker);
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astAnnotations, this, this.tchecker);
        ((ComponentDef)this.obj).getBody().getAnnotations().addAll(annos);
    }
}

