/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPPublicKeyStore;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.IArtifactUIServices;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public class CertificateChecker {
    private static final String DEBUG_PREFIX = "certificate checker";
    private static boolean VERIFY_CERTIFICATE_SIGNATURE_VALIDITY = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("p2.verifyCertificateSignatureValidity", Boolean.TRUE.toString()));
    public static final String TRUST_ALWAYS_PROPERTY = "trustAlways";
    public static final String TRUSTED_KEY_STORE_PROPERTY = "pgp.trustedPublicKeys";
    public static final String TRUSTED_CERTIFICATES_PROPERTY = "trustedCertificates";
    private IProfile profile;
    private Map<IArtifactDescriptor, File> artifacts = new HashMap<IArtifactDescriptor, File>();
    private final IProvisioningAgent agent;
    private final PGPPublicKeyService keyService;
    private Supplier<PGPPublicKeyStore> trustedKeys = new Supplier<PGPPublicKeyStore>(){
        private PGPPublicKeyStore cache = null;

        @Override
        public PGPPublicKeyStore get() {
            if (this.cache == null) {
                this.cache = CertificateChecker.this.getPreferenceTrustedKeys();
                CertificateChecker.this.getContributedTrustedKeys().keySet().forEach(arg_0 -> ((PGPPublicKeyStore)this.cache).addKey(arg_0));
            }
            return this.cache;
        }
    };
    private Supplier<Collection<? extends Certificate>> additionalTrustedCertificates = new Supplier<Collection<? extends Certificate>>(){
        private Collection<? extends Certificate> cache = null;

        @Override
        public Collection<? extends Certificate> get() {
            if (this.cache == null) {
                this.cache = CertificateChecker.this.getPreferenceTrustedCertificates();
            }
            return this.cache;
        }
    };

    public CertificateChecker() {
        this(null);
    }

    public CertificateChecker(IProvisioningAgent agent) {
        this.agent = agent;
        this.artifacts = new HashMap<IArtifactDescriptor, File>();
        this.keyService = (PGPPublicKeyService)agent.getService(PGPPublicKeyService.class);
    }

    public IStatus start() {
        BundleContext context = EngineActivator.getContext();
        ServiceReference contentFactoryRef = context.getServiceReference(SignedContentFactory.class);
        SignedContentFactory verifierFactory = (SignedContentFactory)context.getService(contentFactoryRef);
        try {
            IStatus iStatus = this.checkCertificates(verifierFactory);
            return iStatus;
        }
        finally {
            context.ungetService(contentFactoryRef);
        }
    }

    private IStatus checkCertificates(SignedContentFactory verifierFactory) {
        StringBuilder message;
        if (this.artifacts.isEmpty()) {
            return Status.OK_STATUS;
        }
        String policy = this.getUnsignedContentPolicy();
        if ("allow".equals(policy)) {
            return Status.OK_STATUS;
        }
        UIServices serviceUI = (UIServices)this.agent.getService(UIServices.class);
        if (serviceUI == null) {
            return Status.OK_STATUS;
        }
        if (this.isTrustAlways()) {
            return Status.OK_STATUS;
        }
        IArtifactUIServices artifactServiceUI = serviceUI instanceof IArtifactUIServices ? (IArtifactUIServices)serviceUI : (untrustedCertificateChains, untrustedPGPKeys, unsignedArtifacts, artifactFiles) -> IArtifactUIServices.getTrustInfo((UIServices)serviceUI, (Map)untrustedCertificateChains, (Map)untrustedPGPKeys, (Set)unsignedArtifacts, (Map)artifactFiles);
        LinkedHashMap<List, Set> untrustedCertificates = new LinkedHashMap<List, Set>();
        LinkedHashMap untrustedPGPKeys2 = new LinkedHashMap();
        LinkedHashSet<IArtifactKey> unsignedArtifacts2 = new LinkedHashSet<IArtifactKey>();
        HashSet<PGPPublicKey> trustedKeySet = new HashSet<PGPPublicKey>();
        HashSet<SimpleArtifactRepository> repositories = new HashSet<SimpleArtifactRepository>();
        boolean isTrustedKeySetInitialized = false;
        LinkedHashMap<IArtifactKey, File> artifactFiles2 = new LinkedHashMap<IArtifactKey, File>();
        for (Map.Entry<IArtifactDescriptor, File> artifact : this.artifacts.entrySet()) {
            IArtifactDescriptor artifactDescriptor = artifact.getKey();
            IArtifactRepository iArtifactRepository = artifactDescriptor.getRepository();
            if (iArtifactRepository instanceof SimpleArtifactRepository) {
                SimpleArtifactRepository simpleArtifactRepository = (SimpleArtifactRepository)iArtifactRepository;
                repositories.add(simpleArtifactRepository);
            }
            IArtifactKey artifactKey = artifactDescriptor.getArtifactKey();
            File artifactFile = artifact.getValue();
            artifactFiles2.put(artifactKey, artifactFile);
            boolean artifactTrustedByCertificate = false;
            try {
                List<PGPPublicKey> verifiedKeys;
                SignedContent content = verifierFactory.getSignedContent(artifactFile);
                boolean signed = content.isSigned();
                if (signed) {
                    List invalidSignatures;
                    SignerInfo[] signerInfo = content.getSignerInfos();
                    if (Arrays.stream(signerInfo).noneMatch(SignerInfo::isTrusted) && Arrays.stream(signerInfo).map(SignerInfo::getCertificateChain).flatMap(Arrays::stream).noneMatch(cert -> this.additionalTrustedCertificates.get().contains(cert))) {
                        SignerInfo[] signerInfoArray = signerInfo;
                        int n = signerInfo.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SignerInfo element = signerInfoArray[n2];
                            if (!element.isTrusted()) {
                                List<Certificate> certificateChain = Arrays.asList(element.getCertificateChain());
                                untrustedCertificates.computeIfAbsent(certificateChain, key -> new LinkedHashSet()).add(artifactKey);
                            }
                            ++n2;
                        }
                    } else {
                        artifactTrustedByCertificate = true;
                    }
                    if (VERIFY_CERTIFICATE_SIGNATURE_VALIDITY && signerInfo.length == (invalidSignatures = Arrays.stream(signerInfo).filter(info -> {
                        try {
                            content.checkValidity(info);
                            return false;
                        }
                        catch (CertificateExpiredException | CertificateNotYetValidException e) {
                            return true;
                        }
                    }).collect(Collectors.toList())).size()) {
                        artifactTrustedByCertificate = false;
                        for (SignerInfo info2 : invalidSignatures) {
                            List<Certificate> certificateChain = Arrays.asList(info2.getCertificateChain());
                            untrustedCertificates.computeIfAbsent(certificateChain, key -> new LinkedHashSet()).add(artifactKey);
                        }
                    }
                }
                if (signed) {
                    if (artifactTrustedByCertificate) continue;
                }
                if (!(verifiedKeys = PGPPublicKeyStore.readPublicKeys((String)artifactDescriptor.getProperty("pgp.publicKeys")).stream().map(arg_0 -> ((PGPPublicKeyService)this.keyService).addKey(arg_0)).collect(Collectors.toList())).isEmpty()) {
                    if (!isTrustedKeySetInitialized) {
                        isTrustedKeySetInitialized = true;
                        trustedKeySet.addAll(this.trustedKeys.get().all().stream().filter(it -> this.keyService.getVerifiedRevocationDate(it) == null).toList());
                    }
                    if (verifiedKeys.stream().noneMatch(trustedKeySet::contains)) {
                        verifiedKeys.forEach(key -> {
                            boolean bl = untrustedPGPKeys2.computeIfAbsent(key, k -> new LinkedHashSet()).add(artifactKey);
                        });
                        continue;
                    }
                    untrustedCertificates.values().forEach(it -> {
                        boolean bl = it.remove(artifactKey);
                    });
                    untrustedCertificates.values().removeIf(Collection::isEmpty);
                    continue;
                }
                if (signed) continue;
                unsignedArtifacts2.add(artifactKey);
            }
            catch (GeneralSecurityException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentError, (Throwable)e);
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentIOError, (Throwable)e);
            }
        }
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNSIGNED && !unsignedArtifacts2.isEmpty()) {
            message = new StringBuilder("The following artifacts are unsigned:\n");
            for (IArtifactKey iArtifactKey : unsignedArtifacts2) {
                message.append(NLS.bind((String)"  {0}\n", (Object)((File)artifactFiles2.get(iArtifactKey)).getPath()));
            }
            DebugHelper.debug(DEBUG_PREFIX, message.toString());
        }
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED && !untrustedCertificates.isEmpty()) {
            message = new StringBuilder("The following certificates are untrusted:\n");
            for (Map.Entry entry : untrustedCertificates.entrySet()) {
                message.append(((Certificate)((List)entry.getKey()).get(0)).toString() + "\n");
                message.append("  used by the following artifacts:\n");
                for (IArtifactKey iArtifactKey : (Set)entry.getValue()) {
                    message.append(NLS.bind((String)"    {0}\n", (Object)((File)artifactFiles2.get(iArtifactKey)).getPath()));
                }
            }
            DebugHelper.debug(DEBUG_PREFIX, message.toString());
        }
        if (DebugHelper.DEBUG_CERTIFICATE_CHECKER_UNTRUSTED && !untrustedPGPKeys2.isEmpty()) {
            message = new StringBuilder("The following PGP Keys are untrusted:\n");
            for (Map.Entry entry : untrustedPGPKeys2.entrySet()) {
                message.append(Long.toHexString(((PGPPublicKey)entry.getKey()).getKeyID()) + "\n");
                message.append("  used by the following artifacts:\n");
                for (IArtifactKey iArtifactKey : (Set)entry.getValue()) {
                    message.append(NLS.bind((String)"    {0}\n", (Object)iArtifactKey));
                }
            }
            DebugHelper.debug(DEBUG_PREFIX, message.toString());
        }
        if (!unsignedArtifacts2.isEmpty() && "fail".equals(policy)) {
            return new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.CertificateChecker_UnsignedNotAllowed, unsignedArtifacts2.stream().map(key -> (File)artifactFiles2.get(key)).collect(Collectors.toList())));
        }
        if (unsignedArtifacts2.isEmpty() && untrustedCertificates.isEmpty() && untrustedPGPKeys2.isEmpty()) {
            return Status.OK_STATUS;
        }
        UIServices.TrustInfo trustInfo = artifactServiceUI.getTrustInfo(untrustedCertificates, untrustedPGPKeys2, unsignedArtifacts2, artifactFiles2);
        this.setTrustAlways(trustInfo.trustAlways());
        if (!trustInfo.trustAlways()) {
            String errorMessage;
            HashSet hashSet = new HashSet();
            Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
            if (trustedCertificates != null) {
                for (Map.Entry entry : untrustedCertificates.entrySet()) {
                    Certificate[] certificateArray = trustedCertificates;
                    int n = trustedCertificates.length;
                    int artifactFile = 0;
                    while (artifactFile < n) {
                        Certificate trustedCertificate = certificateArray[artifactFile];
                        if (((List)entry.getKey()).contains(trustedCertificate)) {
                            hashSet.addAll((Collection)entry.getValue());
                        }
                        ++artifactFile;
                    }
                }
            }
            trustedKeySet.addAll(trustInfo.getTrustedPGPKeys());
            Set set = trustedKeySet.stream().map(untrustedPGPKeys2::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
            hashSet.addAll(set);
            untrustedCertificates.values().forEach(it -> {
                boolean bl = it.removeAll(trustedArtifactKeys);
            });
            untrustedPGPKeys2.values().forEach(it -> {
                boolean bl = it.removeAll(trustedArtifactKeys);
            });
            untrustedCertificates.values().removeIf(Collection::isEmpty);
            untrustedPGPKeys2.values().removeIf(Collection::isEmpty);
            String string = !unsignedArtifacts2.isEmpty() && !trustInfo.trustUnsignedContent() ? Messages.CertificateChecker_UnsignedRejected : (!untrustedCertificates.isEmpty() && !untrustedPGPKeys2.isEmpty() ? Messages.CertificateChecker_CertificateOrPGPKeyRejected : (!untrustedCertificates.isEmpty() ? Messages.CertificateChecker_CertificateRejected : (errorMessage = !untrustedPGPKeys2.isEmpty() ? Messages.CertificateChecker_PGPKeyRejected : null)));
            if (errorMessage != null) {
                HashSet<IArtifactKey> keys = new HashSet<IArtifactKey>();
                keys.addAll(unsignedArtifacts2);
                untrustedCertificates.values().stream().forEach(keys::addAll);
                untrustedPGPKeys2.values().stream().forEach(keys::addAll);
                for (SimpleArtifactRepository repository : repositories) {
                    repository.removeDescriptors((IArtifactKey[])keys.toArray(IArtifactKey[]::new), true, null);
                }
                return new Status(8, "org.eclipse.equinox.p2.engine", errorMessage);
            }
        }
        if (trustInfo.persistTrust()) {
            ArrayList<IStatus> arrayList = new ArrayList<IStatus>();
            LinkedHashSet<? extends Certificate> unsavedCertificates = new LinkedHashSet<Certificate>();
            if (trustInfo.getTrustedCertificates() != null) {
                unsavedCertificates.addAll(Arrays.asList(trustInfo.getTrustedCertificates()));
            }
            if (!unsavedCertificates.isEmpty()) {
                IStatus iStatus = this.persistTrustedCertificatesInTrustEngine(unsavedCertificates);
                if (iStatus != null && !iStatus.isOK()) {
                    arrayList.add(iStatus);
                }
                if (!unsavedCertificates.isEmpty()) {
                    unsavedCertificates.addAll(this.getPreferenceTrustedCertificates());
                    IStatus preferenceStatus = this.persistTrustedCertificates(unsavedCertificates);
                    if (preferenceStatus != null && !preferenceStatus.isOK()) {
                        arrayList.add(preferenceStatus);
                    }
                }
            }
            if (!trustInfo.getTrustedPGPKeys().isEmpty()) {
                PGPPublicKeyStore pGPPublicKeyStore = this.getPreferenceTrustedKeys();
                trustInfo.getTrustedPGPKeys().forEach(arg_0 -> ((PGPPublicKeyStore)pGPPublicKeyStore).addKey(arg_0));
                IStatus status = this.persistTrustedKeys(pGPPublicKeyStore);
                if (status != null && !status.isOK()) {
                    arrayList.add(status);
                }
            }
            if (!arrayList.isEmpty()) {
                if (arrayList.size() == 1) {
                    return (IStatus)arrayList.get(1);
                }
                String string = arrayList.stream().map(IStatus::getMessage).collect(Collectors.joining("\n"));
                return new MultiStatus(this.getClass(), 0, (IStatus[])arrayList.toArray(IStatus[]::new), string, null);
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * Loose catch block
     */
    private IStatus persistTrustedCertificatesInTrustEngine(Collection<? extends Certificate> unsavedTrustedCertificates) {
        ServiceTracker trustEngineTracker = new ServiceTracker(EngineActivator.getContext(), TrustEngine.class, null);
        trustEngineTracker.open();
        Object[] trustEngines = trustEngineTracker.getServices();
        try {
            if (trustEngines == null) {
                return null;
            }
            Iterator<? extends Certificate> it = unsavedTrustedCertificates.iterator();
            block9: while (it.hasNext()) {
                Certificate trustedCertificate = it.next();
                Object[] objectArray = trustEngines;
                int n = trustEngines.length;
                int n2 = 0;
                while (n2 < n) {
                    Object engine = objectArray[n2];
                    TrustEngine trustEngine = (TrustEngine)engine;
                    if (!trustEngine.isReadOnly()) {
                        try {
                            trustEngine.addTrustAnchor(trustedCertificate, trustedCertificate.toString());
                            it.remove();
                            continue block9;
                        }
                        catch (IOException e) {
                            Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                            trustEngineTracker.close();
                            return status;
                        }
                        catch (GeneralSecurityException e) {
                            Status status = new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateError, (Throwable)e);
                            trustEngineTracker.close();
                            return status;
                        }
                    }
                    ++n2;
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
        }
        finally {
            trustEngineTracker.close();
        }
        return Status.OK_STATUS;
    }

    public IStatus persistTrustedCertificates(Collection<? extends Certificate> trustedCertificates) {
        if (this.profile != null) {
            ProfileScope profileScope = new ProfileScope((IAgentLocation)this.agent.getService(IAgentLocation.class), this.profile.getProfileId());
            IEclipsePreferences node = profileScope.getNode("org.eclipse.equinox.p2.engine");
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                CertPath certPath = certificateFactory.generateCertPath(new ArrayList<Certificate>(trustedCertificates));
                byte[] encoded = certPath.getEncoded("PKCS7");
                node.putByteArray(TRUSTED_CERTIFICATES_PROPERTY, encoded);
                node.flush();
            }
            catch (CertificateException | BackingStoreException ex) {
                return new Status(4, "org.eclipse.equinox.p2.engine", ex.getMessage(), ex);
            }
        }
        return Status.OK_STATUS;
    }

    public Set<? extends Certificate> getPreferenceTrustedCertificates() {
        if (this.profile != null) {
            ProfileScope profileScope = new ProfileScope((IAgentLocation)this.agent.getService(IAgentLocation.class), this.profile.getProfileId());
            IEclipsePreferences node = profileScope.getNode("org.eclipse.equinox.p2.engine");
            try {
                byte[] encoded = node.getByteArray(TRUSTED_CERTIFICATES_PROPERTY, null);
                if (encoded != null) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    CertPath certPath = certificateFactory.generateCertPath(new ByteArrayInputStream(encoded), "PKCS7");
                    return new LinkedHashSet<Certificate>(certPath.getCertificates());
                }
            }
            catch (CertificateException ex) {
                DebugHelper.debug(DEBUG_PREFIX, ex.getMessage());
            }
        }
        return Set.of();
    }

    private String getUnsignedContentPolicy() {
        String policy = EngineActivator.getProperty("eclipse.p2.unsignedPolicy", this.agent);
        if (policy == null) {
            policy = "prompt";
        }
        return policy;
    }

    public void setProfile(IProfile profile) {
        this.profile = profile;
    }

    public void add(Map<IArtifactDescriptor, File> toAdd) {
        this.artifacts.putAll(toAdd);
    }

    public Map<PGPPublicKey, Set<Bundle>> getContributedTrustedKeys() {
        LinkedHashMap keys = new LinkedHashMap();
        IConfigurationElement[] iConfigurationElementArray = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.equinox.p2.engine", "pgp");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathInBundle;
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if ("trustedKeys".equals(extension.getName()) && (pathInBundle = extension.getAttribute("path")) != null) {
                String name = extension.getContributor().getName();
                Stream.of(EngineActivator.getContext().getBundles()).filter(bundle -> bundle.getSymbolicName().equals(name)).findAny().ifPresent(bundle -> {
                    URL keyURL = bundle.getEntry(pathInBundle);
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (InputStream stream = keyURL.openStream();){
                            PGPPublicKeyStore.readPublicKeys((InputStream)stream).stream().map(arg_0 -> ((PGPPublicKeyService)this.keyService).addKey(arg_0)).forEach(key -> {
                                boolean bl = keys.computeIfAbsent(ByteBuffer.wrap(key.getFingerprint()), k -> new LinkedHashSet()).add(bundle);
                            });
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        DebugHelper.debug(DEBUG_PREFIX, e.getMessage());
                    }
                });
            }
            ++n2;
        }
        Map<PGPPublicKey, Set<Bundle>> result = keys.entrySet().stream().collect(Collectors.toMap(entry -> this.keyService.getKey(((ByteBuffer)entry.getKey()).array()), Map.Entry::getValue));
        return result;
    }

    public boolean isTrustAlways() {
        if (this.profile != null) {
            ProfileScope profileScope = new ProfileScope((IAgentLocation)this.agent.getService(IAgentLocation.class), this.profile.getProfileId());
            return profileScope.getNode("org.eclipse.equinox.p2.engine").getBoolean(TRUST_ALWAYS_PROPERTY, false);
        }
        return false;
    }

    public IStatus setTrustAlways(boolean trustAlways) {
        if (this.profile != null) {
            ProfileScope profileScope = new ProfileScope((IAgentLocation)this.agent.getService(IAgentLocation.class), this.profile.getProfileId());
            IEclipsePreferences node = profileScope.getNode("org.eclipse.equinox.p2.engine");
            try {
                node.putBoolean(TRUST_ALWAYS_PROPERTY, trustAlways);
                node.flush();
            }
            catch (BackingStoreException ex) {
                return new Status(4, "org.eclipse.equinox.p2.engine", ex.getMessage(), (Throwable)ex);
            }
        }
        return Status.OK_STATUS;
    }

    public PGPPublicKeyStore getPreferenceTrustedKeys() {
        PGPPublicKeyStore trustStore = new PGPPublicKeyStore();
        if (this.profile != null) {
            ProfileScope profileScope = new ProfileScope((IAgentLocation)this.agent.getService(IAgentLocation.class), this.profile.getProfileId());
            PGPPublicKeyStore.readPublicKeys((String)profileScope.getNode("org.eclipse.equinox.p2.engine").get(TRUSTED_KEY_STORE_PROPERTY, null)).stream().map(arg_0 -> ((PGPPublicKeyService)this.keyService).addKey(arg_0)).forEach(arg_0 -> ((PGPPublicKeyStore)trustStore).addKey(arg_0));
        }
        return trustStore;
    }

    public IStatus persistTrustedKeys(PGPPublicKeyStore trustStore) {
        if (this.profile != null) {
            ProfileScope profileScope = new ProfileScope((IAgentLocation)this.agent.getService(IAgentLocation.class), this.profile.getProfileId());
            IEclipsePreferences node = profileScope.getNode("org.eclipse.equinox.p2.engine");
            try {
                node.put(TRUSTED_KEY_STORE_PROPERTY, trustStore.toArmoredString());
                node.flush();
            }
            catch (IOException | BackingStoreException ex) {
                return new Status(4, "org.eclipse.equinox.p2.engine", ex.getMessage(), ex);
            }
        }
        return Status.OK_STATUS;
    }
}

