/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.annotations.builtin;

import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProviderHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class ControllerPropertiesAnnotationProvider
extends AnnotationProvider {
    public ControllerPropertiesAnnotationProvider(String annotationName) {
        super(annotationName);
    }

    @Override
    public final void checkAnnotation(AnnotatedObject annotatedObject, Annotation annotation, AnnotationProblemReporter reporter) {
        if (!(annotatedObject instanceof Specification)) {
            reporter.reportProblem(annotation, "controller properties annotation must be on the specification.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
            return;
        }
        AnnotationArgument boundedResponse = null;
        AnnotationArgument uncontrollablesBound = null;
        AnnotationArgument controllablesBound = null;
        AnnotationArgument confluence = null;
        AnnotationArgument finiteResponse = null;
        AnnotationArgument nonBlockingUnderControl = null;
        for (AnnotationArgument arg : annotation.getArguments()) {
            if (arg.getName() == null) {
                reporter.reportProblem(annotation, "unsupported unnamed argument.", arg.getPosition(), SemanticProblemSeverity.ERROR);
                continue;
            }
            switch (arg.getName()) {
                case "boundedResponse": {
                    Assert.check((boundedResponse == null ? 1 : 0) != 0);
                    boundedResponse = arg;
                    break;
                }
                case "uncontrollablesBound": {
                    Assert.check((uncontrollablesBound == null ? 1 : 0) != 0);
                    uncontrollablesBound = arg;
                    break;
                }
                case "controllablesBound": {
                    Assert.check((controllablesBound == null ? 1 : 0) != 0);
                    controllablesBound = arg;
                    break;
                }
                case "confluence": {
                    Assert.check((confluence == null ? 1 : 0) != 0);
                    confluence = arg;
                    break;
                }
                case "finiteResponse": {
                    Assert.check((finiteResponse == null ? 1 : 0) != 0);
                    finiteResponse = arg;
                    break;
                }
                case "nonBlockingUnderControl": {
                    Assert.check((nonBlockingUnderControl == null ? 1 : 0) != 0);
                    nonBlockingUnderControl = arg;
                    break;
                }
                default: {
                    reporter.reportProblem(annotation, Strings.fmt((String)"unsupported argument named \"%s\".", (Object[])new Object[]{arg.getName()}), arg.getPosition(), SemanticProblemSeverity.ERROR);
                }
            }
        }
        boolean argsOk = true;
        if (boundedResponse != null) {
            argsOk &= AnnotationProviderHelper.checkBoolLiteralArg(annotation, boundedResponse, reporter);
        }
        if (uncontrollablesBound != null) {
            argsOk &= AnnotationProviderHelper.checkNonNegativeIntLiteralArg(annotation, uncontrollablesBound, reporter);
        }
        if (controllablesBound != null) {
            argsOk &= AnnotationProviderHelper.checkNonNegativeIntLiteralArg(annotation, controllablesBound, reporter);
        }
        if (confluence != null) {
            argsOk &= AnnotationProviderHelper.checkBoolLiteralArg(annotation, confluence, reporter);
        }
        if (finiteResponse != null) {
            argsOk &= AnnotationProviderHelper.checkBoolLiteralArg(annotation, finiteResponse, reporter);
        }
        if (nonBlockingUnderControl != null) {
            argsOk &= AnnotationProviderHelper.checkBoolLiteralArg(annotation, nonBlockingUnderControl, reporter);
        }
        if (argsOk) {
            String boundedResponseText;
            boolean hasBoundedResponse;
            boolean bl = hasBoundedResponse = boundedResponse != null && ((BoolExpression)boundedResponse.getValue()).isValue();
            String string = boundedResponse == null ? "is not indicated" : (boundedResponseText = ((BoolExpression)boundedResponse.getValue()).isValue() ? "is \"true\"" : "is \"false\"");
            if (hasBoundedResponse) {
                String msg;
                if (uncontrollablesBound == null) {
                    msg = Strings.fmt((String)"missing an argument named \"uncontrollablesBound\", since \"boundedResponse\" %s.", (Object[])new Object[]{boundedResponseText});
                    reporter.reportProblem(annotation, msg, boundedResponse.getPosition(), SemanticProblemSeverity.ERROR);
                }
                if (controllablesBound == null) {
                    msg = Strings.fmt((String)"missing an argument named \"controllablesBound\", since \"boundedResponse\" %s.", (Object[])new Object[]{boundedResponseText});
                    reporter.reportProblem(annotation, msg, boundedResponse.getPosition(), SemanticProblemSeverity.ERROR);
                }
            } else {
                String msg;
                if (uncontrollablesBound != null) {
                    msg = Strings.fmt((String)"unsupported argument named \"uncontrollablesBound\", since \"boundedResponse\" %s.", (Object[])new Object[]{boundedResponseText});
                    reporter.reportProblem(annotation, msg, uncontrollablesBound.getPosition(), SemanticProblemSeverity.ERROR);
                }
                if (controllablesBound != null) {
                    msg = Strings.fmt((String)"unsupported argument named \"controllablesBound\", since \"boundedResponse\" %s.", (Object[])new Object[]{boundedResponseText});
                    reporter.reportProblem(annotation, msg, controllablesBound.getPosition(), SemanticProblemSeverity.ERROR);
                }
            }
        }
    }

    @Override
    public final void checkGlobal(Specification spec, AnnotationProblemReporter reporter) {
        long count = CifAnnotationUtils.getAnnotations((AnnotatedObject)spec, (String)this.annotationName).count();
        if (count > 1L) {
            reporter.reportProblem(this.annotationName, Strings.fmt((String)"the specification has more than one controller properties annotation, namely %d.", (Object[])new Object[]{count}), spec.getPosition(), SemanticProblemSeverity.ERROR);
        }
    }
}

