/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.preconditions;

import java.util.List;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToBddExprOnlySupportedExprsCheck
extends CifCheckNoCompDefInst {
    protected void preprocessAssignment(Assignment asgn, CifCheckViolations violations) {
        CifToBddExprOnlySupportedExprsCheck.checkExprOrPred(asgn.getValue(), false, true, violations);
    }

    protected void preprocessVariableValue(VariableValue values, CifCheckViolations violations) {
        for (Expression value : values.getValues()) {
            CifToBddExprOnlySupportedExprsCheck.checkExprOrPred(value, true, false, violations);
        }
    }

    protected void preprocessEdge(Edge edge, CifCheckViolations violations) {
        CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)edge.getGuards(), false, violations);
    }

    protected void preprocessComplexComponent(ComplexComponent comp, CifCheckViolations violations) {
        CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)comp.getInitials(), true, violations);
        CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)comp.getMarkeds(), false, violations);
    }

    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)loc.getInitials(), true, violations);
        CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)loc.getMarkeds(), false, violations);
    }

    protected void preprocessInvariant(Invariant inv, CifCheckViolations violations) {
        CifToBddExprOnlySupportedExprsCheck.checkPred(inv.getPredicate(), false, violations);
    }

    protected void preprocessEdgeSend(EdgeSend edgeSend, CifCheckViolations violations) {
        Expression value = edgeSend.getValue();
        if (value != null) {
            CifToBddExprOnlySupportedExprsCheck.checkExprOrPred(value, false, false, violations);
        }
    }

    public static void checkExprOrPred(Expression expr, boolean initial, boolean allowSubtract, CifCheckViolations violations) {
        CifType type = CifTypeUtils.normalizeType((CifType)expr.getType());
        if (type instanceof BoolType) {
            CifToBddExprOnlySupportedExprsCheck.checkPred(expr, initial, violations);
        } else if (type instanceof IntType || type instanceof EnumType) {
            CifToBddExprOnlySupportedExprsCheck.checkExpr(expr, initial, allowSubtract, violations);
        } else {
            violations.add((PositionObject)expr, "A value of type \"%s\" is used", new Object[]{CifTextUtils.typeToStr((CifType)type)});
        }
    }

    public static void checkPreds(List<Expression> preds, boolean initial, CifCheckViolations violations) {
        for (Expression pred : preds) {
            CifToBddExprOnlySupportedExprsCheck.checkPred(pred, initial, violations);
        }
    }

    public static void checkPred(Expression pred, boolean initial, CifCheckViolations violations) {
        Object valueObj;
        CifType type = CifTypeUtils.normalizeType((CifType)pred.getType());
        Assert.check((boolean)(type instanceof BoolType));
        if (pred instanceof BoolExpression) {
            return;
        }
        if (pred instanceof DiscVariableExpression) {
            return;
        }
        if (pred instanceof InputVariableExpression) {
            return;
        }
        if (pred instanceof AlgVariableExpression) {
            AlgVariableExpression algExpr = (AlgVariableExpression)pred;
            AlgVariable var = algExpr.getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)var.getType()) instanceof BoolType));
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            CifToBddExprOnlySupportedExprsCheck.checkPred(value, initial, violations);
            return;
        }
        if (pred instanceof LocationExpression) {
            return;
        }
        if (pred instanceof ConstantExpression) {
            return;
        }
        if (pred instanceof UnaryExpression) {
            UnaryExpression unaryExpr = (UnaryExpression)pred;
            UnaryOperator op = unaryExpr.getOperator();
            switch (op) {
                case INVERSE: {
                    CifToBddExprOnlySupportedExprsCheck.checkPred(unaryExpr.getChild(), initial, violations);
                    return;
                }
            }
        } else if (pred instanceof BinaryExpression) {
            BinaryExpression binaryExpr = (BinaryExpression)pred;
            Expression lhs = binaryExpr.getLeft();
            Expression rhs = binaryExpr.getRight();
            BinaryOperator op = binaryExpr.getOperator();
            switch (op) {
                case DISJUNCTION: 
                case CONJUNCTION: {
                    CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
                    CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
                    if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) {
                        violations.add((PositionObject)pred, "Binary operator \"%s\" is used on values of types \"%s\" and \"%s\"", new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
                        return;
                    }
                    CifToBddExprOnlySupportedExprsCheck.checkPred(lhs, initial, violations);
                    CifToBddExprOnlySupportedExprsCheck.checkPred(rhs, initial, violations);
                    return;
                }
                case IMPLICATION: 
                case BI_CONDITIONAL: {
                    CifToBddExprOnlySupportedExprsCheck.checkPred(lhs, initial, violations);
                    CifToBddExprOnlySupportedExprsCheck.checkPred(rhs, initial, violations);
                    return;
                }
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case EQUAL: 
                case UNEQUAL: {
                    CifToBddExprOnlySupportedExprsCheck.checkCmpPred(binaryExpr, initial, violations);
                    return;
                }
            }
        } else {
            if (pred instanceof IfExpression) {
                IfExpression ifExpr = (IfExpression)pred;
                CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)ifExpr.getGuards(), initial, violations);
                CifToBddExprOnlySupportedExprsCheck.checkPred(ifExpr.getThen(), initial, violations);
                for (ElifExpression elif : ifExpr.getElifs()) {
                    CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)elif.getGuards(), initial, violations);
                    CifToBddExprOnlySupportedExprsCheck.checkPred(elif.getThen(), initial, violations);
                }
                CifToBddExprOnlySupportedExprsCheck.checkPred(ifExpr.getElse(), initial, violations);
                return;
            }
            if (pred instanceof SwitchExpression) {
                SwitchExpression switchExpr = (SwitchExpression)pred;
                Expression value = switchExpr.getValue();
                boolean isAutSwitch = CifTypeUtils.isAutRefExpr((Expression)value);
                if (!isAutSwitch) {
                    CifToBddExprOnlySupportedExprsCheck.checkExprOrPred(value, initial, false, violations);
                }
                for (SwitchCase switchCase : switchExpr.getCases()) {
                    if (switchCase.getKey() != null) {
                        CifToBddExprOnlySupportedExprsCheck.checkExprOrPred(switchCase.getKey(), initial, false, violations);
                    }
                    CifToBddExprOnlySupportedExprsCheck.checkPred(switchCase.getValue(), initial, violations);
                }
                return;
            }
            if (pred instanceof ReceivedExpression) {
                return;
            }
        }
        Expression notSingleValue = CifValueUtils.findNonSingleValueSubExpr((Expression)pred, (boolean)initial, (boolean)true);
        if (notSingleValue != null) {
            violations.add((PositionObject)notSingleValue, "Value is too complex to be statically evaluated, or evaluation results in a runtime error", new Object[0]);
            return;
        }
        try {
            valueObj = CifEvalUtils.eval((Expression)pred, (boolean)initial);
        }
        catch (CifEvalException ex) {
            Expression reportObj = ex.expr != null ? ex.expr : pred;
            violations.add((PositionObject)reportObj, "Failed to statically evaluate a predicate", new Object[0]);
            return;
        }
        Assert.check((boolean)(valueObj instanceof Boolean));
    }

    private static void checkCmpPred(BinaryExpression cmpPred, boolean initial, CifCheckViolations violations) {
        Expression lhs = cmpPred.getLeft();
        Expression rhs = cmpPred.getRight();
        CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
        if (ltype instanceof BoolType && rtype instanceof BoolType) {
            CifToBddExprOnlySupportedExprsCheck.checkPred(lhs, initial, violations);
            CifToBddExprOnlySupportedExprsCheck.checkPred(rhs, initial, violations);
        } else if (ltype instanceof EnumType && rtype instanceof EnumType || ltype instanceof IntType && rtype instanceof IntType) {
            CifToBddExprOnlySupportedExprsCheck.checkExpr(lhs, initial, false, violations);
            CifToBddExprOnlySupportedExprsCheck.checkExpr(rhs, initial, false, violations);
        } else {
            violations.add((PositionObject)cmpPred, "Binary operator \"%s\" is used on values of types \"%s\" and \"%s\"", new Object[]{CifTextUtils.operatorToStr((BinaryOperator)cmpPred.getOperator()), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
        }
    }

    public static void checkExpr(Expression expr, boolean initial, boolean allowSubtract, CifCheckViolations violations) {
        Object valueObj;
        UnaryExpression unaryExpr;
        UnaryOperator op;
        CifType type = CifTypeUtils.normalizeType((CifType)expr.getType());
        Assert.check((type instanceof IntType || type instanceof EnumType ? 1 : 0) != 0);
        if (expr instanceof DiscVariableExpression) {
            return;
        }
        if (expr instanceof InputVariableExpression) {
            return;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariableExpression algExpr = (AlgVariableExpression)expr;
            AlgVariable var = algExpr.getVariable();
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            CifToBddExprOnlySupportedExprsCheck.checkExpr(value, initial, allowSubtract, violations);
            return;
        }
        if (expr instanceof UnaryExpression && (op = (unaryExpr = (UnaryExpression)expr).getOperator()) == UnaryOperator.PLUS) {
            CifToBddExprOnlySupportedExprsCheck.checkExpr(unaryExpr.getChild(), initial, false, violations);
            return;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binaryExpr = (BinaryExpression)expr;
            Expression lhs = binaryExpr.getLeft();
            Expression rhs = binaryExpr.getRight();
            BinaryOperator op2 = binaryExpr.getOperator();
            switch (op2) {
                case ADDITION: {
                    CifToBddExprOnlySupportedExprsCheck.checkExpr(lhs, initial, false, violations);
                    CifToBddExprOnlySupportedExprsCheck.checkExpr(rhs, initial, false, violations);
                    return;
                }
                case SUBTRACTION: {
                    if (!allowSubtract) break;
                    CifToBddExprOnlySupportedExprsCheck.checkExpr(lhs, initial, false, violations);
                    CifToBddExprOnlySupportedExprsCheck.checkExpr(rhs, initial, false, violations);
                    return;
                }
                case MODULUS: 
                case INTEGER_DIVISION: {
                    Object rhsValueObj;
                    CifToBddExprOnlySupportedExprsCheck.checkExpr(lhs, initial, false, violations);
                    Expression notSingleValue = CifValueUtils.findNonSingleValueSubExpr((Expression)rhs, (boolean)initial, (boolean)true);
                    if (notSingleValue != null) {
                        violations.add((PositionObject)notSingleValue, "Value is too complex to be statically evaluated, or evaluation results in a runtime error", new Object[0]);
                        return;
                    }
                    try {
                        rhsValueObj = CifEvalUtils.eval((Expression)rhs, (boolean)initial);
                    }
                    catch (CifEvalException ex) {
                        Expression reportObj = ex.expr != null ? ex.expr : rhs;
                        violations.add((PositionObject)reportObj, "Failed to statically evaluate the divisor for \"%s\"", new Object[]{op2});
                        return;
                    }
                    int divisor = (Integer)rhsValueObj;
                    if (divisor == 0) {
                        violations.add((PositionObject)rhs, "Division by zero for \"%s\"", new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op2)});
                        return;
                    }
                    if (divisor < 0) {
                        violations.add((PositionObject)rhs, "Division by a negative value for \"%s\"", new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op2)});
                        return;
                    }
                    return;
                }
            }
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)ifExpr.getGuards(), initial, violations);
            CifToBddExprOnlySupportedExprsCheck.checkExpr(ifExpr.getThen(), initial, false, violations);
            for (ElifExpression elif : ifExpr.getElifs()) {
                CifToBddExprOnlySupportedExprsCheck.checkPreds((List<Expression>)elif.getGuards(), initial, violations);
                CifToBddExprOnlySupportedExprsCheck.checkExpr(elif.getThen(), initial, false, violations);
            }
            CifToBddExprOnlySupportedExprsCheck.checkExpr(ifExpr.getElse(), initial, false, violations);
            return;
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            boolean isAutSwitch = CifTypeUtils.isAutRefExpr((Expression)value);
            if (!isAutSwitch) {
                CifToBddExprOnlySupportedExprsCheck.checkExprOrPred(value, initial, false, violations);
            }
            for (SwitchCase switchCase : switchExpr.getCases()) {
                if (switchCase.getKey() != null) {
                    CifToBddExprOnlySupportedExprsCheck.checkExprOrPred(switchCase.getKey(), initial, false, violations);
                }
                CifToBddExprOnlySupportedExprsCheck.checkExpr(switchCase.getValue(), initial, false, violations);
            }
            return;
        }
        if (expr instanceof ReceivedExpression) {
            return;
        }
        Expression notSingleValue = CifValueUtils.findNonSingleValueSubExpr((Expression)expr, (boolean)initial, (boolean)true);
        if (notSingleValue != null) {
            violations.add((PositionObject)notSingleValue, "Value is too complex to be statically evaluated, or evaluation results in a runtime error", new Object[0]);
            return;
        }
        try {
            valueObj = CifEvalUtils.eval((Expression)expr, (boolean)initial);
        }
        catch (CifEvalException ex) {
            Expression reportObj = ex.expr != null ? ex.expr : expr;
            violations.add((PositionObject)reportObj, "Failed to statically evaluate an expression", new Object[0]);
            return;
        }
        if (valueObj instanceof Integer) {
            Integer value = (Integer)valueObj;
            if (value < 0) {
                violations.add((PositionObject)expr, "A negative integer value is used (%d)", new Object[]{value});
                return;
            }
            return;
        }
        if (valueObj instanceof CifEnumLiteral) {
            return;
        }
        throw new AssertionError((Object)("Unexpected value: " + String.valueOf(valueObj)));
    }
}

