/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc;

import java.util.List;
import org.eclipse.escet.cif.cif2plc.CifToPlcTrans;
import org.eclipse.escet.cif.cif2plc.options.ConvertEnumsOption;
import org.eclipse.escet.cif.cif2plc.options.PlcConfigurationNameOption;
import org.eclipse.escet.cif.cif2plc.options.PlcFormalFuncInvokeArgOption;
import org.eclipse.escet.cif.cif2plc.options.PlcFormalFuncInvokeFuncOption;
import org.eclipse.escet.cif.cif2plc.options.PlcMaxIterOption;
import org.eclipse.escet.cif.cif2plc.options.PlcNumberBitsOption;
import org.eclipse.escet.cif.cif2plc.options.PlcOutputType;
import org.eclipse.escet.cif.cif2plc.options.PlcOutputTypeOption;
import org.eclipse.escet.cif.cif2plc.options.PlcProjectNameOption;
import org.eclipse.escet.cif.cif2plc.options.PlcResourceNameOption;
import org.eclipse.escet.cif.cif2plc.options.PlcTaskCycleTimeOption;
import org.eclipse.escet.cif.cif2plc.options.PlcTaskNameOption;
import org.eclipse.escet.cif.cif2plc.options.PlcTaskPriorityOption;
import org.eclipse.escet.cif.cif2plc.options.RenameWarningsOption;
import org.eclipse.escet.cif.cif2plc.options.SimplifyValuesOption;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcProject;
import org.eclipse.escet.cif.cif2plc.writers.Iec611313Writer;
import org.eclipse.escet.cif.cif2plc.writers.PlcOpenXmlWriter;
import org.eclipse.escet.cif.cif2plc.writers.S7Writer;
import org.eclipse.escet.cif.cif2plc.writers.TwinCatWriter;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;

public class CifToPlcApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifToPlcApp app = new CifToPlcApp();
        app.run(args, true);
    }

    public CifToPlcApp() {
    }

    public CifToPlcApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF PLC code generator";
    }

    public String getAppDescription() {
        return "Generates PLC code for CIF files.";
    }

    protected int runInternal() {
        PlcProject project;
        Specification spec = (Specification)((CifReader)new CifReader().init()).read();
        String absSpecPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        PlcOutputType outType = PlcOutputTypeOption.getPlcOutputType();
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)outType.outFileExtOrDirPostfix);
        Assert.notNull((Object)outPath);
        outPath = Paths.resolve((String)outPath);
        try {
            project = CifToPlcTrans.transform(spec, absSpecPath, () -> this.isTerminationRequested());
            if (this.isTerminationRequested()) {
                return 0;
            }
        }
        catch (UnsupportedException ex) {
            String msg = Strings.fmt((String)"PLC code generation failed for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
            throw new UnsupportedException(msg, (Throwable)ex);
        }
        switch (outType) {
            case PLC_OPEN_XML: {
                new PlcOpenXmlWriter().write(project, outPath);
                break;
            }
            case IEC_61131_3: {
                new Iec611313Writer().write(project, outPath);
                break;
            }
            case TWINCAT: {
                new TwinCatWriter().write(project, outPath);
                break;
            }
            case S7_1500: 
            case S7_1200: 
            case S7_400: 
            case S7_300: {
                new S7Writer(outType).write(project, outPath);
                break;
            }
            default: {
                throw new RuntimeException("Unknown output type: " + String.valueOf((Object)outType));
            }
        }
        return 0;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifToPlcApp.getGeneralOptionCategory();
        List genOpts = Lists.list();
        genOpts.add(Options.getInstance(InputFileOption.class));
        genOpts.add(Options.getInstance(OutputFileOption.class));
        genOpts.add(Options.getInstance(PlcOutputTypeOption.class));
        genOpts.add(Options.getInstance(PlcTaskNameOption.class));
        genOpts.add(Options.getInstance(PlcTaskCycleTimeOption.class));
        genOpts.add(Options.getInstance(PlcTaskPriorityOption.class));
        genOpts.add(Options.getInstance(PlcProjectNameOption.class));
        genOpts.add(Options.getInstance(PlcConfigurationNameOption.class));
        genOpts.add(Options.getInstance(PlcResourceNameOption.class));
        genOpts.add(Options.getInstance(PlcNumberBitsOption.class));
        genOpts.add(Options.getInstance(PlcMaxIterOption.class));
        genOpts.add(Options.getInstance(PlcFormalFuncInvokeArgOption.class));
        genOpts.add(Options.getInstance(PlcFormalFuncInvokeFuncOption.class));
        genOpts.add(Options.getInstance(ConvertEnumsOption.class));
        genOpts.add(Options.getInstance(SimplifyValuesOption.class));
        genOpts.add(Options.getInstance(RenameWarningsOption.class));
        List genSubCats = Lists.list();
        OptionCategory genCat = new OptionCategory("Generator", "Generator options.", genSubCats, genOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, genCat});
        OptionCategory options = new OptionCategory("CIF PLC Code Generator Options", "All options for the CIF PLC code generator.", cats, Lists.list());
        return options;
    }
}

