/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion.expressions;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprAddressableResult;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenResult;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprValueResult;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.names.NameScope;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcRealLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentBlock;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcSelectionStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSetIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class ExprGenerator {
    private static final CifType CIF_INT_TYPE = CifConstructors.newIntType();
    private static final CifType CIF_REAL_TYPE = CifConstructors.newRealType();
    private final NameScope localNameScope = new NameScope();
    private final List<PlcDataVariable> variables = Lists.list();
    private final Map<String, Integer> varNameToVarIndex = Maps.map();
    private final BitSet variableIsScratch = new BitSet();
    private final BitSet variableIsAvailable = new BitSet();
    final PlcTarget target;
    private final NameGenerator nameGenerator;
    private final TypeGenerator typeGenerator;
    private final CifDataProvider scopeCifDataProvider;
    private CifDataProvider currentCifDataProvider;
    private final PlcFunctionAppls funcAppls;
    private PlcBasicVariable channelValueVariable = null;

    public ExprGenerator(PlcTarget target, NameGenerator nameGenerator, TypeGenerator typeGenerator, CifDataProvider cifDataProvider) {
        this.target = target;
        this.nameGenerator = nameGenerator;
        this.typeGenerator = typeGenerator;
        this.scopeCifDataProvider = cifDataProvider;
        this.currentCifDataProvider = cifDataProvider;
        this.funcAppls = new PlcFunctionAppls(target);
    }

    public PlcBasicVariable getScratchVariable(String prefix, CifType cifType) {
        PlcType plcType = this.typeGenerator.convertType(cifType);
        return this.getScratchVariable(prefix, plcType);
    }

    public PlcBasicVariable getScratchVariable(String prefix, PlcType plcType) {
        Iterator iterator = new BitSetIterator(this.variableIsAvailable).iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            PlcBasicVariable var = this.variables.get(idx);
            if (!plcType.equals(var.type) || !var.varName.startsWith(prefix)) continue;
            this.variableIsAvailable.clear(idx);
            return var;
        }
        return this.createVariable(prefix, plcType, null, null, true);
    }

    public PlcDataVariable makeLocalVariable(String prefix, PlcType plcType) {
        return this.createVariable(prefix, plcType, null, null, false);
    }

    public PlcDataVariable makeLocalVariable(String prefix, PlcType plcType, String address, PlcExpression value) {
        return this.createVariable(prefix, plcType, address, value, false);
    }

    private PlcDataVariable createVariable(String prefix, PlcType plcType, String address, PlcExpression value, boolean isScratchVar) {
        String name = this.nameGenerator.generateLocalName(prefix, this.localNameScope);
        String targetText = this.target.getUsageVariableText(PlcVariablePurpose.LOCAL_VAR, name);
        PlcDataVariable newVar = new PlcDataVariable(targetText, name, plcType, address, value);
        this.addLocalVariable(newVar, isScratchVar);
        return newVar;
    }

    public void addLocalVariable(PlcDataVariable variable, boolean isScratchVar) {
        int newVarIndex = this.variables.size();
        this.variables.add(variable);
        this.varNameToVarIndex.put(variable.varName, newVarIndex);
        if (isScratchVar) {
            this.variableIsScratch.set(newVarIndex);
        }
    }

    public void releaseScratchVariables(Collection<PlcBasicVariable> variables) {
        for (PlcBasicVariable var : variables) {
            this.releaseScratchVariable(var);
        }
    }

    public void releaseScratchVariable(PlcBasicVariable variable) {
        Integer idx = this.varNameToVarIndex.get(variable.varName);
        if (idx == null || !this.variableIsScratch.get(idx)) {
            return;
        }
        this.variableIsAvailable.set(idx);
    }

    public List<PlcDataVariable> getCreatedScratchVariables() {
        List scratchVars = Lists.listc((int)this.variableIsScratch.cardinality());
        Iterator iterator = new BitSetIterator(this.variableIsScratch).iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            scratchVars.add(this.variables.get(idx));
        }
        Collections.sort(scratchVars, Comparator.comparing(v -> v.varName));
        return scratchVars;
    }

    public CifDataProvider getScopeCifDataProvider() {
        return this.scopeCifDataProvider;
    }

    public void setCurrentCifDataProvider(CifDataProvider newCifDataProvider) {
        this.currentCifDataProvider = newCifDataProvider == null ? this.scopeCifDataProvider : newCifDataProvider;
    }

    public void setChannelValueVariable(PlcBasicVariable channelValueVariable) {
        this.channelValueVariable = channelValueVariable;
    }

    public ExprAddressableResult convertVariableAddressable(Expression expr) {
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression de = (DiscVariableExpression)expr;
            return (ExprAddressableResult)new ExprAddressableResult((Declaration)de.getVariable(), this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getAddressableForDiscVar(de.getVariable()));
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression ce = (ContVariableExpression)expr;
            return (ExprAddressableResult)new ExprAddressableResult((Declaration)ce.getVariable(), this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getAddressableForContvar(ce.getVariable()));
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }

    public ExprValueResult convertValue(Expression expr) {
        if (expr instanceof BoolExpression) {
            BoolExpression be = (BoolExpression)expr;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(new PlcBoolLiteral(be.isValue()));
        }
        if (expr instanceof IntExpression) {
            IntExpression ie = (IntExpression)expr;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.target.makeStdInteger(ie.getValue()));
        }
        if (expr instanceof RealExpression) {
            RealExpression re = (RealExpression)expr;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.target.makeStdReal(re.getValue()));
        }
        if (expr instanceof StringExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        if (expr instanceof TimeExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        if (expr instanceof CastExpression) {
            CastExpression ce = (CastExpression)expr;
            return this.convertCastExpr(ce);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression ue = (UnaryExpression)expr;
            return this.convertUnaryExpr(ue);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expr;
            return this.convertBinaryExpr(be);
        }
        if (expr instanceof IfExpression) {
            IfExpression ife = (IfExpression)expr;
            return this.convertIfExpr(ife);
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pe = (ProjectionExpression)expr;
            return this.convertProjectionValue((Expression)pe);
        }
        if (expr instanceof SliceExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fce = (FunctionCallExpression)expr;
            return this.convertFuncCallExpr(fce);
        }
        if (expr instanceof ListExpression) {
            ListExpression le = (ListExpression)expr;
            return this.convertArrayExpr(le);
        }
        if (expr instanceof SetExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        if (expr instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)expr;
            return this.convertTupleExpr(te);
        }
        if (expr instanceof DictExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        if (expr instanceof ConstantExpression) {
            ConstantExpression ce = (ConstantExpression)expr;
            if (this.target.supportsConstant(ce.getConstant())) {
                return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getValueForConstant(ce.getConstant()));
            }
            return this.convertValue(ce.getConstant().getValue());
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression de = (DiscVariableExpression)expr;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getValueForDiscVar(de.getVariable()));
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariableExpression ae = (AlgVariableExpression)expr;
            return this.convertValue(ae.getVariable().getValue());
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression ce = (ContVariableExpression)expr;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getValueForContvar(ce.getVariable(), ce.isDerivative()));
        }
        if (expr instanceof LocationExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteralExpression eLitExpr = (EnumLiteralExpression)expr;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.typeGenerator.convertEnumLiteral(eLitExpr.getLiteral()));
        }
        if (expr instanceof FunctionExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        if (expr instanceof InputVariableExpression) {
            InputVariableExpression ie = (InputVariableExpression)expr;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getValueForInputVar(ie.getVariable()));
        }
        if (expr instanceof ReceivedExpression) {
            Assert.notNull((Object)this.channelValueVariable);
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(new PlcVarExpression(this.channelValueVariable, new PlcVarExpression.PlcProjection[0]));
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }

    private ExprValueResult convertCastExpr(CastExpression castExpr) {
        ExprValueResult result = this.convertValue(castExpr.getChild());
        CifType ctype = CifTypeUtils.normalizeType((CifType)castExpr.getChild().getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)castExpr.getType());
        if (ctype instanceof IntType && rtype instanceof RealType) {
            return (ExprValueResult)result.setValue(this.funcAppls.castFuncAppl(result.value, this.target.getStdRealType()));
        }
        if (CifTypeUtils.checkTypeCompat((CifType)ctype, (CifType)rtype, (RangeCompat)RangeCompat.EQUAL)) {
            return result;
        }
        throw new RuntimeException("Precondition violation.");
    }

    private ExprValueResult convertUnaryExpr(UnaryExpression unaryExpr) {
        ExprValueResult result = this.convertValue(unaryExpr.getChild());
        switch (unaryExpr.getOperator()) {
            case INVERSE: {
                return (ExprValueResult)result.setValue(this.funcAppls.complementFuncAppl(result.value));
            }
            case NEGATE: {
                return (ExprValueResult)result.setValue(this.funcAppls.negateFuncAppl(result.value));
            }
            case PLUS: {
                return result;
            }
            case SAMPLE: {
                throw new RuntimeException("Precondition violation.");
            }
        }
        throw new RuntimeException("Unknown unop: " + String.valueOf(unaryExpr.getOperator()));
    }

    private ExprValueResult convertBinaryExpr(BinaryExpression binExpr) {
        CifType ltype = CifTypeUtils.normalizeType((CifType)binExpr.getLeft().getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)binExpr.getRight().getType());
        ExprValueResult leftResult = this.convertValue(binExpr.getLeft());
        ExprValueResult rightResult = this.convertValue(binExpr.getRight());
        ExprValueResult result = new ExprValueResult(this, leftResult, rightResult);
        switch (binExpr.getOperator()) {
            case IMPLICATION: {
                ExprValueResult[] exprValueResults = new ExprValueResult[]{leftResult, rightResult};
                PlcExpression[] values = new PlcExpression[]{this.funcAppls.complementFuncAppl(leftResult.value), rightResult.value};
                return this.generateShortCircuitConds(BinaryOperator.DISJUNCTION, exprValueResults, values);
            }
            case BI_CONDITIONAL: {
                return (ExprValueResult)result.setValue(this.funcAppls.equalFuncAppl(leftResult.value, rightResult.value));
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                if (ltype instanceof BoolType) {
                    return this.convertFlattenedExpr(binExpr);
                }
                throw new RuntimeException("Precondition violation.");
            }
            case LESS_THAN: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                return (ExprValueResult)result.setValue(this.funcAppls.lessThanFuncAppl(leftSide, rightSide));
            }
            case LESS_EQUAL: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                return (ExprValueResult)result.setValue(this.funcAppls.lessEqualFuncAppl(leftSide, rightSide));
            }
            case GREATER_THAN: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                return (ExprValueResult)result.setValue(this.funcAppls.greaterThanFuncAppl(leftSide, rightSide));
            }
            case GREATER_EQUAL: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                return (ExprValueResult)result.setValue(this.funcAppls.greaterEqualFuncAppl(leftSide, rightSide));
            }
            case EQUAL: {
                if (ltype instanceof BoolType || ltype instanceof IntType || ltype instanceof RealType || ltype instanceof EnumType) {
                    return (ExprValueResult)result.setValue(this.funcAppls.equalFuncAppl(leftResult.value, rightResult.value));
                }
                throw new RuntimeException("Precondition violation.");
            }
            case UNEQUAL: {
                if (ltype instanceof BoolType || ltype instanceof IntType || ltype instanceof RealType || ltype instanceof EnumType) {
                    return (ExprValueResult)result.setValue(this.funcAppls.unEqualFuncAppl(leftResult.value, rightResult.value));
                }
                throw new RuntimeException("Precondition violation.");
            }
            case ADDITION: {
                if (ltype instanceof IntType || ltype instanceof RealType) {
                    return this.convertFlattenedExpr(binExpr);
                }
                throw new RuntimeException("Precondition violation.");
            }
            case SUBTRACTION: {
                if (ltype instanceof IntType || ltype instanceof RealType) {
                    PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                    PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                    return (ExprValueResult)result.setValue(this.funcAppls.subtractFuncAppl(leftSide, rightSide));
                }
                throw new RuntimeException("Precondition violation.");
            }
            case MULTIPLICATION: {
                return this.convertFlattenedExpr(binExpr);
            }
            case DIVISION: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, CIF_REAL_TYPE);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, CIF_REAL_TYPE);
                return (ExprValueResult)result.setValue(this.funcAppls.divideFuncAppl(leftSide, rightSide));
            }
            case INTEGER_DIVISION: {
                return (ExprValueResult)result.setValue(this.funcAppls.divideFuncAppl(leftResult.value, rightResult.value));
            }
            case MODULUS: {
                return (ExprValueResult)result.setValue(this.funcAppls.moduloFuncAppl(leftResult.value, rightResult.value));
            }
            case ELEMENT_OF: {
                throw new RuntimeException("Precondition violation.");
            }
            case SUBSET: {
                throw new RuntimeException("Precondition violation.");
            }
        }
        throw new RuntimeException("Unknown binary expression operator: " + String.valueOf(binExpr.getOperator()));
    }

    private ExprValueResult convertFlattenedExpr(BinaryExpression binExpr) {
        CifType unifiedType;
        boolean unifyTypes = switch (binExpr.getOperator()) {
            case BinaryOperator.DISJUNCTION -> false;
            case BinaryOperator.CONJUNCTION -> false;
            case BinaryOperator.ADDITION -> true;
            case BinaryOperator.MULTIPLICATION -> true;
            default -> throw new RuntimeException("Unexpected flattened binary expression operator: " + String.valueOf(binExpr.getOperator()));
        };
        List exprs = CifValueUtils.flattenBinExpr(List.of(binExpr), (BinaryOperator)binExpr.getOperator());
        if (unifyTypes) {
            unifiedType = CIF_INT_TYPE;
            for (Expression expr : exprs) {
                if (!(CifTypeUtils.normalizeType((CifType)expr.getType()) instanceof RealType)) continue;
                unifiedType = CIF_REAL_TYPE;
                break;
            }
        } else {
            unifiedType = null;
        }
        ExprGenResult[] exprValueResults = new ExprGenResult[exprs.size()];
        PlcExpression[] values = new PlcExpression[exprs.size()];
        int i = 0;
        for (Expression expr : exprs) {
            ExprValueResult exprValueResult = this.convertValue(expr);
            exprValueResults[i] = exprValueResult;
            values[i] = unifyTypes ? this.unifyTypeOfExpr(exprValueResult.value, CifTypeUtils.normalizeType((CifType)expr.getType()), unifiedType) : exprValueResult.value;
            ++i;
        }
        switch (binExpr.getOperator()) {
            case DISJUNCTION: 
            case CONJUNCTION: {
                return this.generateShortCircuitConds(binExpr.getOperator(), exprValueResults, values);
            }
            case ADDITION: {
                ExprValueResult exprValueResult = new ExprValueResult(this, exprValueResults);
                return (ExprValueResult)exprValueResult.setValue(this.funcAppls.addFuncAppl(values));
            }
            case MULTIPLICATION: {
                ExprValueResult exprValueResult = new ExprValueResult(this, exprValueResults);
                return (ExprValueResult)exprValueResult.setValue(this.funcAppls.multiplyFuncAppl(values));
            }
        }
        throw new RuntimeException("Unexpected flattened binary expression operator: " + String.valueOf(binExpr.getOperator()));
    }

    private ExprValueResult generateShortCircuitConds(BinaryOperator binOp, ExprGenResult<?, ?>[] exprValueResults, PlcExpression[] values) {
        if (exprValueResults.length == 1) {
            return (ExprValueResult)new ExprValueResult(this, exprValueResults[0]).setValue(values[0]);
        }
        switch (binOp) {
            case CONJUNCTION: {
                if (!this.target.supportsOperation(PlcFuncOperation.AND_SHORT_CIRCUIT_OP, values.length)) break;
                ExprValueResult exprValueResult = new ExprValueResult(this, exprValueResults);
                return (ExprValueResult)exprValueResult.setValue(this.funcAppls.andFuncAppl(true, values));
            }
            case DISJUNCTION: {
                if (!this.target.supportsOperation(PlcFuncOperation.OR_SHORT_CIRCUIT_OP, values.length)) break;
                ExprValueResult exprValueResult = new ExprValueResult(this, exprValueResults);
                return (ExprValueResult)exprValueResult.setValue(this.funcAppls.orFuncAppl(true, values));
            }
            default: {
                throw new RuntimeException("Unexpected flattened binary expression operator: " + String.valueOf(binOp));
            }
        }
        ExprValueResult result = new ExprValueResult(this, new ExprGenResult[0]);
        PlcBasicVariable resultVariable = this.getScratchVariable("b", PlcElementaryType.BOOL_TYPE);
        int i = 0;
        while (i < exprValueResults.length) {
            ExprGenResult<?, ?> genResult = exprValueResults[i];
            List thenStats = Lists.list();
            thenStats.addAll(genResult.code);
            result.codeVariables.addAll(genResult.codeVariables);
            thenStats.add(new PlcAssignmentStatement(resultVariable, values[i]));
            result.codeVariables.addAll(genResult.valueVariables);
            if (i == 0) {
                result.code.addAll(thenStats);
            } else {
                PlcVarExpression condition = new PlcVarExpression(resultVariable, new PlcVarExpression.PlcProjection[0]);
                condition = binOp == BinaryOperator.DISJUNCTION ? this.funcAppls.complementFuncAppl(condition) : condition;
                result.code.add(new PlcSelectionStatement(new PlcSelectionStatement.PlcSelectChoice((PlcExpression)condition, thenStats)));
            }
            ++i;
        }
        result.value = new PlcVarExpression(resultVariable, new PlcVarExpression.PlcProjection[0]);
        result.valueVariables.add(resultVariable);
        return result;
    }

    private ExprValueResult convertIfExpr(IfExpression ifExpr) {
        ExprValueResult result = new ExprValueResult(this, new ExprGenResult[0]);
        PlcType resultValueType = this.typeGenerator.convertType(ifExpr.getType());
        PlcBasicVariable resultVar = this.getScratchVariable("ifResult", resultValueType);
        result.valueVariables.add(resultVar);
        result.setValue(new PlcVarExpression(resultVar, new PlcVarExpression.PlcProjection[0]));
        PlcSelectionStatement selStat = null;
        selStat = this.addBranch((List<Expression>)ifExpr.getGuards(), this.generateThenStatement(resultVar, ifExpr.getThen()), selStat, result.code);
        for (ElifExpression elif : ifExpr.getElifs()) {
            selStat = this.addBranch((List<Expression>)elif.getGuards(), this.generateThenStatement(resultVar, elif.getThen()), selStat, result.code);
        }
        this.addBranch(null, this.generateThenStatement(resultVar, ifExpr.getElse()), selStat, result.code);
        return result;
    }

    private Supplier<List<PlcStatement>> generateThenStatement(PlcBasicVariable resultVar, Expression resultValue) {
        return () -> {
            List statements = Lists.list();
            ExprValueResult retValueResult = this.convertValue(resultValue);
            statements.addAll(retValueResult.code);
            statements.add(new PlcAssignmentStatement(new PlcVarExpression(resultVar, new PlcVarExpression.PlcProjection[0]), retValueResult.value));
            this.releaseScratchVariables(retValueResult.codeVariables);
            this.releaseScratchVariables(retValueResult.valueVariables);
            return statements;
        };
    }

    public PlcSelectionStatement addBranch(List<Expression> guards, Supplier<List<PlcStatement>> genThenStats, PlcSelectionStatement selStat, List<PlcStatement> rootCode) {
        List<ExprValueResult> convertedGuards;
        if (guards == null) {
            convertedGuards = null;
        } else if (guards.isEmpty()) {
            convertedGuards = List.of((ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(new PlcBoolLiteral(true)));
        } else {
            convertedGuards = Lists.listc((int)guards.size());
            for (Expression guard : guards) {
                convertedGuards.add(this.convertValue(guard));
            }
        }
        return this.addPlcBranch(convertedGuards, genThenStats, selStat, rootCode);
    }

    public PlcSelectionStatement addPlcBranch(List<ExprValueResult> plcGuards, Supplier<List<PlcStatement>> genThenStats, PlcSelectionStatement selStat, List<PlcStatement> rootCode) {
        List<PlcStatement> codeStorage;
        List<PlcStatement> list = codeStorage = selStat != null ? selStat.elseStats : rootCode;
        if (plcGuards != null) {
            PlcExpression[] grdValues = new PlcExpression[plcGuards.size()];
            boolean seenGuardCode = false;
            Set grdVariables = Sets.set();
            int grdNum = 0;
            for (ExprValueResult grdResult : plcGuards) {
                if (grdResult.hasCode()) {
                    seenGuardCode = true;
                    codeStorage.addAll(grdResult.code);
                    grdVariables.addAll(grdResult.codeVariables);
                }
                grdVariables.addAll(grdResult.valueVariables);
                grdValues[grdNum] = grdResult.value;
                ++grdNum;
            }
            if (selStat == null || seenGuardCode) {
                selStat = new PlcSelectionStatement();
                codeStorage.add(selStat);
            }
            PlcSelectionStatement.PlcSelectChoice choice = grdNum == 1 ? new PlcSelectionStatement.PlcSelectChoice(grdValues[0], Lists.list()) : new PlcSelectionStatement.PlcSelectChoice((PlcExpression)this.funcAppls.andFuncAppl(false, grdValues), Lists.list());
            selStat.condChoices.add(choice);
            this.releaseScratchVariables(grdVariables);
            codeStorage = choice.thenStats;
        }
        codeStorage.addAll((Collection<PlcStatement>)genThenStats.get());
        return selStat;
    }

    public ExprAddressableResult convertProjectedAddressable(Expression expr) {
        List projections = Lists.list();
        while (expr instanceof ProjectionExpression) {
            ProjectionExpression proj = (ProjectionExpression)expr;
            projections.add(proj);
            expr = proj.getChild();
        }
        Assert.check((!projections.isEmpty() ? 1 : 0) != 0);
        ExprAddressableResult exprResult = this.convertVariableAddressable(expr);
        PlcVarExpression varExpr = new PlcVarExpression(((PlcVarExpression)exprResult.value).variable, this.convertAddProjections(projections, Lists.copy(((PlcVarExpression)exprResult.value).projections), exprResult));
        exprResult.setValue(varExpr);
        return exprResult;
    }

    private ExprValueResult convertProjectionValue(Expression expr) {
        List projections = Lists.list();
        while (expr instanceof ProjectionExpression) {
            ProjectionExpression proj = (ProjectionExpression)expr;
            projections.add(proj);
            expr = proj.getChild();
        }
        Assert.check((!projections.isEmpty() ? 1 : 0) != 0);
        ExprValueResult exprResult = this.convertValue(expr);
        if (exprResult.value instanceof PlcVarExpression) {
            PlcVarExpression parentVarExpr = (PlcVarExpression)exprResult.value;
            PlcVarExpression varExpr = new PlcVarExpression(parentVarExpr.variable, this.convertAddProjections(projections, Lists.copy(parentVarExpr.projections), exprResult));
            exprResult.setValue(varExpr);
            return exprResult;
        }
        PlcType plcType = this.typeGenerator.convertType(expr.getType());
        PlcBasicVariable projectVar = this.getScratchVariable("project", plcType);
        ExprValueResult convertResult = new ExprValueResult(this, exprResult);
        PlcVarExpression varExpr = new PlcVarExpression(projectVar, new PlcVarExpression.PlcProjection[0]);
        convertResult.code.add(new PlcAssignmentStatement(varExpr, convertResult.value));
        convertResult.codeVariables.addAll(exprResult.valueVariables);
        convertResult.setValue(new PlcVarExpression(projectVar, this.convertAddProjections(projections, Lists.list(), convertResult)));
        convertResult.valueVariables.add(projectVar);
        return convertResult;
    }

    private List<PlcVarExpression.PlcProjection> convertAddProjections(List<ProjectionExpression> cifProjections, List<PlcVarExpression.PlcProjection> plcProjections, ExprGenResult<?, ?> convertResult) {
        int i = cifProjections.size() - 1;
        while (i >= 0) {
            ProjectionExpression cifProjection = cifProjections.get(i);
            CifType unProjectedType = CifTypeUtils.normalizeType((CifType)cifProjection.getChild().getType());
            Expression cifIndexExpr = cifProjection.getIndex();
            if (unProjectedType instanceof ListType) {
                ListType lt = (ListType)unProjectedType;
                ExprValueResult indexResult = this.convertValue(cifIndexExpr);
                convertResult.mergeCodeAndVariables(indexResult);
                PlcFuncAppl normalizedIndex = this.funcAppls.normalizeArrayIndex(indexResult.value, lt.getUpper());
                plcProjections.add(new PlcVarExpression.PlcArrayProjection(normalizedIndex));
            } else if (unProjectedType instanceof TupleType) {
                TupleType tt = (TupleType)unProjectedType;
                int fieldIndex = CifValueUtils.getTupleProjIndex((ProjectionExpression)cifProjection);
                PlcStructType structType = this.typeGenerator.convertTupleType(tt);
                plcProjections.add(new PlcVarExpression.PlcStructProjection(structType.fields.get((int)fieldIndex).fieldName));
            } else {
                throw new AssertionError((Object)("Unexpected unprojected type \"" + String.valueOf(unProjectedType) + "\" found."));
            }
            --i;
        }
        return plcProjections;
    }

    private ExprValueResult convertFuncCallExpr(FunctionCallExpression funcCallExpr) {
        List argumentResults = Lists.listc((int)funcCallExpr.getArguments().size());
        for (Expression arg : funcCallExpr.getArguments()) {
            argumentResults.add(this.convertValue(arg));
        }
        Expression fexpr = funcCallExpr.getFunction();
        if (fexpr instanceof StdLibFunctionExpression) {
            return this.convertStdlibExpr(funcCallExpr, argumentResults);
        }
        throw new RuntimeException("Calls to internal user-defined functions are not implemented yet.");
    }

    private ExprValueResult convertStdlibExpr(FunctionCallExpression stdlibCallExpr, List<ExprValueResult> argumentResults) {
        EList arguments = stdlibCallExpr.getArguments();
        StdLibFunction stdlib = ((StdLibFunctionExpression)stdlibCallExpr.getFunction()).getFunction();
        switch (stdlib) {
            case ABS: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.absFuncAppl(arg1.value));
            }
            case CEIL: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return this.cifCeil(arg1);
            }
            case DELETE: {
                throw new RuntimeException("Precondition violation.");
            }
            case EMPTY: {
                throw new RuntimeException("Precondition violation.");
            }
            case EXP: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.expFuncAppl(arg1.value));
            }
            case FLOOR: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return this.cifFloor(arg1);
            }
            case FORMAT: {
                throw new RuntimeException("Precondition violation.");
            }
            case LN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.lnFuncAppl(arg1.value));
            }
            case LOG: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                if (!this.target.supportsOperation(PlcFuncOperation.STDLIB_LOG, argumentResults.size())) {
                    PlcFuncAppl lnX = this.funcAppls.lnFuncAppl(arg1.value);
                    PlcFuncAppl ln10 = this.funcAppls.lnFuncAppl(this.target.makeStdReal("10.0"));
                    return (ExprValueResult)arg1.setValue(this.funcAppls.divideFuncAppl(lnX, ln10));
                }
                return (ExprValueResult)arg1.setValue(this.funcAppls.logFuncAppl(arg1.value));
            }
            case MINIMUM: 
            case MAXIMUM: {
                Assert.check((argumentResults.size() == 2 ? 1 : 0) != 0);
                CifType ltype = CifTypeUtils.normalizeType((CifType)((Expression)arguments.get(0)).getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)((Expression)arguments.get(1)).getType());
                PlcExpression leftSide = this.unifyTypeOfExpr(argumentResults.get((int)0).value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(argumentResults.get((int)1).value, rtype, ltype);
                ExprValueResult result = new ExprValueResult(this, argumentResults.get(0), argumentResults.get(1));
                if (stdlib == StdLibFunction.MAXIMUM) {
                    return (ExprValueResult)result.setValue(this.funcAppls.maxFuncAppl(leftSide, rightSide));
                }
                return (ExprValueResult)result.setValue(this.funcAppls.minFuncAppl(leftSide, rightSide));
            }
            case POP: {
                throw new RuntimeException("Precondition violation.");
            }
            case ROUND: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                ExprValueResult exprResult = new ExprValueResult(this, arg1);
                exprResult.code.add(new PlcCommentLine("CIFround(arg) = CIFfloor(arg + 0.5)"));
                PlcRealLiteral aHalf = new PlcRealLiteral("0.5", arg1.value.type);
                exprResult.value = this.funcAppls.addFuncAppl(arg1.value, aHalf);
                return this.cifFloor(exprResult);
            }
            case SCALE: {
                Assert.check((argumentResults.size() == 5 ? 1 : 0) != 0);
                ExprValueResult valueResult = argumentResults.get(0);
                ExprValueResult inMinResult = argumentResults.get(1);
                ExprValueResult inMaxResult = argumentResults.get(2);
                ExprValueResult outMinResult = argumentResults.get(3);
                ExprValueResult outMaxResult = argumentResults.get(4);
                ExprValueResult exprResult = new ExprValueResult(this, valueResult, inMinResult, inMaxResult, outMinResult, outMaxResult);
                exprResult.code.add(new PlcCommentBlock(0, List.of("CIFscale: Input value 'inMin' is scaled to output value 'outMin'. Input value", "'inMax' is scaled to output value 'outMax'. All other values are scaled by", "interpolating or extrapolating from those value pairs.")));
                PlcVarExpression value = new PlcVarExpression(this.ensureFreshRealVariable("value", valueResult.value, exprResult), new PlcVarExpression.PlcProjection[0]);
                PlcVarExpression inMin = new PlcVarExpression(this.ensureFreshRealVariable("inMin", inMinResult.value, exprResult), new PlcVarExpression.PlcProjection[0]);
                PlcVarExpression inMax = new PlcVarExpression(this.ensureFreshRealVariable("inMax", inMaxResult.value, exprResult), new PlcVarExpression.PlcProjection[0]);
                PlcVarExpression outMin = new PlcVarExpression(this.ensureFreshRealVariable("outMin", outMinResult.value, exprResult), new PlcVarExpression.PlcProjection[0]);
                PlcVarExpression outMax = new PlcVarExpression(this.ensureFreshRealVariable("outMax", outMaxResult.value, exprResult), new PlcVarExpression.PlcProjection[0]);
                PlcFuncAppl valueSubInMin = this.funcAppls.subtractFuncAppl(value, inMin);
                PlcFuncAppl inMaxSubInMin = this.funcAppls.subtractFuncAppl(inMax, inMin);
                PlcFuncAppl fraction = this.funcAppls.divideFuncAppl(valueSubInMin, inMaxSubInMin);
                PlcFuncAppl outRange = this.funcAppls.subtractFuncAppl(outMax, outMin);
                PlcFuncAppl offset = this.funcAppls.multiplyFuncAppl(fraction, outRange);
                exprResult.value = this.funcAppls.addFuncAppl(outMin, offset);
                return exprResult;
            }
            case SIGN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                PlcExpression argValue = arg1.value;
                PlcExpression inputZero = PlcElementaryType.isIntType(argValue.type) ? new PlcIntLiteral(0, argValue.type) : new PlcRealLiteral("0.0", argValue.type);
                PlcFuncAppl lessZero = this.funcAppls.lessThanFuncAppl(argValue, inputZero);
                PlcFuncAppl greaterZero = this.funcAppls.greaterThanFuncAppl(argValue, inputZero);
                PlcElementaryType resultType = this.target.getStdIntegerType();
                PlcIntLiteral plusOne = new PlcIntLiteral(1, resultType);
                PlcFuncAppl minusOne = this.funcAppls.negateFuncAppl(new PlcIntLiteral(1, resultType));
                PlcIntLiteral intZero = new PlcIntLiteral(0, resultType);
                PlcFuncAppl selectLess = this.funcAppls.selFuncAppl(lessZero, intZero, minusOne);
                PlcFuncAppl selectGreater = this.funcAppls.selFuncAppl(greaterZero, selectLess, plusOne);
                ExprValueResult exprResult = new ExprValueResult(this, arg1);
                exprResult.code.add(new PlcCommentBlock(0, List.of("CIFsign(x) = -1 if x < 0", "              0 if x = 0", "             +1 if x > 0")));
                return (ExprValueResult)exprResult.setValue(selectGreater);
            }
            case SIZE: {
                throw new RuntimeException("Precondition violation.");
            }
            case SQRT: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.sqrtFuncAppl(arg1.value));
            }
            case ACOS: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.acosFuncAppl(arg1.value));
            }
            case ASIN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.asinFuncAppl(arg1.value));
            }
            case ATAN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.atanFuncAppl(arg1.value));
            }
            case COS: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.cosFuncAppl(arg1.value));
            }
            case SIN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.sinFuncAppl(arg1.value));
            }
            case TAN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.tanFuncAppl(arg1.value));
            }
            case POWER: 
            case CBRT: 
            case ACOSH: 
            case ASINH: 
            case ATANH: 
            case COSH: 
            case SINH: 
            case TANH: {
                throw new RuntimeException("Precondition violation.");
            }
            case BERNOULLI: 
            case BETA: 
            case BINOMIAL: 
            case CONSTANT: 
            case ERLANG: 
            case EXPONENTIAL: 
            case GAMMA: 
            case GEOMETRIC: 
            case LOG_NORMAL: 
            case NORMAL: 
            case POISSON: 
            case RANDOM: 
            case TRIANGLE: 
            case UNIFORM: 
            case WEIBULL: {
                throw new RuntimeException("Precondition violation.");
            }
        }
        throw new RuntimeException("Unexpected standard library function: " + String.valueOf(stdlib));
    }

    private PlcBasicVariable ensureFreshRealVariable(String name, PlcExpression value, ExprValueResult exprResult) {
        PlcElementaryType stdRealType = this.target.getStdRealType();
        PlcBasicVariable variable = this.getScratchVariable(name, stdRealType);
        exprResult.valueVariables.add(variable);
        if (value.type.equals(stdRealType)) {
            exprResult.code.add(new PlcAssignmentStatement(variable, value));
        } else {
            exprResult.code.add(new PlcAssignmentStatement(variable, (PlcExpression)this.funcAppls.castFuncAppl(value, stdRealType)));
        }
        return variable;
    }

    private ExprValueResult cifFloor(ExprValueResult argument) {
        PlcElementaryType argumentType = (PlcElementaryType)argument.value.type;
        Assert.check((boolean)PlcElementaryType.isRealType(argumentType));
        ExprValueResult exprResult = new ExprValueResult(this, argument);
        exprResult.code.add(new PlcCommentLine("CIFfloor: Round down towards -infinity."));
        PlcBasicVariable trunced = this.getScratchVariable("trunced", CIF_INT_TYPE);
        PlcElementaryType truncedType = (PlcElementaryType)trunced.type;
        exprResult.valueVariables.add(trunced);
        exprResult.code.add(new PlcAssignmentStatement(trunced, (PlcExpression)this.funcAppls.truncFuncAppl(argument.value, truncedType)));
        exprResult.code.add(new PlcCommentBlock(0, List.of("If trunced = inputValue, the inputValue was already floored.", "If inputValue >= 0, TRUNC already rounded towards -infinity.", "If inputValue <= minimal " + truncedType.name + " value, TRUNC already rounded towards -infinity as far as possible.")));
        PlcFuncAppl truncedAsReal = this.funcAppls.castFuncAppl(new PlcVarExpression(trunced, new PlcVarExpression.PlcProjection[0]), argumentType);
        PlcFuncAppl unEqual = this.funcAppls.unEqualFuncAppl(truncedAsReal, argument.value);
        PlcFuncAppl below0 = this.funcAppls.lessThanFuncAppl(argument.value, new PlcRealLiteral("0.0", argumentType));
        PlcFuncAppl aboveMinInt = this.funcAppls.greaterThanFuncAppl(argument.value, new PlcRealLiteral(String.valueOf(PlcElementaryType.getMinIntValue(truncedType)) + ".0", argumentType));
        PlcFuncAppl cond = this.funcAppls.andFuncAppl(false, unEqual, below0, aboveMinInt);
        PlcFuncAppl truncedSub1 = this.funcAppls.subtractFuncAppl(new PlcVarExpression(trunced, new PlcVarExpression.PlcProjection[0]), new PlcIntLiteral(1, this.target.getStdIntegerType()));
        exprResult.value = this.funcAppls.selFuncAppl(cond, new PlcVarExpression(trunced, new PlcVarExpression.PlcProjection[0]), truncedSub1);
        return exprResult;
    }

    private ExprValueResult cifCeil(ExprValueResult argument) {
        PlcElementaryType argumentType = (PlcElementaryType)argument.value.type;
        Assert.check((boolean)PlcElementaryType.isRealType(argumentType));
        ExprValueResult exprResult = new ExprValueResult(this, argument);
        exprResult.code.add(new PlcCommentLine("CIFceil: Round up towards +infinity."));
        PlcBasicVariable trunced = this.getScratchVariable("trunced", CIF_INT_TYPE);
        PlcElementaryType truncedType = (PlcElementaryType)trunced.type;
        exprResult.valueVariables.add(trunced);
        exprResult.code.add(new PlcAssignmentStatement(trunced, (PlcExpression)this.funcAppls.truncFuncAppl(argument.value, truncedType)));
        exprResult.code.add(new PlcCommentBlock(0, List.of("If trunced = inputValue, the inputValue was already ceiled.", "If inputValue <= 0, TRUNC already rounded towards +infinity.", "If inputValue >= maximal " + truncedType.name + " value, TRUNC already rounded towards +infinity as far as possible.")));
        PlcFuncAppl truncedAsReal = this.funcAppls.castFuncAppl(new PlcVarExpression(trunced, new PlcVarExpression.PlcProjection[0]), argumentType);
        PlcFuncAppl unEqual = this.funcAppls.unEqualFuncAppl(truncedAsReal, argument.value);
        PlcFuncAppl above0 = this.funcAppls.greaterThanFuncAppl(argument.value, new PlcRealLiteral("0.0", argumentType));
        PlcFuncAppl belowMaxInt = this.funcAppls.lessThanFuncAppl(argument.value, new PlcRealLiteral(String.valueOf(PlcElementaryType.getMaxIntValue(truncedType)) + ".0", argumentType));
        PlcFuncAppl cond = this.funcAppls.andFuncAppl(false, unEqual, above0, belowMaxInt);
        PlcFuncAppl truncedAdd1 = this.funcAppls.addFuncAppl(new PlcVarExpression(trunced, new PlcVarExpression.PlcProjection[0]), new PlcIntLiteral(1, this.target.getStdIntegerType()));
        exprResult.value = this.funcAppls.selFuncAppl(cond, new PlcVarExpression(trunced, new PlcVarExpression.PlcProjection[0]), truncedAdd1);
        return exprResult;
    }

    private ExprValueResult convertArrayExpr(ListExpression listExpr) {
        PlcType listType = this.typeGenerator.convertType(listExpr.getType());
        PlcBasicVariable arrayVar = this.getScratchVariable("litArray", listType);
        ExprValueResult result = new ExprValueResult(this, new ExprGenResult[0]);
        int idx = 0;
        for (Expression e : listExpr.getElements()) {
            ExprValueResult childResult = this.convertValue(e);
            result.mergeCode(childResult);
            this.releaseScratchVariables(childResult.codeVariables);
            PlcVarExpression.PlcArrayProjection arrayProj = new PlcVarExpression.PlcArrayProjection(this.target.makeStdInteger(idx));
            PlcVarExpression lhs = new PlcVarExpression(arrayVar, List.of(arrayProj));
            PlcAssignmentStatement assignment = new PlcAssignmentStatement(lhs, childResult.value);
            ++idx;
            result.code.add(assignment);
            this.releaseScratchVariables(childResult.valueVariables);
        }
        result.valueVariables.add(arrayVar);
        return (ExprValueResult)result.setValue(new PlcVarExpression(arrayVar, new PlcVarExpression.PlcProjection[0]));
    }

    private ExprValueResult convertTupleExpr(TupleExpression tupleExpr) {
        TupleType tupleType = (TupleType)CifTypeUtils.normalizeType((CifType)tupleExpr.getType());
        PlcStructType structType = this.typeGenerator.convertTupleType(tupleType);
        PlcBasicVariable structVar = this.getScratchVariable("litStruct", structType);
        ExprValueResult result = new ExprValueResult(this, new ExprGenResult[0]);
        int idx = 0;
        for (Expression e : tupleExpr.getFields()) {
            ExprValueResult childResult = this.convertValue(e);
            result.mergeCode(childResult);
            this.releaseScratchVariables(childResult.codeVariables);
            PlcVarExpression.PlcStructProjection structProj = new PlcVarExpression.PlcStructProjection(structType.fields.get((int)idx).fieldName);
            PlcVarExpression lhs = new PlcVarExpression(structVar, List.of(structProj));
            PlcAssignmentStatement assignment = new PlcAssignmentStatement(lhs, childResult.value);
            ++idx;
            result.code.add(assignment);
            this.releaseScratchVariables(childResult.valueVariables);
        }
        result.valueVariables.add(structVar);
        return (ExprValueResult)result.setValue(new PlcVarExpression(structVar, new PlcVarExpression.PlcProjection[0]));
    }

    private PlcExpression unifyTypeOfExpr(PlcExpression expr, CifType myType, CifType otherType) {
        if (myType instanceof IntType && otherType instanceof RealType) {
            return this.funcAppls.castFuncAppl(expr, this.target.getStdRealType());
        }
        return expr;
    }
}

