/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.converter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class CCStringIndentation {
    private static final Pattern lineSeparatorPattern = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(\\r(\\n)?|\\n)");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private final String ccString;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final ImmutableList<String> splittedLines;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final boolean ignoreFirst;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final boolean ignoreLast;

    public static boolean hasLineBreak(String nodeText) {
        int _countLineBreaks = Strings.countLineBreaks((CharSequence)nodeText);
        return _countLineBreaks > 0;
    }

    public static String firstLineSeparator(String it) {
        boolean _greaterEqualsThan;
        String _switchResult = null;
        boolean _matched = false;
        int _indexOf = it.indexOf("\r\n");
        boolean bl = _greaterEqualsThan = _indexOf >= 0;
        if (_greaterEqualsThan) {
            _matched = true;
            _switchResult = "\r\n";
        }
        if (!_matched) {
            boolean _greaterEqualsThan_1;
            int _indexOf_1 = it.indexOf("\n");
            boolean bl2 = _greaterEqualsThan_1 = _indexOf_1 >= 0;
            if (_greaterEqualsThan_1) {
                _matched = true;
                _switchResult = "\n";
            }
        }
        if (!_matched) {
            boolean _greaterEqualsThan_2;
            int _indexOf_2 = it.indexOf("\r");
            boolean bl3 = _greaterEqualsThan_2 = _indexOf_2 >= 0;
            if (_greaterEqualsThan_2) {
                _matched = true;
                _switchResult = "\r";
            }
        }
        if (!_matched) {
            _switchResult = Strings.newLine();
        }
        return _switchResult;
    }

    public CCStringIndentation(String ccString) {
        this.ccString = ccString;
        ArrayList _newArrayList = CollectionLiterals.newArrayList();
        Procedures.Procedure1 _function = lines -> {
            boolean _lessThan;
            Matcher matcher = lineSeparatorPattern.matcher(ccString);
            int lastOffset = 0;
            while (matcher.find()) {
                String _substring = ccString.substring(lastOffset, matcher.end());
                lines.add(_substring);
                lastOffset = matcher.end();
            }
            int _length = ccString.length();
            boolean bl = _lessThan = lastOffset < _length;
            if (_lessThan) {
                String _substring = ccString.substring(lastOffset);
                lines.add(_substring);
            } else if (ccString.endsWith("\n") || ccString.endsWith("\r")) {
                lines.add("");
            }
        };
        ArrayList _doubleArrow = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)_newArrayList, (Procedures.Procedure1)_function);
        this.splittedLines = ImmutableList.copyOf((Collection)_doubleArrow);
        this.ignoreFirst = this.splittedLines.size() >= 2 && ((String)IterableExtensions.head(this.splittedLines)).trim().isEmpty();
        this.ignoreLast = this.splittedLines.size() >= 2 && ((String)IterableExtensions.last(this.splittedLines)).trim().isEmpty();
    }

    public String removeEditorWhiteSpace() {
        return this.removeEditorWhiteSpace("", null);
    }

    protected String removeEditorWhiteSpace(String indent, String lineSeparator) {
        Functions.Function1 _function = offsetLength -> {
            Integer _key = (Integer)offsetLength.getKey();
            Integer _value = (Integer)offsetLength.getValue();
            int _plus = _key + _value;
            String _substring = this.ccString.substring((Integer)offsetLength.getKey(), _plus);
            return indent + _substring;
        };
        Functions.Function1 _function_1 = it -> this.replaceLineBreak((String)it, lineSeparator);
        return IterableExtensions.join((Iterable)ListExtensions.map((List)ListExtensions.map(this.highlight(), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public boolean canRemoveEditorIndentation() {
        return this.splittedLines.size() >= 2 && this.ignoreFirst && this.hasConsistentIndentation();
    }

    public String replaceEditorIndentation(String indentation, String lineSeparator) {
        String _xifexpression = null;
        if (indentation != null && this.canRemoveEditorIndentation()) {
            String _xblockexpression = null;
            String _xifexpression_1 = null;
            if (this.ignoreFirst && this.splittedLines.size() > 2) {
                String _elvis = null;
                if (lineSeparator != null) {
                    _elvis = lineSeparator;
                } else {
                    String _head = (String)IterableExtensions.head(this.splittedLines);
                    String _firstLineSeparator = null;
                    if (_head != null) {
                        _firstLineSeparator = CCStringIndentation.firstLineSeparator(_head);
                    }
                    _elvis = _firstLineSeparator;
                }
                _xifexpression_1 = _elvis;
            } else {
                _xifexpression_1 = "";
            }
            String addFirstLine = _xifexpression_1;
            String _removeEditorWhiteSpace = this.removeEditorWhiteSpace(indentation, lineSeparator);
            _xifexpression = _xblockexpression = addFirstLine + _removeEditorWhiteSpace;
        } else {
            String _xblockexpression_1 = null;
            ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])((String[])Conversions.unwrapArray(this.splittedLines, String.class)));
            Procedures.Procedure1 _function = it -> {
                if (this.ignoreFirst) {
                    it.set(0, CCStringIndentation.firstLineSeparator((String)IterableExtensions.head((Iterable)it)));
                }
                if (this.ignoreLast) {
                    int _size = it.size();
                    int _minus = _size - 1;
                    it.remove(_minus);
                }
            };
            ArrayList lines = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)_newArrayList, (Procedures.Procedure1)_function);
            Functions.Function1 _function_1 = it -> this.replaceLineBreak((String)it, lineSeparator);
            _xifexpression = _xblockexpression_1 = IterableExtensions.join((Iterable)ListExtensions.map((List)lines, (Functions.Function1)_function_1));
        }
        return _xifexpression;
    }

    private String replaceLineBreak(String line, String newLineSeparator) {
        String _xifexpression = null;
        if (newLineSeparator != null && Strings.countLineBreaks((CharSequence)line) > 0) {
            CharSequence _trimTrailingLineBreak = Strings.trimTrailingLineBreak((CharSequence)line);
            _xifexpression = _trimTrailingLineBreak + newLineSeparator;
        } else {
            _xifexpression = line;
        }
        return _xifexpression;
    }

    public List<Pair<Integer, Integer>> highlight() {
        ArrayList offsetLengthLines = CollectionLiterals.newArrayList();
        String editorIndent = this.computeEditorIndent(false);
        int skip = editorIndent.length();
        int offset = 0;
        for (int i = 0; i < ((Object[])Conversions.unwrapArray(this.splittedLines, Object.class)).length; ++i) {
            String line = (String)this.splittedLines.get(i);
            if (i == 0 && this.ignoreFirst) {
                int _offset = offset;
                int _length = line.length();
                offset = _offset + _length;
                continue;
            }
            if (i == this.splittedLines.size() - 1 && this.ignoreLast) continue;
            Pair _xifexpression = null;
            boolean _startsWith = line.startsWith(editorIndent);
            if (_startsWith) {
                int _length_1 = line.length();
                int _minus = _length_1 - skip;
                _xifexpression = Pair.of((Object)(offset + skip), (Object)_minus);
            } else {
                int _length_2 = line.length();
                _xifexpression = Pair.of((Object)offset, (Object)_length_2);
            }
            offsetLengthLines.add(_xifexpression);
            int _offset_1 = offset;
            int _length_3 = line.length();
            offset = _offset_1 + _length_3;
        }
        return offsetLengthLines;
    }

    public boolean hasConsistentIndentation() {
        String _computeEditorIndent = this.computeEditorIndent(true);
        return _computeEditorIndent != null;
    }

    protected String computeEditorIndent(boolean consistentOnly) {
        Functions.Function1 _function;
        String _xblockexpression = null;
        if (this.splittedLines.size() <= 1 || !this.ignoreFirst) {
            return "";
        }
        List _xblockexpression_1 = null;
        int _xifexpression = 0;
        _xifexpression = this.ignoreFirst ? 1 : 0;
        int begin = _xifexpression;
        int _size = this.splittedLines.size();
        int _xifexpression_1 = 0;
        _xifexpression_1 = this.ignoreLast ? 1 : 0;
        int end = _size - _xifexpression_1;
        Functions.Function1 _function2 = it -> Strings.trimTrailingLineBreak((CharSequence)it).toString();
        Functions.Function1 _function_1 = line -> {
            String _leadingWhiteSpace = Strings.getLeadingWhiteSpace((String)line);
            return Pair.of((Object)_leadingWhiteSpace, (Object)line);
        };
        List wsLinePairs = _xblockexpression_1 = IterableExtensions.toList((Iterable)ListExtensions.map(ListExtensions.map(this.splittedLines, (Functions.Function1)_function2).subList(begin, end), (Functions.Function1)_function_1));
        Functions.Function1 minWSComputor = _function = it -> {
            String _xifexpression = null;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)it);
            _xifexpression = _isEmpty ? "" : (String)((Object)IterableExtensions.min((Iterable)it));
            return _xifexpression;
        };
        Functions.Function1 _function_12 = it -> {
            boolean _isEmpty = ((String)it.getValue()).trim().isEmpty();
            return !_isEmpty;
        };
        Functions.Function1 _function_2 = it -> (String)it.getKey();
        String textIndent = (String)minWSComputor.apply((Object)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)wsLinePairs, (Functions.Function1)_function_12), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> (String)it.getKey();
        Functions.Function1 _function_4 = it -> {
            boolean _isEmpty = it.isEmpty();
            return !_isEmpty;
        };
        Functions.Function1 _function_5 = nonEmptyIndent -> nonEmptyIndent.startsWith(textIndent);
        boolean consistent = IterableExtensions.forall((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)wsLinePairs, (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5);
        String _switchResult = null;
        boolean _matched = false;
        if (consistent) {
            _matched = true;
            _switchResult = textIndent;
        }
        if (!_matched && consistentOnly) {
            _matched = true;
            _switchResult = null;
        }
        if (!_matched) {
            Functions.Function1 _function_6 = it -> (String)it.getKey();
            Functions.Function1 _function_7 = it -> {
                boolean _isEmpty = it.isEmpty();
                return !_isEmpty;
            };
            _switchResult = (String)minWSComputor.apply((Object)IterableExtensions.filter((Iterable)ListExtensions.map((List)wsLinePairs, (Functions.Function1)_function_6), (Functions.Function1)_function_7));
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    @Pure
    public ImmutableList<String> getSplittedLines() {
        return this.splittedLines;
    }

    @Pure
    public boolean isIgnoreFirst() {
        return this.ignoreFirst;
    }

    @Pure
    public boolean isIgnoreLast() {
        return this.ignoreLast;
    }
}

