/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.postprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.common.postprocessing.PostprocessingHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.GeneratedMetamodel;

public class DocuPostprocessor {
    public void process(GeneratedMetamodel metamodel) {
        EPackage pckg = metamodel.getEPackage();
        EClass cls = PostprocessingHelpers.getClass(pckg, "Import");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The import declares an imported {@link org.eclipse.etrice.core.room.RoomModel room model} (given as a URI) and");
        _builder.newLine();
        _builder.append("an optional imported namespace.");
        _builder.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder.toString());
        EAttribute _attribute = PostprocessingHelpers.getAttribute(cls, "importedNamespace");
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("The imported name space has to be a dot separated qualified name followed by .*.");
        _builder_1.newLine();
        _builder_1.append("Example: my.namespace.*");
        _builder_1.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute, _builder_1.toString());
        EAttribute _attribute_1 = PostprocessingHelpers.getAttribute(cls, "importURI");
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("The import URI can be a relative or absolute file system path.");
        _builder_2.newLine();
        _builder_2.append("It may contain environment variables in ${} which will be expanded.");
        _builder_2.newLine();
        _builder_2.append("<p>");
        _builder_2.newLine();
        _builder_2.append("Examples:");
        _builder_2.newLine();
        _builder_2.append("<ul>");
        _builder_2.newLine();
        _builder_2.append("  ");
        _builder_2.append("<li>import model \"AnotherModel.room\"</li>");
        _builder_2.newLine();
        _builder_2.append("  ");
        _builder_2.append("<li>import my.namespace.* from \"AnotherModel.room\"</li>");
        _builder_2.newLine();
        _builder_2.append("  ");
        _builder_2.append("<li>import my.namespace.* from \"../../AnotherProject/models/AnotherModel.room\"</li>");
        _builder_2.newLine();
        _builder_2.append("  ");
        _builder_2.append("<li>import my.namespace.* from \"/${ROOM_MODELS}/SomeModel.room\"</li>");
        _builder_2.newLine();
        _builder_2.append("</ul>");
        _builder_2.newLine();
        _builder_2.append("</p>");
        _builder_2.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_1, _builder_2.toString());
        cls = PostprocessingHelpers.getClass(pckg, "LiteralArray");
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("Aggregates one or more {@link Literal literals}.\t\t");
        _builder_3.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_3.toString());
        EReference _reference = PostprocessingHelpers.getReference(cls, "literals");
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("This is a list of literals.");
        _builder_4.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_reference, _builder_4.toString());
        cls = PostprocessingHelpers.getClass(pckg, "Literal");
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("It is the super class of");
        _builder_5.newLine();
        _builder_5.append("<ul>");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("<li>{@link BooleanLiteral}</li>");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("<li>{@link NumberLiteral}</li>");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("<li>{@link StringLiteral}</li>");
        _builder_5.newLine();
        _builder_5.append("</ul>");
        _builder_5.newLine();
        _builder_5.append("that represents a primitive value.");
        _builder_5.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_5.toString());
        cls = PostprocessingHelpers.getClass(pckg, "Documentation");
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("A piece of documentation that can be optionally attached at");
        _builder_6.newLine();
        _builder_6.append("certain places in the model.");
        _builder_6.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_6.toString());
        EAttribute _attribute_2 = PostprocessingHelpers.getAttribute(cls, "lines");
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("This is the documentation's contents.");
        _builder_7.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_2, _builder_7.toString());
        cls = PostprocessingHelpers.getClass(pckg, "Annotation");
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("An annotation similar to Java annotations that can be used");
        _builder_8.newLine();
        _builder_8.append("to add {@link KeyValue} pairs to certain model items. The structure ");
        _builder_8.newLine();
        _builder_8.append("of Annotations are defined by {@link AnnotationType}s.");
        _builder_8.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_8.toString());
        EReference _reference_1 = PostprocessingHelpers.getReference(cls, "type");
        StringConcatenation _builder_9 = new StringConcatenation();
        _builder_9.append("The {@link AnnotationType} that defines the structure of ");
        _builder_9.newLine();
        _builder_9.append("the annotation.");
        _builder_9.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_reference_1, _builder_9.toString());
        EReference _reference_2 = PostprocessingHelpers.getReference(cls, "attributes");
        StringConcatenation _builder_10 = new StringConcatenation();
        _builder_10.append("This is a list of key/value pairs.");
        _builder_10.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_reference_2, _builder_10.toString());
        cls = PostprocessingHelpers.getClass(pckg, "KeyValue");
        StringConcatenation _builder_11 = new StringConcatenation();
        _builder_11.append("A key/value pair.");
        _builder_11.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_11.toString());
        EAttribute _attribute_3 = PostprocessingHelpers.getAttribute(cls, "key");
        StringConcatenation _builder_12 = new StringConcatenation();
        _builder_12.append("This is the key of the pair.");
        _builder_12.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_3, _builder_12.toString());
        EReference _reference_3 = PostprocessingHelpers.getReference(cls, "value");
        StringConcatenation _builder_13 = new StringConcatenation();
        _builder_13.append("This is the value of the pair.");
        _builder_13.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_reference_3, _builder_13.toString());
        cls = PostprocessingHelpers.getClass(pckg, "AnnotationType");
        StringConcatenation _builder_14 = new StringConcatenation();
        _builder_14.append("Defines the structure of {@link Annotation}s.");
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_14.toString());
        EAttribute _attribute_4 = PostprocessingHelpers.getAttribute(cls, "name");
        StringConcatenation _builder_15 = new StringConcatenation();
        _builder_15.append("The name of the AnnotationType");
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_4, _builder_15.toString());
        EAttribute _attribute_5 = PostprocessingHelpers.getAttribute(cls, "targets");
        StringConcatenation _builder_16 = new StringConcatenation();
        _builder_16.append("A list of names representing the locations in which ");
        _builder_16.newLine();
        _builder_16.append("\t\t\t");
        _builder_16.append("{@link Annotation}s of this AnnotationType can occur");
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_5, _builder_16.toString());
        EReference _reference_4 = PostprocessingHelpers.getReference(cls, "docu");
        StringConcatenation _builder_17 = new StringConcatenation();
        _builder_17.append("Optional model-level documentation");
        PostprocessingHelpers.setDocumentation((EModelElement)_reference_4, _builder_17.toString());
        EReference _reference_5 = PostprocessingHelpers.getReference(cls, "attributes");
        StringConcatenation _builder_18 = new StringConcatenation();
        _builder_18.append("Defines the {@link AnnotationAttribute}s that are required or allowed in ");
        _builder_18.newLine();
        _builder_18.append("\t\t\t");
        _builder_18.append("{@link Annotation} instances of this AnnotationType");
        PostprocessingHelpers.setDocumentation((EModelElement)_reference_5, _builder_18.toString());
        cls = PostprocessingHelpers.getClass(pckg, "AnnotationAttribute");
        StringConcatenation _builder_19 = new StringConcatenation();
        _builder_19.append("Defines an attribute in an {@link AnnotationType}. This attribute ");
        _builder_19.newLine();
        _builder_19.append("\t\t\t");
        _builder_19.append("can then be declared in respective {@link Annotation} instances.");
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_19.toString());
        EAttribute _attribute_6 = PostprocessingHelpers.getAttribute(cls, "optional");
        StringConcatenation _builder_20 = new StringConcatenation();
        _builder_20.append("Specifies whether the attribute should be optional or not. If the ");
        _builder_20.newLine();
        _builder_20.append("\t\t\t");
        _builder_20.append("attribute is optional, it can be omitted by {@link Annotation}s of ");
        _builder_20.newLine();
        _builder_20.append("\t\t\t");
        _builder_20.append("the same {@link AnnotationType}.");
        _builder_20.newLine();
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_6, _builder_20.toString());
        EAttribute _attribute_7 = PostprocessingHelpers.getAttribute(cls, "name");
        StringConcatenation _builder_21 = new StringConcatenation();
        _builder_21.append("The name of the attribute");
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_7, _builder_21.toString());
        cls = PostprocessingHelpers.getClass(pckg, "SimpleAnnotationAttribute");
        StringConcatenation _builder_22 = new StringConcatenation();
        _builder_22.append("An {@link AnnotationAttribute} that is associated with a ");
        _builder_22.newLine();
        _builder_22.append("\t\t\t");
        _builder_22.append("{@link LiteralType}.");
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_22.toString());
        EAttribute _attribute_8 = PostprocessingHelpers.getAttribute(cls, "type");
        StringConcatenation _builder_23 = new StringConcatenation();
        _builder_23.append("The type of the attribute");
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_8, _builder_23.toString());
        cls = PostprocessingHelpers.getClass(pckg, "EnumAnnotationAttribute");
        StringConcatenation _builder_24 = new StringConcatenation();
        _builder_24.append("An {@link AnnotationAttribute} whose possible values are defined ");
        _builder_24.newLine();
        _builder_24.append("\t\t\t");
        _builder_24.append("by a list of String values.");
        PostprocessingHelpers.setDocumentation((EModelElement)cls, _builder_24.toString());
        EAttribute _attribute_9 = PostprocessingHelpers.getAttribute(cls, "values");
        StringConcatenation _builder_25 = new StringConcatenation();
        _builder_25.append("A list of values that define the enumeration");
        PostprocessingHelpers.setDocumentation((EModelElement)_attribute_9, _builder_25.toString());
    }
}

