/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SAPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.fsm.generic.FSMExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class RoomExtensions
extends FSMExtensions {
    public final String NEWLINE = System.getProperty("line.separator");
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;

    public List<Port> punion(Iterable<Port> in1, Iterable<ExternalPort> in2) {
        ArrayList<Port> ret = new ArrayList<Port>();
        Consumer<ExternalPort> _function = e -> ret.add(e.getInterfacePort());
        in2.forEach(_function);
        Iterables.addAll(ret, in1);
        return ret;
    }

    public String getModelPath(EObject e) {
        Resource res = e.eResource();
        if (res == null) {
            return "";
        }
        return res.getURI().toFileString();
    }

    public String getPackage(RoomClass rc) {
        EObject _eContainer = rc.eContainer();
        return ((RoomModel)_eContainer).getName();
    }

    public String getFullyQualifiedName(RoomClass rc) {
        String _replace = this.getPackage(rc).replace(".", "_");
        String _plus = _replace + "_";
        String _name = rc.getName();
        return _plus + _name;
    }

    public String getPathFromPackage(String packageName) {
        String _replaceAll = packageName.replaceAll("\\.", "/");
        return _replaceAll + "/";
    }

    public String getPath(RoomClass rc) {
        return this.getPathFromPackage(this.getPackage(rc));
    }

    public String getPathName(String path) {
        return path.replaceAll("/", "_").replaceAll(":", "_");
    }

    protected String _getPortClassName(Port p) {
        String _xifexpression = null;
        GeneralProtocolClass _protocol = p.getProtocol();
        if (_protocol instanceof ProtocolClass) {
            GeneralProtocolClass _protocol_1 = p.getProtocol();
            _xifexpression = this.getPortClassName((ProtocolClass)_protocol_1, p.isConjugated(), p.isReplicated());
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    protected String _getPortClassName(ExternalPort p) {
        return this.getPortClassName((RoomElement)p.getInterfacePort());
    }

    protected String _getPortClassName(SAP sap) {
        return this.getPortClassName(sap.getProtocol(), true);
    }

    protected String _getPortClassName(SPP spp) {
        return this.getPortClassName(spp.getProtocol(), false, true);
    }

    protected String _getPortClassName(ServiceImplementation svc) {
        return this.getPortClassName(svc.getSpp().getProtocol(), false, true);
    }

    public String getPortClassName(ProtocolClass p, boolean conj) {
        return this.getPortClassName(p, conj, false);
    }

    public String getPortClassName(ProtocolClass p, boolean conj, boolean repl) {
        String _name = p.getName();
        String _xifexpression = null;
        _xifexpression = conj ? "Conj" : "";
        String _plus = _name + _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = repl ? "Repl" : "";
        String _plus_1 = _plus + _xifexpression_1;
        return _plus_1 + "Port";
    }

    public PortClass getPortClass(ProtocolClass pc, boolean conj) {
        if (conj) {
            return pc.getConjugated();
        }
        return pc.getRegular();
    }

    public List<PortClass> getAllPortClasses(ProtocolClass pc, boolean conj) {
        ArrayList result = CollectionLiterals.newArrayList();
        for (ProtocolClass protocol = pc; protocol != null; protocol = protocol.getBase()) {
            boolean _tripleNotEquals_1;
            if (conj) {
                boolean _tripleNotEquals;
                PortClass _conjugated = protocol.getConjugated();
                boolean bl = _tripleNotEquals = _conjugated != null;
                if (!_tripleNotEquals) continue;
                result.add(protocol.getConjugated());
                continue;
            }
            PortClass _regular = protocol.getRegular();
            boolean bl = _tripleNotEquals_1 = _regular != null;
            if (!_tripleNotEquals_1) continue;
            result.add(protocol.getRegular());
        }
        return result;
    }

    public boolean handlesSend(ProtocolClass pc, boolean conj) {
        boolean _tripleEquals;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean bl = _tripleEquals = _portClass == null;
        if (_tripleEquals) {
            return false;
        }
        List allMessages = this._roomHelpers.getAllMessages(pc, conj);
        List<MessageHandler> _safeList = RoomExtensions.getSafeList((List<MessageHandler>)this.getPortClass(pc, conj).getMsgHandlers());
        for (MessageHandler hdlr : _safeList) {
            boolean _contains = allMessages.contains(hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean handlesReceive(ProtocolClass pc, boolean conj) {
        boolean _tripleEquals;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean bl = _tripleEquals = _portClass == null;
        if (_tripleEquals) {
            return false;
        }
        List allMessages = this._roomHelpers.getAllMessages(pc, !conj);
        List<MessageHandler> _safeList = RoomExtensions.getSafeList((List<MessageHandler>)this.getPortClass(pc, conj).getMsgHandlers());
        for (MessageHandler hdlr : _safeList) {
            boolean _contains = allMessages.contains(hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean handlesReceiveIncludingSuper(ProtocolClass pc, boolean conj) {
        List<PortClass> allPortClasses = this.getAllPortClasses(pc, conj);
        List allMessages = this._roomHelpers.getAllMessages(pc, !conj);
        for (PortClass p : allPortClasses) {
            List<MessageHandler> _safeList = RoomExtensions.getSafeList((List<MessageHandler>)p.getMsgHandlers());
            for (MessageHandler hdlr : _safeList) {
                boolean _contains = allMessages.contains(hdlr.getMsg());
                if (!_contains) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConjugated(InterfaceItemInstance iii) {
        if (iii instanceof PortInstance) {
            return ((PortInstance)iii).getPort().isConjugated();
        }
        if (iii instanceof SAPInstance) {
            return true;
        }
        if (iii instanceof ServiceImplInstance) {
            return false;
        }
        return false;
    }

    public List<MessageHandler> getReceiveHandlers(ProtocolClass pc, boolean conj) {
        boolean _tripleNotEquals;
        ArrayList<MessageHandler> res = new ArrayList<MessageHandler>();
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean bl = _tripleNotEquals = _portClass != null;
        if (_tripleNotEquals) {
            List allMessages = this._roomHelpers.getAllMessages(pc, !conj);
            List<MessageHandler> _safeList = RoomExtensions.getSafeList((List<MessageHandler>)this.getPortClass(pc, conj).getMsgHandlers());
            for (MessageHandler hdlr : _safeList) {
                boolean _contains = allMessages.contains(hdlr.getMsg());
                if (!_contains) continue;
                res.add(hdlr);
            }
        }
        return res;
    }

    public List<MessageHandler> getReceiveHandlersIncludingSuper(ProtocolClass pc, boolean conj) {
        ArrayList<MessageHandler> res = new ArrayList<MessageHandler>();
        List<PortClass> allPortClasses = this.getAllPortClasses(pc, conj);
        List allMsgs = this._roomHelpers.getAllMessages(pc, !conj);
        for (PortClass p : allPortClasses) {
            List<MessageHandler> _safeList = RoomExtensions.getSafeList((List<MessageHandler>)p.getMsgHandlers());
            for (MessageHandler hdlr : _safeList) {
                boolean _contains = allMsgs.contains(hdlr.getMsg());
                if (!_contains) continue;
                res.add(hdlr);
            }
        }
        return res;
    }

    public List<MessageHandler> getSendHandlers(ProtocolClass pc, boolean conj) {
        boolean _tripleEquals;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean bl = _tripleEquals = _portClass == null;
        if (_tripleEquals) {
            return Collections.emptyList();
        }
        ArrayList<MessageHandler> res = new ArrayList<MessageHandler>();
        List allMessages = this._roomHelpers.getAllMessages(pc, conj);
        List<MessageHandler> _safeList = RoomExtensions.getSafeList((List<MessageHandler>)this.getPortClass(pc, conj).getMsgHandlers());
        for (MessageHandler hdlr : _safeList) {
            boolean _contains = allMessages.contains(hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public MessageHandler getSendHandler(Message m, boolean conj) {
        EObject _eContainer = m.eContainer();
        Functions.Function1 _function = e -> {
            Message _msg = e.getMsg();
            return Objects.equal((Object)_msg, (Object)m);
        };
        return (MessageHandler)IterableExtensions.findFirst(this.getSendHandlers((ProtocolClass)_eContainer, conj), (Functions.Function1)_function);
    }

    public boolean isIncoming(Message m) {
        EObject _eContainer = m.eContainer();
        return this._roomHelpers.getAllIncomingMessages((ProtocolClass)_eContainer).contains(m);
    }

    public String getCodeName(Message m) {
        boolean _isIncoming = this.isIncoming(m);
        if (_isIncoming) {
            String _name = m.getName();
            return "IN_" + _name;
        }
        String _name_1 = m.getName();
        return "OUT_" + _name_1;
    }

    public boolean overridesStop(ActorClass ac) {
        return IterableExtensions.exists((Iterable)ac.getOperations(), e -> Objects.equal((Object)e.getName(), (Object)"stop") && e.getArguments().isEmpty() && e.getReturnType() == null) || ac.getActorBase() != null && this.overridesStop(ac.getActorBase());
    }

    public BasicEList<AbstractInstance> getAllSubInstances(StructureInstance ssi) {
        BasicEList result = new BasicEList();
        TreeIterator it = ssi.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof AbstractInstance)) continue;
            result.add((Object)((AbstractInstance)obj));
        }
        return result;
    }

    public static List<MessageHandler> getSafeList(List<MessageHandler> msgHandlers) {
        List<Object> _xifexpression = null;
        _xifexpression = msgHandlers == null ? Collections.emptyList() : msgHandlers;
        return _xifexpression;
    }

    public String getPortClassName(RoomElement p) {
        if (p instanceof Port) {
            return this._getPortClassName((Port)p);
        }
        if (p instanceof SAP) {
            return this._getPortClassName((SAP)p);
        }
        if (p instanceof SPP) {
            return this._getPortClassName((SPP)p);
        }
        if (p instanceof ExternalPort) {
            return this._getPortClassName((ExternalPort)p);
        }
        if (p instanceof ServiceImplementation) {
            return this._getPortClassName((ServiceImplementation)p);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(p).toString());
    }
}

