/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.StateMachineGen;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    @Extension
    protected CExtensions _cExtensions;
    @Inject
    @Extension
    protected ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    protected StateMachineGen _stateMachineGen;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    protected ILanguageExtension langExt;
    @Inject
    protected IGeneratorFileIO fileIO;
    @Inject
    protected ILogger logger;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Functions.Function1 _function_1 = it -> root.getExpandedActorClass(it);
        Consumer<ExpandedActorClass> _function_2 = xpac -> {
            String path = this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
            String file = this._cExtensions.getCHeaderFileName((RoomClass)xpac.getActorClass());
            this.fileIO.generateFile("generating ActorClass header", path + file, this.generateHeaderFile(root, (ExpandedActorClass)xpac));
            file = this._cExtensions.getCUtilsFileName((RoomClass)xpac.getActorClass());
            this.fileIO.generateFile("generating ActorClass utils", path + file, this.generateUtilsFile(root, (ExpandedActorClass)xpac));
            boolean _isBehaviorAnnotationPresent = this._roomHelpers.isBehaviorAnnotationPresent(xpac.getActorClass(), "BehaviorManual");
            if (_isBehaviorAnnotationPresent) {
                String _name = xpac.getActorClass().getName();
                String _plus = "omitting ActorClass source for '" + _name;
                String _plus_1 = _plus + "' since @BehaviorManual is specified";
                this.logger.logInfo(_plus_1);
            } else {
                file = this._cExtensions.getCSourceFileName((RoomClass)xpac.getActorClass());
                this.fileIO.generateFile("generating ActorClass source", path + file, this.generateSourceFile(root, (ExpandedActorClass)xpac));
            }
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)root.getActorClasses(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    protected CharSequence generateHeaderFile(Root root, ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        Functions.Function1 _function = p -> {
            GeneralProtocolClass _protocol = p.getProtocol();
            CommunicationType _commType = ((ProtocolClass)_protocol).getCommType();
            return Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        };
        Iterable eventPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)_function);
        Functions.Function1 _function_1 = p -> Objects.equal((Object)((ProtocolClass)p.getProtocol()).getCommType(), (Object)CommunicationType.DATA_DRIVEN) && p.isConjugated();
        Iterable sendPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = p -> Objects.equal((Object)((ProtocolClass)p.getProtocol()).getCommType(), (Object)CommunicationType.DATA_DRIVEN) && !p.isConjugated();
        Iterable recvPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)_function_2);
        ComponentCommunicationType _commType = ac.getCommType();
        boolean dataDriven = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.DATA_DRIVEN);
        ComponentCommunicationType _commType_1 = ac.getCommType();
        boolean async = Objects.equal((Object)_commType_1, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        boolean hasConstData = !IterableExtensions.isEmpty((Iterable)eventPorts) || !IterableExtensions.isEmpty((Iterable)recvPorts) || !this._roomHelpers.getAllSAPs(ac).isEmpty() || !this._roomHelpers.getAllServiceImplementations(ac).isEmpty() || this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        boolean isEmptyStateGraph = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
        boolean hasVarData = !IterableExtensions.isEmpty((Iterable)sendPorts) || !this._roomHelpers.getAllAttributes(ac).isEmpty() || !isEmptyStateGraph || hasConstData;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of ActorClass ");
        String _name = ac.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin((RoomClass)ac);
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.append("#include \"messaging/etMessage.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* include all referenced room classes */");
        _builder.newLine();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)ac);
        EList _referencedEnumClasses = root.getReferencedEnumClasses((RoomClass)ac);
        Iterable _plus = Iterables.concat((Iterable)_referencedDataClasses, (Iterable)_referencedEnumClasses);
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)ac);
        Functions.Function1 _function_3 = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)_plus, (Iterable)_referencedProtocolClasses), (Functions.Function1)_function_3);
        for (RoomClass rc : _sortBy) {
            _builder.append("#include ");
            String _includePath = this._cExtensions.getIncludePath(rc);
            _builder.append(_includePath);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)ac, 1, true);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("typedef struct ");
        String _name_1 = ac.getName();
        _builder.append(_name_1);
        _builder.append(" ");
        String _name_2 = ac.getName();
        _builder.append(_name_2);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* const part of ActorClass (ROM) */");
        _builder.newLine();
        if (hasConstData) {
            _builder.append("typedef struct ");
            String _name_3 = ac.getName();
            _builder.append(_name_3);
            _builder.append("_const {");
            _builder.newLineIfNotEmpty();
            boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation) {
                _builder.append("\t");
                _builder.append("const char* instName;");
                _builder.newLine();
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("/* simple ports */");
            _builder.newLine();
            for (Port ep : eventPorts) {
                int _multiplicity = ep.getMultiplicity();
                boolean _equals = _multiplicity == 1;
                if (!_equals) continue;
                _builder.append("\t");
                _builder.append("const ");
                String _portClassName = this._roomExtensions.getPortClassName((RoomElement)ep);
                _builder.append(_portClassName, "\t");
                _builder.append(" ");
                String _name_4 = ep.getName();
                _builder.append(_name_4, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* data receive ports */");
            _builder.newLine();
            for (Object ep_1 : recvPorts) {
                int _multiplicity_1 = ep_1.getMultiplicity();
                boolean _equals_1 = _multiplicity_1 == 1;
                if (!_equals_1) continue;
                _builder.append("\t");
                _builder.append("const ");
                String _portClassName_1 = this._roomExtensions.getPortClassName((RoomElement)ep_1);
                _builder.append(_portClassName_1, "\t");
                _builder.append(" ");
                String _name_5 = ep_1.getName();
                _builder.append(_name_5, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* saps */");
            _builder.newLine();
            List _allSAPs = this._roomHelpers.getAllSAPs(ac);
            for (SAP sap : _allSAPs) {
                _builder.append("\t");
                _builder.append("const ");
                String _portClassName_2 = this._roomExtensions.getPortClassName((RoomElement)sap);
                _builder.append(_portClassName_2, "\t");
                _builder.append(" ");
                String _name_6 = sap.getName();
                _builder.append(_name_6, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* replicated ports */");
            _builder.newLine();
            List _allEndPorts = this._roomHelpers.getAllEndPorts(ac);
            for (Port ep_2 : _allEndPorts) {
                int _multiplicity_2 = ep_2.getMultiplicity();
                boolean _notEquals = _multiplicity_2 != 1;
                if (!_notEquals) continue;
                _builder.append("\t");
                _builder.append("const etReplPort ");
                String _name_7 = ep_2.getName();
                _builder.append(_name_7, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* services */");
            _builder.newLine();
            List _allServiceImplementations = this._roomHelpers.getAllServiceImplementations(ac);
            for (ServiceImplementation svc : _allServiceImplementations) {
                _builder.append("\t");
                _builder.append("const etReplPort ");
                String _name_8 = svc.getSpp().getName();
                _builder.append(_name_8, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("} ");
            String _name_9 = ac.getName();
            _builder.append(_name_9);
            _builder.append("_const;");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("/* this actor class has no ports and thus no constant data */");
            _builder.newLine();
        }
        _builder.newLine();
        if (!isEmptyStateGraph) {
            _builder.newLine();
            CharSequence _genHeaderConstants = this._stateMachineGen.genHeaderConstants(xpac);
            _builder.append((Object)_genHeaderConstants);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* variable part of ActorClass (RAM) */");
        _builder.newLine();
        if (hasVarData) {
            _builder.append("struct ");
            String _name_10 = ac.getName();
            _builder.append(_name_10);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            if (hasConstData) {
                _builder.append("\t");
                _builder.append("const ");
                String _name_11 = ac.getName();
                _builder.append(_name_11, "\t");
                _builder.append("_const* ET_CONST_MEMBER constData;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("/* data send ports */");
            _builder.newLine();
            for (Port ep_3 : sendPorts) {
                int _multiplicity_3 = ep_3.getMultiplicity();
                boolean _equals_2 = _multiplicity_3 == 1;
                if (!_equals_2) continue;
                _builder.append("\t");
                String _portClassName_3 = this._roomExtensions.getPortClassName((RoomElement)ep_3);
                _builder.append(_portClassName_3, "\t");
                _builder.append(" ");
                String _name_12 = ep_3.getName();
                _builder.append(_name_12, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            CharSequence _attributes = this._procedureHelpers.attributes(this._roomHelpers.getAllAttributes(ac));
            _builder.append((Object)_attributes, "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            if (!isEmptyStateGraph) {
                _builder.newLine();
                _builder.append("\t");
                CharSequence _genDataMembers = this._stateMachineGen.genDataMembers(xpac);
                _builder.append((Object)_genDataMembers, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("};");
            _builder.newLine();
        } else {
            _builder.append("struct ");
            String _name_13 = ac.getName();
            _builder.append(_name_13);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* This actor class has no data at all.");
            _builder.newLine();
            _builder.append("\t   ");
            _builder.append("But the private actor instance data is passed to all life cycle functions.");
            _builder.newLine();
            _builder.append("\t   ");
            _builder.append("By introducing the dummy data we keep this case simple");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("int dummy;");
            _builder.newLine();
            _builder.append("};");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("void ");
        String _name_14 = ac.getName();
        _builder.append(_name_14);
        _builder.append("_init(");
        String _name_15 = ac.getName();
        _builder.append(_name_15);
        _builder.append("* self);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("void ");
        String _name_16 = ac.getName();
        _builder.append(_name_16);
        _builder.append("_receiveMessage(void* self, const void* ifitem, const etMessage* msg);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (dataDriven || async) {
            _builder.append("void ");
            String _name_17 = ac.getName();
            _builder.append(_name_17);
            _builder.append("_execute(");
            String _name_18 = ac.getName();
            _builder.append(_name_18);
            _builder.append("* self);");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _userStructorsDeclaration = this._procedureHelpers.userStructorsDeclaration((RoomClass)ac);
        _builder.append(_userStructorsDeclaration);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration(this._roomHelpers.getLatestOperations(ac), ac.getName());
        _builder.append((Object)_operationsDeclaration);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode_1 = this._procedureHelpers.userCode((ActorContainerClass)ac, 2, true);
        _builder.append((Object)_userCode_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd((RoomClass)ac);
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateUtilsFile(Root root, ExpandedActorClass xpac) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        Functions.Function1 _function = p -> {
            GeneralProtocolClass _protocol = p.getProtocol();
            CommunicationType _commType = ((ProtocolClass)_protocol).getCommType();
            return Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        };
        Iterable eventPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            int _multiplicity = it.getMultiplicity();
            return _multiplicity != 1;
        };
        Iterable replEventPorts = IterableExtensions.filter((Iterable)eventPorts, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = p -> Objects.equal((Object)((ProtocolClass)p.getProtocol()).getCommType(), (Object)CommunicationType.DATA_DRIVEN) && p.isConjugated() && p.getMultiplicity() == 1;
        Iterable sendPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = p -> Objects.equal((Object)((ProtocolClass)p.getProtocol()).getCommType(), (Object)CommunicationType.DATA_DRIVEN) && !p.isConjugated() && p.getMultiplicity() == 1;
        Iterable recvPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)_function_3);
        Functions.Function1 _function_4 = p -> this._roomHelpers.getPortClass(p) != null && this._roomHelpers.getPortClass(p).getOperations().size() > 0;
        Iterable portsWithOperations = IterableExtensions.filter((Iterable)this._roomHelpers.getAllInterfaceItems(ac), (Functions.Function1)_function_4);
        EObject _eContainer = ac.eContainer();
        String _replaceAll = ((RoomModel)_eContainer).getName().replaceAll("\\.", "_");
        String _plus = _replaceAll + "_";
        String _name = ac.getName();
        String _plus_1 = _plus + _name;
        String filename = _plus_1 + "_Utils";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Utils File of ActorClass ");
        String _name_1 = ac.getName();
        _builder.append(_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(filename);
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include ");
        String _includePath = this._cExtensions.getIncludePath((RoomClass)ac);
        _builder.append(_includePath);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* access macros for ports, operations and attributes");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* simple event ports */");
        _builder.newLine();
        Functions.Function1 _function_5 = it -> {
            int _multiplicity = it.getMultiplicity();
            return _multiplicity == 1;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)eventPorts, (Functions.Function1)_function_5);
        for (Object ep : _filter) {
            List _outgoing = this._roomHelpers.getOutgoing((InterfaceItem)ep);
            for (Message msg : _outgoing) {
                String _xifexpression = null;
                MessageData _data = msg.getData();
                boolean _tripleNotEquals = _data != null;
                _xifexpression = _tripleNotEquals ? "data" : "";
                String data1 = _xifexpression;
                _builder.newLineIfNotEmpty();
                String _xifexpression_1 = null;
                MessageData _data_1 = msg.getData();
                boolean _tripleNotEquals_1 = _data_1 != null;
                _xifexpression_1 = _tripleNotEquals_1 ? ", data" : "";
                String data2 = _xifexpression_1;
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name_2 = ep.getName();
                _builder.append(_name_2);
                _builder.append("_");
                String _name_3 = msg.getName();
                _builder.append(_name_3);
                _builder.append("(");
                _builder.append(data1);
                _builder.append(") ");
                String _portClassName = this._roomExtensions.getPortClassName((RoomElement)ep);
                _builder.append(_portClassName);
                _builder.append("_");
                String _name_4 = msg.getName();
                _builder.append(_name_4);
                _builder.append("(&self->constData->");
                String _name_5 = ep.getName();
                _builder.append(_name_5);
                _builder.append(data2);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("/* data receive ports */");
        _builder.newLine();
        for (Port ep_1 : recvPorts) {
            List _incoming = this._roomHelpers.getIncoming((InterfaceItem)ep_1);
            for (Message msg_1 : _incoming) {
                _builder.append("#define ");
                String _name_6 = ep_1.getName();
                _builder.append(_name_6);
                _builder.append("_");
                String _name_7 = msg_1.getName();
                _builder.append(_name_7);
                _builder.append(" ");
                String _portClassName_1 = this._roomExtensions.getPortClassName((RoomElement)ep_1);
                _builder.append(_portClassName_1);
                _builder.append("_");
                String _name_8 = msg_1.getName();
                _builder.append(_name_8);
                _builder.append("_get(&self->constData->");
                String _name_9 = ep_1.getName();
                _builder.append(_name_9);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("/* data send ports */");
        _builder.newLine();
        for (Object ep_2 : sendPorts) {
            List _outgoing_1 = this._roomHelpers.getOutgoing((InterfaceItem)ep_2);
            for (Object msg_2 : _outgoing_1) {
                String _xifexpression_2 = null;
                MessageData _data_2 = msg_2.getData();
                boolean _tripleNotEquals_2 = _data_2 != null;
                _xifexpression_2 = _tripleNotEquals_2 ? "data" : "";
                String data1_1 = _xifexpression_2;
                _builder.newLineIfNotEmpty();
                String _xifexpression_3 = null;
                MessageData _data_3 = msg_2.getData();
                boolean _tripleNotEquals_3 = _data_3 != null;
                _xifexpression_3 = _tripleNotEquals_3 ? ", data" : "";
                String data2_1 = _xifexpression_3;
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name_10 = ep_2.getName();
                _builder.append(_name_10);
                _builder.append("_");
                String _name_11 = msg_2.getName();
                _builder.append(_name_11);
                _builder.append("(");
                _builder.append(data1_1);
                _builder.append(") ");
                String _portClassName_2 = this._roomExtensions.getPortClassName((RoomElement)ep_2);
                _builder.append(_portClassName_2);
                _builder.append("_");
                String _name_12 = msg_2.getName();
                _builder.append(_name_12);
                _builder.append("_set(&self->");
                String _name_13 = ep_2.getName();
                _builder.append(_name_13);
                _builder.append(data2_1);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("/* saps */");
        _builder.newLine();
        List _allSAPs = this._roomHelpers.getAllSAPs(ac);
        for (SAP sap : _allSAPs) {
            Object msg_2;
            List _outgoing_2 = this._roomHelpers.getOutgoing((InterfaceItem)sap);
            msg_2 = _outgoing_2.iterator();
            while (msg_2.hasNext()) {
                Message msg_3 = (Message)msg_2.next();
                String _xifexpression_4 = null;
                MessageData _data_4 = msg_3.getData();
                boolean _tripleNotEquals_4 = _data_4 != null;
                _xifexpression_4 = _tripleNotEquals_4 ? "data" : "";
                String data1_2 = _xifexpression_4;
                _builder.newLineIfNotEmpty();
                String _xifexpression_5 = null;
                MessageData _data_5 = msg_3.getData();
                boolean _tripleNotEquals_5 = _data_5 != null;
                _xifexpression_5 = _tripleNotEquals_5 ? ", data" : "";
                String data2_2 = _xifexpression_5;
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name_14 = sap.getName();
                _builder.append(_name_14);
                _builder.append("_");
                String _name_15 = msg_3.getName();
                _builder.append(_name_15);
                _builder.append("(");
                _builder.append(data1_2);
                _builder.append(") ");
                String _portClassName_3 = this._roomExtensions.getPortClassName((RoomElement)sap);
                _builder.append(_portClassName_3);
                _builder.append("_");
                String _name_16 = msg_3.getName();
                _builder.append(_name_16);
                _builder.append("(&self->constData->");
                String _name_17 = sap.getName();
                _builder.append(_name_17);
                _builder.append(data2_2);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("/* replicated event ports */");
        _builder.newLine();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)replEventPorts);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("#define ifitem_index (((etReplSubPort*)ifitem)->index)");
            _builder.newLine();
        }
        for (Port ep_3 : replEventPorts) {
            List _outgoing_3 = this._roomHelpers.getOutgoing((InterfaceItem)ep_3);
            for (Object msg_4 : _outgoing_3) {
                String _xifexpression_6 = null;
                MessageData _data_6 = msg_4.getData();
                boolean _tripleNotEquals_6 = _data_6 != null;
                _xifexpression_6 = _tripleNotEquals_6 ? "data" : "";
                String data1_3 = _xifexpression_6;
                _builder.newLineIfNotEmpty();
                String _xifexpression_7 = null;
                MessageData _data_7 = msg_4.getData();
                boolean _tripleNotEquals_7 = _data_7 != null;
                _xifexpression_7 = _tripleNotEquals_7 ? ", data" : "";
                String data2_3 = _xifexpression_7;
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name_18 = ep_3.getName();
                _builder.append(_name_18);
                _builder.append("_");
                String _name_19 = msg_4.getName();
                _builder.append(_name_19);
                _builder.append("_broadcast(");
                _builder.append(data1_3);
                _builder.append(") ");
                String _portClassName_4 = this._roomExtensions.getPortClassName((RoomElement)ep_3);
                _builder.append(_portClassName_4);
                _builder.append("_");
                String _name_20 = msg_4.getName();
                _builder.append(_name_20);
                _builder.append("_broadcast(&self->constData->");
                String _name_21 = ep_3.getName();
                _builder.append(_name_21);
                _builder.append(data2_3);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name_22 = ep_3.getName();
                _builder.append(_name_22);
                _builder.append("_");
                String _name_23 = msg_4.getName();
                _builder.append(_name_23);
                _builder.append("(idx");
                _builder.append(data2_3);
                _builder.append(") ");
                String _portClassName_5 = this._roomExtensions.getPortClassName((RoomElement)ep_3);
                _builder.append(_portClassName_5);
                _builder.append("_");
                String _name_24 = msg_4.getName();
                _builder.append(_name_24);
                _builder.append("(&self->constData->");
                String _name_25 = ep_3.getName();
                _builder.append(_name_25);
                _builder.append(", idx");
                _builder.append(data2_3);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("/* services */");
        _builder.newLine();
        List _allServiceImplementations = this._roomHelpers.getAllServiceImplementations(ac);
        for (ServiceImplementation svc : _allServiceImplementations) {
            List _outgoing_4 = this._roomHelpers.getOutgoing((InterfaceItem)svc.getSpp());
            for (Message msg_5 : _outgoing_4) {
                String _xifexpression_8 = null;
                MessageData _data_8 = msg_5.getData();
                boolean _tripleNotEquals_8 = _data_8 != null;
                _xifexpression_8 = _tripleNotEquals_8 ? "data" : "";
                String data1_4 = _xifexpression_8;
                _builder.newLineIfNotEmpty();
                String _xifexpression_9 = null;
                MessageData _data_9 = msg_5.getData();
                boolean _tripleNotEquals_9 = _data_9 != null;
                _xifexpression_9 = _tripleNotEquals_9 ? ", data" : "";
                String data2_4 = _xifexpression_9;
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name_26 = svc.getSpp().getName();
                _builder.append(_name_26);
                _builder.append("_");
                String _name_27 = msg_5.getName();
                _builder.append(_name_27);
                _builder.append("_broadcast(");
                _builder.append(data1_4);
                _builder.append(") ");
                String _portClassName_6 = this._roomExtensions.getPortClassName((RoomElement)svc.getSpp());
                _builder.append(_portClassName_6);
                _builder.append("_");
                String _name_28 = msg_5.getName();
                _builder.append(_name_28);
                _builder.append("_broadcast(&self->constData->");
                String _name_29 = svc.getSpp().getName();
                _builder.append(_name_29);
                _builder.append(data2_4);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name_30 = svc.getSpp().getName();
                _builder.append(_name_30);
                _builder.append("_");
                String _name_31 = msg_5.getName();
                _builder.append(_name_31);
                _builder.append("(idx");
                _builder.append(data2_4);
                _builder.append(") ");
                String _portClassName_7 = this._roomExtensions.getPortClassName((RoomElement)svc.getSpp());
                _builder.append(_portClassName_7);
                _builder.append("_");
                String _name_32 = msg_5.getName();
                _builder.append(_name_32);
                _builder.append("(&self->constData->");
                String _name_33 = svc.getSpp().getName();
                _builder.append(_name_33);
                _builder.append(", idx");
                _builder.append(data2_4);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("/* operations */");
        _builder.newLine();
        List _latestOperations = this._roomHelpers.getLatestOperations(ac);
        for (StandardOperation op : _latestOperations) {
            boolean _not_1;
            String params = this.operationParams((Operation)op);
            _builder.newLineIfNotEmpty();
            String args = this.operationArgs((Operation)op);
            _builder.newLineIfNotEmpty();
            _builder.append("#define ");
            String _name_34 = op.getName();
            _builder.append(_name_34);
            _builder.append("(");
            _builder.append(params);
            _builder.append(") ");
            String _name_35 = ac.getName();
            _builder.append(_name_35);
            _builder.append("_");
            String _name_36 = op.getName();
            _builder.append(_name_36);
            _builder.append("(self");
            boolean _isEmpty_1 = op.getArguments().isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append(", ");
                _builder.append(args);
            }
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* attributes */");
        _builder.newLine();
        List _allAttributes = this._roomHelpers.getAllAttributes(ac);
        Iterator ep_3 = _allAttributes.iterator();
        while (ep_3.hasNext()) {
            Attribute a = (Attribute)ep_3.next();
            _builder.append("#define ");
            String _name_37 = a.getName();
            _builder.append(_name_37);
            _builder.append(" (self->");
            String _name_38 = a.getName();
            _builder.append(_name_38);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* port operations */");
        _builder.newLine();
        for (InterfaceItem p2 : portsWithOperations) {
            EList _operations = this._roomHelpers.getPortClass(p2).getOperations();
            for (PortOperation op_1 : _operations) {
                boolean _not_2;
                String params_1 = this.operationParams((Operation)op_1);
                _builder.newLineIfNotEmpty();
                String args_1 = this.operationArgs((Operation)op_1);
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name_39 = p2.getName();
                _builder.append(_name_39);
                _builder.append("_");
                String _name_40 = op_1.getName();
                _builder.append(_name_40);
                _builder.append("(");
                _builder.append(params_1);
                _builder.append(") ");
                String _portClassName_8 = this._roomExtensions.getPortClassName((RoomElement)p2);
                _builder.append(_portClassName_8);
                _builder.append("_");
                String _name_41 = op_1.getName();
                _builder.append(_name_41);
                _builder.append("((");
                String _portClassName_9 = this._roomExtensions.getPortClassName((RoomElement)p2);
                _builder.append(_portClassName_9);
                _builder.append("*)&self->constData->");
                String _name_42 = p2.getName();
                _builder.append(_name_42);
                boolean _isEmpty_2 = op_1.getArguments().isEmpty();
                boolean bl3 = _not_2 = !_isEmpty_2;
                if (_not_2) {
                    _builder.append(", ");
                    _builder.append(args_1);
                }
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(filename);
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String operationParams(Operation op) {
        Functions.Function1 _function = it -> {
            String _switchResult = null;
            boolean _matched = false;
            boolean _isVarargs = it.isVarargs();
            if (_isVarargs) {
                _matched = true;
                _switchResult = "...";
            }
            if (!_matched) {
                _switchResult = it.getName();
            }
            return _switchResult;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)_function), (CharSequence)", ");
    }

    private String operationArgs(Operation op) {
        Functions.Function1 _function = it -> {
            String _switchResult = null;
            boolean _matched = false;
            boolean _isVarargs = it.isVarargs();
            if (_isVarargs) {
                _matched = true;
                _switchResult = "__VA_ARGS__";
            }
            if (!_matched) {
                _switchResult = it.getName();
            }
            return _switchResult;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)_function), (CharSequence)", ");
    }

    protected CharSequence generateSourceFile(Root root, ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        ComponentCommunicationType _commType = ac.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.ASYNCHRONOUS);
        ComponentCommunicationType _commType_1 = ac.getCommType();
        boolean eventDriven = Objects.equal((Object)_commType_1, (Object)ComponentCommunicationType.EVENT_DRIVEN);
        ComponentCommunicationType _commType_2 = ac.getCommType();
        boolean dataDriven = Objects.equal((Object)_commType_2, (Object)ComponentCommunicationType.DATA_DRIVEN);
        boolean handleEvents = async || eventDriven;
        boolean isEmptyStateGraph = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of ActorClass ");
        String _name = ac.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)ac);
        _builder.append(_cHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"modelbase/etActor.h\"");
        _builder.newLine();
        _builder.append("#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append("#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.append("#include \"etUnit/etUnit.h\"");
        _builder.newLine();
        _builder.append("#include \"base/etMemory.h\"");
        _builder.newLine();
        _builder.newLine();
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : _referencedProtocolClasses) {
            _builder.append("#include ");
            String _includePath = this._cExtensions.getIncludePath((RoomClass)pc);
            _builder.append(_includePath);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("#include \"");
        String _cUtilsFileName = this._cExtensions.getCUtilsFileName((RoomClass)ac);
        _builder.append(_cUtilsFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)ac, 3, true);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* interface item IDs */");
        _builder.newLine();
        String _genInterfaceItemConstants = this.genInterfaceItemConstants(xpac);
        _builder.append(_genInterfaceItemConstants);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (!isEmptyStateGraph) {
            CharSequence _genStateMachine = this._stateMachineGen.genStateMachine(xpac.getGraphContainer());
            _builder.append((Object)_genStateMachine);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("void ");
        String _name_1 = ac.getName();
        _builder.append(_name_1);
        _builder.append("_init(");
        String _name_2 = ac.getName();
        _builder.append(_name_2);
        _builder.append("* self){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String _name_3 = ac.getName();
        _builder.append(_name_3, "\t");
        _builder.append("\", \"init\")");
        _builder.newLineIfNotEmpty();
        if (!isEmptyStateGraph) {
            _builder.append("\t");
            CharSequence _genInitialization = this._stateMachineGen.genInitialization(xpac);
            _builder.append((Object)_genInitialization, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _name_4 = ac.getName();
        _builder.append(_name_4);
        _builder.append("_receiveMessage(void* self, const void* ifitem, const etMessage* msg){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String _name_5 = ac.getName();
        _builder.append(_name_5, "\t");
        _builder.append("\", \"_receiveMessage\")");
        _builder.newLineIfNotEmpty();
        if (!isEmptyStateGraph) {
            if (handleEvents) {
                _builder.append("\t");
                String _operationScope = this.langExt.operationScope(ac.getName(), false);
                _builder.append(_operationScope, "\t");
                _builder.append("receiveEvent((");
                String _name_6 = ac.getName();
                _builder.append(_name_6, "\t");
                _builder.append("*) self, (etPort*)ifitem, msg->evtID, (void*)(((char*)msg)+MEM_CEIL(sizeof(etMessage))));");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                String _operationScope_1 = this.langExt.operationScope(ac.getName(), false);
                _builder.append(_operationScope_1, "\t");
                _builder.append("receiveEventInternal((");
                String _name_7 = ac.getName();
                _builder.append(_name_7, "\t");
                _builder.append("*) self);");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        if (dataDriven || async) {
            _builder.append("void ");
            String _name_8 = ac.getName();
            _builder.append(_name_8);
            _builder.append("_execute(");
            String _name_9 = ac.getName();
            _builder.append(_name_9);
            _builder.append("* self) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
            String _name_10 = ac.getName();
            _builder.append(_name_10, "\t");
            _builder.append("\", \"_execute\")");
            _builder.newLineIfNotEmpty();
            if (!isEmptyStateGraph) {
                _builder.newLine();
                if (handleEvents) {
                    _builder.append("\t");
                    String _operationScope_2 = this.langExt.operationScope(ac.getName(), false);
                    _builder.append(_operationScope_2, "\t");
                    _builder.append("receiveEvent(self, NULL, 0, NULL);");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    String _operationScope_3 = this.langExt.operationScope(ac.getName(), false);
                    _builder.append(_operationScope_3, "\t");
                    _builder.append("receiveEventInternal(self);");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        String _userStructorsImplementation = this._procedureHelpers.userStructorsImplementation((RoomClass)ac);
        _builder.append(_userStructorsImplementation);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation(this._roomHelpers.getLatestOperations(ac), ac.getName());
        _builder.append((Object)_operationsImplementation);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

