/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class CExtensions
implements ILanguageExtension {
    @Inject
    protected IDiagnostician diagnostician;
    @Inject
    @Extension
    protected RoomHelpers _roomHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public String getTypedDataDefinition(EObject msg) {
        String _xifexpression = null;
        _xifexpression = msg instanceof Message ? this.generateArglistAndTypedData((EObject)((Message)msg).getData())[ILanguageExtensionBase.TypedDataKind.DECLARATION_AND_INITIALIZATION.ordinal()] : "";
        return _xifexpression;
    }

    public String accessLevelPrivate() {
        return "static ";
    }

    public String accessLevelProtected() {
        return "static ";
    }

    public String accessLevelPublic() {
        return "";
    }

    public String memberAccess() {
        return "self->";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        String _xifexpression = null;
        _xifexpression = hasArgs ? "* self, " : "* self";
        return classname + _xifexpression;
    }

    public String selfPointer(boolean hasArgs) {
        String _xifexpression = null;
        _xifexpression = hasArgs ? "self, " : "self";
        return _xifexpression;
    }

    public String scopeSeparator() {
        return "";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        return classname + "_";
    }

    public String memberInDeclaration(String namespace, String member) {
        return namespace + "_" + member;
    }

    public String memberInUse(String namespace, String member) {
        return namespace + "_" + member;
    }

    public String getCHeaderFileName(RoomClass rc) {
        String _name = rc.getName();
        String _headerExtension = this.headerExtension();
        return _name + _headerExtension;
    }

    public String getCSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        String _sourceExtension = this.sourceExtension();
        return _name + _sourceExtension;
    }

    public String getCUtilsFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = _name + "_Utils";
        String _headerExtension = this.headerExtension();
        return _plus + _headerExtension;
    }

    public String getInstSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = _name + "_Inst";
        String _headerExtension = this.headerExtension();
        return _plus + _headerExtension;
    }

    public String getDispSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        String _plus = _name + "_Disp";
        String _headerExtension = this.headerExtension();
        return _plus + _headerExtension;
    }

    public String getCHeaderFileName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = _name + "_";
        String _name_1 = ssi.getName();
        String _plus_1 = _plus + _name_1;
        String _headerExtension = this.headerExtension();
        return _plus_1 + _headerExtension;
    }

    public String getCSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = _name + "_";
        String _name_1 = ssi.getName();
        String _plus_1 = _plus + _name_1;
        String _sourceExtension = this.sourceExtension();
        return _plus_1 + _sourceExtension;
    }

    public String getInstSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = _name + "_";
        String _name_1 = ssi.getName();
        String _plus_1 = _plus + _name_1;
        String _plus_2 = _plus_1 + "_Inst";
        String _headerExtension = this.headerExtension();
        return _plus_2 + _headerExtension;
    }

    public String getDispSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = _name + "_";
        String _name_1 = ssi.getName();
        String _plus_1 = _plus + _name_1;
        String _plus_2 = _plus_1 + "_Disp";
        String _headerExtension = this.headerExtension();
        return _plus_2 + _headerExtension;
    }

    public String headerExtension() {
        String _xifexpression = null;
        boolean _isCppFileExtensions = this._generatorOptionsHelper.isCppFileExtensions(Main.getSettings());
        _xifexpression = _isCppFileExtensions ? ".hpp" : ".h";
        return _xifexpression;
    }

    public String sourceExtension() {
        String _xifexpression = null;
        boolean _isCppFileExtensions = this._generatorOptionsHelper.isCppFileExtensions(Main.getSettings());
        _xifexpression = _isCppFileExtensions ? ".cpp" : ".c";
        return _xifexpression;
    }

    public CharSequence getIncludeGuardString(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("_");
        String _upperCase = filename.toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_H_");
        return _builder;
    }

    public CharSequence generateIncludeGuardBegin(RoomClass rc) {
        CharSequence _xblockexpression = null;
        EObject _eContainer = rc.eContainer();
        String _replaceAll = ((RoomModel)_eContainer).getName().replaceAll("\\.", "_");
        String _plus = _replaceAll + "_";
        String _name = rc.getName();
        String filename = _plus + _name;
        _xblockexpression = this.generateIncludeGuardBegin(filename);
        return _xblockexpression;
    }

    public CharSequence generateIncludeGuardEnd(RoomClass rc) {
        CharSequence _xblockexpression = null;
        EObject _eContainer = rc.eContainer();
        String _replaceAll = ((RoomModel)_eContainer).getName().replaceAll("\\.", "_");
        String _plus = _replaceAll + "_";
        String _name = rc.getName();
        String filename = _plus + _name;
        _xblockexpression = this.generateIncludeGuardEnd(filename);
        return _xblockexpression;
    }

    public CharSequence generateIncludeGuardBegin(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef ");
        CharSequence _includeGuardString = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString);
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        CharSequence _includeGuardString_1 = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString_1);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateIncludeGuardEnd(String filename) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#endif /* ");
        CharSequence _includeGuardString = this.getIncludeGuardString(filename);
        _builder.append((Object)_includeGuardString);
        _builder.append(" */");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateCppExternCBegin() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifdef __cplusplus");
        _builder.newLine();
        _builder.append("extern \u201eC\u201c {");
        _builder.newLine();
        _builder.append("#endif // __cplusplus");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateCppExternCEnd() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifdef __cplusplus");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("#endif // __cplusplus");
        _builder.newLine();
        return _builder;
    }

    public boolean usesInheritance() {
        return false;
    }

    public boolean usesPointers() {
        return true;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        String _xblockexpression = null;
        boolean _isEmpty = entries.isEmpty();
        if (_isEmpty) {
            return "/* empty enum not generated */";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("enum ");
        _builder.append(name);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (Pair<String, String> entry : entries) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            String _first = (String)entry.getFirst();
            _builder.append(_first, "\t");
            _builder.append(" = ");
            String _second = (String)entry.getSecond();
            _builder.append(_second, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String booleanConstant(boolean b) {
        String _xifexpression = null;
        _xifexpression = b ? "ET_TRUE" : "ET_FALSE";
        return _xifexpression;
    }

    public String pointerLiteral() {
        return "*";
    }

    public String nullPointer() {
        return "NULL";
    }

    public String voidPointer() {
        return "void*";
    }

    public String arrayType(String type, int size, boolean isRef) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(type);
        if (isRef) {
            _builder.append("*");
        }
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(type);
        if (isRef) {
            _builder.append("*");
        }
        _builder.append(" ");
        _builder.append(name);
        _builder.append("[");
        _builder.append((Object)size);
        _builder.append("]");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String superCall(String baseClassName, String method, String args) {
        return "";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        LiteralType _type;
        boolean _equals;
        String _switchResult = null;
        String _targetName = type.getTargetName();
        boolean _matched = false;
        if (type.getTargetName().equals("char") && value.length() == 1) {
            _matched = true;
            _switchResult = "'" + value + "'";
        }
        if (!_matched && (_equals = Objects.equal((Object)(_type = type.getType()), (Object)LiteralType.CHAR))) {
            _matched = true;
            _switchResult = "\"" + value + "\"";
        }
        if (!_matched && (value.contains(",") || value.contains("{"))) {
            _matched = true;
            String _xblockexpression = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{ ");
            boolean _hasElements = false;
            for (String v : singleValues) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _valueLiteral = this.toValueLiteral(type, v.trim());
                _builder.append(_valueLiteral);
            }
            _builder.append(" }");
            _switchResult = _xblockexpression = _builder.toString();
        }
        if (!_matched && Objects.equal((Object)_targetName, (Object)"boolean")) {
            _matched = true;
            String _xifexpression = null;
            boolean _equals_1 = value.equals("true");
            _xifexpression = _equals_1 ? "ET_TRUE" : "ET_FALSE";
            _switchResult = _xifexpression;
        }
        if (!_matched) {
            _switchResult = value;
        }
        return _switchResult;
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        String _xifexpression = null;
        if (value.contains(",") || value.contains("{")) {
            String _xblockexpression = null;
            String[] singleValues = value.replace("{", "").replace("}", "").trim().split(",");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{ ");
            boolean _hasElements = false;
            for (String v : singleValues) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _convertStringEnumLiteral = this.convertStringEnumLiteral(type, v.trim());
                _builder.append(_convertStringEnumLiteral);
            }
            _builder.append(" }");
            _xifexpression = _xblockexpression = _builder.toString();
        } else {
            _xifexpression = this.convertStringEnumLiteral(type, value);
        }
        return _xifexpression;
    }

    private String convertStringEnumLiteral(EnumerationType type, String value) {
        String v = value;
        boolean _startsWith = v.startsWith(type.getName());
        if (_startsWith) {
            int _length = type.getName().length();
            int _plus = _length + 1;
            v = v.substring(_plus);
        }
        EList _literals = type.getLiterals();
        for (EnumLiteral l : _literals) {
            boolean _equals = l.getName().equals(v);
            if (!_equals) continue;
            String _name = type.getName();
            String _plus_1 = _name + "_";
            String _name_1 = l.getName();
            return _plus_1 + _name_1;
        }
        return null;
    }

    public String defaultValue(DataType dt) {
        String _switchResult = null;
        boolean _matched = false;
        if (dt instanceof PrimitiveType) {
            _matched = true;
            _switchResult = this.toValueLiteral((PrimitiveType)dt, ((PrimitiveType)dt).getDefaultValueLiteral());
        }
        if (!_matched && dt instanceof EnumerationType) {
            _matched = true;
            _switchResult = this.getDefaultValue((EnumerationType)dt);
        }
        if (!_matched && dt instanceof ExternalType) {
            boolean _tripleNotEquals;
            _matched = true;
            String _xblockexpression = null;
            String _defaultValueLiteral = ((ExternalType)dt).getDefaultValueLiteral();
            boolean bl = _tripleNotEquals = _defaultValueLiteral != null;
            if (_tripleNotEquals) {
                return ((ExternalType)dt).getDefaultValueLiteral();
            }
            String _name = ((ExternalType)dt).getName();
            String _plus = "external type " + _name;
            String _plus_1 = _plus + "has no default initialization";
            this.diagnostician.error(_plus_1, ((ExternalType)dt).eContainer(), ((ExternalType)dt).eContainingFeature());
            _switchResult = _xblockexpression = "";
        }
        if (!_matched && dt instanceof DataClass) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{");
            _builder.newLine();
            List _allAttributes = this._roomHelpers.getAllAttributes((DataClass)dt);
            boolean _hasElements = false;
            for (Attribute att : _allAttributes) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append("\t");
                String _initializationWithDefaultValues = this.initializationWithDefaultValues(att);
                _builder.append(_initializationWithDefaultValues, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
            _switchResult = _builder.toString();
        }
        return _switchResult;
    }

    public String getDefaultValue(EnumerationType type) {
        String _xifexpression = null;
        boolean _isEmpty = type.getLiterals().isEmpty();
        _xifexpression = _isEmpty ? "" : this.getCastedValue((EnumLiteral)type.getLiterals().get(0));
        return _xifexpression;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        _xblockexpression = this.initializer(dv, size);
        return _xblockexpression;
    }

    private String initializer(String dv, int size) {
        String _xifexpression = null;
        if (size > 1) {
            String _xblockexpression = null;
            String res = "{";
            int i = 0;
            while (i < size) {
                res = res + dv;
                if (++i >= size) continue;
                res = res + ",";
            }
            _xifexpression = _xblockexpression = res + "}";
        } else {
            _xifexpression = dv;
        }
        return _xifexpression;
    }

    public String initializationWithDefaultValues(Attribute att) {
        String _xblockexpression = null;
        String dv = att.getDefaultValueLiteral();
        String _xifexpression = null;
        if (dv != null) {
            String _xifexpression_1 = null;
            boolean _startsWith = dv.startsWith("{");
            _xifexpression_1 = _startsWith ? dv : this.initializer(dv, att.getSize());
            _xifexpression = _xifexpression_1;
        } else {
            String _xifexpression_2 = null;
            boolean _isRef = att.getType().isRef();
            _xifexpression_2 = _isRef ? this.initializer("NULL", att.getSize()) : this.initializationWithDefaultValues(att.getType().getType(), att.getSize());
            _xifexpression = _xifexpression_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        boolean isPrim;
        DataType _type_7;
        if (d == null || !(d instanceof MessageData)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        MessageData data = (MessageData)d;
        if (data == null) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        String _xifexpression = null;
        DataType _type = data.getRefType().getType();
        if (_type instanceof PrimitiveType) {
            DataType _type_1 = data.getRefType().getType();
            _xifexpression = ((PrimitiveType)_type_1).getTargetName();
        } else {
            String _xifexpression_1 = null;
            DataType _type_2 = data.getRefType().getType();
            if (_type_2 instanceof EnumerationType) {
                DataType _type_3 = data.getRefType().getType();
                _xifexpression_1 = this.getTargetType((EnumerationType)_type_3);
            } else {
                String _xifexpression_2 = null;
                DataType _type_4 = data.getRefType().getType();
                if (_type_4 instanceof ExternalType) {
                    DataType _type_5 = data.getRefType().getType();
                    _xifexpression_2 = ((ExternalType)_type_5).getTargetName();
                } else {
                    _xifexpression_2 = data.getRefType().getType().getName();
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        String typeName = _xifexpression;
        String _xifexpression_3 = null;
        DataType _type_6 = data.getRefType().getType();
        if (_type_6 instanceof PrimitiveType) {
            String _xblockexpression = null;
            _type_7 = data.getRefType().getType();
            String ct = ((PrimitiveType)_type_7).getCastName();
            String _xifexpression_4 = null;
            _xifexpression_4 = ct != null && !ct.isEmpty() ? ct : typeName;
            _xifexpression_3 = _xblockexpression = _xifexpression_4;
        } else {
            String _xifexpression_4 = null;
            _type_7 = data.getRefType().getType();
            if (_type_7 instanceof EnumerationType) {
                DataType _type_8 = data.getRefType().getType();
                _xifexpression_4 = this.getCastType((EnumerationType)_type_8);
            } else {
                _xifexpression_4 = typeName;
            }
            _xifexpression_3 = _xifexpression_4;
        }
        String castTypeName = _xifexpression_3;
        castTypeName = castTypeName + "*";
        String deRef = "*";
        boolean isRef = data.getRefType().isRef();
        boolean bl = isPrim = data.getRefType().getType() instanceof PrimitiveType || data.getRefType().getType() instanceof EnumerationType;
        if (isRef) {
            typeName = typeName + "*";
            castTypeName = castTypeName + "*";
        } else if (!isPrim) {
            typeName = typeName + "*";
            deRef = "";
        }
        String _xifexpression_5 = null;
        _xifexpression_5 = this._generatorOptionsHelper.isOldStyleTransitionData(Main.getSettings()) && data.getDeprecatedName() != null && !data.getDeprecatedName().trim().isEmpty() ? data.getDeprecatedName() : "transitionData";
        String dataName = _xifexpression_5;
        String dataArg = ", " + dataName;
        String typedData = typeName + " " + dataName + " = " + deRef + "((" + castTypeName + ") generic_data__et);\n";
        String typedArgList = ", " + typeName + " " + dataName;
        return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{dataArg, typedData, typedArgList}), String.class);
    }

    public String getIncludePath(RoomClass rc) {
        EObject _eContainer = rc.eContainer();
        String _replaceAll = ((RoomModel)_eContainer).getName().replaceAll("\\.", "/");
        String _plus = "\"" + _replaceAll;
        String _plus_1 = _plus + "/";
        String _cHeaderFileName = this.getCHeaderFileName(rc);
        String _plus_2 = _plus_1 + _cHeaderFileName;
        return _plus_2 + "\"";
    }

    public String getUtilsIncludePath(RoomClass rc) {
        EObject _eContainer = rc.eContainer();
        String _replaceAll = ((RoomModel)_eContainer).getName().replaceAll("\\.", "/");
        String _plus = "\"" + _replaceAll;
        String _plus_1 = _plus + "/";
        String _cUtilsFileName = this.getCUtilsFileName(rc);
        String _plus_2 = _plus_1 + _cUtilsFileName;
        return _plus_2 + "\"";
    }

    public String getTargetType(EnumerationType type) {
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean _tripleNotEquals = _primitiveType != null;
        _xifexpression = _tripleNotEquals ? type.getPrimitiveType().getTargetName() : type.getName();
        return _xifexpression;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean _tripleEquals;
        String _xblockexpression = null;
        EObject _eContainer = literal.eContainer();
        EnumerationType type = (EnumerationType)_eContainer;
        String cast = this.getTargetType(type);
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean bl = _tripleEquals = _primitiveType == null;
        if (_tripleEquals) {
            _xifexpression = Long.toString(literal.getLiteralValue());
        } else {
            String _string = Long.toString(literal.getLiteralValue());
            String _plus = "((" + cast + ")" + _string;
            _xifexpression = _plus + ")";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getCastType(EnumerationType type) {
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean _tripleNotEquals = _primitiveType != null;
        _xifexpression = _tripleNotEquals ? type.getPrimitiveType().getCastName() : type.getName();
        return _xifexpression;
    }

    public String makeOverridable() {
        return "";
    }

    public String getTypeSignature(RefableType type) {
        boolean _isRef;
        String _switchResult = null;
        RefableType it = type;
        boolean _matched = false;
        if (Objects.equal((Object)it, null)) {
            _matched = true;
            _switchResult = "void";
        }
        if (!_matched && (_isRef = it.isRef())) {
            _matched = true;
            String _dataTypeName = this.getDataTypeName(type.getType());
            String _pointerLiteral = this.pointerLiteral();
            _switchResult = _dataTypeName + _pointerLiteral;
        }
        if (!_matched) {
            _switchResult = this.getDataTypeName(type.getType());
        }
        return _switchResult;
    }

    public String getDataTypeName(DataType it) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof PrimitiveType) {
            _matched = true;
            _switchResult = ((PrimitiveType)it).getTargetName();
        }
        if (!_matched && it instanceof EnumerationType) {
            _matched = true;
            _switchResult = this.getTargetType((EnumerationType)it);
        }
        if (!_matched && it instanceof ExternalType) {
            _matched = true;
            _switchResult = ((ExternalType)it).getTargetName();
        }
        if (!_matched) {
            _switchResult = it.getName();
        }
        return _switchResult;
    }

    public String toParameterDecl(VarDecl it) {
        String _switchResult = null;
        boolean _matched = false;
        boolean _isVarargs = it.isVarargs();
        if (_isVarargs) {
            _matched = true;
            _switchResult = "...";
        }
        if (!_matched) {
            String _typeSignature = this.getTypeSignature(it.getRefType());
            String _plus = _typeSignature + " ";
            String _name = it.getName();
            _switchResult = _plus + _name;
        }
        return _switchResult;
    }
}

