/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class DataClassGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Consumer<DataClass> _function_1 = dc -> {
            String path = this._roomExtensions.getPath((RoomClass)dc);
            String file = this._cExtensions.getCHeaderFileName((RoomClass)dc);
            this.fileIO.generateFile("generating DataClass header", path + file, this.generateHeaderFile(root, (DataClass)dc));
            file = this._cExtensions.getCUtilsFileName((RoomClass)dc);
            this.fileIO.generateFile("generating ProtocolClass utils", path + file, this.generateUtilsFile(root, (DataClass)dc));
            file = this._cExtensions.getCSourceFileName((RoomClass)dc);
            this.fileIO.generateFile("generating DataClass source", path + file, this.generateSourceFile(root, (DataClass)dc));
        };
        IterableExtensions.filter((Iterable)root.getDataClasses(), (Functions.Function1)_function).forEach(_function_1);
    }

    public CharSequence generateHeaderFile(Root root, DataClass dc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of DataClass ");
        String _name = dc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin((RoomClass)dc);
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* include all referenced room classes */");
        _builder.newLine();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)dc);
        EList _referencedEnumClasses = root.getReferencedEnumClasses((RoomClass)dc);
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)_referencedDataClasses, (Iterable)_referencedEnumClasses), (Functions.Function1)_function);
        for (DataType rc : _sortBy) {
            _builder.append("#include ");
            String _includePath = this._cExtensions.getIncludePath((RoomClass)rc);
            _builder.append(_includePath);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(dc, 1);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("typedef struct {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this._procedureHelpers.attributes(this._roomHelpers.getAllAttributes(dc));
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("} ");
        String _name_1 = dc.getName();
        _builder.append(_name_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        List _allAttributes = this._roomHelpers.getAllAttributes(dc);
        for (Attribute a : _allAttributes) {
            String _defaultValueLiteral = a.getDefaultValueLiteral();
            boolean _tripleNotEquals = _defaultValueLiteral != null;
            if (!_tripleNotEquals) continue;
            String _name_2 = dc.getName();
            String _plus = _name_2 + " ";
            String _name_3 = a.getName();
            String _plus_1 = _plus + _name_3;
            String _plus_2 = _plus_1 + ": Attribute initialization not supported in C";
            this.logger.logInfo(_plus_2);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.newLine();
        CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration(this._roomHelpers.getLatestOperations(dc), dc.getName());
        _builder.append((Object)_operationsDeclaration);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* deep copy */");
        _builder.newLine();
        _builder.append("void ");
        String _name_4 = dc.getName();
        _builder.append(_name_4);
        _builder.append("_deepCopy(");
        String _name_5 = dc.getName();
        _builder.append(_name_5);
        _builder.append("* source, ");
        String _name_6 = dc.getName();
        _builder.append(_name_6);
        _builder.append("* target);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode_1 = this._procedureHelpers.userCode(dc, 2);
        _builder.append((Object)_userCode_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd((RoomClass)dc);
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateUtilsFile(Root root, DataClass dc) {
        StringConcatenation _xblockexpression = null;
        EObject _eContainer = dc.eContainer();
        String _replaceAll = ((RoomModel)_eContainer).getName().replaceAll("\\.", "_");
        String _plus = _replaceAll + "_";
        String _name = dc.getName();
        String _plus_1 = _plus + _name;
        String filename = _plus_1 + "_Utils";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Utils File of DataClass ");
        String _name_1 = dc.getName();
        _builder.append(_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(filename);
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include ");
        String _includePath = this._cExtensions.getIncludePath((RoomClass)dc);
        _builder.append(_includePath);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* access macros for operations and attributes");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* operations */");
        _builder.newLine();
        List _allOperations = this._roomHelpers.getAllOperations(dc);
        for (StandardOperation op : _allOperations) {
            boolean _not;
            String params = this.operationParams((Operation)op);
            _builder.newLineIfNotEmpty();
            String args = this.operationArgs((Operation)op);
            _builder.newLineIfNotEmpty();
            _builder.append("#define ");
            String _name_2 = op.getName();
            _builder.append(_name_2);
            _builder.append("(");
            _builder.append(params);
            _builder.append(") ");
            String _name_3 = dc.getName();
            _builder.append(_name_3);
            _builder.append("_");
            String _name_4 = op.getName();
            _builder.append(_name_4);
            _builder.append("(self");
            boolean _isEmpty = op.getArguments().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append(", ");
                _builder.append(args);
            }
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* attributes */");
        _builder.newLine();
        List _allAttributes = this._roomHelpers.getAllAttributes(dc);
        for (Attribute a : _allAttributes) {
            _builder.append("#define ");
            String _name_5 = a.getName();
            _builder.append(_name_5);
            _builder.append(" (self->");
            String _name_6 = a.getName();
            _builder.append(_name_6);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(filename);
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String operationParams(Operation op) {
        Functions.Function1 _function = it -> {
            String _switchResult = null;
            boolean _matched = false;
            boolean _isVarargs = it.isVarargs();
            if (_isVarargs) {
                _matched = true;
                _switchResult = "...";
            }
            if (!_matched) {
                _switchResult = it.getName();
            }
            return _switchResult;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)_function), (CharSequence)", ");
    }

    private String operationArgs(Operation op) {
        Functions.Function1 _function = it -> {
            String _switchResult = null;
            boolean _matched = false;
            boolean _isVarargs = it.isVarargs();
            if (_isVarargs) {
                _matched = true;
                _switchResult = "__VA_ARGS__";
            }
            if (!_matched) {
                _switchResult = it.getName();
            }
            return _switchResult;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)_function), (CharSequence)", ");
    }

    public CharSequence generateSourceFile(Root root, DataClass dc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of DataClass ");
        String _name = dc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <string.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)dc);
        _builder.append(_cHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _cUtilsFileName = this._cExtensions.getCUtilsFileName((RoomClass)dc);
        _builder.append(_cUtilsFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(dc, 3);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation(this._roomHelpers.getLatestOperations(dc), dc.getName());
        _builder.append((Object)_operationsImplementation);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("void ");
        String _name_1 = dc.getName();
        _builder.append(_name_1);
        _builder.append("_deepCopy(");
        String _name_2 = dc.getName();
        _builder.append(_name_2);
        _builder.append("* source, ");
        String _name_3 = dc.getName();
        _builder.append(_name_3);
        _builder.append("* target) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("memcpy(target, source, sizeof(");
        String _name_4 = dc.getName();
        _builder.append(_name_4, "\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

