/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EnumerationTypeGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Consumer<EnumerationType> _function_1 = et -> {
            String path = this._roomExtensions.getPath((RoomClass)et);
            String file = this._cExtensions.getCHeaderFileName((RoomClass)et);
            this.fileIO.generateFile("generating Enumeration header", path + file, this.generateHeaderFile(root, (EnumerationType)et));
            file = this._cExtensions.getCSourceFileName((RoomClass)et);
            this.fileIO.generateFile("generating Enumeration source", path + file, this.generateSourceFile(root, (EnumerationType)et));
        };
        IterableExtensions.filter((Iterable)root.getEnumClasses(), (Functions.Function1)_function).forEach(_function_1);
    }

    private CharSequence generateHeaderFile(Root root, EnumerationType et) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of Enumeration ");
        String _name = et.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin((RoomClass)et);
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.newLine();
        PrimitiveType _primitiveType = et.getPrimitiveType();
        boolean bl = _tripleNotEquals = _primitiveType != null;
        if (_tripleNotEquals) {
            EList _literals = et.getLiterals();
            for (EnumLiteral lit : _literals) {
                _builder.append("#define ");
                String _name_1 = et.getName();
                _builder.append(_name_1);
                _builder.append("_");
                String _name_2 = lit.getName();
                _builder.append(_name_2);
                _builder.append(" ");
                String _castedValue = this._cExtensions.getCastedValue(lit);
                _builder.append(_castedValue);
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append("typedef enum ");
            String _name_3 = et.getName();
            _builder.append(_name_3);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            EList _literals_1 = et.getLiterals();
            boolean _hasElements = false;
            for (EnumLiteral lit_1 : _literals_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append("\t");
                String _name_4 = et.getName();
                _builder.append(_name_4, "\t");
                _builder.append("_");
                String _name_5 = lit_1.getName();
                _builder.append(_name_5, "\t");
                _builder.append(" = ");
                long _literalValue = lit_1.getLiteralValue();
                _builder.append((Object)_literalValue, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
            String _name_6 = et.getName();
            _builder.append(_name_6);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("const char* ");
        String _name_7 = et.getName();
        _builder.append(_name_7);
        _builder.append("_getLiteralName(");
        String _typeName = this._typeHelpers.typeName((DataType)et);
        _builder.append(_typeName);
        _builder.append(" literal);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd((RoomClass)et);
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateSourceFile(Root root, EnumerationType et) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of ProtocolClass ");
        String _name = et.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)et);
        _builder.append(_cHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("const char* ");
        String _name_1 = et.getName();
        _builder.append(_name_1);
        _builder.append("_getLiteralName(");
        String _typeName = this._typeHelpers.typeName((DataType)et);
        _builder.append(_typeName);
        _builder.append(" literal) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("switch(literal) {");
        _builder.newLine();
        EList _literals = et.getLiterals();
        for (EnumLiteral lit : _literals) {
            _builder.append("\t\t");
            _builder.append("case ");
            String _name_2 = et.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append("_");
            String _name_3 = lit.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(": return \"");
            String _name_4 = lit.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return NULL;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

