/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Initialization {
    @Inject
    private CExtensions languageExt;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;

    public CharSequence generateAttributeInit(InstanceBase instance, List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : attributes) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _initAttributeArray = this.initAttributeArray(instance, this._roomExtensions.union(new ArrayList(), (Object)a));
            _builder.append(_initAttributeArray);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String initAttributeArray(InstanceBase instance, List<Attribute> path) {
        boolean _greaterThan;
        String _xblockexpression = null;
        Attribute a = (Attribute)IterableExtensions.last(path);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t\t");
        _builder.append("/* ");
        String _name = a.getName();
        _builder.append(_name, "\t\t");
        int _size = a.getSize();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            _builder.append("[");
            int _size_1 = a.getSize();
            _builder.append((Object)_size_1, "\t\t");
            _builder.append("]");
        }
        _builder.append(" */");
        String COMMENT = _builder.toString();
        String _xifexpression = null;
        if (a.getSize() == 0 || !a.getType().isRef() && this._typeHelpers.isEnumerationOrPrimitive(a.getType().getType())) {
            CharSequence _initAttribute = this.initAttribute(instance, path);
            _xifexpression = _initAttribute + COMMENT;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("{ ");
            int _size_2 = a.getSize();
            IntegerRange _upTo = new IntegerRange(1, _size_2);
            boolean _hasElements = false;
            for (Integer i : _upTo) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_1.appendImmediate((Object)", ", "");
                }
                CharSequence _initAttribute_1 = this.initAttribute(instance, path);
                _builder_1.append((Object)_initAttribute_1);
            }
            _builder_1.append(" } ");
            _builder_1.append(COMMENT);
            _builder_1.newLineIfNotEmpty();
            _xifexpression = _builder_1.toString();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence initAttribute(InstanceBase instance, List<Attribute> path) {
        boolean _hasElements;
        IntegerRange _upTo;
        StringConcatenation _builder;
        String value;
        String _xblockexpression_1;
        String _xblockexpression = null;
        Attribute a = (Attribute)IterableExtensions.last(path);
        DataType aType = a.getType().getType();
        boolean _isRef = a.getType().isRef();
        if (_isRef) {
            String _xifexpression = null;
            String _defaultValueLiteral = a.getDefaultValueLiteral();
            boolean _tripleNotEquals = _defaultValueLiteral != null;
            _xifexpression = _tripleNotEquals ? a.getDefaultValueLiteral() : this.languageExt.nullPointer();
            return _xifexpression;
        }
        String _switchResult = null;
        boolean _matched = false;
        if (aType instanceof DataClass) {
            _matched = true;
            StringConcatenation _builder2 = new StringConcatenation();
            _builder2.append("{");
            _builder2.newLine();
            List _allAttributes = this._roomHelpers.getAllAttributes((DataClass)aType);
            boolean _hasElements2 = false;
            for (Attribute subA : _allAttributes) {
                if (!_hasElements2) {
                    _hasElements2 = true;
                } else {
                    _builder2.appendImmediate((Object)",", "\t");
                }
                _builder2.append("\t");
                String _initAttributeArray = this.initAttributeArray(instance, this._roomExtensions.union(path, (Object)subA));
                _builder2.append(_initAttributeArray, "\t");
                _builder2.newLineIfNotEmpty();
            }
            _builder2.append("}");
            _switchResult = _builder2;
        }
        if (!_matched && aType instanceof ExternalType) {
            _matched = true;
            String _xifexpression_1 = null;
            String _defaultValueLiteral_1 = a.getDefaultValueLiteral();
            boolean _tripleNotEquals_1 = _defaultValueLiteral_1 != null;
            _xifexpression_1 = _tripleNotEquals_1 ? a.getDefaultValueLiteral() : this.languageExt.defaultValue(aType);
            _switchResult = _xifexpression_1;
        }
        if (!_matched && aType instanceof PrimitiveType) {
            _matched = true;
            _xblockexpression_1 = null;
            value = this.getPrimitiveValue(instance, path);
            String _xifexpression_1 = null;
            if (a.getSize() > 0 && !this._typeHelpers.isCharacterType((PrimitiveType)aType) && !value.trim().startsWith("{")) {
                _builder = new StringConcatenation();
                _builder.append("{");
                int _size = a.getSize();
                _upTo = new IntegerRange(1, _size);
                _hasElements = false;
                for (Integer i : _upTo) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append(value);
                }
                _builder.append("}");
                _xifexpression_1 = _builder;
            } else {
                String _xifexpression_2 = null;
                _xifexpression_2 = a.getSize() > 0 && this._typeHelpers.isCharacterType((PrimitiveType)aType) && value.startsWith("'") ? "{" + value + "}" : value;
                _xifexpression_1 = _xifexpression_2;
            }
            _switchResult = _xblockexpression_1 = _xifexpression_1;
        }
        if (!_matched && aType instanceof EnumerationType) {
            _matched = true;
            _xblockexpression_1 = null;
            value = this.getPrimitiveValue(instance, path);
            String _xifexpression_1 = null;
            if (a.getSize() > 0 && !value.trim().startsWith("{")) {
                _builder = new StringConcatenation();
                _builder.append("{");
                int _size = a.getSize();
                _upTo = new IntegerRange(1, _size);
                _hasElements = false;
                for (Integer i : _upTo) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append(value);
                }
                _builder.append("}");
                _xifexpression_1 = _builder;
            } else {
                _xifexpression_1 = value;
            }
            _switchResult = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private String getPrimitiveValue(InstanceBase instance, List<Attribute> path) {
        String value = this._typeHelpers.getAttrInstanceConfigValue(path, instance);
        if (value == null) {
            String _switchResult = null;
            boolean _matched = false;
            if (instance instanceof ActorInstance) {
                _matched = true;
                _switchResult = this._typeHelpers.getAttrClassConfigValue(path, ((ActorInstance)instance).getActorClass(), true);
            }
            if (!_matched && instance instanceof InterfaceItemInstance) {
                _matched = true;
                _switchResult = this._typeHelpers.getAttrClassConfigValue(path, this._roomHelpers.getPortClass(((InterfaceItemInstance)instance).getInterfaceItem()));
            }
            value = _switchResult;
        }
        if (value == null) {
            value = ((Attribute)IterableExtensions.last(path)).getDefaultValueLiteral();
        }
        DataType type = ((Attribute)IterableExtensions.last(path)).getType().getType();
        String _xifexpression = null;
        if (value != null && this._typeHelpers.isPrimitive(type)) {
            _xifexpression = this.languageExt.toValueLiteral((PrimitiveType)type, value);
        } else {
            String _xifexpression_1 = null;
            _xifexpression_1 = value != null && this._typeHelpers.isEnumeration(type) ? this.languageExt.toEnumLiteral((EnumerationType)type, value) : this.languageExt.defaultValue(type);
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }
}

