/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.common.converter.TimeConverter;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.Initialization;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.base.IntelligentSeparator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    private Initialization attrInitGenAddon;

    public void doGenerate(Root root) {
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                if (ssi == null) continue;
                String filepath = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                String file = this._cExtensions.getCHeaderFileName(nr, ssi);
                this.checkDataPorts(ssi);
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                this.fileIO.generateFile("generating Node declaration", filepath + file, this.generateHeaderFile(root, ssi));
                file = this._cExtensions.getCSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node implementation", filepath + file, this.generateSourceFile(root, ssi, usedThreads));
                file = this._cExtensions.getInstSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node instance file", filepath + file, this.generateInstanceFile(root, ssi, usedThreads));
                file = this._cExtensions.getDispSourceFileName(nr, ssi);
                this.fileIO.generateFile("generating Node dispatcher file", filepath + file, this.generateDispatcherFile(root, ssi, usedThreads));
            }
        }
    }

    private CharSequence generateHeaderFile(Root root, SubSystemInstance ssi) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String _name = nr.getName();
        String _plus = _name + "_";
        String _name_1 = ssi.getName();
        String clsname = _plus + _name_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of Node ");
        String _name_2 = nr.getName();
        _builder.append(_name_2, " ");
        _builder.append(" with SubSystem ");
        String _name_3 = ssi.getName();
        _builder.append(_name_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(clsname);
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(ssc.getUserCode1());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* lifecycle functions");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* init -> start -> run (loop) -> stop -> destroy");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_init(void);\t\t/* lifecycle init  \t */");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_start(void);\t/* lifecycle start \t */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_run(etBool runAsTest);\t\t/* lifecycle run \t */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_stop(void); \t/* lifecycle stop\t */");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_destroy(void); \t/* lifecycle destroy */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_shutdown(void);  /* shutdown the dispatcher loop */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode_1 = this.helpers.userCode(ssc.getUserCode2());
        _builder.append((Object)_userCode_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(clsname);
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateSourceFile(Root root, SubSystemInstance ssi, Collection<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String _name = nr.getName();
        String _plus = _name + "_";
        String _name_1 = ssi.getName();
        String clsname = _plus + _name_1;
        Functions.Function1 _function = t -> usedThreads.contains(t);
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of Node ");
        String _name_2 = nr.getName();
        _builder.append(_name_2, " ");
        _builder.append(" with SubSystem ");
        String _name_3 = ssi.getName();
        _builder.append(_name_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <stdio.h>");
        _builder.newLine();
        _builder.append("#include <string.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName(nr, ssi);
        _builder.append(_cHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append("#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.append("#include \"messaging/etSystemProtocol.h\"");
        _builder.newLine();
        _builder.append("#include \"osal/etTimer.h\"");
        _builder.newLine();
        _builder.append("#include \"osal/etSema.h\"");
        _builder.newLine();
        _builder.append("#include \"runtime/etRuntime.h\"");
        _builder.newLine();
        _builder.append("#include \"etRuntimeConfig.h\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(ssc.getUserCode3());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* data for Node ");
        String _name_4 = nr.getName();
        _builder.append(_name_4);
        _builder.append(" with SubSystem ");
        String _name_5 = ssi.getName();
        _builder.append(_name_5);
        _builder.append(" */");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef struct ");
        _builder.append(clsname);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("char *name;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("volatile int shutdownRequest;");
        _builder.newLine();
        _builder.append("} ");
        _builder.append(clsname);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("static ");
        _builder.append(clsname);
        _builder.append(" ");
        _builder.append(clsname);
        _builder.append("Inst = {\"");
        _builder.append(clsname);
        _builder.append("\", 0};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("static void ");
        _builder.append(clsname);
        _builder.append("_initActorInstances(void);");
        _builder.newLineIfNotEmpty();
        _builder.append("static void ");
        _builder.append(clsname);
        _builder.append("_constructActorInstances(void);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* include instances for all classes */");
        _builder.newLine();
        _builder.append("#include \"");
        String _instSourceFileName = this._cExtensions.getInstSourceFileName(nr, ssi);
        _builder.append(_instSourceFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _dispSourceFileName = this._cExtensions.getDispSourceFileName(nr, ssi);
        _builder.append(_dispSourceFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("static void ");
        _builder.append(clsname);
        _builder.append("_initMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"initMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("etTime interval;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of all message services */");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> {
            long _prio = it.getPrio();
            return -_prio;
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)_function_1);
        for (PhysicalThread thread : _sortBy) {
            if (Objects.equal((Object)thread.getExecmode(), (Object)ExecMode.POLLED) || Objects.equal((Object)thread.getExecmode(), (Object)ExecMode.MIXED)) {
                _builder.append("\t\t");
                _builder.append("interval.sec = ");
                long _split = TimeConverter.split((long)thread.getTime(), (String)"s", (boolean)true);
                _builder.append((Object)_split, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("interval.nSec = ");
                long _split_1 = TimeConverter.split((long)thread.getTime(), (String)"ms", (boolean)false);
                _builder.append((Object)_split_1, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("etMessageService_init(");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("&msgService_");
            String _name_6 = thread.getName();
            _builder.append(_name_6, "\t\t\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("msgBuffer_");
            String _name_7 = thread.getName();
            _builder.append(_name_7, "\t\t\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _upperCase = thread.getName().toUpperCase();
            _builder.append(_upperCase, "\t\t\t");
            _builder.append("_POOL_SIZE,");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            String _upperCase_1 = thread.getName().toUpperCase();
            _builder.append(_upperCase_1, "\t\t\t");
            _builder.append("_BLOCK_SIZE,");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            int _stacksize = thread.getStacksize();
            _builder.append((Object)_stacksize, "\t\t\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            long _prio = thread.getPrio();
            _builder.append((Object)_prio, "\t\t\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("interval,");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("MsgDispatcher_");
            String _name_8 = thread.getName();
            _builder.append(_name_8, "\t\t\t");
            _builder.append("_receiveMessage,");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("EXECMODE_");
            String _upperCase_2 = thread.getExecmode().toString().toUpperCase();
            _builder.append(_upperCase_2, "\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static void ");
        _builder.append(clsname);
        _builder.append("_startMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"startMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Functions.Function1 _function_2 = it -> {
            long _prio_1 = it.getPrio();
            return -_prio_1;
        };
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)_function_2);
        for (PhysicalThread thread_1 : _sortBy_1) {
            _builder.append("\t");
            _builder.append("etMessageService_start(&msgService_");
            String _name_9 = thread_1.getName();
            _builder.append(_name_9, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static void ");
        _builder.append(clsname);
        _builder.append("_stopMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"stopMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (PhysicalThread thread_2 : threads) {
            _builder.append("\t");
            _builder.append("etMessageService_stop(&msgService_");
            String _name_10 = thread_2.getName();
            _builder.append(_name_10, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static void ");
        _builder.append(clsname);
        _builder.append("_destroyMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"destroyMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (PhysicalThread thread_3 : threads) {
            _builder.append("\t");
            _builder.append("etMessageService_destroy(&msgService_");
            String _name_11 = thread_3.getName();
            _builder.append(_name_11, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_init(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"init\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("etLogger_logInfoF(\"%s_init\", ");
        _builder.append(clsname, "\t");
        _builder.append("Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* construct all actors */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_constructActorInstances();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* initialization of all message services */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_initMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* init all actors */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_initActorInstances();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_start(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"start\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("etLogger_logInfoF(\"%s_start\", ");
        _builder.append(clsname, "\t");
        _builder.append("Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_startMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_run(etBool runAsTest) {");
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef ET_RUNNER_ACTIVATE");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"run\")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (runAsTest) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("etSema_waitForWakeup(etRuntime_getTerminateSemaphore());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("printf(\"type quit to exit\\n\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fflush(stdout);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("while (ET_TRUE) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("char line[64];");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (fgets(line, 64, stdin) != NULL) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if (strncmp(line, \"quit\", 4)==0)");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_stop(void){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"stop\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("etLogger_logInfoF(\"%s_stop\", ");
        _builder.append(clsname, "\t");
        _builder.append("Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_stopMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_destroy(void){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"destroy\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("etLogger_logInfoF(\"%s_destroy\", ");
        _builder.append(clsname, "\t");
        _builder.append("Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            _builder.append("\t");
            ActorClass _actorClass = ai.getActorClass();
            String _pathName = this._roomExtensions.getPathName(ai.getPath());
            String _plus_1 = "&" + _pathName;
            String _invokeUserStructor = this.helpers.invokeUserStructor((RoomClass)_actorClass, _plus_1, false);
            _builder.append(_invokeUserStructor, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_destroyMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("_shutdown(void){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"shutdown\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("etLogger_logInfoF(\"%s_shutdown\", ");
        _builder.append(clsname, "\t");
        _builder.append("Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("Inst.shutdownRequest = 1;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("static void ");
        _builder.append(clsname);
        _builder.append("_constructActorInstances(void){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"constructActorInstances\")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _allContainedInstances_1 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            _builder.append("\t");
            ActorClass _actorClass_1 = ai_1.getActorClass();
            String _pathName_1 = this._roomExtensions.getPathName(ai_1.getPath());
            String _plus_2 = "&" + _pathName_1;
            String _invokeUserStructor_1 = this.helpers.invokeUserStructor((RoomClass)_actorClass_1, _plus_2, true);
            _builder.append(_invokeUserStructor_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static void ");
        _builder.append(clsname);
        _builder.append("_initActorInstances(void){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append(clsname, "\t");
        _builder.append("\", \"initActorInstances\")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _allContainedInstances_2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            _builder.append("\t");
            String _name_12 = ai_2.getActorClass().getName();
            _builder.append(_name_12, "\t");
            _builder.append("_init(&");
            String _pathName_2 = this._roomExtensions.getPathName(ai_2.getPath());
            _builder.append(_pathName_2, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateInstanceFile(Root root, SubSystemInstance ssi, Collection<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Instance File of Node ");
        String _name = nr.getName();
        _builder.append(_name, " ");
        _builder.append(" with SubSystem ");
        String _name_1 = ssi.getName();
        _builder.append(_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* - instantiation of all actor instances and port instances");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* - configuration of data and connection of ports");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"messaging/etMessageService.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* include all referenced room classes */");
        _builder.newLine();
        EList _referencedActorClasses = root.getReferencedActorClasses((RoomClass)ssi.getSubSystemClass());
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)ssi.getSubSystemClass());
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)_referencedActorClasses, (Iterable)_referencedProtocolClasses), (Functions.Function1)_function);
        for (RoomClass dc : _sortBy) {
            _builder.append("#include ");
            String _includePath = this._cExtensions.getIncludePath(dc);
            _builder.append(_includePath);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* instantiation of message services and message buffers */");
        _builder.newLine();
        Functions.Function1 _function_1 = t -> usedThreads.contains(t);
        Iterable _filter = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)_function_1);
        for (PhysicalThread thread : _filter) {
            _builder.append("/* ");
            String _name_2 = thread.getName();
            _builder.append(_name_2);
            _builder.append(" */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ");
            String _upperCase = thread.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_POOL_SIZE\t\t");
            int _msgpoolsize = thread.getMsgpoolsize();
            _builder.append((Object)_msgpoolsize);
            _builder.newLineIfNotEmpty();
            _builder.append("#define ");
            String _upperCase_1 = thread.getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_BLOCK_SIZE\t");
            int _msgblocksize = thread.getMsgblocksize();
            _builder.append((Object)_msgblocksize);
            _builder.newLineIfNotEmpty();
            _builder.append("static uint8 msgBuffer_");
            String _name_3 = thread.getName();
            _builder.append(_name_3);
            _builder.append("[");
            String _upperCase_2 = thread.getName().toUpperCase();
            _builder.append(_upperCase_2);
            _builder.append("_POOL_SIZE * ");
            String _upperCase_3 = thread.getName().toUpperCase();
            _builder.append(_upperCase_3);
            _builder.append("_BLOCK_SIZE];");
            _builder.newLineIfNotEmpty();
            _builder.append("static etMessageService msgService_");
            String _name_4 = thread.getName();
            _builder.append(_name_4);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* declarations of all ActorClass instances (const and variable structs) */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* forward declaration of variable actor structs */");
        _builder.newLine();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            _builder.append("ET_FOWARD_DECLARATION_OF_INST_VAR ");
            String _name_5 = ai.getActorClass().getName();
            _builder.append(_name_5);
            _builder.append(" ");
            String _pathName = this._roomExtensions.getPathName(ai.getPath());
            _builder.append(_pathName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* forward declaration of variable port structs */");
        _builder.newLine();
        EList _allContainedInstances_1 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            boolean _isEmpty = ai_1.getOrderedIfItemInstances().isEmpty();
            if (_isEmpty) {
                _builder.append("/* nothing to do */");
                _builder.newLine();
                continue;
            }
            EList _orderedIfItemInstances = ai_1.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                int _portClassAttributesSize = this.getPortClassAttributesSize(pi);
                boolean _greaterThan = _portClassAttributesSize > 0;
                if (!_greaterThan) continue;
                _builder.append("ET_FOWARD_DECLARATION_OF_INST_VAR ");
                String _portClassName = this._roomExtensions.getPortClassName(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                _builder.append(_portClassName);
                _builder.append("_var ");
                String _pathName_1 = this._roomExtensions.getPathName(pi.getPath());
                _builder.append(_pathName_1);
                _builder.append("_var");
                boolean _isReplicated = pi.isReplicated();
                if (_isReplicated) {
                    _builder.append("[");
                    int _size = pi.getPeers().size();
                    _builder.append((Object)_size);
                    _builder.append("]");
                }
                _builder.append("={");
                _builder.newLineIfNotEmpty();
                int _xifexpression = 0;
                int _size_1 = pi.getPeers().size();
                boolean _equals = _size_1 == 0;
                _xifexpression = _equals ? 1 : pi.getPeers().size();
                IntegerRange _upTo = new IntegerRange(1, _xifexpression);
                boolean _hasElements = false;
                for (Integer i : _upTo) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    _builder.append("\t");
                    CharSequence _generateAttributeInit = this.attrInitGenAddon.generateAttributeInit((InstanceBase)pi, (List<Attribute>)this._roomHelpers.getPortClass(pi.getInterfaceItem()).getAttributes());
                    _builder.append((Object)_generateAttributeInit, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t\t\t\t\t");
                }
                _builder.append("};");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        EList _allContainedInstances_2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            _builder.newLine();
            _builder.append("/* instance ");
            String _pathName_2 = this._roomExtensions.getPathName(ai_2.getPath());
            _builder.append(_pathName_2);
            _builder.append(" */");
            _builder.newLineIfNotEmpty();
            if (!this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) && ai_2.getOrderedIfItemInstances().isEmpty()) {
                _builder.append("/* no ports/saps/services - nothing to initialize statically */");
                _builder.newLine();
                continue;
            }
            CharSequence _genActorInstanceInitializer = this.genActorInstanceInitializer(root, ai_2);
            _builder.append((Object)_genActorInstanceInitializer);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/* special user codes from annotation SubSystemUserCode */");
        _builder.newLine();
        String _generateSubSystemUserCodes = this.generateSubSystemUserCodes(ssi);
        _builder.append(_generateSubSystemUserCodes);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private int getPortClassAttributesSize(InterfaceItemInstance pi) {
        int _xblockexpression = 0;
        PortClass _portClass = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
        EList _attributes = null;
        if (_portClass != null) {
            _attributes = _portClass.getAttributes();
        }
        EList attribs = _attributes;
        int _xifexpression = 0;
        _xifexpression = attribs == null ? 0 : attribs.size();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence genActorInstanceInitializer(Root root, ActorInstance ai) {
        StringConcatenation _xblockexpression = null;
        String instName = this._roomExtensions.getPathName(ai.getPath());
        ArrayList replEventItems = new ArrayList();
        Functions.Function1 _function = e -> e.isReplicated();
        Iterables.addAll(replEventItems, (Iterable)IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = e -> {
            boolean _isEmpty = e.getPeers().isEmpty();
            return !_isEmpty;
        };
        InterfaceItemInstance _findFirst = (InterfaceItemInstance)IterableExtensions.findFirst(replEventItems, (Functions.Function1)_function_1);
        boolean haveReplSubItems = _findFirst != null;
        Functions.Function1 _function_2 = i -> {
            InterfaceItem _interfaceItem = i.getInterfaceItem();
            return _interfaceItem instanceof Port;
        };
        Iterable replEventPorts = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = i -> {
            InterfaceItem _interfaceItem = i.getInterfaceItem();
            return _interfaceItem instanceof SPP;
        };
        Iterable replEventSPPs = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_3);
        Functions.Function1 _function_4 = e -> e.isSimple();
        Iterable simplePorts = IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)_function_4);
        ArrayList simpleEventItems = new ArrayList();
        Functions.Function1 _function_5 = p -> {
            CommunicationType _commType = p.getProtocol().getCommType();
            return Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        };
        Iterables.addAll(simpleEventItems, (Iterable)IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_5));
        Functions.Function1 _function_6 = i -> {
            InterfaceItem _interfaceItem = i.getInterfaceItem();
            return _interfaceItem instanceof Port;
        };
        Iterable simpleEventPorts = IterableExtensions.filter(simpleEventItems, (Functions.Function1)_function_6);
        Functions.Function1 _function_7 = i -> {
            InterfaceItem _interfaceItem = i.getInterfaceItem();
            return _interfaceItem instanceof SAP;
        };
        Iterable simpleEventSAPs = IterableExtensions.filter(simpleEventItems, (Functions.Function1)_function_7);
        Functions.Function1 _function_8 = p -> {
            CommunicationType _commType = p.getProtocol().getCommType();
            return Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
        };
        Iterable dataPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_8);
        Functions.Function1 _function_9 = p -> p instanceof PortInstance && !((PortInstance)p).getPort().isConjugated();
        Iterable recvPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)_function_9);
        Functions.Function1 _function_10 = p -> p instanceof PortInstance && ((PortInstance)p).getPort().isConjugated();
        Iterable sendPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)_function_10);
        HashMap<InterfaceItemInstance, Integer> offsets = new HashMap<InterfaceItemInstance, Integer>();
        int offset = 0;
        for (InterfaceItemInstance p2 : replEventItems) {
            int _plus;
            offsets.put(p2, offset);
            int _size = p2.getPeers().size();
            offset = _plus = offset + _size;
        }
        String _xifexpression = null;
        _xifexpression = haveReplSubItems ? instName + "_repl_sub_ports" : "NULL";
        String replSubPortsArray = _xifexpression;
        boolean haveConstData = !simpleEventItems.isEmpty() || !IterableExtensions.isEmpty((Iterable)recvPorts) || !replEventItems.isEmpty() || this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        IntelligentSeparator sep = new IntelligentSeparator(",");
        String _xifexpression_1 = null;
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        _xifexpression_1 = _isGenerateMSCInstrumentation ? "/*const*/" : "const";
        String const_ = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_1) {
            CharSequence _genPeerPortArrays = this.genPeerPortArrays(root, ai);
            _builder.append((Object)_genPeerPortArrays);
            _builder.newLineIfNotEmpty();
        }
        if (haveReplSubItems) {
            _builder.append("ET_INITIALIZATION_OF_INST_VAR const etReplSubPort ");
            _builder.append(replSubPortsArray);
            _builder.append("[");
            _builder.append((Object)offset);
            _builder.append("] = {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Replicated Sub Ports: {varData, msgService, peerAddress, localId, index} */");
            _builder.newLine();
            Functions.Function1 _function_11 = e -> {
                boolean _isEmpty = e.getPeers().isEmpty();
                return !_isEmpty;
            };
            Iterable _filter = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_11);
            boolean _hasElements = false;
            for (InterfaceItemInstance pi : _filter) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append("\t");
                String _genReplSubPortInitializers = this.genReplSubPortInitializers(root, ai, pi);
                _builder.append(_genReplSubPortInitializers, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("};");
            _builder.newLine();
        }
        if (haveConstData) {
            _builder.append("ET_INITIALIZATION_OF_INST_VAR ");
            _builder.append(const_);
            _builder.append(" ");
            String _name = ai.getActorClass().getName();
            _builder.append(_name);
            _builder.append("_const ");
            _builder.append(instName);
            _builder.append("_const = {");
            _builder.newLineIfNotEmpty();
            boolean _isGenerateMSCInstrumentation_2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation_2) {
                _builder.append("\t");
                _builder.append((Object)sep, "\t");
                _builder.append("\"");
                String _path = ai.getPath();
                _builder.append(_path, "\t");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("/* Ports: {varData, msgService, peerAddress, localId} */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* simple ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_1 : simpleEventPorts) {
                _builder.append("\t");
                _builder.append((Object)sep, "\t");
                String _genPortInitializer = this.genPortInitializer(root, ai, pi_1);
                _builder.append(_genPortInitializer, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* data receive ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_2 : recvPorts) {
                _builder.append("\t");
                _builder.append((Object)sep, "\t");
                String _genRecvPortInitializer = this.genRecvPortInitializer(root, ai, pi_2);
                _builder.append(_genRecvPortInitializer, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* saps */");
            _builder.newLine();
            for (InterfaceItemInstance pi_3 : simpleEventSAPs) {
                _builder.append("\t");
                _builder.append((Object)sep, "\t");
                String _genPortInitializer_1 = this.genPortInitializer(root, ai, pi_3);
                _builder.append(_genPortInitializer_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* replicated ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_4 : replEventPorts) {
                _builder.append("\t");
                _builder.append((Object)sep, "\t");
                _builder.append("{");
                int _size = pi_4.getPeers().size();
                _builder.append((Object)_size, "\t");
                _builder.append(", ");
                _builder.append(replSubPortsArray, "\t");
                _builder.append("+");
                Integer _get = (Integer)offsets.get(pi_4);
                _builder.append((Object)_get, "\t");
                _builder.append("}");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* services */");
            _builder.newLine();
            for (InterfaceItemInstance pi_5 : replEventSPPs) {
                _builder.append("\t");
                _builder.append((Object)sep, "\t");
                _builder.append("{");
                int _size_1 = pi_5.getPeers().size();
                _builder.append((Object)_size_1, "\t");
                _builder.append(", ");
                _builder.append(replSubPortsArray, "\t");
                _builder.append("+");
                Integer _get_1 = (Integer)offsets.get(pi_5);
                _builder.append((Object)_get_1, "\t");
                _builder.append("}");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("};");
            _builder.newLine();
        }
        _builder.append("ET_INITIALIZATION_OF_INST_VAR ");
        String _name_1 = ai.getActorClass().getName();
        _builder.append(_name_1);
        _builder.append(" ");
        _builder.append(instName);
        _builder.append(" = {");
        _builder.newLineIfNotEmpty();
        if (haveConstData) {
            _builder.append("\t");
            _builder.append("&");
            _builder.append(instName, "\t");
            _builder.append("_const,");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* data send ports */");
        _builder.newLine();
        for (InterfaceItemInstance pi_6 : sendPorts) {
            _builder.append("\t");
            CharSequence _genSendPortInitializer = this.genSendPortInitializer(pi_6);
            _builder.append((Object)_genSendPortInitializer, "\t");
            _builder.append(",");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* attributes */");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generateAttributeInit = this.attrInitGenAddon.generateAttributeInit((InstanceBase)ai, this._roomHelpers.getAllAttributes(ai.getActorClass()));
        _builder.append((Object)_generateAttributeInit, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* state and history are initialized in init function */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence genPeerPortArrays(Root root, ActorInstance ai) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = e -> e.isSimple() && e instanceof PortInstance;
        Functions.Function1 _function_1 = inst -> (PortInstance)inst;
        Iterable simplePorts = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ai.getOrderedIfItemInstances(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = p -> p.getPort().isConjugated() && Objects.equal((Object)p.getProtocol().getCommType(), (Object)CommunicationType.DATA_DRIVEN);
        Iterable sendPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = p -> {
            Functions.Function1 _function_4 = m -> this._typeHelpers.isEnumeration(m.getData().getRefType().getType()) || this._typeHelpers.isBoolean(m.getData().getRefType().getType());
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)this._roomHelpers.getOutgoing((InterfaceItem)p.getPort()), (Functions.Function1)_function_4));
            return !_isEmpty;
        };
        Iterable loggedPorts = IterableExtensions.filter((Iterable)sendPorts, (Functions.Function1)_function_3);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)loggedPorts);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            _builder.newLine();
            for (PortInstance pi : loggedPorts) {
                _builder.append("static const char* ");
                String _pathName = this._roomExtensions.getPathName(pi.getPath());
                _builder.append(_pathName);
                _builder.append("_peers[");
                int _size = pi.getPeers().size();
                int _plus = _size + 1;
                _builder.append((Object)_plus);
                _builder.append("] = {");
                _builder.newLineIfNotEmpty();
                EList _peers = pi.getPeers();
                for (InterfaceItemInstance peer : _peers) {
                    _builder.append("\t");
                    _builder.append("\"");
                    EObject _eContainer = peer.eContainer();
                    String _path = ((ActorInstance)_eContainer).getPath();
                    _builder.append(_path, "\t");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("NULL");
                _builder.newLine();
                _builder.append("};");
                _builder.newLine();
            }
            _builder.append("#endif");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String genPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String _xblockexpression = null;
        int _xifexpression = 0;
        boolean _isEmpty = pi.getPeers().isEmpty();
        _xifexpression = _isEmpty ? 0 : ((InterfaceItemInstance)pi.getPeers().get(0)).getObjId();
        int objId = _xifexpression;
        int _xifexpression_1 = 0;
        boolean _isEmpty_1 = pi.getPeers().isEmpty();
        _xifexpression_1 = _isEmpty_1 ? 0 : ((InterfaceItemInstance)pi.getPeers().get(0)).getPeers().indexOf((Object)pi);
        int idx = _xifexpression_1;
        String _xifexpression_2 = null;
        boolean _isEmpty_2 = pi.getPeers().isEmpty();
        if (_isEmpty_2) {
            _xifexpression_2 = "NULL";
        } else {
            EObject _eContainer = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
            String _name = ETMapUtil.getMappedThread((AbstractInstance)((ActorInstance)_eContainer)).getThread().getName();
            _xifexpression_2 = "&msgService_" + _name;
        }
        String msgSvc = _xifexpression_2;
        String myInst = "";
        String peerInst = "";
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            boolean _not;
            String _plus_1;
            EObject _eContainer_1 = pi.eContainer();
            String _path = ((ActorInstance)_eContainer_1).getPath();
            String _plus = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE\n,\"" + _path;
            myInst = _plus_1 = _plus + "\",";
            String _xifexpression_3 = null;
            boolean _isEmpty_3 = pi.getPeers().isEmpty();
            boolean bl = _not = !_isEmpty_3;
            if (_not) {
                EObject _eContainer_2 = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
                String _path_1 = ((ActorInstance)_eContainer_2).getPath();
                String _plus_2 = "\"" + _path_1;
                _xifexpression_3 = _plus_2 + "\"\n#endif\n";
            } else {
                _xifexpression_3 = "\n#endif\n";
            }
            peerInst = _xifexpression_3;
        }
        String _interfaceItemInstanceData = this.getInterfaceItemInstanceData(pi);
        String _plus_3 = "{" + _interfaceItemInstanceData;
        String _plus_4 = _plus_3 + ", ";
        String _plus_5 = _plus_4 + msgSvc;
        String _plus_6 = _plus_5 + ", ";
        String _plus_7 = _plus_6 + Integer.valueOf(objId + idx);
        String _plus_8 = _plus_7 + "+BASE_ADDRESS, ";
        int _interfaceItemLocalId = root.getExpandedActorClass(ai).getInterfaceItemLocalId((AbstractInterfaceItem)pi.getInterfaceItem());
        int _plus_9 = _interfaceItemLocalId + 1;
        String _plus_10 = _plus_8 + Integer.valueOf(_plus_9);
        String _plus_11 = _plus_10 + myInst;
        String _plus_12 = _plus_11 + peerInst;
        String _plus_13 = _plus_12 + "} /* Port ";
        String _name_1 = pi.getName();
        String _plus_14 = _plus_13 + _name_1;
        _xblockexpression = _plus_14 + " */";
        return _xblockexpression;
    }

    private CharSequence genSendPortInitializer(InterfaceItemInstance pi) {
        StringConcatenation _xblockexpression = null;
        GeneralProtocolClass _protocol = ((PortInstance)pi).getPort().getProtocol();
        ProtocolClass pc = (ProtocolClass)_protocol;
        Functions.Function1 _function = m -> {
            MessageData _data = m.getData();
            return _data != null;
        };
        Iterable messages = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)_function);
        Functions.Function1 _function_1 = m -> this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
        Iterable enumMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = m -> this._typeHelpers.isBoolean(m.getData().getRefType().getType());
        Iterable boolMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)_function_2);
        boolean usesMSC = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) && (!IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs));
        EObject _eContainer = pi.eContainer();
        String instName = ((ActorInstance)_eContainer).getPath();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{");
        _builder.newLine();
        EList _incomingMessages = pc.getIncomingMessages();
        boolean _hasElements = false;
        for (Message m2 : _incomingMessages) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            String _defaultValue = this._cExtensions.defaultValue(m2.getData().getRefType().getType());
            _builder.append(_defaultValue, "\t");
            _builder.newLineIfNotEmpty();
        }
        if (usesMSC) {
            _builder.append("\t");
            _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append(", \"");
            _builder.append(instName, "\t\t");
            _builder.append("\",");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _pathName = this._roomExtensions.getPathName(pi.getPath());
            _builder.append(_pathName, "\t\t");
            _builder.append("_peers");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#endif");
            _builder.newLine();
        }
        _builder.append("} /* send port ");
        String _name = pi.getName();
        _builder.append(_name);
        _builder.append(" */");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getInterfaceItemInstanceData(InterfaceItemInstance pi) {
        boolean _tripleEquals;
        PortClass _portClass = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
        boolean bl = _tripleEquals = _portClass == null;
        if (_tripleEquals) {
            return "NULL";
        }
        boolean _isEmpty = this._roomExtensions.getPortClass(pi.getProtocol(), this._roomExtensions.isConjugated(pi)).getAttributes().isEmpty();
        if (_isEmpty) {
            return "NULL";
        }
        String _pathName = this._roomExtensions.getPathName(pi.getPath());
        String _plus = "&" + _pathName;
        return _plus + "_var";
    }

    private String genRecvPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        boolean _isEmpty;
        String _xblockexpression = null;
        Functions.Function1 _function = m -> {
            MessageData _data = m.getData();
            return _data != null;
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getIncoming(pi.getInterfaceItem()), (Functions.Function1)_function);
        Functions.Function1 _function_1 = m -> this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
        Iterable enumMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = m -> this._typeHelpers.isBoolean(m.getData().getRefType().getType());
        Iterable boolMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)_function_2);
        boolean usesMSC = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) && (!IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs));
        String enumVal = "";
        if (usesMSC) {
            String _plus_1;
            String _path = ai.getPath();
            String _plus = "\n, \"" + _path;
            enumVal = _plus_1 = _plus + "\"";
            for (Message msg : enumMsgs) {
                String _plus_2;
                String _defaultValue = this._cExtensions.defaultValue(msg.getData().getRefType().getType());
                enumVal = _plus_2 = enumVal + "\n, " + _defaultValue;
            }
            for (Message msg_1 : boolMsgs) {
                String _plus_3;
                String _defaultValue_1 = this._cExtensions.defaultValue(msg_1.getData().getRefType().getType());
                enumVal = _plus_3 = enumVal + "\n, " + _defaultValue_1;
            }
            enumVal = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE" + enumVal + "\n#endif\n";
        }
        if (_isEmpty = pi.getPeers().isEmpty()) {
            return "{NULL" + enumVal + "}";
        }
        InterfaceItemInstance peer = (InterfaceItemInstance)pi.getPeers().get(0);
        EObject _eContainer = ((InterfaceItemInstance)pi.getPeers().get(0)).eContainer();
        ActorInstance peerInst = (ActorInstance)_eContainer;
        String instName = this._roomExtensions.getPathName(peerInst.getPath());
        String _name = peer.getName();
        String _plus_4 = "{&" + instName + "." + _name;
        String _plus_5 = _plus_4 + enumVal;
        _xblockexpression = _plus_5 + "}";
        return _xblockexpression;
    }

    private String genReplSubPortInitializers(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String result = "";
        String _xifexpression = null;
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            EObject _eContainer = pi.eContainer();
            String _path = ((ActorInstance)_eContainer).getPath();
            String _plus = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE\n,\"" + _path;
            _xifexpression = _plus + "\"\n";
        } else {
            _xifexpression = "";
        }
        String myInst = _xifexpression;
        EList _peers = pi.getPeers();
        for (InterfaceItemInstance p : _peers) {
            String _plus_16;
            int idx = pi.getPeers().indexOf((Object)p);
            String _xifexpression_1 = null;
            int _size = pi.getPeers().size();
            int _minus = _size - 1;
            boolean _lessThan = idx < _minus;
            _xifexpression_1 = _lessThan ? "," : "";
            String comma = _xifexpression_1;
            EObject _eContainer_1 = p.eContainer();
            String thread = ETMapUtil.getMappedThread((AbstractInstance)((ActorInstance)_eContainer_1)).getThread().getName();
            String iiiD = this.getInterfaceItemInstanceData(pi);
            String _xifexpression_2 = null;
            boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation_1) {
                EObject _eContainer_2 = p.eContainer();
                String _path_1 = ((ActorInstance)_eContainer_2).getPath();
                String _plus_1 = ",\"" + _path_1;
                _xifexpression_2 = _plus_1 + "\"\n#endif\n";
            } else {
                _xifexpression_2 = "";
            }
            String peerInst = _xifexpression_2;
            String _xifexpression_3 = null;
            boolean _equals = iiiD.equals("NULL");
            _xifexpression_3 = _equals ? iiiD + "," : iiiD + "[" + Integer.valueOf(idx) + "],";
            iiiD = _xifexpression_3;
            int _objId = p.getObjId();
            String _plus_2 = result + "{{" + iiiD + "&msgService_" + thread + ", " + Integer.valueOf(_objId);
            String _plus_3 = _plus_2 + "+BASE_ADDRESS, ";
            int _interfaceItemLocalId = root.getExpandedActorClass(ai).getInterfaceItemLocalId((AbstractInterfaceItem)pi.getInterfaceItem());
            int _plus_4 = _interfaceItemLocalId + 1;
            String _plus_5 = _plus_3 + Integer.valueOf(_plus_4);
            String _plus_6 = _plus_5 + myInst;
            String _plus_7 = _plus_6 + peerInst;
            String _plus_8 = _plus_7 + "},";
            String _plus_9 = _plus_8 + Integer.valueOf(idx);
            String _plus_10 = _plus_9 + "}";
            String _plus_11 = _plus_10 + comma;
            String _plus_12 = _plus_11 + " /* Repl Sub Port ";
            String _name = pi.getName();
            String _plus_13 = _plus_12 + _name;
            String _plus_14 = _plus_13 + " idx +";
            String _plus_15 = _plus_14 + Integer.valueOf(idx);
            result = _plus_16 = _plus_15 + "*/\n";
        }
        return result;
    }

    private CharSequence generateDispatcherFile(Root root, SubSystemInstance ssi, Collection<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Dispatcher File of Node ");
        String _name = nr.getName();
        _builder.append(_name, " ");
        _builder.append(" with SubSystem ");
        String _name_1 = ssi.getName();
        _builder.append(_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* contains a generated message dispatcher (receiveMessage) for each MessageService (Thread)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"messaging/etMessageReceiver.h\"");
        _builder.newLine();
        _builder.append("#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append("#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = t -> usedThreads.contains(t);
        Iterable _filter = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (PhysicalThread thread : _filter) {
            boolean _not;
            boolean _greaterThan;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            Functions.Function1 _function_1 = ai -> {
                PhysicalThread _thread = ETMapUtil.getMappedThread((AbstractInstance)ai).getThread();
                return Objects.equal((Object)_thread, (Object)thread);
            };
            Iterable instancesOnThread = IterableExtensions.filter((Iterable)ssi.getAllContainedInstances(), (Functions.Function1)_function_1);
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_2 = ai -> Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.EVENT_DRIVEN) || Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS);
            Iterable dispatchedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)_function_2);
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_3 = ai -> Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN) || Objects.equal((Object)ai.getActorClass().getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS);
            Iterable executedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)_function_3);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            int _size = IterableExtensions.size((Iterable)executedInstances);
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* generated execute function for all cyclic execute calls for the async or datadriven actor instances of thread \"");
                String _name_2 = thread.getName();
                _builder.append(_name_2, " ");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("static void MsgDispatcher_");
                String _name_3 = thread.getName();
                _builder.append(_name_3);
                _builder.append("_poll(void){");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
                String _name_4 = thread.getName();
                _builder.append(_name_4, "\t");
                _builder.append("\", \"execute\")");
                _builder.newLineIfNotEmpty();
                for (ActorInstance ai2 : executedInstances) {
                    _builder.append("\t");
                    String _name_5 = ai2.getActorClass().getName();
                    _builder.append(_name_5, "\t");
                    _builder.append("_execute((");
                    String _name_6 = ai2.getActorClass().getName();
                    _builder.append(_name_6, "\t");
                    _builder.append("*)&");
                    String _pathName = this._roomExtensions.getPathName(ai2.getPath());
                    _builder.append(_pathName, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* generated dispatch function for all messages for the thread \"");
            String _name_7 = thread.getName();
            _builder.append(_name_7, " ");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("static etBool MsgDispatcher_");
            String _name_8 = thread.getName();
            _builder.append(_name_8);
            _builder.append("_receiveMessage(const etMessage* msg){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
            String _name_9 = thread.getName();
            _builder.append(_name_9, "\t");
            _builder.append("\", \"receiveMessage\")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("switch(msg->address){");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("case MESSAGESERVICE_ADDRESS:");
            _builder.newLine();
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)executedInstances);
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                _builder.append("\t\t\t");
                _builder.append("if (msg->evtID == etSystemProtocol_IN_poll) {");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("MsgDispatcher_");
                String _name_10 = thread.getName();
                _builder.append(_name_10, "\t\t\t\t");
                _builder.append("_poll();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("else");
                _builder.newLine();
            }
            _builder.append("\t\t\t");
            _builder.append("if (msg->evtID == etSystemProtocol_IN_terminate)");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("return ET_FALSE;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("break;");
            _builder.newLine();
            for (ActorInstance ai_1 : dispatchedInstances) {
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("/* interface items of ");
                String _path = ai_1.getPath();
                _builder.append(_path, "\t\t");
                _builder.append(" */");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_4 = p -> {
                    CommunicationType _commType = p.getProtocol().getCommType();
                    return Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)ai_1.getOrderedIfItemInstances(), (Functions.Function1)_function_4);
                for (InterfaceItemInstance pi : _filter_1) {
                    boolean _isReplicated = pi.isReplicated();
                    if (_isReplicated) {
                        EList _peers = pi.getPeers();
                        for (InterfaceItemInstance peer : _peers) {
                            _builder.append("\t\t");
                            _builder.append("case ");
                            int _objId = pi.getObjId();
                            int _indexOf = pi.getPeers().indexOf((Object)peer);
                            int _plus = _objId + _indexOf;
                            _builder.append((Object)_plus, "\t\t");
                            _builder.append("+BASE_ADDRESS:");
                            _builder.newLineIfNotEmpty();
                            boolean _handlesReceive = this._roomExtensions.handlesReceive(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                            if (_handlesReceive) {
                                _builder.append("\t\t");
                                _builder.append("\t");
                                _builder.append("switch (msg->evtID){");
                                _builder.newLine();
                                List _receiveHandlers = this._roomExtensions.getReceiveHandlers(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                                for (MessageHandler h : _receiveHandlers) {
                                    _builder.append("\t\t");
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    _builder.append("case ");
                                    String _name_11 = pi.getProtocol().getName();
                                    _builder.append(_name_11, "\t\t\t\t");
                                    _builder.append("_");
                                    String _codeName = this._roomExtensions.getCodeName(h.getMsg());
                                    _builder.append(_codeName, "\t\t\t\t");
                                    _builder.append(":");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t\t");
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    String _portClassName = this._roomExtensions.getPortClassName(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                                    _builder.append(_portClassName, "\t\t\t\t\t");
                                    _builder.append("_");
                                    String _name_12 = h.getMsg().getName();
                                    _builder.append(_name_12, "\t\t\t\t\t");
                                    _builder.append("_receiveHandler((etPort *)&");
                                    String _pathName_1 = this._roomExtensions.getPathName(ai_1.getPath());
                                    _builder.append(_pathName_1, "\t\t\t\t\t");
                                    _builder.append("_const.");
                                    String _name_13 = pi.getName();
                                    _builder.append(_name_13, "\t\t\t\t\t");
                                    _builder.append(".ports[");
                                    int _indexOf_1 = pi.getPeers().indexOf((Object)peer);
                                    _builder.append((Object)_indexOf_1, "\t\t\t\t\t");
                                    _builder.append("],msg,(void*)&");
                                    String _pathName_2 = this._roomExtensions.getPathName(ai_1.getPath());
                                    _builder.append(_pathName_2, "\t\t\t\t\t");
                                    _builder.append(",");
                                    String _name_14 = ai_1.getActorClass().getName();
                                    _builder.append(_name_14, "\t\t\t\t\t");
                                    _builder.append("_receiveMessage);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t\t");
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    _builder.append("break;");
                                    _builder.newLine();
                                }
                                _builder.append("\t\t");
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("default: ");
                                String _name_15 = ai_1.getActorClass().getName();
                                _builder.append(_name_15, "\t\t\t\t");
                                _builder.append("_receiveMessage((void*)&");
                                String _pathName_3 = this._roomExtensions.getPathName(ai_1.getPath());
                                _builder.append(_pathName_3, "\t\t\t\t");
                                _builder.append(",(etPort*)&");
                                String _pathName_4 = this._roomExtensions.getPathName(ai_1.getPath());
                                _builder.append(_pathName_4, "\t\t\t\t");
                                _builder.append("_const.");
                                String _name_16 = pi.getName();
                                _builder.append(_name_16, "\t\t\t\t");
                                _builder.append(".ports[");
                                int _indexOf_2 = pi.getPeers().indexOf((Object)peer);
                                _builder.append((Object)_indexOf_2, "\t\t\t\t");
                                _builder.append("], msg);");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t\t");
                                _builder.append("\t");
                                _builder.append("\t\t");
                                _builder.append("break;");
                                _builder.newLine();
                                _builder.append("\t\t");
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("}");
                                _builder.newLine();
                            } else {
                                boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                                if (_isGenerateMSCInstrumentation) {
                                    _builder.append("\t\t");
                                    _builder.append("\t");
                                    _builder.append("ET_MSC_LOGGER_ASYNC_IN(");
                                    _builder.newLine();
                                    _builder.append("\t\t");
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    String _pathName_5 = this._roomExtensions.getPathName(ai_1.getPath());
                                    _builder.append(_pathName_5, "\t\t\t\t");
                                    _builder.append("_const.");
                                    String _name_17 = pi.getName();
                                    _builder.append(_name_17, "\t\t\t\t");
                                    _builder.append(".ports[");
                                    int _indexOf_3 = pi.getPeers().indexOf((Object)peer);
                                    _builder.append((Object)_indexOf_3, "\t\t\t\t");
                                    _builder.append("].port.peerInstName,");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t\t");
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    String _name_18 = pi.getProtocol().getName();
                                    _builder.append(_name_18, "\t\t\t\t");
                                    _builder.append("_getMessageString(msg->evtID),");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t\t");
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    String _pathName_6 = this._roomExtensions.getPathName(ai_1.getPath());
                                    _builder.append(_pathName_6, "\t\t\t\t");
                                    _builder.append("_const.");
                                    String _name_19 = pi.getName();
                                    _builder.append(_name_19, "\t\t\t\t");
                                    _builder.append(".ports[");
                                    int _indexOf_4 = pi.getPeers().indexOf((Object)peer);
                                    _builder.append((Object)_indexOf_4, "\t\t\t\t");
                                    _builder.append("].port.myInstName");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append("\t\t");
                                    _builder.append("\t");
                                    _builder.append("\t");
                                    _builder.append(")");
                                    _builder.newLine();
                                }
                                _builder.append("\t\t");
                                _builder.append("\t");
                                String _name_20 = ai_1.getActorClass().getName();
                                _builder.append(_name_20, "\t\t\t");
                                _builder.append("_receiveMessage((void*)&");
                                String _pathName_7 = this._roomExtensions.getPathName(ai_1.getPath());
                                _builder.append(_pathName_7, "\t\t\t");
                                _builder.append(",&");
                                String _pathName_8 = this._roomExtensions.getPathName(ai_1.getPath());
                                _builder.append(_pathName_8, "\t\t\t");
                                _builder.append("_const.");
                                String _name_21 = pi.getName();
                                _builder.append(_name_21, "\t\t\t");
                                _builder.append(".ports[");
                                int _indexOf_5 = pi.getPeers().indexOf((Object)peer);
                                _builder.append((Object)_indexOf_5, "\t\t\t");
                                _builder.append("].port, msg);");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append("\t\t");
                            _builder.append("break;");
                            _builder.newLine();
                        }
                        continue;
                    }
                    _builder.append("\t\t");
                    _builder.append("case ");
                    int _objId_1 = pi.getObjId();
                    _builder.append((Object)_objId_1, "\t\t");
                    _builder.append("+BASE_ADDRESS:");
                    _builder.newLineIfNotEmpty();
                    boolean _handlesReceive_1 = this._roomExtensions.handlesReceive(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                    if (_handlesReceive_1) {
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("switch (msg->evtID){");
                        _builder.newLine();
                        List _receiveHandlers_1 = this._roomExtensions.getReceiveHandlers(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                        for (MessageHandler h_1 : _receiveHandlers_1) {
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("case ");
                            String _name_22 = pi.getProtocol().getName();
                            _builder.append(_name_22, "\t\t\t\t");
                            _builder.append("_");
                            String _codeName_1 = this._roomExtensions.getCodeName(h_1.getMsg());
                            _builder.append(_codeName_1, "\t\t\t\t");
                            _builder.append(":");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            String _portClassName_1 = this._roomExtensions.getPortClassName(pi.getProtocol(), this._roomExtensions.isConjugated(pi));
                            _builder.append(_portClassName_1, "\t\t\t\t\t");
                            _builder.append("_");
                            String _name_23 = h_1.getMsg().getName();
                            _builder.append(_name_23, "\t\t\t\t\t");
                            _builder.append("_receiveHandler((etPort *)&");
                            String _pathName_9 = this._roomExtensions.getPathName(ai_1.getPath());
                            _builder.append(_pathName_9, "\t\t\t\t\t");
                            _builder.append("_const.");
                            String _name_24 = pi.getName();
                            _builder.append(_name_24, "\t\t\t\t\t");
                            _builder.append(",msg,(void*)&");
                            String _pathName_10 = this._roomExtensions.getPathName(ai_1.getPath());
                            _builder.append(_pathName_10, "\t\t\t\t\t");
                            _builder.append(",");
                            String _name_25 = ai_1.getActorClass().getName();
                            _builder.append(_name_25, "\t\t\t\t\t");
                            _builder.append("_receiveMessage);");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("break;");
                            _builder.newLine();
                        }
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("default: ");
                        String _name_26 = ai_1.getActorClass().getName();
                        _builder.append(_name_26, "\t\t\t\t");
                        _builder.append("_receiveMessage((void*)&");
                        String _pathName_11 = this._roomExtensions.getPathName(ai_1.getPath());
                        _builder.append(_pathName_11, "\t\t\t\t");
                        _builder.append(",(etPort*)&");
                        String _pathName_12 = this._roomExtensions.getPathName(ai_1.getPath());
                        _builder.append(_pathName_12, "\t\t\t\t");
                        _builder.append("_const.");
                        String _name_27 = pi.getName();
                        _builder.append(_name_27, "\t\t\t\t");
                        _builder.append(", msg);");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("break;");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    } else {
                        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                        if (_isGenerateMSCInstrumentation_1) {
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("ET_MSC_LOGGER_ASYNC_IN(");
                            _builder.newLine();
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("((etPort*)&");
                            String _pathName_13 = this._roomExtensions.getPathName(ai_1.getPath());
                            _builder.append(_pathName_13, "\t\t\t\t");
                            _builder.append("_const.");
                            String _name_28 = pi.getName();
                            _builder.append(_name_28, "\t\t\t\t");
                            _builder.append(")->peerInstName,");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            String _name_29 = pi.getProtocol().getName();
                            _builder.append(_name_29, "\t\t\t\t");
                            _builder.append("_getMessageString(msg->evtID),");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("((etPort*)&");
                            String _pathName_14 = this._roomExtensions.getPathName(ai_1.getPath());
                            _builder.append(_pathName_14, "\t\t\t\t");
                            _builder.append("_const.");
                            String _name_30 = pi.getName();
                            _builder.append(_name_30, "\t\t\t\t");
                            _builder.append(")->myInstName");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append(")");
                            _builder.newLine();
                        }
                        _builder.append("\t\t");
                        _builder.append("\t");
                        String _name_31 = ai_1.getActorClass().getName();
                        _builder.append(_name_31, "\t\t\t");
                        _builder.append("_receiveMessage((void*)&");
                        String _pathName_15 = this._roomExtensions.getPathName(ai_1.getPath());
                        _builder.append(_pathName_15, "\t\t\t");
                        _builder.append(",(etPort*)&");
                        String _pathName_16 = this._roomExtensions.getPathName(ai_1.getPath());
                        _builder.append(_pathName_16, "\t\t\t");
                        _builder.append("_const.");
                        String _name_32 = pi.getName();
                        _builder.append(_name_32, "\t\t\t");
                        _builder.append(", msg);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("break;");
                    _builder.newLine();
                }
            }
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("etLogger_logErrorF(\"MessageService_");
            String _name_33 = thread.getName();
            _builder.append(_name_33, "\t\t\t");
            _builder.append("_receiveMessage: address %d does not exist \", msg->address);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return ET_TRUE;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<String> found = new HashSet<String>();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            int thread = ai.getThreadId();
            EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                CommunicationType _commType = pi.getProtocol().getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                if (!_equals) continue;
                EList _peers = pi.getPeers();
                for (InterfaceItemInstance peer : _peers) {
                    EObject _eContainer = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)_eContainer;
                    int peer_thread = peer_ai.getThreadId();
                    if (thread == peer_thread) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String _xifexpression = null;
                    int _compareTo = path.compareTo(ppath);
                    boolean _lessThan = _compareTo < 0;
                    _xifexpression = _lessThan ? path + " and " + ppath : ppath + " and " + path;
                    String pair = _xifexpression;
                    boolean _contains = found.contains(pair);
                    boolean _not = !_contains;
                    if (!_not) continue;
                    found.add(pair);
                    this._cExtensions.diagnostician.error(pair + ": data ports placed on different threads (not supported yet)", (EObject)pi.getInterfaceItem(), pi.getInterfaceItem().eContainingFeature());
                }
            }
        }
    }

    private String generateSubSystemUserCodes(SubSystemInstance ssi) {
        String _xblockexpression = null;
        Functions.Function1 _function = it -> it.getActorClass();
        Set acs = IterableExtensions.toSet((Iterable)ListExtensions.map((List)ssi.getAllContainedInstances(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> {
                String _name = it_1.getType().getName();
                return Objects.equal((Object)_name, (Object)"SubSystemUserCode");
            };
            return IterableExtensions.filter((Iterable)it.getAnnotations(), (Functions.Function1)_function_2);
        };
        Iterable annotations = Iterables.concat((Iterable)IterableExtensions.map((Iterable)acs, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> it.getAttributes();
        Functions.Function1 _function_3 = it -> it.getValue();
        Functions.Function1 _function_4 = it -> it.getValue();
        _xblockexpression = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)annotations, (Functions.Function1)_function_2)), (Functions.Function1)_function_3), StringLiteral.class), (Functions.Function1)_function_4), (CharSequence)this._roomExtensions.NEWLINE);
        return _xblockexpression;
    }
}

