/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public void doGenerate(Root root) {
        boolean first = true;
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                if (ssi == null) continue;
                String _name = nr.getName();
                String _plus = _name + "_";
                String _name_1 = ssi.getName();
                String clsname = _plus + _name_1;
                String path = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                String _sourceExtension = this._cExtensions.sourceExtension();
                String file = clsname + "_Runner" + _sourceExtension;
                this.fileIO.generateFile("generating Node runner file", path + file, this.generateSourceFile(root, ssi, first));
                first = false;
            }
        }
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance ssi, boolean first) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        String _name = nr.getName();
        String _plus = _name + "_";
        String _name_1 = ssi.getName();
        String clsname = _plus + _name_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* this class contains the main function running Node ");
        String _name_2 = nr.getName();
        _builder.append(_name_2, " ");
        _builder.append(" with SubSystem ");
        String _name_3 = ssi.getName();
        _builder.append(_name_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* it instantiates Node ");
        String _name_4 = nr.getName();
        _builder.append(_name_4, " ");
        _builder.append(" with SubSystem ");
        String _name_5 = ssi.getName();
        _builder.append(_name_5, " ");
        _builder.append(" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <string.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName(nr, ssi);
        _builder.append(_cHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append("#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"osal/etPlatformLifecycle.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        String _mainMethodName = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        _builder.append(_mainMethodName, " ");
        _builder.append(" function");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* creates components and starts and stops the lifecycle");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("int ");
        String _mainMethodName_1 = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        _builder.append(_mainMethodName_1);
        _builder.append("(int argc, char** argv) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("etBool runAsTest = ET_FALSE;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef ET_DO_NOT_USE_ARGC_ARGV");
        _builder.newLine();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (argc>1 && strcmp(argv[1], \"-headless\")==0)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("runAsTest = ET_TRUE;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (argc>1 && strcmp(argv[1], \"-run_as_test\")==0)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("runAsTest = ET_TRUE;");
        _builder.newLine();
        _builder.append("#endif\t\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("etUserEntry(); /* platform specific */");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("etLogger_logInfo(\"***   T H E   B E G I N   ***\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_OPEN(\"main\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* startup sequence  of lifecycle */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_init(); \t\t/* lifecycle init */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_start(); \t/* lifecycle start */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("etUserPreRun(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* run Scheduler */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_run(runAsTest);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("etUserPostRun(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* shutdown sequence of lifecycle */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_stop(); \t\t/* lifecycle stop */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("_destroy(); \t/* lifecycle destroy */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ET_MSC_LOGGER_CLOSE");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("etLogger_logInfo(\"***   T H E   E N D   ***\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("etUserExit(); /* platform specific */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

