/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    @Extension
    protected IDetailCodeTranslator _iDetailCodeTranslator;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Consumer<ProtocolClass> _function_1 = pc -> {
            String path = this._roomExtensions.getPath((RoomClass)pc);
            String file = this._cExtensions.getCHeaderFileName((RoomClass)pc);
            this.fileIO.generateFile("generating ProtocolClass header", path + file, this.generateHeaderFile(root, (ProtocolClass)pc));
            file = this._cExtensions.getCUtilsFileName((RoomClass)pc);
            this.fileIO.generateFile("generating ProtocolClass utils", path + file, this.generateUtilsFile(root, (ProtocolClass)pc));
            file = this._cExtensions.getCSourceFileName((RoomClass)pc);
            this.fileIO.generateFile("generating ProtocolClass source", path + file, this.generateSourceFile(root, (ProtocolClass)pc));
        };
        IterableExtensions.filter((Iterable)root.getProtocolClasses(), (Functions.Function1)_function).forEach(_function_1);
    }

    private CharSequence generateHeaderFile(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin((RoomClass)pc);
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.append("#include \"modelbase/etPort.h\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 1);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* include all referenced room classes */");
        _builder.newLine();
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)pc);
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)pc);
        Iterable _plus = Iterables.concat((Iterable)_referencedProtocolClasses, (Iterable)_referencedDataClasses);
        EList _referencedEnumClasses = root.getReferencedEnumClasses((RoomClass)pc);
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)_plus, (Iterable)_referencedEnumClasses), (Functions.Function1)_function);
        for (RoomClass dc : _sortBy) {
            _builder.append("#include ");
            String _includePath = this._cExtensions.getIncludePath(dc);
            _builder.append(_includePath);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CommunicationType _commType = pc.getCommType();
        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        if (_equals) {
            _builder.newLine();
            _builder.append("/* message IDs */");
            _builder.newLine();
            String _genMessageIDs = this.genMessageIDs(pc);
            _builder.append(_genMessageIDs);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("/*--------------------- port structs and methods */");
            _builder.newLine();
            CharSequence _portClassHeader = this.portClassHeader(pc, false);
            _builder.append((Object)_portClassHeader);
            _builder.newLineIfNotEmpty();
            CharSequence _portClassHeader_1 = this.portClassHeader(pc, true);
            _builder.append((Object)_portClassHeader_1);
            _builder.newLineIfNotEmpty();
        } else {
            CommunicationType _commType_1 = pc.getCommType();
            boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)CommunicationType.DATA_DRIVEN);
            if (_equals_1) {
                _builder.append("/*--------------------- port structs and methods */");
                _builder.newLine();
                CharSequence _genDataDrivenPortHeaders = this.genDataDrivenPortHeaders(pc);
                _builder.append((Object)_genDataDrivenPortHeaders);
                _builder.newLineIfNotEmpty();
            } else {
                CommunicationType _commType_2 = pc.getCommType();
                boolean _equals_2 = Objects.equal((Object)_commType_2, (Object)CommunicationType.SYNCHRONOUS);
                if (_equals_2) {
                    _builder.append("#error \"synchronoue protocols not implemented yet\"");
                    _builder.newLine();
                }
            }
        }
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("/*--------------------- debug helpers */");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/* get message string for message id */");
            _builder.newLine();
            _builder.append("const char* ");
            String _name_1 = pc.getName();
            _builder.append(_name_1);
            _builder.append("_getMessageString(int msg_id);");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode_1 = this._procedureHelpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd((RoomClass)pc);
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateUtilsFile(Root root, ProtocolClass pc) {
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        EObject _eContainer = pc.eContainer();
        String _replaceAll = ((RoomModel)_eContainer).getName().replaceAll("\\.", "_");
        String _plus = _replaceAll + "_";
        String _name = pc.getName();
        String _plus_1 = _plus + _name;
        String filename = _plus_1 + "_Utils";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Utils File of ProtocolClass ");
        String _name_1 = pc.getName();
        _builder.append(_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(filename);
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        ProtocolClass _base = pc.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            _builder.append("// include base class utils");
            _builder.newLine();
            _builder.append("#include ");
            String _utilsIncludePath = this._cExtensions.getUtilsIncludePath((RoomClass)pc.getBase());
            _builder.append(_utilsIncludePath);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.append("#include ");
        String _includePath = this._cExtensions.getIncludePath((RoomClass)pc);
        _builder.append(_includePath);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* access macros for operations and attributes");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateUtilsFile = this.generateUtilsFile(pc, false);
        _builder.append((Object)_generateUtilsFile);
        _builder.newLineIfNotEmpty();
        CharSequence _generateUtilsFile_1 = this.generateUtilsFile(pc, true);
        _builder.append((Object)_generateUtilsFile_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(filename);
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateUtilsFile(ProtocolClass pc, boolean conj) {
        StringConcatenation _xblockexpression = null;
        PortClass portClass = this._roomExtensions.getPortClass(pc, conj);
        String portClassName = this._roomExtensions.getPortClassName(pc, conj);
        StringConcatenation _builder = new StringConcatenation();
        if (portClass != null) {
            _builder.append("/* ");
            if (conj) {
                _builder.append("conjugate");
            } else {
                _builder.append("regular");
            }
            _builder.append(" port class */");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("/* operations */");
            _builder.newLine();
            EList _operations = portClass.getOperations();
            for (PortOperation op : _operations) {
                boolean _not;
                String params = this.operationParams((Operation)op);
                _builder.newLineIfNotEmpty();
                String args = this.operationArgs((Operation)op);
                _builder.newLineIfNotEmpty();
                _builder.append("#define ");
                String _name = op.getName();
                _builder.append(_name);
                _builder.append("(");
                _builder.append(params);
                _builder.append(") ");
                _builder.append(portClassName);
                _builder.append("_");
                String _name_1 = op.getName();
                _builder.append(_name_1);
                _builder.append("(self");
                boolean _isEmpty = op.getArguments().isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append(", ");
                    _builder.append(args);
                }
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("/* attributes */");
            _builder.newLine();
            EList _attributes = portClass.getAttributes();
            for (Attribute a : _attributes) {
                _builder.append("#define ");
                String _name_2 = a.getName();
                _builder.append(_name_2);
                _builder.append(" (((");
                _builder.append(portClassName);
                _builder.append("_var*)(self->varData))->");
                String _name_3 = a.getName();
                _builder.append(_name_3);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
            }
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String operationParams(Operation op) {
        Functions.Function1 _function = it -> {
            String _switchResult = null;
            boolean _matched = false;
            boolean _isVarargs = it.isVarargs();
            if (_isVarargs) {
                _matched = true;
                _switchResult = "...";
            }
            if (!_matched) {
                _switchResult = it.getName();
            }
            return _switchResult;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)_function), (CharSequence)", ");
    }

    private String operationArgs(Operation op) {
        Functions.Function1 _function = it -> {
            String _switchResult = null;
            boolean _matched = false;
            boolean _isVarargs = it.isVarargs();
            if (_isVarargs) {
                _matched = true;
                _switchResult = "__VA_ARGS__";
            }
            if (!_matched) {
                _switchResult = it.getName();
            }
            return _switchResult;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)_function), (CharSequence)", ");
    }

    private CharSequence generateSourceFile(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)pc);
        _builder.append(_cHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.append("#include \"");
        String _cUtilsFileName = this._cExtensions.getCUtilsFileName((RoomClass)pc);
        _builder.append(_cUtilsFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(pc, 3);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*--------------------- port methods */");
        _builder.newLine();
        CommunicationType _commType = pc.getCommType();
        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        if (_equals) {
            CharSequence _portClassSource = this.portClassSource(pc, false);
            _builder.append((Object)_portClassSource);
            _builder.newLineIfNotEmpty();
            CharSequence _portClassSource_1 = this.portClassSource(pc, true);
            _builder.append((Object)_portClassSource_1);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation) {
                _builder.append("/*--------------------- debug helpers */");
                _builder.newLine();
                CharSequence _generateDebugHelpersImplementation = this.generateDebugHelpersImplementation(root, pc);
                _builder.append((Object)_generateDebugHelpersImplementation);
                _builder.newLineIfNotEmpty();
            }
        } else {
            CommunicationType _commType_1 = pc.getCommType();
            boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)CommunicationType.DATA_DRIVEN);
            if (_equals_1) {
                CharSequence _genDataDrivenPortSources = this.genDataDrivenPortSources(pc);
                _builder.append((Object)_genDataDrivenPortSources);
                _builder.newLineIfNotEmpty();
            } else {
                CommunicationType _commType_2 = pc.getCommType();
                boolean _equals_2 = Objects.equal((Object)_commType_2, (Object)CommunicationType.SYNCHRONOUS);
                if (_equals_2) {
                    _builder.append("#error \"synchronous protocols not implemented yet\"");
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    private CharSequence portClassHeader(ProtocolClass pc, Boolean conj) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        String portClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue(), true);
        List _xifexpression = null;
        _xifexpression = conj != false ? this._roomHelpers.getAllIncomingMessages(pc) : this._roomHelpers.getAllOutgoingMessages(pc);
        List messages = _xifexpression;
        List allPortClasses = this._roomExtensions.getAllPortClasses(pc, conj.booleanValue());
        Functions.Function1 _function = p -> p.getAttributes();
        List allAttributes = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)allPortClasses, (Functions.Function1)_function)));
        Functions.Function1 _function_1 = p -> p.getOperations();
        List allOperations = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)allPortClasses, (Functions.Function1)_function_1)));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef etPort ");
        _builder.append(portClassName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef etReplPort ");
        _builder.append(replPortClassName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isEmpty = allAttributes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("/* variable part of PortClass (RAM) */");
            _builder.newLine();
            _builder.append("typedef struct ");
            _builder.append(portClassName);
            _builder.append("_var ");
            _builder.append(portClassName);
            _builder.append("_var; ");
            _builder.newLineIfNotEmpty();
            _builder.append("struct ");
            _builder.append(portClassName);
            _builder.append("_var {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _attributes = this._procedureHelpers.attributes(allAttributes);
            _builder.append((Object)_attributes, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
            for (Attribute a : allAttributes) {
                String _defaultValueLiteral = a.getDefaultValueLiteral();
                boolean _tripleNotEquals = _defaultValueLiteral != null;
                if (!_tripleNotEquals) continue;
                String _name = a.getName();
                String _plus = portClassName + " " + _name;
                String _plus_1 = _plus + ": Attribute initialization not supported in C";
                this.logger.logInfo(_plus_1);
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        for (Message message : messages) {
            MessageData _data = message.getData();
            boolean hasData = _data != null;
            _builder.newLineIfNotEmpty();
            String _xifexpression_1 = null;
            _xifexpression_1 = hasData ? this._typeHelpers.typeName(message.getData().getRefType().getType()) : "";
            String typeName = _xifexpression_1;
            _builder.newLineIfNotEmpty();
            String _xifexpression_2 = null;
            _xifexpression_2 = hasData && (!this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType()) || message.getData().getRefType().isRef()) ? "*" : "";
            String refp = _xifexpression_2;
            _builder.newLineIfNotEmpty();
            String _xifexpression_3 = null;
            _xifexpression_3 = hasData ? ", " + typeName + refp + " data" : "";
            String data = _xifexpression_3;
            _builder.newLineIfNotEmpty();
            String _messageSignature = this.messageSignature(portClassName, message.getName(), "", data);
            _builder.append(_messageSignature);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            String _messageSignature_1 = this.messageSignature(replPortClassName, message.getName(), "_broadcast", data);
            _builder.append(_messageSignature_1);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            String _messageSignature_2 = this.messageSignature(replPortClassName, message.getName(), "", ", int idx" + data);
            _builder.append(_messageSignature_2);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isEmpty_1 = allOperations.isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration(allOperations, portClassName);
            _builder.append((Object)_operationsDeclaration);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _handlesReceiveIncludingSuper = this._roomExtensions.handlesReceiveIncludingSuper(pc, conj.booleanValue());
        if (_handlesReceiveIncludingSuper) {
            List _receiveHandlersIncludingSuper = this._roomExtensions.getReceiveHandlersIncludingSuper(pc, conj.booleanValue());
            for (MessageHandler h : _receiveHandlersIncludingSuper) {
                _builder.append("void ");
                _builder.append(portClassName);
                _builder.append("_");
                String _name_1 = h.getMsg().getName();
                _builder.append(_name_1);
                _builder.append("_receiveHandler(");
                _builder.append(portClassName);
                _builder.append("* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc);");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("etInt32 ");
        _builder.append(replPortClassName);
        _builder.append("_getReplication(const ");
        _builder.append(replPortClassName);
        _builder.append("* self);");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence genDataDrivenPortHeaders(ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = m -> {
            MessageData _data = m.getData();
            return _data != null;
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)_function);
        Functions.Function1 _function_1 = m -> this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
        Iterable enumMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = m -> this._typeHelpers.isBoolean(m.getData().getRefType().getType());
        Iterable boolMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)_function_2);
        boolean usesMSC = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) && (!IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* data driven send port (conjugated) */");
        _builder.newLine();
        _builder.append("typedef struct ");
        String _portClassName = this._roomExtensions.getPortClassName(pc, true);
        _builder.append(_portClassName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        for (Message msg : sentMsgs) {
            _builder.append("\t");
            String typeName = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Object _xifexpression = null;
            boolean _isRef = msg.getData().getRefType().isRef();
            _xifexpression = _isRef ? "*" : "";
            String refp = _xifexpression;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(typeName, "\t");
            _builder.append(refp, "\t");
            _builder.append(" ");
            String _name = msg.getName();
            _builder.append(_name, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        if (usesMSC) {
            _builder.append("\t");
            _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("const char* instName;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("const char** peerNames;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#endif");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        String _portClassName_1 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append(_portClassName_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* data driven receive port (regular) */");
        _builder.newLine();
        _builder.append("typedef struct ");
        String _portClassName_2 = this._roomExtensions.getPortClassName(pc, false);
        _builder.append(_portClassName_2);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("const ");
        String _portClassName_3 = this._roomExtensions.getPortClassName(pc, true);
        _builder.append(_portClassName_3, "\t");
        _builder.append("* peer;");
        _builder.newLineIfNotEmpty();
        if (usesMSC) {
            _builder.append("\t");
            _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("const char* instName;");
            _builder.newLine();
            for (Message msg_1 : enumMsgs) {
                _builder.append("\t");
                _builder.append("\t");
                String typeName_1 = this._typeHelpers.typeName(msg_1.getData().getRefType().getType());
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                String _xifexpression_1 = null;
                boolean _isRef_1 = msg_1.getData().getRefType().isRef();
                _xifexpression_1 = _isRef_1 ? "*" : "";
                String refp_1 = _xifexpression_1;
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(typeName_1, "\t\t");
                _builder.append(refp_1, "\t\t");
                _builder.append(" ");
                String _name_1 = msg_1.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            for (Message msg_2 : boolMsgs) {
                _builder.append("\t");
                _builder.append("\t");
                String typeName_2 = this._typeHelpers.typeName(msg_2.getData().getRefType().getType());
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                String _xifexpression_2 = null;
                boolean _isRef_2 = msg_2.getData().getRefType().isRef();
                _xifexpression_2 = _isRef_2 ? "*" : "";
                String refp_2 = _xifexpression_2;
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(typeName_2, "\t\t");
                _builder.append(refp_2, "\t\t");
                _builder.append(" ");
                String _name_2 = msg_2.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("#endif");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        String _portClassName_4 = this._roomExtensions.getPortClassName(pc, false);
        _builder.append(_portClassName_4);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        for (Message message : sentMsgs) {
            MessageData _data = message.getData();
            boolean hasData = _data != null;
            _builder.newLineIfNotEmpty();
            String _xifexpression_3 = null;
            _xifexpression_3 = hasData ? this._typeHelpers.typeName(message.getData().getRefType().getType()) : "";
            String typeName_3 = _xifexpression_3;
            _builder.newLineIfNotEmpty();
            String _xifexpression_4 = null;
            _xifexpression_4 = hasData && !this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType()) ? "*" : "";
            String refp_3 = _xifexpression_4;
            _builder.newLineIfNotEmpty();
            String _xifexpression_5 = null;
            _xifexpression_5 = hasData ? ", " + typeName_3 + refp_3 + " data" : "";
            String data = _xifexpression_5;
            _builder.newLineIfNotEmpty();
            String _messageSetterSignature = this.messageSetterSignature(this._roomExtensions.getPortClassName(pc, true), message.getName(), data);
            _builder.append(_messageSetterSignature);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            String _messageGetterSignature = this.messageGetterSignature(this._roomExtensions.getPortClassName(pc, false), message.getName(), typeName_3);
            _builder.append(_messageGetterSignature);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence genDataDrivenPortSources(ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = m -> {
            MessageData _data = m.getData();
            return _data != null;
        };
        Iterable messages = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)_function);
        Functions.Function1 _function_1 = m -> this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
        Iterable enumMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = m -> this._typeHelpers.isBoolean(m.getData().getRefType().getType());
        Iterable boolMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)_function_2);
        boolean usesMSC = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) && (!IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs));
        StringConcatenation _builder = new StringConcatenation();
        for (Message message : messages) {
            String typeName = this._typeHelpers.typeName(message.getData().getRefType().getType());
            _builder.newLineIfNotEmpty();
            String _xifexpression = null;
            boolean _isEnumerationOrPrimitive = this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType());
            boolean _not = !_isEnumerationOrPrimitive;
            _xifexpression = _not ? "*" : "";
            String refp = _xifexpression;
            _builder.newLineIfNotEmpty();
            String data = ", " + typeName + refp + " data";
            _builder.newLineIfNotEmpty();
            String _messageSetterSignature = this.messageSetterSignature(this._roomExtensions.getPortClassName(pc, true), message.getName(), data);
            _builder.append(_messageSetterSignature);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            if (usesMSC && IterableExtensions.exists((Iterable)enumMsgs, m -> Objects.equal((Object)m, (Object)message))) {
                _builder.append("\t");
                _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("const char** peerName;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("for (peerName=self->peerNames; *peerName!=NULL; ++peerName) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("ET_MSC_LOGGER_ASYNC_OUT(self->instName, ");
                String _name = message.getData().getRefType().getType().getName();
                _builder.append(_name, "\t\t\t\t");
                _builder.append("_getLiteralName(data), *peerName)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("ET_MSC_LOGGER_ASYNC_IN(self->instName, ");
                String _name_1 = message.getData().getRefType().getType().getName();
                _builder.append(_name_1, "\t\t\t\t");
                _builder.append("_getLiteralName(data), *peerName)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#endif");
                _builder.newLine();
            }
            if (usesMSC && IterableExtensions.exists((Iterable)boolMsgs, m -> Objects.equal((Object)m, (Object)message))) {
                _builder.append("\t");
                _builder.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("const char** peerName;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("for (peerName=self->peerNames; *peerName!=NULL; ++peerName) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("ET_MSC_LOGGER_ASYNC_OUT(self->instName, data?\"true\":\"false\", *peerName)");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("ET_MSC_LOGGER_ASYNC_IN(self->instName, data?\"true\":\"false\", *peerName)");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#endif");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("self->");
            String _name_2 = message.getName();
            _builder.append(_name_2, "\t");
            _builder.append(" = ");
            _builder.append(refp, "\t");
            _builder.append("data;");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            String _messageGetterSignature = this.messageGetterSignature(this._roomExtensions.getPortClassName(pc, false), message.getName(), typeName);
            _builder.append(_messageGetterSignature);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return self->peer->");
            String _name_3 = message.getName();
            _builder.append(_name_3, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence portClassSource(ProtocolClass pc, Boolean conj) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        List allPortClasses = this._roomExtensions.getAllPortClasses(pc, conj.booleanValue());
        String portClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue(), true);
        List _xifexpression = null;
        _xifexpression = conj != false ? this._roomHelpers.getAllIncomingMessages(pc) : this._roomHelpers.getAllOutgoingMessages(pc);
        List messages = _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = conj != false ? "IN_" : "OUT_";
        String dir = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        for (Message message : messages) {
            MessageData _data = message.getData();
            boolean hasData = _data != null;
            _builder.newLineIfNotEmpty();
            String _xifexpression_2 = null;
            _xifexpression_2 = hasData ? this._typeHelpers.typeName(message.getData().getRefType().getType()) : "";
            String typeName = _xifexpression_2;
            _builder.newLineIfNotEmpty();
            String _xifexpression_3 = null;
            _xifexpression_3 = hasData && message.getData().getRefType().isRef() ? "*" : "";
            String refp = _xifexpression_3;
            _builder.newLineIfNotEmpty();
            String _xifexpression_4 = null;
            _xifexpression_4 = hasData && (!this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType()) || message.getData().getRefType().isRef()) ? "*" : "";
            String refpd = _xifexpression_4;
            _builder.newLineIfNotEmpty();
            String _xifexpression_5 = null;
            _xifexpression_5 = hasData && !this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType()) && !message.getData().getRefType().isRef() ? "" : "&";
            String refa = _xifexpression_5;
            _builder.newLineIfNotEmpty();
            String _xifexpression_6 = null;
            _xifexpression_6 = hasData ? ", " + typeName + refpd + " data__et" : "";
            String data = _xifexpression_6;
            _builder.newLineIfNotEmpty();
            String _xifexpression_7 = null;
            _xifexpression_7 = hasData ? ", data__et" : "";
            String dataCall = _xifexpression_7;
            _builder.newLineIfNotEmpty();
            MessageHandler hdlr = this._roomExtensions.getSendHandler(message, conj.booleanValue());
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            String _messageSignature = this.messageSignature(portClassName, message.getName(), "", data);
            _builder.append(_messageSignature);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            if (hdlr != null) {
                _builder.append("\t");
                String _translatedCode = this._iDetailCodeTranslator.getTranslatedCode(hdlr.getDetailCode());
                _builder.append(_translatedCode, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
                _builder.append(portClassName, "\t");
                _builder.append("\", \"");
                String _name = message.getName();
                _builder.append(_name, "\t");
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                String _name_1 = pc.getName();
                String _name_2 = message.getName();
                String _plus = dir + _name_2;
                String _sendMessageCall = this.sendMessageCall(hasData, "self", this._cExtensions.memberInUse(_name_1, _plus), typeName + refp, refa + "data__et");
                _builder.append(_sendMessageCall, "\t\t");
                _builder.newLineIfNotEmpty();
                boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                if (_isGenerateMSCInstrumentation) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("ET_MSC_LOGGER_ASYNC_OUT(self->myInstName, \"");
                    String _name_3 = message.getName();
                    _builder.append(_name_3, "\t\t");
                    _builder.append("\", self->peerInstName)");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            String _messageSignature_1 = this.messageSignature(replPortClassName, message.getName(), "_broadcast", data);
            _builder.append(_messageSignature_1);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            if (hdlr != null) {
                _builder.append("\t");
                _builder.append("int i;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(portClassName, "\t\t");
                _builder.append("_");
                String _name_4 = message.getName();
                _builder.append(_name_4, "\t\t");
                _builder.append("(&((etReplPort*)self)->ports[i].port");
                _builder.append(dataCall, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}\t\t\t\t\t");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("int i;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
                _builder.append(replPortClassName, "\t");
                _builder.append("\", \"");
                String _name_5 = message.getName();
                _builder.append(_name_5, "\t");
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                String _name_6 = pc.getName();
                String _name_7 = message.getName();
                String _plus_1 = dir + _name_7;
                String _sendMessageCall_1 = this.sendMessageCall(hasData, "(&((etReplPort*)self)->ports[i].port)", this._cExtensions.memberInUse(_name_6, _plus_1), typeName + refp, refa + "data__et");
                _builder.append(_sendMessageCall_1, "\t\t");
                _builder.newLineIfNotEmpty();
                boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                if (_isGenerateMSCInstrumentation_1) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("ET_MSC_LOGGER_ASYNC_OUT(((etReplPort*)self)->ports[i].port.myInstName, \"");
                    String _name_8 = message.getName();
                    _builder.append(_name_8, "\t\t");
                    _builder.append("\", ((etReplPort*)self)->ports[i].port.peerInstName)");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            String _messageSignature_2 = this.messageSignature(replPortClassName, message.getName(), "", ", int idx__et" + data);
            _builder.append(_messageSignature_2);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            if (hdlr != null) {
                _builder.append("\t");
                _builder.append(portClassName, "\t");
                _builder.append("_");
                String _name_9 = message.getName();
                _builder.append(_name_9, "\t");
                _builder.append("(&((etReplPort*)self)->ports[idx__et].port");
                _builder.append(dataCall, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
                _builder.append(replPortClassName, "\t");
                _builder.append("\", \"");
                String _name_10 = message.getName();
                _builder.append(_name_10, "\t");
                _builder.append("\")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if (0<=idx__et && idx__et<((etReplPort*)self)->size) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                String _name_11 = pc.getName();
                String _name_12 = message.getName();
                String _plus_2 = dir + _name_12;
                String _sendMessageCall_2 = this.sendMessageCall(hasData, "(&((etReplPort*)self)->ports[idx__et].port)", this._cExtensions.memberInUse(_name_11, _plus_2), typeName + refp, refa + "data__et");
                _builder.append(_sendMessageCall_2, "\t\t");
                _builder.newLineIfNotEmpty();
                boolean _isGenerateMSCInstrumentation_2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                if (_isGenerateMSCInstrumentation_2) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("ET_MSC_LOGGER_ASYNC_OUT(((etReplPort*)self)->ports[idx__et].port.myInstName, \"");
                    String _name_13 = message.getName();
                    _builder.append(_name_13, "\t\t");
                    _builder.append("\", ((etReplPort*)self)->ports[idx__et].port.peerInstName)");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        boolean _isEmpty = allPortClasses.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("/* begin ");
            _builder.append(portClassName);
            _builder.append(" specific (including base classes) */");
            _builder.newLineIfNotEmpty();
            for (PortClass p : allPortClasses) {
                CharSequence _userCode = this._procedureHelpers.userCode(p.getUserCode());
                _builder.append((Object)_userCode);
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            for (PortClass p_1 : allPortClasses) {
                CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)p_1.getOperations(), portClassName);
                _builder.append((Object)_operationsImplementation);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("/* end ");
            _builder.append(portClassName);
            _builder.append(" specific (including base classes) */");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        _builder.append("etInt32 ");
        _builder.append(replPortClassName);
        _builder.append("_getReplication(const ");
        _builder.append(replPortClassName);
        _builder.append("* self) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ((etReplPort*)self)->size;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _handlesReceive = this._roomExtensions.handlesReceive(pc, conj.booleanValue());
        if (_handlesReceive) {
            CharSequence _genReceiveHandlers = this.genReceiveHandlers(pc, conj);
            _builder.append((Object)_genReceiveHandlers);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String sendMessageCall(boolean hasData, String selfPtr, String msg, String typeName, String data) {
        String _xifexpression = null;
        _xifexpression = hasData ? "etPort_sendMessage(" + selfPtr + ", " + msg + ", sizeof(" + typeName + "), " + data + ");" : "etPort_sendMessage(" + selfPtr + ", " + msg + ", 0, NULL);";
        return _xifexpression;
    }

    private String messageSignature(String className, String messageName, String methodSuffix, String data) {
        return "void " + className + "_" + messageName + methodSuffix + "(const " + className + "* self" + data + ")";
    }

    private String messageSetterSignature(String className, String messageName, String data) {
        return "void " + className + "_" + messageName + "_set(" + className + "* self" + data + ")";
    }

    private String messageGetterSignature(String className, String messageName, String type) {
        return type + " " + className + "_" + messageName + "_get(const " + className + "* const self)";
    }

    private CharSequence genReceiveHandlers(ProtocolClass pc, Boolean conj) {
        StringConcatenation _xblockexpression = null;
        String portClassName = this._roomExtensions.getPortClassName(pc, conj.booleanValue());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* receiver handlers */");
        _builder.newLine();
        List _receiveHandlers = this._roomExtensions.getReceiveHandlers(pc, conj.booleanValue());
        for (MessageHandler h : _receiveHandlers) {
            _builder.append("void ");
            _builder.append(portClassName);
            _builder.append("_");
            String _name = h.getMsg().getName();
            _builder.append(_name);
            _builder.append("_receiveHandler(");
            _builder.append(portClassName);
            _builder.append("* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _translatedCode = this._iDetailCodeTranslator.getTranslatedCode(h.getDetailCode());
            _builder.append(_translatedCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* hand over the message to the actor:      */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* (*receiveMessageFunc)(actor, self, msg); */");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateDebugHelpersImplementation(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("/* message names as strings for debugging (generate MSC) */");
        _builder.newLine();
        _builder.append("static const char* const ");
        String _name = pc.getName();
        _builder.append(_name);
        _builder.append("_messageStrings[] = {\"MIN\", ");
        List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
        for (Message m : _allOutgoingMessages) {
            _builder.append("\"");
            String _name_1 = m.getName();
            _builder.append(_name_1);
            _builder.append("\",");
        }
        List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
        for (Message m_1 : _allIncomingMessages) {
            _builder.append("\"");
            String _name_2 = m_1.getName();
            _builder.append(_name_2);
            _builder.append("\", ");
        }
        _builder.append("\"MAX\"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("const char* ");
        String _name_3 = pc.getName();
        _builder.append(_name_3);
        _builder.append("_getMessageString(int msg_id) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (msg_id<");
        String _name_4 = pc.getName();
        _builder.append(_name_4, "\t");
        _builder.append("_MSG_MIN || msg_id>");
        String _name_5 = pc.getName();
        _builder.append(_name_5, "\t");
        _builder.append("_MSG_MAX+1){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* id out of range */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return \"Message ID out of range\";");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("else{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ");
        String _name_6 = pc.getName();
        _builder.append(_name_6, "\t\t");
        _builder.append("_messageStrings[msg_id];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

