/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public CharSequence genHeaderConstants(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        Functions.Function1 _function = it -> {
            boolean _isLeaf = FsmGenExtensions.isLeaf((Node)it);
            return !_isLeaf;
        };
        int _size = IteratorExtensions.size((Iterator)IteratorExtensions.filter((Iterator)FsmGenExtensions.getAllStateNodes((Graph)xpac.getGraphContainer().getGraph()), (Functions.Function1)_function));
        int historySize = _size + 2;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* constant for state machine data */");
        _builder.newLine();
        _builder.append("#define ");
        String _upperCase = ac.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_HISTORY_SIZE ");
        _builder.append((Object)historySize);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence genDataMembers(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* state machine variables */");
        _builder.newLine();
        _builder.append("etInt16 state;");
        _builder.newLine();
        _builder.append("etInt16 history[");
        String _upperCase = ac.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_HISTORY_SIZE];");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence genInitialization(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("self->state = STATE_TOP;");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int i;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (i=0; i<");
        String _upperCase = ac.getName().toUpperCase();
        _builder.append(_upperCase, "\t");
        _builder.append("_HISTORY_SIZE; ++i)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("self->history[i] = NO_STATE;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String _operationScope = this.langExt.operationScope(ac.getName(), false);
        _builder.append(_operationScope);
        _builder.append("executeInitTransition(self);");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence genExtra(GraphContainer gc, boolean generateImplementation) {
        StringConcatenation _xblockexpression = null;
        ModelComponent mc = gc.getComponent();
        Functions.Function1 _function = it -> it.getStateGraphNode();
        List allStates = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph()), (Functions.Function1)_function), State.class));
        Iterable states = this._roomExtensions.getLeafStatesLast(allStates);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("/* state names */");
            _builder.newLine();
            _builder.append("static const char* stateStrings[] = {\"<no state>\",\"<top>\",");
            boolean _hasElements = false;
            for (State state : states) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                _builder.append("\"");
                String _genStatePathName = this._codegenHelpers.getGenStatePathName(state);
                _builder.append(_genStatePathName);
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _accessLevelPrivate = this.langExt.accessLevelPrivate();
        _builder.append(_accessLevelPrivate);
        _builder.append("void setState(");
        String _componentName = mc.getComponentName();
        _builder.append(_componentName);
        _builder.append("* self, ");
        String _stateType = this.stateType();
        _builder.append(_stateType);
        _builder.append(" new_state) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("self->state = new_state;");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append("\t");
            _builder.append("ET_MSC_LOGGER_CHANGE_STATE(self->constData->instName, stateStrings[new_state]);");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _accessLevelPrivate_1 = this.langExt.accessLevelPrivate();
        _builder.append(_accessLevelPrivate_1);
        String _stateType_1 = this.stateType();
        _builder.append(_stateType_1);
        _builder.append(" getState(");
        String _componentName_1 = mc.getComponentName();
        _builder.append(_componentName_1);
        _builder.append("* self) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return self->state;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String stateType() {
        return "etInt16";
    }

    public String boolType() {
        return "etBool";
    }

    public CharSequence markVariableUsed(String varname) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("((void)trigger__et);\t/* avoids unused warning */");
        _builder.newLine();
        return _builder;
    }

    public String unreachableReturn() {
        return "/* return NO_STATE; // required by CDT but detected as unreachable by JDT because of while (true) */";
    }
}

