/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FsmGenChecker {
    public static void check(GraphContainer gc, ILogger logger) {
        Procedures.Procedure1 _function = it -> FsmGenChecker.checkGraph(it, logger);
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)gc.eAllContents(), Graph.class), (Procedures.Procedure1)_function);
        Procedures.Procedure1 _function_1 = it -> FsmGenChecker.checkNode(it, logger);
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)gc.eAllContents(), Node.class), (Procedures.Procedure1)_function_1);
        Procedures.Procedure1 _function_2 = it -> FsmGenChecker.checkLink(it, logger);
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)gc.eAllContents(), Link.class), (Procedures.Procedure1)_function_2);
    }

    private static void checkLink(Link it, ILogger logger) {
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        TransitionBase _transition = it.getTransition();
        boolean bl = _tripleEquals = _transition == null;
        if (_tripleEquals) {
            logger.logError("graph doesn't point to ROOM transition");
        } else {
            boolean _eIsProxy = it.getTransition().eIsProxy();
            if (_eIsProxy) {
                logger.logError("unresolved ROOM transition");
            } else {
                boolean _tripleEquals_1;
                EObject _eContainer = it.getTransition().eContainer();
                boolean bl2 = _tripleEquals_1 = _eContainer == null;
                if (_tripleEquals_1) {
                    logger.logError("dangling ROOM transition");
                } else {
                    boolean _tripleEquals_2;
                    Node _target = it.getTarget();
                    boolean bl3 = _tripleEquals_2 = _target == null;
                    if (_tripleEquals_2) {
                        logger.logError("link without target");
                    } else if (it.getSource() == null && it.getTransition() instanceof NonInitialTransition) {
                        logger.logError("non-initial link without source");
                    }
                }
            }
        }
        Node _source = it.getSource();
        boolean bl4 = _tripleNotEquals = _source != null;
        if (_tripleNotEquals) {
            FsmGenChecker.checkLinkEnd(it, it.getSource(), logger);
        }
        FsmGenChecker.checkLinkEnd(it, it.getTarget(), logger);
    }

    private static void checkLinkEnd(Link link, Node node, ILogger logger) {
        boolean _not;
        EObject _eContainer_1;
        EObject _eContainer = node.eContainer();
        boolean _equals = Objects.equal((Object)_eContainer, (Object)(_eContainer_1 = link.eContainer()));
        if (_equals) {
            return;
        }
        StateGraphNode _stateGraphNode = node.getStateGraphNode();
        boolean bl = _not = !(_stateGraphNode instanceof TrPoint);
        if (_not) {
            logger.logError("subgraph item is not transition point");
        } else {
            boolean _not_1;
            EObject _eContainer_2 = node.eContainer().eContainer();
            boolean bl2 = _not_1 = !(_eContainer_2 instanceof Node);
            if (_not_1) {
                logger.logError("subgraph item is in unexpected container");
            } else {
                boolean _not_2;
                EObject _eContainer_3 = node.eContainer().eContainer();
                StateGraphNode _stateGraphNode_1 = ((Node)_eContainer_3).getStateGraphNode();
                boolean bl3 = _not_2 = !(_stateGraphNode_1 instanceof State);
                if (_not_2) {
                    logger.logError("subgraph item is in unexpected container");
                } else {
                    EObject _eContainer_5;
                    boolean _notEquals;
                    EObject _eContainer_4 = node.eContainer().eContainer().eContainer();
                    boolean bl4 = _notEquals = !Objects.equal((Object)_eContainer_4, (Object)(_eContainer_5 = link.eContainer()));
                    if (_notEquals) {
                        logger.logError("subgraph item is in unexpected container");
                    }
                }
            }
        }
    }

    private static void checkNode(Node it, ILogger logger) {
        boolean _tripleEquals;
        StateGraphNode _stateGraphNode = it.getStateGraphNode();
        boolean bl = _tripleEquals = _stateGraphNode == null;
        if (_tripleEquals) {
            logger.logError("graph doesn't point to ROOM state graph node");
        } else {
            boolean _eIsProxy = it.getStateGraphNode().eIsProxy();
            if (_eIsProxy) {
                logger.logError("unresolved ROOM graph node");
            } else {
                boolean _tripleEquals_1;
                Iterator _eContainer = it.getStateGraphNode().eContainer();
                boolean bl2 = _tripleEquals_1 = _eContainer == null;
                if (_tripleEquals_1) {
                    logger.logError("dangling ROOM graph node");
                } else {
                    boolean _tripleEquals_2;
                    String _name = it.getStateGraphNode().getName();
                    boolean bl3 = _tripleEquals_2 = _name == null;
                    if (_tripleEquals_2) {
                        logger.logError("ROOM graph node without name");
                    } else {
                        boolean _tripleEquals_3;
                        Graph _graph = it.getGraph();
                        boolean bl4 = _tripleEquals_3 = _graph == null;
                        if (_tripleEquals_3) {
                            logger.logError("node isn't contained in a graph");
                        }
                    }
                }
            }
        }
        EList<Link> _incoming = it.getIncoming();
        for (Link l : _incoming) {
            StateGraphNode _stateGraphNode_2;
            StateGraphNode _stateGraphNode_1 = l.getTarget().getStateGraphNode();
            boolean _notEquals = !Objects.equal((Object)_stateGraphNode_1, (Object)(_stateGraphNode_2 = it.getStateGraphNode()));
            if (!_notEquals) continue;
            logger.logError("ROOM target node of an incoming transition must be myself");
        }
        EList<Link> _outgoing = it.getOutgoing();
        for (Link l_1 : _outgoing) {
            StateGraphNode _stateGraphNode_4;
            StateGraphNode _stateGraphNode_3 = l_1.getSource().getStateGraphNode();
            boolean _notEquals_1 = !Objects.equal((Object)_stateGraphNode_3, (Object)(_stateGraphNode_4 = it.getStateGraphNode()));
            if (!_notEquals_1) continue;
            logger.logError("ROOM source node of an outgoing transition must be myself");
        }
    }

    private static void checkGraph(Graph it, ILogger logger) {
        boolean _tripleEquals;
        StateGraph _stateGraph = it.getStateGraph();
        boolean bl = _tripleEquals = _stateGraph == null;
        if (_tripleEquals) {
            logger.logError("graph doesn't point to ROOM state graph");
        } else {
            boolean _eIsProxy = it.getStateGraph().eIsProxy();
            if (_eIsProxy) {
                logger.logError("unresolved ROOM graph");
            } else {
                boolean _tripleEquals_1;
                EObject _eContainer = it.getStateGraph().eContainer();
                boolean bl2 = _tripleEquals_1 = _eContainer == null;
                if (_tripleEquals_1) {
                    logger.logError("dangling ROOM graph");
                }
            }
        }
    }
}

