/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.ExitPoint;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphItem;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FsmGenExtensions {
    protected static String _getName(Node nd) {
        return nd.getStateGraphNode().getName();
    }

    protected static String _getName(Link l) {
        return l.getTransition().getName();
    }

    public static Iterable<Node> getStateNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof State;
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)_function);
    }

    public static Iterator<Node> getAllNodes(Graph g) {
        return Iterators.filter((Iterator)g.eAllContents(), Node.class);
    }

    public static Iterator<Node> getAllStateNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof State;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)_function);
    }

    public static Iterable<Node> getChoicePointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof ChoicePoint;
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)_function);
    }

    public static Iterator<Node> getAllChoicePointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof ChoicePoint;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)_function);
    }

    public static Iterable<Node> getTrPointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof TrPoint;
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)_function);
    }

    public static Iterator<Node> getAllTrPointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof TrPoint;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)_function);
    }

    public static Iterable<Node> getTransitionPointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof TransitionPoint;
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)_function);
    }

    public static Iterator<Node> getAllTransitionPointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof TransitionPoint;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)_function);
    }

    public static Iterable<Node> getEntryPointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof EntryPoint;
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)_function);
    }

    public static Iterator<Node> getAllEntryPointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof EntryPoint;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)_function);
    }

    public static Iterable<Node> getExitPointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof ExitPoint;
        };
        return IterableExtensions.filter(g.getNodes(), (Functions.Function1)_function);
    }

    public static Iterator<Node> getAllExitPointNodes(Graph g) {
        Functions.Function1 _function = it -> {
            StateGraphNode _stateGraphNode = it.getStateGraphNode();
            return _stateGraphNode instanceof ExitPoint;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllNodes(g), (Functions.Function1)_function);
    }

    public static Iterable<State> getStates(Graph g) {
        Functions.Function1 _function = it -> it.getStateGraphNode();
        return Iterables.filter((Iterable)IterableExtensions.map(FsmGenExtensions.getStateNodes(g), (Functions.Function1)_function), State.class);
    }

    public static Iterator<State> getAllStates(Graph g) {
        Functions.Function1 _function = it -> it.getStateGraphNode();
        return Iterators.filter((Iterator)IteratorExtensions.map(FsmGenExtensions.getAllStateNodes(g), (Functions.Function1)_function), State.class);
    }

    public static Iterable<ChoicePoint> getChoicePoints(Graph g) {
        Functions.Function1 _function = it -> it.getStateGraphNode();
        return Iterables.filter((Iterable)IterableExtensions.map(FsmGenExtensions.getChoicePointNodes(g), (Functions.Function1)_function), ChoicePoint.class);
    }

    public static Iterable<TrPoint> getTrPoints(Graph g) {
        Functions.Function1 _function = it -> it.getStateGraphNode();
        return Iterables.filter((Iterable)IterableExtensions.map(FsmGenExtensions.getTrPointNodes(g), (Functions.Function1)_function), TrPoint.class);
    }

    public static InitialTransition getInitialTransition(Graph g) {
        Functions.Function1 _function = it -> it.getTransition();
        return (InitialTransition)IterableExtensions.head((Iterable)Iterables.filter((Iterable)ListExtensions.map(g.getLinks(), (Functions.Function1)_function), InitialTransition.class));
    }

    public static Iterator<Link> getAllLinks(Graph g) {
        return Iterators.filter((Iterator)g.eAllContents(), Link.class);
    }

    public static Iterator<Link> getAllInitialTranisitionLinks(Graph g) {
        Functions.Function1 _function = it -> {
            TransitionBase _transition = it.getTransition();
            return _transition instanceof InitialTransition;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)_function);
    }

    public static Iterator<Link> getAllTriggeredTranisitionLinks(Graph g) {
        Functions.Function1 _function = it -> {
            TransitionBase _transition = it.getTransition();
            return _transition instanceof TriggeredTransition;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)_function);
    }

    public static Iterator<Link> getAllContinuationTranisitionLinks(Graph g) {
        Functions.Function1 _function = it -> {
            TransitionBase _transition = it.getTransition();
            return _transition instanceof ContinuationTransition;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)_function);
    }

    public static Iterator<Link> getAllCPBranchTranisitionLinks(Graph g) {
        Functions.Function1 _function = it -> {
            TransitionBase _transition = it.getTransition();
            return _transition instanceof CPBranchTransition;
        };
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)_function);
    }

    public static Iterator<Link> getAllChainHeads(Graph g) {
        Functions.Function1 _function = it -> FsmGenExtensions.isChainHead(it);
        return IteratorExtensions.filter(FsmGenExtensions.getAllLinks(g), (Functions.Function1)_function);
    }

    public static boolean isChainHead(Link l) {
        return FsmGenExtensions.isChainHead(l.getTransition());
    }

    public static boolean isChainHead(TransitionBase t) {
        boolean _xifexpression = false;
        _xifexpression = t instanceof RefinedTransition ? FsmGenExtensions.isChainHead((TransitionBase)((RefinedTransition)t).getTarget()) : t instanceof InitialTransition || t instanceof GuardedTransition || t instanceof TriggeredTransition;
        return _xifexpression;
    }

    public static Iterable<Link> getOutgoingTriggeredTransitionLinks(Node s) {
        Functions.Function1 _function = it -> {
            TransitionBase _transition = it.getTransition();
            return _transition instanceof TriggeredTransition;
        };
        return IterableExtensions.filter(s.getOutgoing(), (Functions.Function1)_function);
    }

    public static Iterable<TriggeredTransition> getOutgoingTriggeredTransitions(Node s) {
        Functions.Function1 _function = it -> it.getTransition();
        return Iterables.filter((Iterable)IterableExtensions.map(FsmGenExtensions.getOutgoingTriggeredTransitionLinks(s), (Functions.Function1)_function), TriggeredTransition.class);
    }

    public static List<TransitionBase> getOutgoingTransitionsHierarchically(Node s) {
        Functions.Function1 _function = it -> it.getTransition();
        return ListExtensions.map(FsmGenExtensions.getOutgoingLinksHierarchically(s), (Functions.Function1)_function);
    }

    public static ArrayList<Link> getOutgoingLinksHierarchically(Node s) {
        ArrayList result = CollectionLiterals.newArrayList();
        Node current = s;
        while (current != null) {
            result.addAll(s.getOutgoing());
            Functions.Function1 _function = it -> it.getOutgoing();
            Iterables.addAll((Collection)result, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(FsmGenExtensions.getTransitionPointNodes(s.getGraph()), (Functions.Function1)_function)));
            current = FsmGenExtensions.getParentState(current);
        }
        return result;
    }

    public static boolean isTopLevel(Graph g) {
        boolean _xifexpression = false;
        if (g != null) {
            EObject _eContainer = g.eContainer();
            _xifexpression = _eContainer instanceof GraphContainer;
        } else {
            _xifexpression = true;
        }
        return _xifexpression;
    }

    public static boolean isEmpty(Graph g) {
        return g == null || g.getNodes().isEmpty() && g.getLinks().isEmpty();
    }

    public static boolean isLeaf(Node n) {
        Graph _subgraph = n.getSubgraph();
        return _subgraph == null;
    }

    public static boolean isTopLevel(Node n) {
        return FsmGenExtensions.isTopLevel(n.getGraph());
    }

    public static Node getParentState(Node n) {
        Node _xifexpression = null;
        boolean _isTopLevel = FsmGenExtensions.isTopLevel(n);
        if (_isTopLevel) {
            _xifexpression = null;
        } else {
            EObject _eContainer = n.getGraph().eContainer();
            _xifexpression = (Node)_eContainer;
        }
        return _xifexpression;
    }

    public static Link getChoicepointDefaultBranch(Node n) {
        boolean _not;
        StateGraphNode _stateGraphNode = n.getStateGraphNode();
        boolean bl = _not = !(_stateGraphNode instanceof ChoicePoint);
        if (_not) {
            return null;
        }
        Functions.Function1 _function = it -> {
            TransitionBase _transition = it.getTransition();
            return _transition instanceof ContinuationTransition;
        };
        return (Link)IterableExtensions.head((Iterable)IterableExtensions.filter(n.getOutgoing(), (Functions.Function1)_function));
    }

    public static Node getParentState(Link l) {
        Node _xifexpression = null;
        boolean _isTopLevel = FsmGenExtensions.isTopLevel(l.getGraph());
        if (_isTopLevel) {
            _xifexpression = null;
        } else {
            EObject _eContainer = l.getGraph().eContainer();
            _xifexpression = (Node)_eContainer;
        }
        return _xifexpression;
    }

    public static boolean isHandler(Link l) {
        boolean _xblockexpression = false;
        StateGraphNode sourceNode = l.getSource().getStateGraphNode();
        boolean _xifexpression = false;
        _xifexpression = sourceNode instanceof TransitionPoint ? ((TransitionPoint)sourceNode).isHandler() : false;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static List<DetailCode> getAllDetailCodes(Graph graph) {
        ArrayList detailCodes = CollectionLiterals.newArrayList();
        if (graph != null) {
            Functions.Function1 _function = it -> it.getTransition();
            Iterator allTransitions = IteratorExtensions.map(FsmGenExtensions.getAllLinks(graph), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> it.getAction();
            List _list = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)allTransitions, (Functions.Function1)_function_1));
            Iterables.addAll((Collection)detailCodes, (Iterable)_list);
            Functions.Function1 _function_2 = it -> it.getStateGraphNode();
            UnmodifiableIterator allStates = Iterators.filter((Iterator)IteratorExtensions.map(FsmGenExtensions.getAllStateNodes(graph), (Functions.Function1)_function_2), State.class);
            Functions.Function1 _function_3 = it -> it.getEntryCode();
            List _list_1 = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)allStates, (Functions.Function1)_function_3));
            Iterables.addAll((Collection)detailCodes, (Iterable)_list_1);
            Functions.Function1 _function_4 = it -> it.getDoCode();
            List _list_2 = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)allStates, (Functions.Function1)_function_4));
            Iterables.addAll((Collection)detailCodes, (Iterable)_list_2);
            Functions.Function1 _function_5 = it -> it.getExitCode();
            List _list_3 = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)allStates, (Functions.Function1)_function_5));
            Iterables.addAll((Collection)detailCodes, (Iterable)_list_3);
        }
        return detailCodes;
    }

    public static Link getLinkFor(GraphContainer gc, TransitionBase t) {
        Functions.Function1 _function = it -> {
            TransitionBase _transition = it.getTransition();
            return _transition == t;
        };
        return (Link)IteratorExtensions.findFirst(FsmGenExtensions.getAllLinks(gc.getGraph()), (Functions.Function1)_function);
    }

    public static String getName(GraphItem l) {
        if (l instanceof Link) {
            return FsmGenExtensions._getName((Link)l);
        }
        if (l instanceof Node) {
            return FsmGenExtensions._getName((Node)l);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(l).toString());
    }
}

