/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class RoomCrossReferencer {
    private RoomHelpers roomHelpers = new RoomHelpers();

    public Set<RoomModel> getReferencedModels(RoomClass cls) {
        HashSet<DataClass> dataClasses = new HashSet<DataClass>();
        HashSet<EnumerationType> enumClasses = new HashSet<EnumerationType>();
        HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
        HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
        HashSet<RoomModel> models = new HashSet<RoomModel>();
        if (cls instanceof DataClass) {
            dataClasses.add((DataClass)cls);
        } else if (cls instanceof ProtocolClass) {
            protocolClasses.add((ProtocolClass)cls);
        } else if (cls instanceof ActorClass) {
            actorClasses.add((ActorClass)cls);
        } else if (cls instanceof SubSystemClass) {
            SubSystemClass cc = (SubSystemClass)cls;
            for (ActorRef ar : cc.getActorRefs()) {
                this.recursivelyAddReferencedClasses(ar.getType(), actorClasses);
            }
        }
        this.getReferencedClassesAndModels(dataClasses, enumClasses, protocolClasses, actorClasses, models);
        models.remove(cls.eContainer());
        return models;
    }

    public Set<ProtocolClass> getReferencedProtocolClasses(RoomClass rc) {
        HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
        if (rc instanceof ActorClass) {
            ActorClass cls = (ActorClass)rc;
            HashSet<DataClass> dataClasses = new HashSet<DataClass>();
            HashSet<EnumerationType> enumClasses = new HashSet<EnumerationType>();
            HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
            HashSet<RoomModel> models = new HashSet<RoomModel>();
            actorClasses.add(cls);
            this.getReferencedClassesAndModels(dataClasses, enumClasses, protocolClasses, actorClasses, models);
        } else if (rc instanceof ProtocolClass) {
            HashSet<DataClass> dataClasses = new HashSet<DataClass>();
            HashSet<EnumerationType> enumClasses = new HashSet<EnumerationType>();
            HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
            HashSet<RoomModel> models = new HashSet<RoomModel>();
            protocolClasses.add((ProtocolClass)rc);
            this.getReferencedClassesAndModels(dataClasses, enumClasses, protocolClasses, actorClasses, models);
            protocolClasses.remove(rc);
        }
        return protocolClasses;
    }

    public Set<DataClass> getReferencedDataClasses(RoomClass rc) {
        HashSet<DataClass> dataClasses = new HashSet<DataClass>();
        HashSet<EnumerationType> enumClasses = new HashSet<EnumerationType>();
        if (rc instanceof DataClass) {
            DataClass cls = (DataClass)rc;
            if (cls.getBase() != null) {
                dataClasses.add(cls.getBase());
            }
            this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)cls.getAttributes());
            this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)cls.getOperations());
        } else if (rc instanceof ActorClass) {
            ActorClass cls = (ActorClass)rc;
            do {
                this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)cls.getAttributes());
                this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)cls.getOperations());
            } while ((cls = cls.getActorBase()) != null);
        } else if (rc instanceof ProtocolClass) {
            ProtocolClass pc = (ProtocolClass)rc;
            this.getMessageDataClasses(dataClasses, enumClasses, (EList<Message>)pc.getIncomingMessages());
            this.getMessageDataClasses(dataClasses, enumClasses, (EList<Message>)pc.getOutgoingMessages());
            if (pc.getRegular() != null) {
                this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)pc.getRegular().getAttributes());
                this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)pc.getRegular().getOperations());
            }
            if (pc.getConjugated() != null) {
                this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)pc.getConjugated().getAttributes());
                this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)pc.getConjugated().getOperations());
            }
        }
        return dataClasses;
    }

    public Set<EnumerationType> getReferencedEnumClasses(RoomClass rc) {
        HashSet<DataClass> dataClasses = new HashSet<DataClass>();
        HashSet<EnumerationType> enumClasses = new HashSet<EnumerationType>();
        if (rc instanceof DataClass) {
            DataClass cls = (DataClass)rc;
            if (cls.getBase() != null) {
                dataClasses.add(cls.getBase());
            }
            this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)cls.getAttributes());
            this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)cls.getOperations());
        } else if (rc instanceof ActorClass) {
            ActorClass cls = (ActorClass)rc;
            do {
                this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)cls.getAttributes());
                this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)cls.getOperations());
                for (ProtocolClass protocol : this.getReferencedProtocolClasses((RoomClass)cls)) {
                    enumClasses.addAll(this.getReferencedEnumClasses((RoomClass)protocol));
                }
            } while ((cls = cls.getActorBase()) != null);
        } else if (rc instanceof ProtocolClass) {
            ProtocolClass pc = (ProtocolClass)rc;
            this.getMessageDataClasses(dataClasses, enumClasses, (EList<Message>)pc.getIncomingMessages());
            this.getMessageDataClasses(dataClasses, enumClasses, (EList<Message>)pc.getOutgoingMessages());
            if (pc.getRegular() != null) {
                this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)pc.getRegular().getAttributes());
                this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)pc.getRegular().getOperations());
            }
            if (pc.getConjugated() != null) {
                this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)pc.getConjugated().getAttributes());
                this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)pc.getConjugated().getOperations());
            }
        }
        return enumClasses;
    }

    public Set<EnumerationType> getReferencedEnumClasses(PortClass pc) {
        HashSet<DataClass> dataClasses = new HashSet<DataClass>();
        HashSet<EnumerationType> enumClasses = new HashSet<EnumerationType>();
        this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)pc.getAttributes());
        this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)pc.getOperations());
        return enumClasses;
    }

    public Set<DataClass> getReferencedDataClasses(PortClass pc) {
        HashSet<DataClass> dataClasses = new HashSet<DataClass>();
        HashSet<EnumerationType> enumClasses = new HashSet<EnumerationType>();
        this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)pc.getAttributes());
        this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)pc.getOperations());
        return dataClasses;
    }

    public Set<ActorClass> getReferencedActorClasses(RoomClass rc) {
        HashSet<ActorClass> result = new HashSet<ActorClass>();
        if (rc instanceof ActorClass) {
            ActorClass cls = (ActorClass)rc;
            this.recursivelyAddReferencedClasses(cls, result);
        } else if (rc instanceof SubSystemClass) {
            SubSystemClass cls = (SubSystemClass)rc;
            for (ActorRef ar : cls.getActorRefs()) {
                this.recursivelyAddReferencedClasses(ar.getType(), result);
            }
        }
        return result;
    }

    private void recursivelyAddReferencedClasses(ActorClass ac, HashSet<ActorClass> actorClasses) {
        actorClasses.add(ac);
        for (ActorContainerRef ar : this.roomHelpers.getAllActorContainerRefs((StructureClass)ac)) {
            if (!(ar instanceof ActorRef)) continue;
            this.recursivelyAddReferencedClasses(((ActorRef)ar).getType(), actorClasses);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getReferencedClassesAndModels(Set<DataClass> dataClasses, Set<EnumerationType> enumClasses, Set<ProtocolClass> protocolClasses, Set<ActorClass> actorClasses, Set<RoomModel> models) {
        boolean bl;
        LinkedList<ActorClass> tmpAc = new LinkedList<ActorClass>(actorClasses);
        for (ActorClass actorClass : tmpAc) {
            void var8_9;
            while (var8_9.getActorBase() != null) {
                ActorClass actorClass2 = var8_9.getActorBase();
                actorClasses.add(actorClass2);
            }
        }
        boolean addedNew = false;
        do {
            tmpAc = new LinkedList<ActorClass>(actorClasses);
            addedNew = false;
            for (ActorClass actorClass : tmpAc) {
                for (ActorRef ref : actorClass.getActorRefs()) {
                    ActorClass cls = ref.getType();
                    addedNew |= actorClasses.add(cls);
                    while (cls.getActorBase() != null) {
                        cls = cls.getActorBase();
                        addedNew |= actorClasses.add(cls);
                    }
                }
            }
        } while (addedNew);
        for (ActorClass actorClass : actorClasses) {
            this.getInterfaceItemProtocolClasses(protocolClasses, (EList<? extends InterfaceItem>)actorClass.getInterfacePorts());
            this.getInterfaceItemProtocolClasses(protocolClasses, (EList<? extends InterfaceItem>)actorClass.getInternalPorts());
            this.getInterfaceItemProtocolClasses(protocolClasses, (EList<? extends InterfaceItem>)actorClass.getServiceAccessPoints());
            for (Object ispp : actorClass.getServiceImplementations()) {
                protocolClasses.add(ispp.getSpp().getProtocol());
            }
            this.getInterfaceItemProtocolClasses(protocolClasses, (EList<? extends InterfaceItem>)actorClass.getServiceProvisionPoints());
            this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)actorClass.getAttributes());
            this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)actorClass.getOperations());
        }
        LinkedList<ProtocolClass> linkedList = new LinkedList<ProtocolClass>(protocolClasses);
        for (ProtocolClass pc : linkedList) {
            while (pc.getBase() != null) {
                pc = pc.getBase();
                protocolClasses.add(pc);
            }
        }
        for (ProtocolClass pc : protocolClasses) {
            for (Message m : pc.getIncomingMessages()) {
                if (m.getData() == null) continue;
                this.getMessageDataClasses(dataClasses, enumClasses, Collections.singleton(m.getData()));
            }
            for (Message m : pc.getOutgoingMessages()) {
                if (m.getData() == null) continue;
                this.getMessageDataClasses(dataClasses, enumClasses, Collections.singleton(m.getData()));
            }
            if (pc.getRegular() != null) {
                this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)pc.getRegular().getAttributes());
                this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)pc.getRegular().getOperations());
            }
            if (pc.getConjugated() == null) continue;
            this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)pc.getConjugated().getAttributes());
            this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)pc.getConjugated().getOperations());
        }
        boolean bl2 = true;
        do {
            LinkedList<DataClass> tmpDc = new LinkedList<DataClass>(dataClasses);
            for (DataClass dc : tmpDc) {
                this.getAttributeDataClasses(dataClasses, enumClasses, (Collection<Attribute>)dc.getAttributes());
                this.getOperationDataClasses(dataClasses, enumClasses, (EList<? extends Operation>)dc.getOperations());
                while (dc.getBase() != null) {
                    dc = dc.getBase();
                    dataClasses.add(dc);
                }
            }
            if (tmpDc.size() != dataClasses.size()) continue;
            bl = false;
        } while (bl);
        for (DataClass dc : dataClasses) {
            models.add((RoomModel)dc.eContainer());
        }
        for (EnumerationType et : enumClasses) {
            models.add((RoomModel)et.eContainer());
        }
        for (ProtocolClass pc : protocolClasses) {
            models.add((RoomModel)pc.eContainer());
        }
        for (ActorClass ac : actorClasses) {
            models.add((RoomModel)ac.eContainer());
        }
    }

    private void getInterfaceItemProtocolClasses(Set<ProtocolClass> protocolClasses, EList<? extends InterfaceItem> items) {
        for (InterfaceItem ii : items) {
            if (ii instanceof Port && ((Port)ii).getProtocol() instanceof ProtocolClass) {
                protocolClasses.add((ProtocolClass)((Port)ii).getProtocol());
                continue;
            }
            if (ii instanceof SAP) {
                protocolClasses.add(((SAP)ii).getProtocol());
                continue;
            }
            if (!(ii instanceof SPP)) continue;
            protocolClasses.add(((SPP)ii).getProtocol());
        }
    }

    private void getOperationDataClasses(Set<DataClass> dataClasses, Set<EnumerationType> enumClasses, EList<? extends Operation> operations) {
        for (Operation op : operations) {
            if (op.getReturnType() != null) {
                this.getClasses(op.getReturnType().getType(), dataClasses, enumClasses);
            }
            this.getVarDeclDataClasses(dataClasses, enumClasses, (Collection<VarDecl>)op.getArguments());
        }
    }

    private void getVarDeclDataClasses(Set<DataClass> dataClasses, Set<EnumerationType> enumClasses, Collection<VarDecl> decls) {
        for (VarDecl vd : decls) {
            this.getClasses(vd.getRefType().getType(), dataClasses, enumClasses);
        }
    }

    private void getMessageDataClasses(Set<DataClass> dataClasses, Set<EnumerationType> enumClasses, Collection<MessageData> decls) {
        for (MessageData vd : decls) {
            this.getClasses(vd.getRefType().getType(), dataClasses, enumClasses);
        }
    }

    private void getAttributeDataClasses(Set<DataClass> dataClasses, Set<EnumerationType> enumClasses, Collection<Attribute> attributes) {
        for (Attribute attr : attributes) {
            this.getClasses(attr.getType().getType(), dataClasses, enumClasses);
        }
    }

    private void getMessageDataClasses(Set<DataClass> dataClasses, Set<EnumerationType> enumClasses, EList<Message> messages) {
        for (Message message : messages) {
            if (message.getData() == null) continue;
            this.getClasses(message.getData().getRefType().getType(), dataClasses, enumClasses);
        }
    }

    private void getClasses(DataType type, Set<DataClass> dataClasses, Set<EnumerationType> enumClasses) {
        if (type instanceof DataClass) {
            dataClasses.add((DataClass)type);
        } else if (type instanceof EnumerationType) {
            enumClasses.add((EnumerationType)type);
        }
    }
}

