/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.eTMap.ETMapFactory;
import org.eclipse.etrice.core.etmap.eTMap.Mapping;
import org.eclipse.etrice.core.etmap.eTMap.MappingModel;
import org.eclipse.etrice.core.etmap.eTMap.SubSystemMapping;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalModel;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalSystem;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@FinalFieldsConstructor
public class TestInstanceCreator {
    private static final String ANNOTATION_TYPE_NAME = "TestInstance";
    @Extension
    private final RoomFactory _roomFactory = RoomFactory.eINSTANCE;
    @Extension
    private final ETMapFactory _eTMapFactory = ETMapFactory.eINSTANCE;
    private final ILogger logger;
    private final IDiagnostician diagnostician;

    public List<Resource> createInstancesAndMapping(Collection<URI> modelsURIs, ResourceSet rs) {
        boolean _notEquals;
        boolean _greaterThan;
        boolean _isEmpty;
        boolean _not;
        ArrayList roomModels = CollectionLiterals.newArrayList();
        ArrayList physModels = CollectionLiterals.newArrayList();
        Consumer<Resource> _function = it -> {
            Consumer<EObject> _function_1 = it_1 -> {
                boolean _matched = false;
                if (it_1 instanceof RoomModel) {
                    _matched = true;
                    boolean _contains = modelsURIs.contains(((RoomModel)it_1).eResource().getURI());
                    if (_contains) {
                        roomModels.add((RoomModel)it_1);
                    }
                }
                if (!_matched && it_1 instanceof PhysicalModel) {
                    _matched = true;
                    physModels.add((PhysicalModel)it_1);
                }
            };
            it.getContents().forEach(_function_1);
        };
        rs.getResources().forEach(_function);
        Functions.Function2 _function_1 = (list, model) -> {
            Functions.Function1 _function_2 = it -> this.hasTestAnnotation((StructureClass)it);
            Iterable _filter = IterableExtensions.filter((Iterable)model.getSubSystemClasses(), (Functions.Function1)_function_2);
            Iterables.addAll((Collection)list, (Iterable)_filter);
            return list;
        };
        ArrayList allTestSubSystems = (ArrayList)IterableExtensions.fold((Iterable)roomModels, (Object)CollectionLiterals.newArrayList(), (Functions.Function2)_function_1);
        ArrayList allAnnotatedClasses = CollectionLiterals.newArrayList((Object[])((StructureClass[])Conversions.unwrapArray((Object)allTestSubSystems, StructureClass.class)));
        ArrayList result = CollectionLiterals.newArrayList();
        SubSystemClass _createSubSystemClass = this._roomFactory.createSubSystemClass();
        Procedures.Procedure1 _function_2 = it -> it.setName("DerivedTestSubSystem");
        SubSystemClass derivedSubSystem = (SubSystemClass)ObjectExtensions.operator_doubleArrow((Object)_createSubSystemClass, (Procedures.Procedure1)_function_2);
        Functions.Function2 _function_3 = model -> {
            EList _actorRefs = derivedSubSystem.getActorRefs();
            Functions.Function1 _function_4 = it -> this.hasTestAnnotation((StructureClass)it);
            Functions.Function1 _function_5 = ac -> {
                ActorRef _xblockexpression = null;
                allAnnotatedClasses.add(ac);
                ActorRef _createActorRef = this._roomFactory.createActorRef();
                Procedures.Procedure1 _function_6 = it -> {
                    String _name = ac.getName();
                    String _plus = "ref_" + _name;
                    it.setName(_plus);
                    it.setType(ac);
                };
                _xblockexpression = (ActorRef)ObjectExtensions.operator_doubleArrow((Object)_createActorRef, (Procedures.Procedure1)_function_6);
                return _xblockexpression;
            };
            Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)model.getActorClasses(), (Functions.Function1)_function_4), (Functions.Function1)_function_5);
            Iterables.addAll((Collection)_actorRefs, (Iterable)_map);
        };
        roomModels.forEach(_function_3);
        boolean _isEmpty2 = derivedSubSystem.getActorRefs().isEmpty();
        boolean bl = _not = !_isEmpty2;
        if (_not) {
            allTestSubSystems.add(derivedSubSystem);
        }
        if (_isEmpty = allTestSubSystems.isEmpty()) {
            return result;
        }
        int _size = allAnnotatedClasses.size();
        boolean bl2 = _greaterThan = _size > 1;
        if (_greaterThan) {
            Consumer<StructureClass> _function_22 = roomCls -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("TestInstanceCreator: mapping failed, multiple test instances present");
                this.diagnostician.error(_builder.toString(), (EObject)roomCls, null);
            };
            allAnnotatedClasses.forEach(_function_22);
            return null;
        }
        _function_3 = (list, model) -> {
            EList _systems = model.getSystems();
            Iterables.addAll((Collection)list, (Iterable)_systems);
            return list;
        };
        List allPhysSystems = (List)IterableExtensions.fold((Iterable)physModels, (Object)CollectionLiterals.newArrayList(), (Functions.Function2)_function_3);
        int _size_1 = allPhysSystems.size();
        boolean bl3 = _notEquals = _size_1 != 1;
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("TestInstanceCreator: mapping failed, found ");
            int _size_2 = allPhysSystems.size();
            _builder.append((Object)_size_2);
            _builder.append(" physical systems");
            this.logger.logError(_builder.toString());
            return null;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("TestInstanceCreator: creating instance and mapping for ");
        String _name = ((StructureClass)IterableExtensions.head((Iterable)allAnnotatedClasses)).getName();
        _builder_1.append(_name);
        _builder_1.append(":");
        String _name_1 = ((StructureClass)IterableExtensions.head((Iterable)allAnnotatedClasses)).eClass().getName();
        _builder_1.append(_name_1);
        this.logger.logInfo(_builder_1.toString());
        PhysicalSystem physSystem = (PhysicalSystem)IterableExtensions.head((Iterable)allPhysSystems);
        SubSystemClass testSubSystem = (SubSystemClass)IterableExtensions.head((Iterable)allTestSubSystems);
        LogicalSystem _createLogicalSystem = this._roomFactory.createLogicalSystem();
        Procedures.Procedure1 _function_4 = it -> it.setName("DerivedTestSystem");
        LogicalSystem testSystem = (LogicalSystem)ObjectExtensions.operator_doubleArrow((Object)_createLogicalSystem, (Procedures.Procedure1)_function_4);
        EList _subSystems = testSystem.getSubSystems();
        SubSystemRef _createSubSystemRef = this._roomFactory.createSubSystemRef();
        Procedures.Procedure1 _function_5 = it -> {
            String _name_2 = testSubSystem.getName();
            String _plus = "ref_" + _name_2;
            it.setName(_plus);
            it.setType(testSubSystem);
        };
        SubSystemRef _doubleArrow = (SubSystemRef)ObjectExtensions.operator_doubleArrow((Object)_createSubSystemRef, (Procedures.Procedure1)_function_5);
        _subSystems.add((Object)_doubleArrow);
        RoomModel _createRoomModel = this._roomFactory.createRoomModel();
        Procedures.Procedure1 _function_6 = it -> {
            boolean _tripleEquals;
            it.setName("DerivedTestRoomModel");
            EList _systems = it.getSystems();
            _systems.add((Object)testSystem);
            Resource _eResource = testSubSystem.eResource();
            boolean bl = _tripleEquals = _eResource == null;
            if (_tripleEquals) {
                EList _subSystemClasses = it.getSubSystemClasses();
                _subSystemClasses.add((Object)testSubSystem);
            }
        };
        RoomModel testRoomModel = (RoomModel)ObjectExtensions.operator_doubleArrow((Object)_createRoomModel, (Procedures.Procedure1)_function_6);
        MappingModel _createMappingModel = this._eTMapFactory.createMappingModel();
        Procedures.Procedure1 _function_7 = it -> {
            it.setName("DerivedTestMappingModel");
            EList _mappings = it.getMappings();
            Mapping _createMapping = this._eTMapFactory.createMapping();
            Procedures.Procedure1 _function_8 = it_1 -> {
                it_1.setLogicalSys(testSystem);
                it_1.setPhysicalSys(physSystem);
                EList _subsysMappings = it_1.getSubsysMappings();
                Functions.Function1 _function_9 = subSysRef -> {
                    SubSystemMapping _createSubSystemMapping = this._eTMapFactory.createSubSystemMapping();
                    Procedures.Procedure1 _function_10 = it_2 -> {
                        it_2.setLogicalSubSys(subSysRef);
                        it_2.setNode((NodeRef)IterableExtensions.head((Iterable)physSystem.getNodeRefs()));
                    };
                    return (SubSystemMapping)ObjectExtensions.operator_doubleArrow((Object)_createSubSystemMapping, (Procedures.Procedure1)_function_10);
                };
                List _map = ListExtensions.map((List)testSystem.getSubSystems(), (Functions.Function1)_function_9);
                Iterables.addAll((Collection)_subsysMappings, (Iterable)_map);
            };
            Mapping _doubleArrow_1 = (Mapping)ObjectExtensions.operator_doubleArrow((Object)_createMapping, (Procedures.Procedure1)_function_8);
            _mappings.add((Object)_doubleArrow_1);
        };
        MappingModel testMappingModel = (MappingModel)ObjectExtensions.operator_doubleArrow((Object)_createMappingModel, (Procedures.Procedure1)_function_7);
        Resource _xifexpression = null;
        Resource _eResource = testSubSystem.eResource();
        boolean _tripleNotEquals = _eResource != null;
        _xifexpression = _tripleNotEquals ? testSubSystem.eResource() : ((StructureClass)IterableExtensions.head((Iterable)allAnnotatedClasses)).eResource();
        Resource existingResource = _xifexpression;
        URI uriPath = existingResource.getURI().trimFileExtension().trimSegments(1);
        Resource res = rs.createResource(uriPath.appendSegment("DerivedTestMappingModel").appendFileExtension("etmap"));
        EList _contents = res.getContents();
        _contents.add((Object)testMappingModel);
        result.add(res);
        res = rs.createResource(uriPath.appendSegment("DerivedTestRoomModel").appendFileExtension("room"));
        EList _contents_1 = res.getContents();
        _contents_1.add((Object)testRoomModel);
        result.add(res);
        return result;
    }

    protected boolean hasTestAnnotation(StructureClass cls) {
        Functions.Function1 _function = it -> {
            String _name = it.getType().getName();
            return Objects.equal((Object)_name, (Object)ANNOTATION_TYPE_NAME);
        };
        return IterableExtensions.exists((Iterable)cls.getAnnotations(), (Functions.Function1)_function);
    }

    public TestInstanceCreator(ILogger logger, IDiagnostician diagnostician) {
        this.logger = logger;
        this.diagnostician = diagnostician;
    }
}

