/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;

public class FSMNewNamingUtil {
    @Inject
    private FSMHelpers fsmHelpers;

    public String getUniqueName(String prefix, StateGraph sg) {
        Set<String> names = this.getAllNamesFromCompleteHierarchy(sg);
        for (int i = 0; i < 1000; ++i) {
            String name = prefix + i;
            if (names.contains(name)) continue;
            return name;
        }
        return "not_unique";
    }

    protected Set<String> getAllNamesFromCompleteHierarchy(StateGraph sg) {
        HashSet visitedGraphs = Sets.newHashSet((Object[])new StateGraph[]{sg});
        HashSet leafGraphs = Sets.newHashSet((Object[])new StateGraph[]{sg});
        LinkedList stack = Lists.newLinkedList();
        stack.push(sg);
        while (!stack.isEmpty()) {
            StateGraph baseGraph = (StateGraph)stack.pop();
            EObject baseContainer = baseGraph.eContainer();
            assert (baseContainer instanceof ModelComponent || baseContainer instanceof State) : "unexpected container for StateGraph";
            Collection usages = EcoreUtil.UsageCrossReferencer.find((EObject)baseContainer, (ResourceSet)sg.eResource().getResourceSet());
            for (EStructuralFeature.Setting setting : usages) {
                StateGraph refinedGraph = null;
                if (setting.getEStructuralFeature() == FSMPackage.Literals.MODEL_COMPONENT__BASE) {
                    refinedGraph = ((ModelComponent)setting.getEObject()).getStateMachine();
                } else if (setting.getEStructuralFeature() == FSMPackage.Literals.REFINED_STATE__TARGET) {
                    refinedGraph = ((RefinedState)setting.getEObject()).getSubgraph();
                }
                if (refinedGraph == null || !visitedGraphs.add(refinedGraph)) continue;
                stack.push(refinedGraph);
                leafGraphs.add(refinedGraph);
                leafGraphs.remove(baseGraph);
            }
        }
        HashSet result = Sets.newHashSet();
        for (StateGraph graph : leafGraphs) {
            result.addAll(this.fsmHelpers.getAllNames(graph));
        }
        return result;
    }
}

