/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReferenceType implements Enumerator
{
    FIXED(0, "FIXED", "fixed"),
    OPTIONAL(1, "OPTIONAL", "optional");

    public static final int FIXED_VALUE = 0;
    public static final int OPTIONAL_VALUE = 1;
    private static final ReferenceType[] VALUES_ARRAY;
    public static final List<ReferenceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ReferenceType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ReferenceType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ReferenceType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ReferenceType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ReferenceType get(int value) {
        switch (value) {
            case 0: {
                return FIXED;
            }
            case 1: {
                return OPTIONAL;
            }
        }
        return null;
    }

    private ReferenceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ReferenceType[]{FIXED, OPTIONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

