/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.base.util.ImportHelpers;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class InterfaceContractHelpers {
    public static final String InterfaceContract_NAME = "InterfaceContract";
    public static final String ContractClass_KEY = "definedBy";
    public static final String InterfaceContractDefinition_NAME = "InterfaceContractDefinition";
    public static final String Protocol_KEY = "protocol";
    public static final String GeneratedMonitorName_KEY = "generatedMonitorName";
    @Inject
    private RoomHelpers roomHelpers;
    @Inject
    private ImportHelpers importHelpers;
    @Inject
    private IQualifiedNameConverter fqnConverter;
    @Inject
    private IQualifiedNameProvider fqnProvider;

    public boolean hasContract(GeneralProtocolClass pc) {
        return this.roomHelpers.isAnnotationPresent((List)pc.getAnnotations(), InterfaceContract_NAME);
    }

    public boolean isContract(ActorClass ac) {
        return this.roomHelpers.isAnnotationPresent((List)ac.getAnnotations(), InterfaceContractDefinition_NAME);
    }

    public ActorClass getInterfaceContractActorClass(ProtocolClass pc) {
        boolean _not;
        String name = this.roomHelpers.getAttribute((List)pc.getAnnotations(), InterfaceContract_NAME, ContractClass_KEY);
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)name);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            EObject _eContainer = pc.eContainer();
            EObject match = this.findClassForName(name, RoomPackage.Literals.ACTOR_CLASS, (RoomModel)_eContainer);
            EObject _xifexpression = null;
            _xifexpression = match != null && match.eIsProxy() ? EcoreUtil.resolve((EObject)match, (ResourceSet)pc.eResource().getResourceSet()) : match;
            EObject resolved = _xifexpression;
            if (resolved instanceof ActorClass) {
                return (ActorClass)resolved;
            }
        }
        return null;
    }

    public ProtocolClass getContractProtocol(ActorClass ac) {
        boolean _not;
        String name = this.roomHelpers.getAttribute((List)ac.getAnnotations(), InterfaceContractDefinition_NAME, Protocol_KEY);
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)name);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            EObject _eContainer = ac.eContainer();
            EObject _findClassForName = this.findClassForName(name, RoomPackage.Literals.PROTOCOL_CLASS, (RoomModel)_eContainer);
            ProtocolClass match = (ProtocolClass)_findClassForName;
            ProtocolClass _xifexpression = null;
            _xifexpression = match != null && match.eIsProxy() ? EcoreUtil.resolve((EObject)match, (ResourceSet)ac.eResource().getResourceSet()) : match;
            ProtocolClass resolved = _xifexpression;
            if (resolved instanceof ProtocolClass) {
                return resolved;
            }
        }
        return null;
    }

    public String getGeneratedMonitorName(ActorClass ac) {
        boolean _not;
        String userName = this.roomHelpers.getAttribute((List)ac.getAnnotations(), InterfaceContractDefinition_NAME, GeneratedMonitorName_KEY);
        String _xifexpression = null;
        boolean _isNullOrEmpty = Strings.isNullOrEmpty((String)userName);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _xifexpression = userName;
        } else {
            String _name = ac.getName();
            _xifexpression = _name + "_GeneratedMontior";
        }
        return _xifexpression;
    }

    public Pair<List<Port>, List<Port>> getContractPorts(ActorClass ac, ProtocolClass contractProtocol) {
        Pair _xblockexpression = null;
        List<Port> allPorts = this.roomHelpers.getAllEndPorts(ac);
        Functions.Function1 _function = it -> Objects.equal((Object)it.getProtocol(), (Object)contractProtocol) && !it.isConjugated();
        ArrayList regularPorts = CollectionLiterals.newArrayList((Object[])((Port[])Conversions.unwrapArray((Object)IterableExtensions.filter(allPorts, (Functions.Function1)_function), Port.class)));
        Functions.Function1 _function_1 = it -> Objects.equal((Object)it.getProtocol(), (Object)contractProtocol) && it.isConjugated();
        ArrayList conjugatedPorts = CollectionLiterals.newArrayList((Object[])((Port[])Conversions.unwrapArray((Object)IterableExtensions.filter(allPorts, (Functions.Function1)_function_1), Port.class)));
        _xblockexpression = Pair.of((Object)regularPorts, (Object)conjugatedPorts);
        return _xblockexpression;
    }

    private EObject findClassForName(String name, EClass type, RoomModel currentModel) {
        EObject _xblockexpression = null;
        QualifiedName fqn = this.fqnConverter.toQualifiedName(name);
        QualifiedName modelFQN = this.fqnProvider.getFullyQualifiedName((EObject)currentModel);
        EObject _xifexpression = null;
        if (fqn.getSegmentCount() == 1 || fqn.startsWith(modelFQN)) {
            Functions.Function1 _function = it -> type.isSuperTypeOf(it.eClass());
            Functions.Function1 _function_1 = it -> {
                String _name = it.getName();
                String _lastSegment = fqn.getLastSegment();
                return Objects.equal((Object)_name, (Object)_lastSegment);
            };
            _xifexpression = (EObject)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IterableExtensions.filter((Iterable)currentModel.eContents(), (Functions.Function1)_function), RoomClass.class), (Functions.Function1)_function_1);
        } else {
            boolean _tripleNotEquals;
            EObject _xifexpression_1 = null;
            Resource _eResource = currentModel.eResource();
            boolean bl = _tripleNotEquals = _eResource != null;
            if (_tripleNotEquals) {
                IEObjectDescription _singleElement = this.importHelpers.getVisibleScope(currentModel.eResource(), type).getSingleElement(fqn);
                EObject _eObjectOrProxy = null;
                if (_singleElement != null) {
                    _eObjectOrProxy = _singleElement.getEObjectOrProxy();
                }
                _xifexpression_1 = _eObjectOrProxy;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

