/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.config;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.ConfigStandaloneSetup;
import org.eclipse.etrice.core.common.base.BooleanLiteral;
import org.eclipse.etrice.core.common.base.IntLiteral;
import org.eclipse.etrice.core.common.base.Literal;
import org.eclipse.etrice.core.common.base.NumberLiteral;
import org.eclipse.etrice.core.common.base.RealLiteral;
import org.eclipse.etrice.core.common.base.StringLiteral;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.ConfigValue;
import org.eclipse.etrice.core.config.ConfigValueArray;
import org.eclipse.etrice.core.config.DynamicConfig;
import org.eclipse.etrice.core.config.EnumConfigValue;
import org.eclipse.etrice.core.config.LiteralConfigValue;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.config.util.DataConfigurationHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DataConfiguration
implements IDataConfiguration {
    @Inject
    @Extension
    protected DataConfigurationHelper _dataConfigurationHelper;
    @Inject
    protected ILogger logger;
    @Inject
    protected ImportUriResolver uriResolver;

    public void doSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ConfigStandaloneSetup.doSetup();
        }
    }

    public boolean setResources(ResourceSet resource, ILogger logger) {
        return this._dataConfigurationHelper.setConfigModels(resource, logger);
    }

    public String getAttrClassConfigValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig _attrClassConfig = this.getAttrClassConfig(actor, path);
        ConfigValueArray _value = null;
        if (_attrClassConfig != null) {
            _value = _attrClassConfig.getValue();
        }
        String _stringExpr = null;
        if (_value != null) {
            _stringExpr = this.toStringExpr(_value);
        }
        return _stringExpr;
    }

    public String getAttrClassConfigMaxValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig _attrClassConfig = this.getAttrClassConfig(actor, path);
        NumberLiteral _max = null;
        if (_attrClassConfig != null) {
            _max = _attrClassConfig.getMax();
        }
        String _stringExpr = null;
        if (_max != null) {
            _stringExpr = this.toStringExpr((Literal)_max);
        }
        return _stringExpr;
    }

    public String getAttrClassConfigMinValue(ActorClass actor, List<Attribute> path) {
        AttrClassConfig _attrClassConfig = this.getAttrClassConfig(actor, path);
        NumberLiteral _min = null;
        if (_attrClassConfig != null) {
            _min = _attrClassConfig.getMin();
        }
        String _stringExpr = null;
        if (_min != null) {
            _stringExpr = this.toStringExpr((Literal)_min);
        }
        return _stringExpr;
    }

    private AttrClassConfig getAttrClassConfig(ActorClass actor, List<Attribute> path) {
        AttrClassConfig _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/");
        String _name = actor.getName();
        _builder.append(_name);
        _builder.append("/");
        String _stringPath = this.toStringPath(path);
        _builder.append(_stringPath);
        String id = _builder.toString();
        _xblockexpression = this._dataConfigurationHelper.actorClassAttrMap.get(id);
        return _xblockexpression;
    }

    public String getAttrClassConfigValue(ProtocolClass pc, boolean regular, List<Attribute> path) {
        String _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/");
        String _name = pc.getName();
        _builder.append(_name);
        _builder.append("/");
        if (regular) {
            _builder.append("regular");
        } else {
            _builder.append("conjugated");
        }
        _builder.append("/");
        String _stringPath = this.toStringPath(path);
        _builder.append(_stringPath);
        String id = _builder.toString();
        AttrClassConfig _get = this._dataConfigurationHelper.protocolClassAttrMap.get(id);
        ConfigValueArray _value = null;
        if (_get != null) {
            _value = _get.getValue();
        }
        String _stringExpr = null;
        if (_value != null) {
            _stringExpr = this.toStringExpr(_value);
        }
        _xblockexpression = _stringExpr;
        return _xblockexpression;
    }

    private String toStringPath(List<Attribute> path) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (Attribute a : path) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"/", "");
            }
            String _name = a.getName();
            _builder.append(_name);
        }
        return _builder.toString();
    }

    public String getAttrInstanceConfigValue(ActorInstance ai, List<Attribute> path) {
        String _xblockexpression = null;
        String _path = ai.getPath();
        String _plus = _path + "/";
        String _stringPath = this.toStringPath(path);
        String id = _plus + _stringPath;
        AttrInstanceConfig _get = this._dataConfigurationHelper.actorInstanceAttrMap.get(id);
        ConfigValueArray _value = null;
        if (_get != null) {
            _value = _get.getValue();
        }
        String _stringExpr = null;
        if (_value != null) {
            _stringExpr = this.toStringExpr(_value);
        }
        _xblockexpression = _stringExpr;
        return _xblockexpression;
    }

    public String getAttrInstanceConfigValue(InterfaceItemInstance item, List<Attribute> path) {
        String _path = item.getPath();
        String _plus = _path + "/";
        String _stringPath = this.toStringPath(path);
        String _plus_1 = _plus + _stringPath;
        AttrInstanceConfig _get = this._dataConfigurationHelper.actorInstanceAttrMap.get(_plus_1);
        ConfigValueArray _value = null;
        if (_get != null) {
            _value = _get.getValue();
        }
        String _stringExpr = null;
        if (_value != null) {
            _stringExpr = this.toStringExpr(_value);
        }
        return _stringExpr;
    }

    public long getPollingTimerUser(SubSystemInstance subsystem) {
        long _xblockexpression = 0L;
        SubSystemConfig _config = this.getConfig(subsystem);
        DynamicConfig _dynConfig = null;
        if (_config != null) {
            _dynConfig = _config.getDynConfig();
        }
        DynamicConfig dynConf = _dynConfig;
        long _xifexpression = 0L;
        _xifexpression = dynConf == null ? 0L : dynConf.getPolling();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getUserCode1(SubSystemInstance subsystem) {
        boolean _tripleNotEquals;
        SubSystemConfig _config = this.getConfig(subsystem);
        DynamicConfig _dynConfig = null;
        if (_config != null) {
            _dynConfig = _config.getDynConfig();
        }
        DynamicConfig dynConfig = _dynConfig;
        String _xifexpression = null;
        String _filePath = null;
        if (dynConfig != null) {
            _filePath = dynConfig.getFilePath();
        }
        boolean bl = _tripleNotEquals = _filePath != null;
        if (_tripleNotEquals) {
            _xifexpression = "import org.eclipse.etrice.runtime.java.config.ConfigSourceFile;";
        } else {
            String _userCode1 = null;
            if (dynConfig != null) {
                _userCode1 = dynConfig.getUserCode1();
            }
            _xifexpression = _userCode1;
        }
        return _xifexpression;
    }

    public String getUserCode2(SubSystemInstance subsystem) {
        boolean _tripleNotEquals;
        SubSystemConfig _config = this.getConfig(subsystem);
        DynamicConfig _dynConfig = null;
        if (_config != null) {
            _dynConfig = _config.getDynConfig();
        }
        DynamicConfig dynConfig = _dynConfig;
        String _xifexpression = null;
        String _filePath = null;
        if (dynConfig != null) {
            _filePath = dynConfig.getFilePath();
        }
        boolean bl = _tripleNotEquals = _filePath != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("new ConfigSourceFile(\"");
            String _filePath_1 = dynConfig.getFilePath();
            _builder.append(_filePath_1);
            _builder.append("\")");
            _xifexpression = _builder.toString();
        } else {
            String _userCode2 = null;
            if (dynConfig != null) {
                _userCode2 = dynConfig.getUserCode2();
            }
            _xifexpression = _userCode2;
        }
        return _xifexpression;
    }

    public List<Attribute> getDynConfigReadAttributes(ActorInstance ai) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        List<AttrInstanceConfig> configs = this._dataConfigurationHelper.dynActorInstanceAttrMap.get(ai.getPath());
        if (configs != null) {
            Consumer<AttrInstanceConfig> _function = c -> {
                boolean _isReadOnly = c.isReadOnly();
                if (_isReadOnly) {
                    result.add(c.getAttribute());
                }
            };
            configs.forEach(_function);
        }
        return result;
    }

    public List<Attribute> getDynConfigWriteAttributes(ActorInstance ai) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        List<AttrInstanceConfig> configs = this._dataConfigurationHelper.dynActorInstanceAttrMap.get(ai.getPath());
        if (configs != null) {
            Consumer<AttrInstanceConfig> _function = c -> {
                boolean _not;
                boolean _isReadOnly = c.isReadOnly();
                boolean bl = _not = !_isReadOnly;
                if (_not) {
                    result.add(c.getAttribute());
                }
            };
            configs.forEach(_function);
        }
        return result;
    }

    public boolean hasVariableService(SubSystemInstance subsystem) {
        SubSystemConfig _config = this.getConfig(subsystem);
        DynamicConfig _dynConfig = null;
        if (_config != null) {
            _dynConfig = _config.getDynConfig();
        }
        return _dynConfig != null;
    }

    private String toStringExpr(ConfigValueArray literal) {
        StringConcatenation _builder = new StringConcatenation();
        EList _values = literal.getValues();
        boolean _hasElements = false;
        for (ConfigValue l : _values) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            String _stringExpr = this.toStringExpr(l);
            _builder.append(_stringExpr);
        }
        return _builder.toString();
    }

    private String toStringExpr(ConfigValue configValue) {
        String _switchResult = null;
        boolean _matched = false;
        if (configValue instanceof LiteralConfigValue) {
            _matched = true;
            _switchResult = this.toStringExpr(((LiteralConfigValue)configValue).getValue());
        }
        if (!_matched && configValue instanceof EnumConfigValue) {
            _matched = true;
            _switchResult = ((EnumConfigValue)configValue).getValue().getFullName();
        }
        return _switchResult;
    }

    private String toStringExpr(Literal literal) {
        String _switchResult = null;
        boolean _matched = false;
        if (literal instanceof BooleanLiteral) {
            _matched = true;
            _switchResult = Boolean.valueOf(((BooleanLiteral)literal).isIsTrue()).toString();
        }
        if (!_matched && literal instanceof IntLiteral) {
            _matched = true;
            _switchResult = Long.valueOf(((IntLiteral)literal).getValue()).toString();
        }
        if (!_matched && literal instanceof RealLiteral) {
            _matched = true;
            _switchResult = Double.valueOf(((RealLiteral)literal).getValue()).toString();
        }
        if (!_matched && literal instanceof StringLiteral) {
            _matched = true;
            _switchResult = ((StringLiteral)literal).getValue().toString();
        }
        return _switchResult;
    }

    private SubSystemConfig getConfig(SubSystemInstance cc) {
        return this._dataConfigurationHelper.subSystemConfigMap.get(cc.getPath());
    }

    public List<Attribute> getDynConfigReadAttributes(ActorClass actor) {
        HashSet result = new HashSet();
        List<AttrInstanceConfig> configs = this._dataConfigurationHelper.dynActorClassAttrMap.get(actor);
        if (configs != null) {
            Consumer<AttrInstanceConfig> _function = c -> {
                boolean _isReadOnly = c.isReadOnly();
                if (_isReadOnly) {
                    result.add(c.getAttribute());
                }
            };
            configs.forEach(_function);
        }
        return IterableExtensions.toList(result);
    }

    public List<Attribute> getDynConfigWriteAttributes(ActorClass actor) {
        HashSet result = new HashSet();
        List<AttrInstanceConfig> configs = this._dataConfigurationHelper.dynActorClassAttrMap.get(actor);
        if (configs != null) {
            Consumer<AttrInstanceConfig> _function = c -> {
                boolean _not;
                boolean _isReadOnly = c.isReadOnly();
                boolean bl = _not = !_isReadOnly;
                if (_not) {
                    result.add(c.getAttribute());
                }
            };
            configs.forEach(_function);
        }
        return IterableExtensions.toList(result);
    }
}

