/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.cpp.gen.StateMachineGen;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    protected IGeneratorFileIO fileIO;
    @Inject
    @Extension
    protected CppExtensions _cppExtensions;
    @Inject
    @Extension
    protected RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected ProcedureHelpers _procedureHelpers;
    @Inject
    protected Initialization initHelper;
    @Inject
    @Extension
    protected StateMachineGen _stateMachineGen;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public void doGenerate(Root root) {
        HashMap ac2wired = CollectionLiterals.newHashMap();
        Consumer<WiredActorClass> _function = it -> ac2wired.put(it.getActorClass(), it);
        Iterables.filter((Iterable)root.getWiredInstances(), WiredActorClass.class).forEach(_function);
        Functions.Function1 _function_1 = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Functions.Function1 _function_2 = it -> root.getExpandedActorClass(it);
        Consumer<ExpandedActorClass> _function_3 = xpac -> {
            WiredActorClass wired = (WiredActorClass)ac2wired.get(xpac.getActorClass());
            boolean manualBehavior = this._roomHelpers.isBehaviorAnnotationPresent(xpac.getActorClass(), "BehaviorManual");
            String path = this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
            String _xifexpression = null;
            _xifexpression = manualBehavior ? "Abstract" : "";
            String file = _xifexpression;
            String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName((RoomClass)xpac.getActorClass());
            String _plus = path + file + _cppHeaderFileName;
            this.fileIO.generateFile("generating ActorClass declaration", _plus, this.generateHeaderFile(root, (ExpandedActorClass)xpac, wired, manualBehavior));
            String _cppSourceFileName = this._cppExtensions.getCppSourceFileName((RoomClass)xpac.getActorClass());
            String _plus_1 = path + file + _cppSourceFileName;
            this.fileIO.generateFile("generating ActorClass implementation", _plus_1, this.generateSourceFile(root, (ExpandedActorClass)xpac, wired, manualBehavior));
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)root.getActorClasses(), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
    }

    protected CharSequence generateHeaderFile(Root root, ExpandedActorClass xpac, WiredActorClass wired, boolean manualBehavior) {
        boolean _tripleEquals;
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        String _xifexpression = null;
        if (manualBehavior) {
            String _name = ac.getName();
            _xifexpression = "Abstract" + _name;
        } else {
            _xifexpression = ac.getName();
        }
        String clsname = _xifexpression;
        String _elvis = null;
        ActorClass _actorBase = ac.getActorBase();
        String _name_1 = null;
        if (_actorBase != null) {
            _name_1 = _actorBase.getName();
        }
        _elvis = _name_1 != null ? _name_1 : "etRuntime::ActorClassBase";
        String rtBaseClassName = _elvis;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of ActorClass ");
        _builder.append(clsname, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin((RoomClass)ac, "");
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/etDatatypesCpp.hpp\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/IRTObject.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/PortBase.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/ReplicatedActorClassBase.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/SubSystemClassBase.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/Address.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/IMessageReceiver.h\"");
        _builder.newLine();
        _builder.append("#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.newLine();
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : _referencedProtocolClasses) {
            _builder.append("#include \"");
            String _path = this._roomExtensions.getPath((RoomClass)pc);
            _builder.append(_path);
            String _name_2 = pc.getName();
            _builder.append(_name_2);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)ac);
        for (DataClass dc : _referencedDataClasses) {
            _builder.append("#include \"");
            String _path_1 = this._roomExtensions.getPath((RoomClass)dc);
            _builder.append(_path_1);
            String _name_3 = dc.getName();
            _builder.append(_name_3);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        ActorClass _actorBase_1 = ac.getActorBase();
        boolean bl = _tripleEquals = _actorBase_1 == null;
        if (_tripleEquals) {
            _builder.append("#include \"common/modelbase/ActorClassBase.h\"");
            _builder.newLine();
        } else {
            _builder.append("#include \"");
            String _path_2 = this._roomExtensions.getPath((RoomClass)ac.getActorBase());
            _builder.append(_path_2);
            String _name_4 = ac.getActorBase().getName();
            _builder.append(_name_4);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList _actorRefs = ac.getActorRefs();
        for (ActorRef ar : _actorRefs) {
            _builder.append("#include \"");
            String _actorIncludePath = this._cppExtensions.getActorIncludePath(ar.getType());
            _builder.append(_actorIncludePath);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(ac.getUserCode1());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)ac);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        _builder.append(clsname);
        _builder.append(" : public ");
        _builder.append(rtBaseClassName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--------------------- ports");
        _builder.newLine();
        List _endPorts = this._roomHelpers.getEndPorts(ac);
        for (Port ep : _endPorts) {
            _builder.append("\t\t");
            String _portClassName = this._roomExtensions.getPortClassName((RoomElement)ep);
            _builder.append(_portClassName, "\t\t");
            _builder.append(" ");
            String _name_5 = ep.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--------------------- sub actors");
        _builder.newLine();
        EList _actorRefs_1 = ac.getActorRefs();
        for (ActorRef sub : _actorRefs_1) {
            boolean _greaterThan;
            int _multiplicity = sub.getMultiplicity();
            boolean bl2 = _greaterThan = _multiplicity > 1;
            if (_greaterThan) {
                _builder.append("\t\t");
                _builder.append("Replicated");
                String _implementationClassName = this._cppExtensions.getImplementationClassName(sub.getType());
                _builder.append(_implementationClassName, "\t\t");
                _builder.append(" ");
                String _name_6 = sub.getName();
                _builder.append(_name_6, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t\t");
            String _implementationClassName_1 = this._cppExtensions.getImplementationClassName(sub.getType());
            _builder.append(_implementationClassName_1, "\t\t");
            _builder.append(" ");
            String _name_7 = sub.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--------------------- saps");
        _builder.newLine();
        EList _serviceAccessPoints = ac.getServiceAccessPoints();
        for (SAP sap : _serviceAccessPoints) {
            _builder.append("\t\t");
            String _portClassName_1 = this._roomExtensions.getPortClassName((RoomElement)sap);
            _builder.append(_portClassName_1, "\t\t");
            _builder.append(" ");
            String _name_8 = sap.getName();
            _builder.append(_name_8, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--------------------- services");
        _builder.newLine();
        EList _serviceImplementations = ac.getServiceImplementations();
        for (ServiceImplementation svc : _serviceImplementations) {
            _builder.append("\t\t");
            String _portClassName_2 = this._roomExtensions.getPortClassName((RoomElement)svc);
            _builder.append(_portClassName_2, "\t\t");
            _builder.append(" ");
            String _name_9 = svc.getSpp().getName();
            _builder.append(_name_9, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--------------------- interface item IDs");
        _builder.newLine();
        _builder.append("\t\t");
        String _genInterfaceItemConstants = this.genInterfaceItemConstants(xpac);
        _builder.append(_genInterfaceItemConstants, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _attributes = this._procedureHelpers.attributes((List)ac.getAttributes());
        _builder.append((Object)_attributes, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _operationsDeclaration = this._procedureHelpers.operationsDeclaration((List)ac.getOperations(), ac.getName());
        _builder.append((Object)_operationsDeclaration, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--------------------- construction");
        _builder.newLine();
        _builder.append("\t\t");
        String _name_10 = ac.getName();
        _builder.append(_name_10, "\t\t");
        _builder.append("(etRuntime::IRTObject* parent, const String& name);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("void initialize(void);");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("\t\t");
            _builder.append("void setProbesActive(bool recursive, bool active);");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--------------------- port getters");
        _builder.newLine();
        _builder.append("\t\t");
        Functions.Function1 _function = it -> {
            String _portClassName_3 = this._roomExtensions.getPortClassName((RoomElement)it);
            String _plus = _portClassName_3 + "&";
            return this._procedureHelpers.getterImplementation(_plus, it.getName(), clsname);
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)this._roomHelpers.getEndPorts(ac), (Functions.Function1)_function), (CharSequence)this._roomExtensions.NEWLINE);
        _builder.append(_join, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        Functions.Function1 _function_1 = it -> {
            String _portClassName_3 = this._roomExtensions.getPortClassName((RoomElement)it);
            String _plus = _portClassName_3 + "&";
            return this._procedureHelpers.getterImplementation(_plus, it.getName(), clsname);
        };
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map((List)ac.getServiceAccessPoints(), (Functions.Function1)_function_1), (CharSequence)this._roomExtensions.NEWLINE);
        _builder.append(_join_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        Functions.Function1 _function_2 = it -> {
            String _portClassName_3 = this._roomExtensions.getPortClassName((RoomElement)it);
            String _plus = _portClassName_3 + "&";
            return this._procedureHelpers.getterImplementation(_plus, it.getSpp().getName(), clsname);
        };
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map((List)ac.getServiceImplementations(), (Functions.Function1)_function_2), (CharSequence)this._roomExtensions.NEWLINE);
        _builder.append(_join_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//--------------------- lifecycle functions");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("virtual void destroy();");
        _builder.newLine();
        _builder.newLine();
        boolean _hasNonEmptyStateMachine = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (_hasNonEmptyStateMachine) {
            _builder.append("\t\t");
            CharSequence _genStateMachineConstants = this._stateMachineGen.genStateMachineConstants(xpac.getGraphContainer());
            _builder.append((Object)_genStateMachineConstants, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t\t");
            CharSequence _genStateMachineMethods = this._stateMachineGen.genStateMachineMethods(xpac.getGraphContainer(), false);
            _builder.append((Object)_genStateMachineMethods, "\t\t");
            _builder.newLineIfNotEmpty();
            ComponentCommunicationType _commType = ac.getCommType();
            boolean _equals = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.DATA_DRIVEN);
            if (_equals) {
                _builder.append("\t\t");
                _builder.append("void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* generic_data);");
                _builder.newLine();
            }
            if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
                _builder.append("\t\t");
                _builder.append("virtual void receive(const etRuntime::Message* msg);");
                _builder.newLine();
            }
        } else {
            boolean _isEmpty = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
            if (_isEmpty) {
                _builder.append("\t\t");
                _builder.append("//--------------------- no state machine");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("virtual void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data);");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("virtual void executeInitTransition() {}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(ac.getUserCode2());
        _builder.append((Object)_userCode_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class Replicated");
        _builder.append(clsname);
        _builder.append(" : public ReplicatedActorClassBase {");
        _builder.newLineIfNotEmpty();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Replicated");
        _builder.append(clsname, "\t");
        _builder.append("(IRTObject* parent, const String& name) :");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("ReplicatedActorClassBase(parent, name) {}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ActorClassBase* createActor(IRTObject* parent, const String& name) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return new ");
        _builder.append(clsname, "\t\t");
        _builder.append("(parent, name);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)ac);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd((RoomClass)ac, "");
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateConstructorInitalizerList(ActorClass ac) {
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        StringConcatenation _builder = new StringConcatenation();
        String _elvis = null;
        ActorClass _actorBase = ac.getActorBase();
        String _name = null;
        if (_actorBase != null) {
            _name = _actorBase.getName();
        }
        _elvis = _name != null ? _name : "ActorClassBase";
        _builder.append(_elvis);
        _builder.append("(parent, name)");
        initList.add(_builder.toString());
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_1 = it.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(this, \"");
            String _name_2 = it.getName();
            _builder_1.append(_name_2);
            _builder_1.append("\", IFITEM_");
            String _name_3 = it.getName();
            _builder_1.append(_name_3);
            _builder_1.append(")");
            return _builder_1.toString();
        };
        List _map = ListExtensions.map((List)this._roomHelpers.getEndPorts(ac), (Functions.Function1)_function);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_1 = it.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(this, \"");
            String _name_2 = it.getName();
            _builder_1.append(_name_2);
            _builder_1.append("\")");
            return _builder_1.toString();
        };
        List _map_1 = ListExtensions.map((List)ac.getActorRefs(), (Functions.Function1)_function_1);
        Iterables.addAll((Collection)initList, (Iterable)_map_1);
        Functions.Function1 _function_2 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_1 = it.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(this, \"");
            String _name_2 = it.getName();
            _builder_1.append(_name_2);
            _builder_1.append("\", IFITEM_");
            String _name_3 = it.getName();
            _builder_1.append(_name_3);
            _builder_1.append(")");
            return _builder_1.toString();
        };
        List _map_2 = ListExtensions.map((List)ac.getServiceAccessPoints(), (Functions.Function1)_function_2);
        Iterables.addAll((Collection)initList, (Iterable)_map_2);
        Functions.Function1 _function_3 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_1 = it.getSpp().getName();
            _builder_1.append(_name_1);
            _builder_1.append("(this, \"");
            String _name_2 = it.getSpp().getName();
            _builder_1.append(_name_2);
            _builder_1.append("\", IFITEM_");
            String _name_3 = it.getSpp().getName();
            _builder_1.append(_name_3);
            _builder_1.append(")");
            return _builder_1.toString();
        };
        List _map_3 = ListExtensions.map((List)ac.getServiceImplementations(), (Functions.Function1)_function_3);
        Iterables.addAll((Collection)initList, (Iterable)_map_3);
        Functions.Function1 _function_4 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_1 = it.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(");
            String _initializerListValue = initHelper.getInitializerListValue((Attribute)it);
            _builder_1.append(_initializerListValue);
            _builder_1.append(")");
            return _builder_1.toString();
        };
        List _map_4 = ListExtensions.map((List)ac.getAttributes(), (Functions.Function1)_function_4);
        Iterables.addAll((Collection)initList, (Iterable)_map_4);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    protected CharSequence generateSourceFile(Root root, ExpandedActorClass xpac, WiredActorClass wired, boolean manualBehavior) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        String _xifexpression = null;
        if (manualBehavior) {
            String _name = ac.getName();
            _xifexpression = "Abstract" + _name;
        } else {
            _xifexpression = ac.getName();
        }
        String clsname = _xifexpression;
        String _elvis = null;
        ActorClass _actorBase = ac.getActorBase();
        String _name_1 = null;
        if (_actorBase != null) {
            _name_1 = _actorBase.getName();
        }
        _elvis = _name_1 != null ? _name_1 : "ActorClassBase";
        String rtBaseClassName = _elvis;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of ActorClass ");
        String _name_2 = ac.getName();
        _builder.append(_name_2, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName((RoomClass)ac);
        _builder.append(_cppHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/messaging/RTObject.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/RTServices.h\"");
        _builder.newLine();
        _builder.append("#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append("#include \"common/debugging/MSCFunctionObject.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)ac);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(ac.getUserCode3());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append(clsname);
        _builder.append("::");
        _builder.append(clsname);
        _builder.append("(etRuntime::IRTObject* parent, const String& name)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _generateConstructorInitalizerList = this.generateConstructorInitalizerList(ac);
        _builder.append((Object)_generateConstructorInitalizerList, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("\t");
            _builder.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Constructor\");");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        boolean _hasNonEmptyStateMachine = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (_hasNonEmptyStateMachine) {
            _builder.append("\t");
            _builder.append("for (int i = 0; i < s_numberOfStates; i++) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("history[i] = NO_STATE;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("setClassName(\"");
        String _name_3 = ac.getName();
        _builder.append(_name_3, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// sub actors");
        _builder.newLine();
        EList _actorRefs = ac.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            int _multiplicity = sub.getMultiplicity();
            boolean _greaterThan = _multiplicity > 1;
            if (!_greaterThan) continue;
            _builder.append("\t");
            String _name_4 = sub.getName();
            _builder.append(_name_4, "\t");
            _builder.append(".createSubActors(");
            int _multiplicity_1 = sub.getMultiplicity();
            _builder.append((Object)_multiplicity_1, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genExtraInitializers = this.initHelper.genExtraInitializers((Iterable<Attribute>)ac.getAttributes());
        _builder.append((Object)_genExtraInitializers, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _userStructorBody = this._procedureHelpers.userStructorBody((RoomClass)ac, true);
        _builder.append(_userStructorBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _name_5 = ac.getName();
        _builder.append(_name_5);
        _builder.append("::initialize() {");
        _builder.newLineIfNotEmpty();
        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append("\t");
            _builder.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"initialize()\");");
            _builder.newLine();
            EList _actorRefs_1 = ac.getActorRefs();
            for (ActorRef sub_1 : _actorRefs_1) {
                boolean _greaterThan_1;
                int _multiplicity_2 = sub_1.getMultiplicity();
                boolean bl = _greaterThan_1 = _multiplicity_2 > 1;
                if (_greaterThan_1) {
                    _builder.append("\t");
                    _builder.append("for (int i=0; i<");
                    int _multiplicity_3 = sub_1.getMultiplicity();
                    _builder.append((Object)_multiplicity_3, "\t");
                    _builder.append("; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("DebuggingService::getInstance().addMessageActorCreate(*this, ");
                    String _name_6 = sub_1.getName();
                    _builder.append(_name_6, "\t\t");
                    _builder.append(".getSubActor(i)->getName());");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                _builder.append("\t");
                _builder.append("DebuggingService::getInstance().addMessageActorCreate(*this, \"");
                String _name_7 = sub_1.getName();
                _builder.append(_name_7, "\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ActorClassBase::initialize();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        EList _actorRefs_2 = ac.getActorRefs();
        for (ActorRef sub_2 : _actorRefs_2) {
            _builder.append("\t");
            String _name_8 = sub_2.getName();
            _builder.append(_name_8, "\t");
            _builder.append(".initialize();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// wiring");
        _builder.newLine();
        EList _wires = wired.getWires();
        for (Wire wire : _wires) {
            _builder.append("\t");
            String _xifexpression_1 = null;
            boolean _isDataDriven = wire.isDataDriven();
            _xifexpression_1 = _isDataDriven ? "DataPortBase" : "InterfaceItemBase";
            _builder.append(_xifexpression_1, "\t");
            _builder.append("::connect(this, \"");
            String _join = IterableExtensions.join((Iterable)wire.getPath1(), (CharSequence)"/");
            _builder.append(_join, "\t");
            _builder.append("\", \"");
            String _join_1 = IterableExtensions.join((Iterable)wire.getPath2(), (CharSequence)"/");
            _builder.append(_join_1, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
            _builder.append("\t");
            _builder.append("// activate polling for data-driven communication");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("RTServices::getInstance().getMsgSvcCtrl().getMsgSvc(getThread())->addPollingMessageReceiver(*this);");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_2) {
            boolean _greaterThan_2;
            _builder.append("void ");
            String _name_9 = ac.getName();
            _builder.append(_name_9);
            _builder.append("::setProbesActive(bool recursive, bool active) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("DebuggingService::getInstance().addPortInstance(m_RTSystemPort);");
            _builder.newLine();
            int _size = ac.getActorRefs().size();
            boolean bl = _greaterThan_2 = _size > 0;
            if (_greaterThan_2) {
                _builder.append("\t");
                _builder.append("if(recursive) {");
                _builder.newLine();
                EList _actorRefs_3 = ac.getActorRefs();
                for (ActorRef sub_3 : _actorRefs_3) {
                    _builder.append("\t");
                    _builder.append("\t");
                    String _name_10 = sub_3.getName();
                    _builder.append(_name_10, "\t\t");
                    _builder.append(".setProbesActive(recursive, active);");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            List _endPorts = this._roomHelpers.getEndPorts(ac);
            for (Port ep : _endPorts) {
                boolean _isDataDriven_1 = this._roomHelpers.isDataDriven((InterfaceItem)ep);
                boolean _not = !_isDataDriven_1;
                if (!_not) continue;
                boolean _isReplicated = ep.isReplicated();
                if (_isReplicated) {
                    _builder.append("\t");
                    _builder.append("for(int i = 0; i < ");
                    String _name_11 = ep.getName();
                    _builder.append(_name_11, "\t");
                    _builder.append(".getNInterfaceItems(); i++)");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("DebuggingService::getInstance().addPortInstance(*(");
                    String _name_12 = ep.getName();
                    _builder.append(_name_12, "\t\t");
                    _builder.append(".getInterfaceItem(i)));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                _builder.append("DebuggingService::getInstance().addPortInstance(");
                String _name_13 = ep.getName();
                _builder.append(_name_13, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            EList _serviceAccessPoints = ac.getServiceAccessPoints();
            for (SAP sap : _serviceAccessPoints) {
                _builder.append("\t");
                _builder.append("DebuggingService::getInstance().addPortInstance(");
                String _name_14 = sap.getName();
                _builder.append(_name_14, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            EList _serviceProvisionPoints = ac.getServiceProvisionPoints();
            for (SPP spp : _serviceProvisionPoints) {
                _builder.append("\t");
                _builder.append("for(int i = 0; i < ");
                String _name_15 = spp.getName();
                _builder.append(_name_15, "\t");
                _builder.append(".getNInterfaceItems(); i++)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("DebuggingService::getInstance().addPortInstance(*(");
                String _name_16 = spp.getName();
                _builder.append(_name_16, "\t\t\t");
                _builder.append(".getInterfaceItem(i)));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("void ");
        String _name_17 = ac.getName();
        _builder.append(_name_17);
        _builder.append("::destroy(){");
        _builder.newLineIfNotEmpty();
        boolean _isGenerateMSCInstrumentation_3 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_3) {
            _builder.append("\t");
            _builder.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"destroy()\");");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _userStructorBody_1 = this._procedureHelpers.userStructorBody((RoomClass)ac, false);
        _builder.append(_userStructorBody_1, "\t");
        _builder.newLineIfNotEmpty();
        boolean _isGenerateMSCInstrumentation_4 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_4) {
            _builder.append("\t");
            _builder.append("DebuggingService::getInstance().addMessageActorDestroy(*this);");
            _builder.newLine();
        }
        if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
            _builder.append("\t");
            _builder.append("RTServices::getInstance().getMsgSvcCtrl().getMsgSvc(getThread())->removePollingMessageReceiver(*this);");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append(rtBaseClassName, "\t");
        _builder.append("::destroy();");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _operationsImplementation = this._procedureHelpers.operationsImplementation((List)ac.getOperations(), ac.getName());
        _builder.append((Object)_operationsImplementation);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasNonEmptyStateMachine_1 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
        if (_hasNonEmptyStateMachine_1) {
            CharSequence _genStateMachineMethods = this._stateMachineGen.genStateMachineMethods(xpac.getGraphContainer(), true);
            _builder.append((Object)_genStateMachineMethods);
            _builder.newLineIfNotEmpty();
            ComponentCommunicationType _commType = ac.getCommType();
            boolean _equals = Objects.equal((Object)_commType, (Object)ComponentCommunicationType.DATA_DRIVEN);
            if (_equals) {
                _builder.append("void ");
                String _name_18 = ac.getName();
                _builder.append(_name_18);
                _builder.append("::receiveEvent(InterfaceItemBase* ifitem, int evt, void* generic_data) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("handleSystemEvent(ifitem, evt, generic_data);");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
            if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
                _builder.append("void ");
                String _name_19 = ac.getName();
                _builder.append(_name_19);
                _builder.append("::receive(const Message* msg) {");
                _builder.newLineIfNotEmpty();
                ComponentCommunicationType _commType_1 = ac.getCommType();
                boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)ComponentCommunicationType.ASYNCHRONOUS);
                if (_equals_1) {
                    _builder.append("\t");
                    _builder.append("receiveEvent(0, -1, 0);");
                    _builder.newLine();
                } else {
                    _builder.append("\t");
                    _builder.append("receiveEventInternal();");
                    _builder.newLine();
                }
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            boolean _isEmpty = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
            if (_isEmpty) {
                _builder.append("//--------------------- no state machine");
                _builder.newLine();
                _builder.append("void ");
                String _name_20 = ac.getName();
                _builder.append(_name_20);
                _builder.append("::receiveEvent(InterfaceItemBase* ifitem, int evt, void* data) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("handleSystemEvent(ifitem, evt, data);");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)ac);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

