/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.generic.ILanguageExtensionBase;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class CppExtensions
implements ILanguageExtension {
    @Inject
    private IDiagnostician diagnostician;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    public String getTypedDataDefinition(EObject msg) {
        return this.generateArglistAndTypedData((EObject)((Message)msg).getData())[ILanguageExtensionBase.TypedDataKind.DECLARATION_AND_INITIALIZATION.ordinal()];
    }

    public String getCppHeaderFileName(RoomClass rc) {
        String _name = rc.getName();
        return _name + ".h";
    }

    public String getCppSourceFileName(RoomClass rc) {
        String _name = rc.getName();
        return _name + ".cpp";
    }

    public String getCppClassName(NodeRef nr, SubSystemInstance ssi) {
        String _name = nr.getName();
        String _plus = "Node_" + _name;
        String _plus_1 = _plus + "_";
        String _name_1 = ssi.getName();
        return _plus_1 + _name_1;
    }

    public String getCppHeaderFileName(NodeRef nr, SubSystemInstance ssi) {
        String _cppClassName = this.getCppClassName(nr, ssi);
        return _cppClassName + ".h";
    }

    public String getCppSourceFileName(NodeRef nr, SubSystemInstance ssi) {
        String _cppClassName = this.getCppClassName(nr, ssi);
        return _cppClassName + ".cpp";
    }

    public String accessLevelPrivate() {
        return "";
    }

    public String accessLevelProtected() {
        return "";
    }

    public String accessLevelPublic() {
        return "";
    }

    public String memberAccess() {
        return "this->";
    }

    public String selfPointer(String classname, boolean hasArgs) {
        return "";
    }

    public String selfPointer(boolean hasArgs) {
        return "";
    }

    public String scopeSeparator() {
        return "::";
    }

    public String operationScope(String classname, boolean isDeclaration) {
        String _xifexpression = null;
        _xifexpression = isDeclaration ? "" : classname + "::";
        return _xifexpression;
    }

    public String memberInDeclaration(String namespace, String member) {
        return member;
    }

    public String memberInUse(String namespace, String member) {
        return namespace + "." + member;
    }

    public boolean usesInheritance() {
        return true;
    }

    public boolean usesPointers() {
        return true;
    }

    public String genEnumeration(String name, List<Pair<String, String>> entries) {
        String _xblockexpression = null;
        boolean _isEmpty = entries.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef enum {");
        _builder.newLine();
        boolean _hasElements = false;
        for (Pair<String, String> entry : entries) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append("\t");
            String _first = (String)entry.getFirst();
            _builder.append(_first, "\t");
            _builder.append(" = ");
            String _second = (String)entry.getSecond();
            _builder.append(_second, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("} ");
        _builder.append(name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String booleanConstant(boolean b) {
        return Boolean.valueOf(b).toString();
    }

    public String pointerLiteral() {
        return "*";
    }

    public String nullPointer() {
        return "0";
    }

    public String voidPointer() {
        return "void*";
    }

    public String arrayType(String type, int size, boolean isRef) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("StaticArray<");
        _builder.append(type);
        if (isRef) {
            _builder.append("*");
        }
        _builder.append(", ");
        _builder.append((Object)size);
        _builder.append(">");
        return _builder.toString();
    }

    public String arrayDeclaration(String type, int size, boolean isRef, String name) {
        String _arrayType = this.arrayType(type, size, isRef);
        String _plus = _arrayType + " ";
        return _plus + name;
    }

    public String getIncludeGuardString(RoomClass roomClass, String appendSegments) {
        String[] _split = this._roomExtensions.getPackage(roomClass).split("\\.");
        String _name = roomClass.getName();
        Iterable _plus = Iterables.concat((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_name})));
        String[] _split_1 = appendSegments.split("\\.");
        Functions.Function1 _function = it -> {
            boolean _isEmpty = it.isEmpty();
            return !_isEmpty;
        };
        String _upperCase = IterableExtensions.join((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)_plus, (Iterable)((Iterable)Conversions.doWrapArray((Object)_split_1))), (Functions.Function1)_function), (CharSequence)"_").toUpperCase();
        String _plus_1 = "_" + _upperCase;
        return _plus_1 + "_H_";
    }

    public CharSequence generateIncludeGuardBegin(RoomClass roomClass, String appendSegments) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef ");
        String _includeGuardString = this.getIncludeGuardString(roomClass, appendSegments);
        _builder.append(_includeGuardString);
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        String _includeGuardString_1 = this.getIncludeGuardString(roomClass, appendSegments);
        _builder.append(_includeGuardString_1);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateIncludeGuardEnd(RoomClass roomClass, String appendSegments) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#endif /* ");
        String _includeGuardString = this.getIncludeGuardString(roomClass, appendSegments);
        _builder.append(_includeGuardString);
        _builder.append(" */");
        return _builder;
    }

    public String generateNamespaceBegin(RoomClass roomClass) {
        return "";
    }

    public String generateNamespaceEnd(RoomClass roomClass) {
        return "";
    }

    public String superCall(String baseClassName, String method, String arguments) {
        return baseClassName + "::" + method + "(" + arguments + ");";
    }

    public String toValueLiteral(PrimitiveType type, String value) {
        throw new UnsupportedOperationException("TODO Config for Cpp");
    }

    public String toEnumLiteral(EnumerationType type, String value) {
        throw new UnsupportedOperationException("TODO Config for Cpp");
    }

    public String defaultValue(DataType dt) {
        String _switchResult = null;
        DataType it = dt;
        boolean _matched = false;
        if (it instanceof PrimitiveType) {
            _matched = true;
            _switchResult = ((PrimitiveType)it).getDefaultValueLiteral();
        }
        if (!_matched && it instanceof EnumerationType) {
            _matched = true;
            String _xblockexpression = null;
            this.diagnostician.error("Enumeration not supported", (EObject)dt, null);
            _switchResult = _xblockexpression = "/* TODO */";
        }
        if (!_matched && it instanceof ExternalType) {
            _matched = true;
            _switchResult = ((ExternalType)it).getDefaultValueLiteral();
        }
        return _switchResult;
    }

    public String getDefaultValue(EnumerationType type) {
        String _xifexpression = null;
        boolean _isEmpty = type.getLiterals().isEmpty();
        _xifexpression = _isEmpty ? "" : this.getCastedValue((EnumLiteral)type.getLiterals().get(0));
        return _xifexpression;
    }

    public String initializationWithDefaultValues(DataType dt, int size) {
        String _xblockexpression = null;
        String dv = this.defaultValue(dt);
        String _xifexpression = null;
        if (size > 1) {
            String _xblockexpression_1 = null;
            String res = "{";
            int i = 0;
            while (i < size) {
                res = res + dv;
                if (++i >= size) continue;
                res = res + ",";
            }
            _xifexpression = _xblockexpression_1 = res + "}";
        } else {
            _xifexpression = dv;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String[] generateArglistAndTypedData(EObject d) {
        boolean _isPrimitive;
        RefableType _refType;
        DataType _type;
        if (d == null || !(d instanceof MessageData)) {
            return (String[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new String[]{"", "", ""}), String.class);
        }
        MessageData data = (MessageData)d;
        String _switchResult = null;
        DataType it = _type = data.getRefType().getType();
        boolean _matched = false;
        if (it instanceof PrimitiveType) {
            boolean _not;
            boolean _isEmpty = Strings.isEmpty((String)((PrimitiveType)it).getCastName());
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _matched = true;
                _switchResult = ((PrimitiveType)it).getCastName();
            }
        }
        if (!_matched && it instanceof EnumerationType) {
            _matched = true;
            _switchResult = this.getCastType((EnumerationType)it);
        }
        if (!_matched) {
            _switchResult = this._typeHelpers.typeName(it);
        }
        String castExpr = _switchResult + "*";
        String _typeName = this._typeHelpers.typeName(data.getRefType().getType());
        String _switchResult_1 = null;
        RefableType it_1 = _refType = data.getRefType();
        boolean _matched_1 = false;
        boolean _isRef = it_1.isRef();
        if (_isRef) {
            _matched_1 = true;
            _switchResult_1 = "*";
        }
        if (!_matched_1 && (_isPrimitive = this._typeHelpers.isPrimitive(it_1.getType()))) {
            _matched_1 = true;
            _switchResult_1 = "";
        }
        if (!_matched_1) {
            _switchResult_1 = "&";
        }
        String typeExpr = _typeName + _switchResult_1;
        String _xifexpression = null;
        boolean _isRef_1 = data.getRefType().isRef();
        boolean _not = !_isRef_1;
        _xifexpression = _not ? "*" : "";
        String deRef = _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = this._generatorOptionsHelper.isOldStyleTransitionData(Main.getSettings()) && data.getDeprecatedName() != null && !data.getDeprecatedName().trim().isEmpty() ? data.getDeprecatedName() : "transitionData";
        String dataName = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(", ");
        _builder.append(dataName);
        String dataArg = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(typeExpr);
        _builder_1.append(" ");
        _builder_1.append(dataName);
        _builder_1.append(" = ");
        _builder_1.append(deRef);
        _builder_1.append("(static_cast<");
        _builder_1.append(castExpr);
        _builder_1.append(">(generic_data__et));");
        String typedData = _builder_1.toString() + this._roomExtensions.NEWLINE;
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(", ");
        _builder_2.append(typeExpr);
        _builder_2.append(" ");
        _builder_2.append(dataName);
        String typedArgList = _builder_2.toString();
        return new String[]{dataArg, typedData, typedArgList};
    }

    public String getTargetType(EnumerationType type) {
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean _tripleNotEquals = _primitiveType != null;
        _xifexpression = _tripleNotEquals ? type.getPrimitiveType().getTargetName() : type.getName();
        return _xifexpression;
    }

    public String getCastedValue(EnumLiteral literal) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        EObject _eContainer = literal.eContainer();
        EnumerationType type = (EnumerationType)_eContainer;
        String cast = this.getTargetType(type);
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean bl = _tripleNotEquals = _primitiveType != null;
        if (_tripleNotEquals) {
            _xifexpression = Long.toString(literal.getLiteralValue());
        } else {
            String _string = Long.toString(literal.getLiteralValue());
            String _plus = "((" + cast + ")" + _string;
            _xifexpression = _plus + ")";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getCastType(EnumerationType type) {
        String _xifexpression = null;
        PrimitiveType _primitiveType = type.getPrimitiveType();
        boolean _tripleNotEquals = _primitiveType != null;
        _xifexpression = _tripleNotEquals ? type.getPrimitiveType().getCastName() : type.getName();
        return _xifexpression;
    }

    public String makeOverridable() {
        return "virtual ";
    }

    public String getImplementationClassName(ActorClass ac) {
        String _xblockexpression = null;
        List attributes = this._roomHelpers.getAttributes(ac, "ImplementationSubclass");
        String _xifexpression = null;
        boolean _isEmpty = attributes.isEmpty();
        if (_isEmpty) {
            _xifexpression = ac.getName();
        } else {
            Functions.Function1 _function = it -> {
                String _key = it.getKey();
                return Objects.equal((Object)_key, (Object)"fqnClassName");
            };
            _xifexpression = this._roomHelpers.literalToString(((KeyValue)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)attributes, (Functions.Function1)_function))).getValue());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getActorIncludePath(ActorClass ac) {
        String _xblockexpression = null;
        List attributes = this._roomHelpers.getAttributes(ac, "ImplementationSubclass");
        String _xifexpression = null;
        boolean _isEmpty = attributes.isEmpty();
        if (_isEmpty) {
            String _path = this._roomExtensions.getPath((RoomClass)ac);
            String _name = ac.getName();
            String _plus = _path + _name;
            _xifexpression = _plus + ".h";
        } else {
            String _xblockexpression_1 = null;
            Functions.Function1 _function = it -> {
                String _key = it.getKey();
                return Objects.equal((Object)_key, (Object)"includePath");
            };
            Iterable path = IterableExtensions.filter((Iterable)attributes, (Functions.Function1)_function);
            String _xifexpression_1 = null;
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)path);
            if (_isEmpty_1) {
                String _xblockexpression_2 = null;
                Functions.Function1 _function_1 = it -> {
                    String _key = it.getKey();
                    return Objects.equal((Object)_key, (Object)"fqnClassName");
                };
                String baseName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)this._roomHelpers.literalToString(((KeyValue)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)attributes, (Functions.Function1)_function_1))).getValue()).split("::"))));
                _xifexpression_1 = _xblockexpression_2 = baseName + ".h";
            } else {
                _xifexpression_1 = this._roomHelpers.literalToString(((KeyValue)IterableExtensions.head((Iterable)path)).getValue());
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String getTypeSignature(RefableType type) {
        boolean _isRef;
        String _switchResult = null;
        RefableType it = type;
        boolean _matched = false;
        if (Objects.equal((Object)it, null)) {
            _matched = true;
            _switchResult = "void";
        }
        if (!_matched && (_isRef = it.isRef())) {
            _matched = true;
            String _dataTypeName = this.getDataTypeName(type.getType());
            String _pointerLiteral = this.pointerLiteral();
            _switchResult = _dataTypeName + _pointerLiteral;
        }
        if (!_matched) {
            _switchResult = this.getDataTypeName(type.getType());
        }
        return _switchResult;
    }

    public String getDataTypeName(DataType it) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof PrimitiveType) {
            _matched = true;
            _switchResult = ((PrimitiveType)it).getTargetName();
        }
        if (!_matched && it instanceof EnumerationType) {
            _matched = true;
            _switchResult = this.getTargetType((EnumerationType)it);
        }
        if (!_matched && it instanceof ExternalType) {
            _matched = true;
            _switchResult = ((ExternalType)it).getTargetName();
        }
        if (!_matched) {
            _switchResult = it.getName();
        }
        return _switchResult;
    }

    public String toParameterDecl(VarDecl it) {
        String _switchResult = null;
        boolean _matched = false;
        boolean _isVarargs = it.isVarargs();
        if (_isVarargs) {
            _matched = true;
            String _typeSignature = this.getTypeSignature(it.getRefType());
            String _plus = _typeSignature + " ";
            String _name = it.getName();
            String _plus_1 = _plus + _name;
            _switchResult = _plus_1 + "...";
        }
        if (!_matched) {
            String _typeSignature_1 = this.getTypeSignature(it.getRefType());
            String _plus_2 = _typeSignature_1 + " ";
            String _name_1 = it.getName();
            _switchResult = _plus_2 + _name_1;
        }
        return _switchResult;
    }
}

