/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.CppProcedureHelpers;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class DataClassGen {
    @Inject
    @Extension
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private CppProcedureHelpers helpers;
    @Inject
    private Initialization initHelper;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Consumer<DataClass> _function_1 = dc -> {
            String path = this.roomExt.getPath((RoomClass)dc);
            String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)dc);
            String _plus = path + _cppHeaderFileName;
            this.fileIO.generateFile("generating DataClass header", _plus, this.generateHeaderFile(root, (DataClass)dc));
            String _cppSourceFileName = this.stdExt.getCppSourceFileName((RoomClass)dc);
            String _plus_1 = path + _cppSourceFileName;
            this.fileIO.generateFile("generating DataClass source", _plus_1, this.generateSourceFile(root, (DataClass)dc));
        };
        IterableExtensions.filter((Iterable)root.getDataClasses(), (Functions.Function1)_function).forEach(_function_1);
    }

    public CharSequence generateHeaderFile(Root root, DataClass dc) {
        boolean _not;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin((RoomClass)dc, "");
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/etDatatypesCpp.hpp\"");
        _builder.newLine();
        DataClass _base = dc.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            _builder.append("#include \"");
            String _path = this.roomExt.getPath((RoomClass)dc.getBase());
            _builder.append(_path);
            String _name = dc.getBase().getName();
            _builder.append(_name);
            _builder.append(".h\"");
        }
        _builder.newLineIfNotEmpty();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)dc);
        for (DataClass classes : _referencedDataClasses) {
            _builder.append("#include \"");
            String _path_1 = this.roomExt.getPath((RoomClass)classes);
            _builder.append(_path_1);
            String _name_1 = classes.getName();
            _builder.append(_name_1);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
        }
        EList _referencedModels = root.getReferencedModels((RoomClass)dc);
        for (RoomModel model : _referencedModels) {
            EList _dataClasses = model.getDataClasses();
            for (DataClass classes_1 : _dataClasses) {
                _builder.append("#include \"");
                String _path_2 = this.roomExt.getPath((RoomClass)classes_1);
                _builder.append(_path_2);
                String _name_2 = classes_1.getName();
                _builder.append(_name_2);
                _builder.append(".h\"");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(dc.getUserCode1());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("using namespace etRuntime; // TODO JH remove");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)dc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _name_3 = dc.getName();
        _builder.append(_name_3);
        DataClass _base_1 = dc.getBase();
        boolean bl2 = _tripleNotEquals_1 = _base_1 != null;
        if (_tripleNotEquals_1) {
            _builder.append(" : public ");
            String _name_4 = dc.getBase().getName();
            _builder.append(_name_4);
        }
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _userCode_1 = this.helpers.userCode(dc.getUserCode2());
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributes = this.helpers.attributes((List)dc.getAttributes());
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _attributeSettersGettersImplementation = this.helpers.attributeSettersGettersImplementation((List)dc.getAttributes(), dc.getName());
        _builder.append((Object)_attributeSettersGettersImplementation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _operationsDeclaration = this.helpers.operationsDeclaration((List)dc.getOperations(), dc.getName());
        _builder.append((Object)_operationsDeclaration, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// default constructor, copy constructor and assignment operator");
        _builder.newLine();
        _builder.append("\t");
        String _name_5 = dc.getName();
        _builder.append(_name_5, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _name_6 = dc.getName();
        _builder.append(_name_6, "\t");
        _builder.append("(const ");
        String _name_7 = dc.getName();
        _builder.append(_name_7, "\t");
        _builder.append("& rhs);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// constructor using fields");
        _builder.newLine();
        _builder.append("\t");
        boolean _isEmpty = this._roomHelpers.getAllAttributes(dc).isEmpty();
        boolean bl3 = _not = !_isEmpty;
        if (_not) {
            String _name_8 = dc.getName();
            _builder.append(_name_8, "\t");
            _builder.append("(");
            String _constArgList = this.helpers.constArgList(this._roomHelpers.getAllAttributes(dc));
            _builder.append(_constArgList, "\t");
            _builder.append(");");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        String _name_9 = dc.getName();
        _builder.append(_name_9, "\t");
        _builder.append("& operator=(const ");
        String _name_10 = dc.getName();
        _builder.append(_name_10, "\t");
        _builder.append("& rhs);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)dc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd((RoomClass)dc, "");
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateSourceFile(Root root, DataClass dc) {
        boolean _tripleNotEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of DataClass ");
        String _name = dc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)dc);
        _builder.append(_cppHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"etUnit/etUnit.h\"");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)dc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(dc.getUserCode3());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// default constructor");
        _builder.newLine();
        String _name_1 = dc.getName();
        _builder.append(_name_1);
        _builder.append("::");
        String _name_2 = dc.getName();
        _builder.append(_name_2);
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateDefaultInitalizerList = this.generateDefaultInitalizerList(dc);
        _builder.append((Object)_generateDefaultInitalizerList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genExtraInitializers = this.initHelper.genExtraInitializers((Iterable<Attribute>)dc.getAttributes());
        _builder.append((Object)_genExtraInitializers, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _userStructorBody = this.helpers.userStructorBody((RoomClass)dc, true);
        _builder.append(_userStructorBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// copy constructor");
        _builder.newLine();
        String _name_3 = dc.getName();
        _builder.append(_name_3);
        _builder.append("::");
        String _name_4 = dc.getName();
        _builder.append(_name_4);
        _builder.append("(const ");
        String _name_5 = dc.getName();
        _builder.append(_name_5);
        _builder.append("& rhs)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateCopyInitalizerList = this.generateCopyInitalizerList(dc);
        _builder.append((Object)_generateCopyInitalizerList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// constructor using fields");
        _builder.newLine();
        _builder.append("// TODO");
        _builder.newLine();
        boolean _isEmpty = this._roomHelpers.getAllAttributes(dc).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _name_6 = dc.getName();
            _builder.append(_name_6);
            _builder.append("::");
            String _name_7 = dc.getName();
            _builder.append(_name_7);
            _builder.append("(");
            String _constArgList = this.helpers.constArgList(this._roomHelpers.getAllAttributes(dc));
            _builder.append(_constArgList);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateFieldInitializerList = this.generateFieldInitializerList(dc);
            _builder.append((Object)_generateFieldInitializerList, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("// assignment operator");
        _builder.newLine();
        String _name_8 = dc.getName();
        _builder.append(_name_8);
        _builder.append("& ");
        String _name_9 = dc.getName();
        _builder.append(_name_9);
        _builder.append("::operator=(const ");
        String _name_10 = dc.getName();
        _builder.append(_name_10);
        _builder.append("& rhs)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (this == &rhs) { return *this; };");
        _builder.newLine();
        _builder.append("\t");
        DataClass _base = dc.getBase();
        boolean bl2 = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            String _name_11 = dc.getBase().getName();
            _builder.append(_name_11, "\t");
            _builder.append("::operator=(rhs);");
        }
        _builder.newLineIfNotEmpty();
        EList _attributes = dc.getAttributes();
        for (Attribute attr : _attributes) {
            _builder.append("\t");
            _builder.append("this->");
            String _name_12 = attr.getName();
            _builder.append(_name_12, "\t");
            _builder.append(" = rhs.");
            String _name_13 = attr.getName();
            _builder.append(_name_13, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return *this;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _operationsImplementation = this.helpers.operationsImplementation((List)dc.getOperations(), dc.getName());
        _builder.append((Object)_operationsImplementation);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)dc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateDefaultInitalizerList(DataClass dataClass) {
        boolean _tripleNotEquals;
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        DataClass _base = dataClass.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            String _name = dataClass.getBase().getName();
            String _plus = _name + "()";
            initList.add(_plus);
        }
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            String _name_1 = it.getName();
            _builder.append(_name_1);
            _builder.append("(");
            String _initializerListValue = initHelper.getInitializerListValue((Attribute)it);
            _builder.append(_initializerListValue);
            _builder.append(")");
            return _builder.toString();
        };
        List _map = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)_function);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    private CharSequence generateCopyInitalizerList(DataClass dataClass) {
        boolean _tripleNotEquals;
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        DataClass _base = dataClass.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            String _name = dataClass.getBase().getName();
            String _plus = _name + "(rhs)";
            initList.add(_plus);
        }
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            String _name_1 = it.getName();
            _builder.append(_name_1);
            _builder.append("(rhs.");
            String _name_2 = it.getName();
            _builder.append(_name_2);
            _builder.append(")");
            return _builder.toString();
        };
        List _map = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)_function);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    private CharSequence generateFieldInitializerList(DataClass dataClass) {
        boolean _tripleNotEquals;
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        DataClass _base = dataClass.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = dataClass.getBase().getName();
            _builder.append(_name);
            _builder.append("(");
            Functions.Function1 _function = it -> it.getName();
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)this._roomHelpers.getAllAttributes(dataClass.getBase()), (Functions.Function1)_function), (CharSequence)", ");
            _builder.append(_join);
            _builder.append(")");
            initList.add(_builder.toString());
        }
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_1 = it.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(");
            String _name_2 = it.getName();
            _builder_1.append(_name_2);
            _builder_1.append(")");
            return _builder_1.toString();
        };
        List _map = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)_function_1);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    public String deepCopy(DataClass _dc) {
        String result = "";
        for (DataClass dc = _dc; dc != null; dc = dc.getBase()) {
            String _plus;
            String _string = this.deepCopy((List<Attribute>)dc.getAttributes()).toString();
            result = _plus = _string + result;
        }
        return result;
    }

    public CharSequence deepCopy(List<Attribute> attributes) {
        StringConcatenation _builder = new StringConcatenation();
        for (Attribute a : attributes) {
            boolean _equals_1;
            DataType _type = a.getType().getType();
            if (_type instanceof ComplexType) {
                boolean _equals;
                _builder.append("if (");
                String _name = a.getName();
                _builder.append(_name);
                _builder.append("!=null) {");
                _builder.newLineIfNotEmpty();
                int _size = a.getSize();
                boolean bl = _equals = _size == 0;
                if (_equals) {
                    _builder.append("\t");
                    _builder.append("copy.");
                    String _name_1 = a.getName();
                    _builder.append(_name_1, "\t");
                    _builder.append(" = ");
                    String _name_2 = a.getName();
                    _builder.append(_name_2, "\t");
                    _builder.append(".deepCopy();");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("for (int i=0;i<");
                    String _name_3 = a.getName();
                    _builder.append(_name_3, "\t");
                    _builder.append(".length;i++){");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("copy.");
                    String _name_4 = a.getName();
                    _builder.append(_name_4, "\t\t");
                    _builder.append("[i] = ");
                    String _name_5 = a.getName();
                    _builder.append(_name_5, "\t\t");
                    _builder.append("[i].deepCopy();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("}");
                _builder.newLine();
                continue;
            }
            int _size_1 = a.getSize();
            boolean bl = _equals_1 = _size_1 == 0;
            if (_equals_1) {
                _builder.append("copy.");
                String _name_6 = a.getName();
                _builder.append(_name_6);
                _builder.append(" = ");
                String _name_7 = a.getName();
                _builder.append(_name_7);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("for (int i=0;i<");
            String _name_8 = a.getName();
            _builder.append(_name_8);
            _builder.append(".length;i++){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("copy.");
            String _name_9 = a.getName();
            _builder.append(_name_9, "\t");
            _builder.append("[i] = ");
            String _name_10 = a.getName();
            _builder.append(_name_10, "\t");
            _builder.append("[i];");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }
}

