/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.common.converter.TimeConverter;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredSubSystemClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.base.Indexed;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private CppExtensions _cppExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    private Initialization initHelper;

    public void doGenerate(Root root) {
        HashMap sscc2wired = CollectionLiterals.newHashMap();
        Consumer<WiredSubSystemClass> _function = it -> sscc2wired.put(it.getSubSystemClass(), it);
        Iterables.filter((Iterable)root.getWiredInstances(), WiredSubSystemClass.class).forEach(_function);
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                if (ssi == null) continue;
                WiredSubSystemClass wired = (WiredSubSystemClass)sscc2wired.get(ssi.getSubSystemClass());
                String path = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName(nr, ssi);
                String _plus = path + _cppHeaderFileName;
                this.fileIO.generateFile("generating Node declaration", _plus, this.generateHeaderFile(root, ssi, wired, usedThreads));
                String _cppSourceFileName = this._cppExtensions.getCppSourceFileName(nr, ssi);
                String _plus_1 = path + _cppSourceFileName;
                this.fileIO.generateFile("generating Node implementation", _plus_1, this.generateSourceFile(root, ssi, wired, usedThreads));
            }
        }
    }

    public CharSequence generateHeaderFile(Root root, SubSystemInstance comp, WiredSubSystemClass wired, Collection<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = comp.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._cppExtensions.getCppClassName(nr, comp);
        Functions.Function1 _function = t -> usedThreads.contains(t);
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of SubSystemClass ");
        _builder.append(clsname, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin((RoomClass)cc, "");
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/messaging/IMessageService.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/SubSystemClassBase.h\"");
        _builder.newLine();
        EList _actorInstances = comp.getActorInstances();
        for (ActorInstance ai : _actorInstances) {
            _builder.append("#include \"");
            String _actorIncludePath = this._cppExtensions.getActorIncludePath(ai.getActorClass());
            _builder.append(_actorIncludePath);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this._procedureHelpers.userCode(cc.getUserCode1());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        _builder.append(clsname);
        _builder.append(" : public etRuntime::SubSystemClassBase{");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode(cc.getUserCode2());
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        Iterable _indexed = Indexed.indexed((Iterable)threads);
        for (Indexed thread : _indexed) {
            _builder.append("\t\t");
            _builder.append("static const int ");
            String _threadId = this.getThreadId((PhysicalThread)thread.getValue());
            _builder.append(_threadId, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// sub actors");
        _builder.newLine();
        EList _actorRefs = cc.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            boolean _greaterThan;
            int _multiplicity = sub.getMultiplicity();
            boolean bl = _greaterThan = _multiplicity > 1;
            if (_greaterThan) {
                _builder.append("\t\t");
                _builder.append("Replicated");
                String _implementationClassName = this._cppExtensions.getImplementationClassName(sub.getType());
                _builder.append(_implementationClassName, "\t\t");
                _builder.append(" ");
                String _name = sub.getName();
                _builder.append(_name, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t\t");
            String _implementationClassName_1 = this._cppExtensions.getImplementationClassName(sub.getType());
            _builder.append(_implementationClassName_1, "\t\t");
            _builder.append(" ");
            String _name_1 = sub.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(clsname, "\t\t");
        _builder.append("(IRTObject* parent, const String& name);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("~");
        _builder.append(clsname, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("virtual void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("virtual void instantiateMessageServices();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("virtual void mapThreads(void);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("virtual void initialize(void);");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("\t\t");
            _builder.append("virtual void setProbesActive(bool recursive, bool active);");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("virtual void init();");
        _builder.newLine();
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append("\t\t");
            _builder.append("etBool hasGeneratedMSCInstrumentation() const { return true; }");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("virtual void destroy();");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// MessageServices");
        _builder.newLine();
        for (PhysicalThread thread_1 : threads) {
            _builder.append("\t\t");
            _builder.append("IMessageService* msgSvc_");
            String _name_2 = thread_1.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(clsname, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append(clsname, "\t\t");
        _builder.append("(");
        _builder.append(clsname, "\t\t");
        _builder.append(" const&);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append(clsname, "\t\t");
        _builder.append("& operator=(");
        _builder.append(clsname, "\t\t");
        _builder.append(" const&);");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd((RoomClass)cc, "");
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getThreadId(PhysicalThread thread) {
        String _upperCase = thread.getName().toUpperCase();
        return "THREAD_" + _upperCase;
    }

    private CharSequence generateConstructorInitalizerList(SubSystemClass cc) {
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("SubSystemClassBase(parent, name)");
        initList.add(_builder.toString());
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name = it.getName();
            _builder_1.append(_name);
            _builder_1.append("(this, \"");
            String _name_1 = it.getName();
            _builder_1.append(_name_1);
            _builder_1.append("\")");
            return _builder_1.toString();
        };
        List _map = ListExtensions.map((List)cc.getActorRefs(), (Functions.Function1)_function);
        Iterables.addAll((Collection)initList, (Iterable)_map);
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance comp, WiredSubSystemClass wired, Collection<PhysicalThread> usedThreads) {
        Object _name_2;
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = comp.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._cppExtensions.getCppClassName(nr, comp);
        Functions.Function1 _function = t -> usedThreads.contains(t);
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of SubsystemClass ");
        _builder.append(clsname, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName(nr, comp);
        _builder.append(_cppHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append("#include \"common/debugging/MSCFunctionObject.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/IMessageService.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/MessageService.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/MessageServiceController.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/RTServices.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/StaticMessageMemory.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Iterable _indexed = Indexed.indexed((Iterable)threads);
        for (Indexed thread : _indexed) {
            _builder.append("const int ");
            _builder.append(clsname);
            _builder.append("::");
            String _threadId = this.getThreadId((PhysicalThread)thread.getValue());
            _builder.append(_threadId);
            _builder.append(" = ");
            int _index0 = thread.getIndex0();
            _builder.append((Object)_index0);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append(clsname);
        _builder.append("::");
        _builder.append(clsname);
        _builder.append("(IRTObject* parent, const String& name)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _generateConstructorInitalizerList = this.generateConstructorInitalizerList(cc);
        _builder.append((Object)_generateConstructorInitalizerList, "\t\t");
        _builder.newLineIfNotEmpty();
        for (Object thread_1 : threads) {
            _builder.append("\t\t");
            _builder.append(", msgSvc_");
            String _name = thread_1.getName();
            _builder.append(_name, "\t\t");
            _builder.append("(NULL)");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("{");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("\t");
            _builder.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Constructor\");");
            _builder.newLine();
        }
        EList _actorRefs = cc.getActorRefs();
        for (ActorRef sub : _actorRefs) {
            int _multiplicity = sub.getMultiplicity();
            boolean _greaterThan = _multiplicity > 1;
            if (!_greaterThan) continue;
            _builder.append("\t");
            String _name_1 = sub.getName();
            _builder.append(_name_1, "\t");
            _builder.append(".createSubActors(");
            int _multiplicity_1 = sub.getMultiplicity();
            _builder.append((Object)_multiplicity_1, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append(clsname);
        _builder.append("::~");
        _builder.append(clsname);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append("\t");
            _builder.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Destructor\");");
            _builder.newLine();
        }
        for (PhysicalThread thread_2 : threads) {
            _builder.append("\t");
            _builder.append("delete msgSvc_");
            _name_2 = thread_2.getName();
            _builder.append((String)_name_2, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("::receiveEvent(InterfaceItemBase* ifitem, int evt, void* data){");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("::instantiateMessageServices(){");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_2) {
            _builder.append("\t");
            _builder.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"instantiateMessageServices()\");");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("IMessageMemory* msgMemory;");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> {
            long _prio = it.getPrio();
            return -_prio;
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)_function_1);
        _name_2 = _sortBy.iterator();
        while (_name_2.hasNext()) {
            PhysicalThread thread_3 = (PhysicalThread)_name_2.next();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("msgMemory = new StaticMessageMemory(this, \"MessageMemory_");
            String _name_3 = thread_3.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append("\", ");
            int _msgblocksize = thread_3.getMsgblocksize();
            _builder.append((Object)_msgblocksize, "\t\t");
            _builder.append(", ");
            int _msgpoolsize = thread_3.getMsgpoolsize();
            _builder.append((Object)_msgpoolsize, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            if (Objects.equal((Object)thread_3.getExecmode(), (Object)ExecMode.POLLED) || Objects.equal((Object)thread_3.getExecmode(), (Object)ExecMode.MIXED)) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("etTime interval;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("interval.sec = ");
                long _split = TimeConverter.split((long)thread_3.getTime(), (String)"s", (boolean)true);
                _builder.append((Object)_split, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("interval.nSec = ");
                long _split_1 = TimeConverter.split((long)thread_3.getTime(), (String)"ms", (boolean)false);
                _builder.append((Object)_split_1, "\t\t");
                _builder.append("L;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("msgSvc_");
                String _name_4 = thread_3.getName();
                _builder.append(_name_4, "\t\t");
                _builder.append(" = new MessageService(this, IMessageService::");
                String _name_5 = thread_3.getExecmode().getName();
                _builder.append(_name_5, "\t\t");
                _builder.append(", interval, 0, ");
                String _threadId_1 = this.getThreadId(thread_3);
                _builder.append(_threadId_1, "\t\t");
                _builder.append(", \"MessageService_");
                String _name_6 = thread_3.getName();
                _builder.append(_name_6, "\t\t");
                _builder.append("\", msgMemory, ");
                long _prio = thread_3.getPrio();
                _builder.append((Object)_prio, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("msgSvc_");
                String _name_7 = thread_3.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append(" = new MessageService(this, IMessageService::");
                String _name_8 = thread_3.getExecmode().getName();
                _builder.append(_name_8, "\t\t");
                _builder.append(", 0, ");
                String _threadId_2 = this.getThreadId(thread_3);
                _builder.append(_threadId_2, "\t\t");
                _builder.append(", \"MessageService_");
                String _name_9 = thread_3.getName();
                _builder.append(_name_9, "\t\t");
                _builder.append("\", msgMemory, ");
                long _prio_1 = thread_3.getPrio();
                _builder.append((Object)_prio_1, "\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("RTServices::getInstance().getMsgSvcCtrl().addMsgSvc(*msgSvc_");
            String _name_10 = thread_3.getName();
            _builder.append(_name_10, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("::mapThreads() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// thread mappings");
        _builder.newLine();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (Object ai : _allContainedInstances) {
            _builder.append("\t");
            ETMapUtil.MappedThread mapped = ETMapUtil.getMappedThread((AbstractInstance)ai);
            _builder.newLineIfNotEmpty();
            boolean _not = !mapped.isImplicit() && !mapped.isAsParent();
            if (!_not) continue;
            _builder.append("\t");
            _builder.append("addPathToThread(\"");
            String _path = ai.getPath();
            _builder.append(_path, "\t");
            _builder.append("\", ");
            String _threadId_3 = this.getThreadId(mapped.getThread());
            _builder.append(_threadId_3, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("::initialize() {");
        _builder.newLineIfNotEmpty();
        boolean _isGenerateMSCInstrumentation_3 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_3) {
            Object ai;
            _builder.append("\t");
            _builder.append("DebuggingService::getInstance().getSyncLogger().addVisibleComment(\"starting initialization\");");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"initialize()\");");
            _builder.newLine();
            EList _actorRefs_1 = cc.getActorRefs();
            ai = _actorRefs_1.iterator();
            while (ai.hasNext()) {
                boolean _greaterThan_1;
                ActorRef sub_1 = (ActorRef)ai.next();
                int _multiplicity_2 = sub_1.getMultiplicity();
                boolean bl = _greaterThan_1 = _multiplicity_2 > 1;
                if (_greaterThan_1) {
                    _builder.append("\t");
                    _builder.append("for (int i=0; i<");
                    int _multiplicity_3 = sub_1.getMultiplicity();
                    _builder.append((Object)_multiplicity_3, "\t");
                    _builder.append("; ++i) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("DebuggingService::getInstance().addMessageActorCreate(*this, ");
                    String _name_11 = sub_1.getName();
                    _builder.append(_name_11, "\t\t");
                    _builder.append(".getSubActor(i)->getName());");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                _builder.append("\t");
                _builder.append("DebuggingService::getInstance().addMessageActorCreate(*this, \"");
                String _name_12 = sub_1.getName();
                _builder.append(_name_12, "\t");
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// wiring");
        _builder.newLine();
        EList _wires = wired.getWires();
        for (Wire wire : _wires) {
            _builder.append("\t");
            String _xifexpression = null;
            boolean _isDataDriven = wire.isDataDriven();
            _xifexpression = _isDataDriven ? "DataPortBase" : "InterfaceItemBase";
            _builder.append(_xifexpression, "\t");
            _builder.append("::connect(this, \"");
            String _join = IterableExtensions.join((Iterable)wire.getPath1(), (CharSequence)"/");
            _builder.append(_join, "\t");
            _builder.append("\", \"");
            String _join_1 = IterableExtensions.join((Iterable)wire.getPath2(), (CharSequence)"/");
            _builder.append(_join_1, "\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// call initialize of sub actors");
        _builder.newLine();
        EList _actorRefs_2 = cc.getActorRefs();
        for (ActorRef sub_2 : _actorRefs_2) {
            _builder.append("\t");
            String _name_13 = sub_2.getName();
            _builder.append(_name_13, "\t");
            _builder.append(".initialize();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_4 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_4) {
            _builder.append("void ");
            _builder.append(clsname);
            _builder.append("::setProbesActive(bool recursive, bool active) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("for(int i = 0; i < m_RTSystemPort.getNInterfaceItems(); i++)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("DebuggingService::getInstance().addPortInstance(*(m_RTSystemPort.getInterfaceItem(i)));");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if(recursive) {");
            _builder.newLine();
            EList _actorRefs_3 = cc.getActorRefs();
            for (ActorRef sub_3 : _actorRefs_3) {
                _builder.append("\t\t");
                String _name_14 = sub_3.getName();
                _builder.append(_name_14, "\t\t");
                _builder.append(".setProbesActive(recursive, active);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("void ");
        _builder.append(clsname);
        _builder.append("::init(){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("SubSystemClassBase::init();");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_5 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_5) {
            _builder.append("\t");
            _builder.append("DebuggingService::getInstance().addVisibleComment(\"done sub system initialization\");");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_6 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_6) {
            _builder.newLine();
            _builder.append("void ");
            _builder.append(clsname);
            _builder.append("::destroy() {");
            _builder.newLineIfNotEmpty();
            boolean _isGenerateMSCInstrumentation_7 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation_7) {
                _builder.append("\t");
                _builder.append("DebuggingService::getInstance().getSyncLogger().addVisibleComment(\"starting destruction\");");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"destroy()\");");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("DebuggingService::getInstance().addVisibleComment(\"begin sub system destruction\");");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("SubSystemClassBase::destroy();");
            _builder.newLine();
            boolean _isGenerateMSCInstrumentation_8 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation_8) {
                _builder.append("\t");
                _builder.append("DebuggingService::getInstance().addVisibleComment(\"done sub system destruction\");");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

