/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private CppExtensions _cppExtensions;
    @Inject
    @Extension
    private GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;

    public void doGenerate(Root root) {
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                if (ssi == null) continue;
                String filepath = this.roomExt.getPath((RoomClass)ssi.getSubSystemClass());
                String _cppClassName = this._cppExtensions.getCppClassName(nr, ssi);
                String _plus = filepath + _cppClassName;
                String _plus_1 = _plus + "Runner.h";
                this.fileIO.generateFile("generating SubSystemRunner declaration", _plus_1, this.generateHeaderFile(root, ssi));
                String _cppClassName_1 = this._cppExtensions.getCppClassName(nr, ssi);
                String _plus_2 = filepath + _cppClassName_1;
                String _plus_3 = _plus_2 + "Runner.cpp";
                this.fileIO.generateFile("generating SubSystemRunner implementation", _plus_3, this.generateSourceFile(root, ssi));
            }
        }
    }

    public CharSequence generateHeaderFile(Root root, SubSystemInstance ssc) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._cppExtensions.getCppClassName(nr, ssc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* this class contains the main function running component ");
        String _name = ssc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* it instantiates ");
        String _name_1 = ssc.getName();
        _builder.append(_name_1, " ");
        _builder.append(" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin((RoomClass)cc, "Runner");
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/modelbase/SubSystemRunnerBase.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        _builder.append(clsname + "Runner");
        _builder.append(" : public etRuntime::SubSystemRunnerBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd((RoomClass)cc, "Runner");
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance ssc) {
        StringConcatenation _xblockexpression = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._cppExtensions.getCppClassName(nr, ssc);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* this class contains the main function running component ");
        String _name = ssc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* it instantiates ");
        String _name_1 = ssc.getName();
        _builder.append(_name_1, " ");
        _builder.append(" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        _builder.append(clsname);
        _builder.append("Runner.h\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        _builder.append(clsname);
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"common/modelbase/RTSystem.h\"");
        _builder.newLine();
        _builder.append("#include \"common/containers/String.h\"");
        _builder.newLine();
        _builder.append("#include \"common/containers/Vector.h\"");
        _builder.newLine();
        _builder.append("#include \"common/containers/Set.h\"");
        _builder.newLine();
        _builder.append("#include \"common/containers/Map.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        String _mainMethodName = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        _builder.append(_mainMethodName, " ");
        _builder.append(" function");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* creates components and starts and stops the lifecycle");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("int ");
        String _mainMethodName_1 = this._generatorOptionsHelper.getMainMethodName(Main.getSettings());
        _builder.append(_mainMethodName_1);
        _builder.append("(int argc, char* argv[]) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// instantiate the main component");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("RTSystem* sys = ");
        EObject _eContainer = ssc.eContainer();
        if (_eContainer instanceof SystemInstance) {
            _builder.append("new RTSystem(\"");
            EObject _eContainer_1 = ssc.eContainer();
            String _name_2 = ((SystemInstance)_eContainer_1).getName();
            _builder.append(_name_2, "\t");
            _builder.append("\")");
        } else {
            _builder.append("0");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("* main_component = new ");
        _builder.append(clsname, "\t");
        _builder.append("(sys, \"");
        String _name_3 = ssc.getName();
        _builder.append(_name_3, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append(clsname, "\t");
        _builder.append("Runner::run(*main_component, argc, argv);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//delete sys;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("printf(\"String allocations %d and deallocations %d\\n\", etRuntime::String::getNAllocations(), etRuntime::String::getNDeallocations());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("printf(\"String creations %d and destructions %d\\n\", etRuntime::String::getNCreated(), etRuntime::String::getNDestroyed());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("printf(\"Vector allocations %d and deallocations %d\\n\", etRuntime::VectorStats::getNAllocations(), etRuntime::VectorStats::getNDeallocations());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("printf(\"Vector creations %d and destructions %d\\n\", etRuntime::VectorStats::getNCreated(), etRuntime::VectorStats::getNDestroyed());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("printf(\"Set creations %d and destructions %d\\n\", etRuntime::SetStats::getNCreated(), etRuntime::SetStats::getNDestroyed());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("printf(\"Map creations %d and destructions %d\\n\", etRuntime::MapStats::getNCreated(), etRuntime::MapStats::getNDestroyed());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fflush(stdout);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

