/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private Initialization initHelper;
    @Inject
    private IDiagnostician diagnostician;

    public void doGenerate(Root root) {
        Functions.Function1 _function = it -> {
            boolean _isDeprecatedGeneration = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !_isDeprecatedGeneration;
        };
        Consumer<ProtocolClass> _function_1 = pc -> {
            String path = this.roomExt.getPath((RoomClass)pc);
            CommunicationType _commType = pc.getCommType();
            if (_commType != null) {
                switch (_commType) {
                    case EVENT_DRIVEN: {
                        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)pc);
                        String _plus = path + _cppHeaderFileName;
                        this.fileIO.generateFile("generating ProtocolClass declaration", _plus, this.generateHeaderFile(root, (ProtocolClass)pc));
                        String _cppSourceFileName = this.stdExt.getCppSourceFileName((RoomClass)pc);
                        String _plus_1 = path + _cppSourceFileName;
                        this.fileIO.generateFile("generating ProtocolClass implementation", _plus_1, this.generateSourceFile(root, (ProtocolClass)pc));
                        break;
                    }
                    case DATA_DRIVEN: {
                        String _cppHeaderFileName_1 = this.stdExt.getCppHeaderFileName((RoomClass)pc);
                        String _plus_2 = path + _cppHeaderFileName_1;
                        this.fileIO.generateFile("generating ProtocolClass declaration", _plus_2, this.generateDataDrivenHeaderFile(root, (ProtocolClass)pc));
                        String _cppSourceFileName_1 = this.stdExt.getCppSourceFileName((RoomClass)pc);
                        String _plus_3 = path + _cppSourceFileName_1;
                        this.fileIO.generateFile("generating ProtocolClass implementation", _plus_3, this.generateDataDrivenSourceFile(root, (ProtocolClass)pc));
                        break;
                    }
                    case SYNCHRONOUS: {
                        this.diagnostician.error("synchronous protocols not supported yet", (EObject)pc, null);
                        break;
                    }
                }
            }
        };
        IterableExtensions.filter((Iterable)root.getProtocolClasses(), (Functions.Function1)_function).forEach(_function_1);
    }

    protected CharSequence generateHeaderFile(Root root, ProtocolClass pc) {
        boolean _equals_1;
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin((RoomClass)pc, "");
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/PortBase.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/ReplicatedInterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/ReplicatedPortBase.h\"");
        _builder.newLine();
        _builder.append("#include \"common/etDatatypesCpp.hpp\"");
        _builder.newLine();
        _builder.newLine();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)pc);
        for (DataClass dataClass : _referencedDataClasses) {
            _builder.append("#include \"");
            String _path = this.roomExt.getPath((RoomClass)dataClass);
            _builder.append(_path);
            String _name_1 = dataClass.getName();
            _builder.append(_name_1);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(pc.getUserCode1());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _name_2 = pc.getName();
        _builder.append(_name_2);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("   ");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* message IDs */");
        _builder.newLine();
        _builder.append("\t\t");
        String _genMessageIDs = this.genMessageIDs(pc);
        _builder.append(_genMessageIDs, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _userCode_1 = this.helpers.userCode(pc, 2);
        _builder.append((Object)_userCode_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static bool isValidEvtID(int evtId) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ((MSG_MIN < evtId) && (evtId < MSG_MAX));");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static bool isValidOutgoingEvtID(int evtId) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ((MSG_MIN < evtId) && (evtId < ");
        int _size = pc.getIncomingMessages().size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            _builder.append("MSG_MAX");
        } else {
            _builder.append("IN_");
            String _name_3 = ((Message)pc.getIncomingMessages().get(0)).getName();
            _builder.append(_name_3, "\t\t\t");
        }
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static bool isValidIncomingEvtID(int evtId) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ((");
        int _size_1 = pc.getIncomingMessages().size();
        boolean bl2 = _equals_1 = _size_1 == 0;
        if (_equals_1) {
            _builder.append("MSG_MAX");
        } else {
            _builder.append("IN_");
            String _name_4 = ((Message)pc.getIncomingMessages().get(0)).getName();
            _builder.append(_name_4, "\t\t\t");
        }
        _builder.append(" <= evtId) && (evtId < MSG_MAX));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static const etRuntime::String& getMessageString(int msg_id);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static const etRuntime::String s_messageStrings[];");
        _builder.newLine();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        CharSequence _portClassDeclaration = this.portClassDeclaration(pc, false);
        _builder.append((Object)_portClassDeclaration);
        _builder.newLineIfNotEmpty();
        CharSequence _portClassDeclaration_1 = this.portClassDeclaration(pc, true);
        _builder.append((Object)_portClassDeclaration_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd((RoomClass)pc, "");
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence portClassDeclaration(ProtocolClass pc, boolean conj) {
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this.roomExt.getPortClass(pc, conj);
        String portClassName = this.roomExt.getPortClassName(pc, conj);
        String replPortClassName = this.roomExt.getPortClassName(pc, conj, true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("// ");
        if (conj) {
            _builder.append("conjugated ");
        }
        _builder.append("port class");
        _builder.newLineIfNotEmpty();
        _builder.append("//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("class ");
        _builder.append(portClassName);
        _builder.append(" : public etRuntime::PortBase {");
        _builder.newLineIfNotEmpty();
        if (pclass != null) {
            _builder.append("\t");
            CharSequence _userCode = this.helpers.userCode(pclass.getUserCode());
            _builder.append((Object)_userCode, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("   ");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append(portClassName, "\t ");
        _builder.append("(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t ");
        _builder.append(portClassName, "\t ");
        _builder.append("(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId, int idx);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.append("\t");
            _builder.append("virtual void destroy();");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("virtual void receive(const etRuntime::Message* m);");
        _builder.newLine();
        _builder.newLine();
        if (pclass != null) {
            _builder.append("\t");
            CharSequence _attributes = this.helpers.attributes((List)pclass.getAttributes());
            _builder.append((Object)_attributes, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _operationsDeclaration = this.helpers.operationsDeclaration((List)pclass.getOperations(), portClassName);
            _builder.append((Object)_operationsDeclaration, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("// sent messages");
        _builder.newLine();
        List _allMessages = this._roomHelpers.getAllMessages(pc, conj);
        for (Message m : _allMessages) {
            _builder.append("\t");
            CharSequence _messageSignature = this.messageSignature(m, false);
            _builder.append((Object)_messageSignature, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _messageSignature_1 = this.messageSignature(m, true);
            _builder.append((Object)_messageSignature_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("// ");
        if (conj) {
            _builder.append("conjugated ");
        }
        _builder.append("replicated port class");
        _builder.newLineIfNotEmpty();
        _builder.append("//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("class ");
        _builder.append(replPortClassName);
        _builder.append(" : public etRuntime::ReplicatedPortBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(replPortClassName, "\t\t");
        _builder.append("(etRuntime::IInterfaceItemOwner* actor, const etRuntime::String& name, int localId);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int getReplication() const { return getNInterfaceItems(); }");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int getIndexOf(const etRuntime::InterfaceItemBase& ifitem) const { return ifitem.getIdx(); }");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(portClassName, "\t\t");
        _builder.append("& get(int idx) const { return *dynamic_cast<");
        _builder.append(portClassName, "\t\t");
        _builder.append("*>(getInterfaceItem(idx)); }");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (conj) {
            _builder.append("\t\t");
            _builder.append("// incoming messages");
            _builder.newLine();
            List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message m_1 : _allIncomingMessages) {
                _builder.append("\t\t");
                CharSequence _messageSignature_2 = this.messageSignature(m_1, false);
                _builder.append((Object)_messageSignature_2, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append("\t\t");
            _builder.append("// outgoing messages");
            _builder.newLine();
            List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message m_2 : _allOutgoingMessages) {
                _builder.append("\t\t");
                CharSequence _messageSignature_3 = this.messageSignature(m_2, false);
                _builder.append((Object)_messageSignature_3, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("virtual etRuntime::InterfaceItemBase* createInterfaceItem(etRuntime::IInterfaceItemOwner* rcv, const etRuntime::String& name, int lid, int idx) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return new ");
        _builder.append(portClassName, "\t\t\t");
        _builder.append("(rcv, name, lid, idx);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateSourceFile(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)pc);
        _builder.append(_cppHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append("#include \"common/debugging/MSCFunctionObject.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/AbstractMessageReceiver.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/Address.h\"");
        _builder.newLine();
        _builder.append("#include \"common/messaging/Message.h\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/IEventReceiver.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(pc, 3);
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* message names as strings for debugging (generate MSC) */");
        _builder.newLine();
        _builder.append("const String ");
        String _name_1 = pc.getName();
        _builder.append(_name_1);
        _builder.append("::s_messageStrings[] = {\"MIN\", ");
        List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
        for (Message m : _allOutgoingMessages) {
            _builder.append("\"");
            String _name_2 = m.getName();
            _builder.append(_name_2);
            _builder.append("\",");
        }
        _builder.append(" ");
        List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
        for (Message m_1 : _allIncomingMessages) {
            _builder.append("\"");
            String _name_3 = m_1.getName();
            _builder.append(_name_3);
            _builder.append("\",");
        }
        _builder.append("\"MAX\"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("const String& ");
        String _name_4 = pc.getName();
        _builder.append(_name_4);
        _builder.append("::getMessageString(int msg_id) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if ((MSG_MIN < msg_id ) && ( msg_id < MSG_MAX )) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return s_messageStrings[msg_id];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// id out of range");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static const String errorMsg = \"Message ID out of range\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return errorMsg;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _portClassImplementation = this.portClassImplementation(pc, false);
        _builder.append((Object)_portClassImplementation);
        _builder.newLineIfNotEmpty();
        CharSequence _portClassImplementation_1 = this.portClassImplementation(pc, true);
        _builder.append((Object)_portClassImplementation_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    protected CharSequence portClassImplementation(ProtocolClass pc, boolean conj) {
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this.roomExt.getPortClass(pc, conj);
        String portClassName = this.roomExt.getPortClassName(pc, conj);
        String replPortClassName = this.roomExt.getPortClassName(pc, conj, true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("// ");
        if (conj) {
            _builder.append("conjugated ");
        }
        _builder.append("port class");
        _builder.newLineIfNotEmpty();
        _builder.append("//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append(portClassName);
        _builder.append("::");
        _builder.append(portClassName);
        _builder.append("(IInterfaceItemOwner* actor, const String& name, int localId)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateConstructorInitalizerList = this.generateConstructorInitalizerList(pclass, "0");
        _builder.append((Object)_generateConstructorInitalizerList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append(portClassName);
        _builder.append("::");
        _builder.append(portClassName);
        _builder.append("(IInterfaceItemOwner* actor, const String& name, int localId, int idx)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateConstructorInitalizerList_1 = this.generateConstructorInitalizerList(pclass, "idx");
        _builder.append((Object)_generateConstructorInitalizerList_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        if (pclass != null) {
            CharSequence _genExtraInitializers = this.initHelper.genExtraInitializers((Iterable<Attribute>)pclass.getAttributes());
            _builder.append((Object)_genExtraInitializers, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder.newLine();
            _builder.append("void ");
            _builder.append(portClassName);
            _builder.append("::destroy() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("DebuggingService::getInstance().removePortInstance(*this);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("PortBase::destroy();");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("void ");
        _builder.append(portClassName);
        _builder.append("::receive(const Message* msg) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// TODO JH further");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (! ");
        String _name = pc.getName();
        _builder.append(_name, "\t");
        _builder.append("::");
        if (conj) {
            _builder.append("isValidOutgoingEvtID");
        } else {
            _builder.append("isValidIncomingEvtID");
        }
        _builder.append("(msg->getEvtId())) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("//std::cout << \"unknown\" << std::endl;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _isGenerateMSCInstrumentation_1 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation_1) {
            _builder.append("\t");
            _builder.append("DebuggingService::getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), ");
            String _name_1 = pc.getName();
            _builder.append(_name_1, "\t");
            _builder.append("::getMessageString(msg->getEvtId()).c_str());");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _handlesReceive = this.roomExt.handlesReceive(pc, conj);
        if (_handlesReceive) {
            _builder.append("\t");
            _builder.append("switch (msg->getEvtId()) {");
            _builder.newLine();
            List _receiveHandlers = this.roomExt.getReceiveHandlers(pc, conj);
            for (MessageHandler hdlr : _receiveHandlers) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("case ");
                String _name_2 = pc.getName();
                _builder.append(_name_2, "\t\t");
                _builder.append("::");
                String _codeName = this.roomExt.getCodeName(hdlr.getMsg());
                _builder.append(_codeName, "\t\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("{");
                _builder.newLine();
                EList _lines = hdlr.getDetailCode().getLines();
                for (String command : _lines) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append(command, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("default:");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("getActor()->receiveEvent(this, msg->getEvtId(),\tmsg->getData());");
        _builder.newLine();
        boolean _handlesReceive_1 = this.roomExt.handlesReceive(pc, conj);
        if (_handlesReceive_1) {
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        if (pclass != null) {
            CharSequence _operationsImplementation = this.helpers.operationsImplementation((List)pclass.getOperations(), portClassName);
            _builder.append((Object)_operationsImplementation);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("// sent messages");
        _builder.newLine();
        List _allMessages = this._roomHelpers.getAllMessages(pc, conj);
        for (Message m : _allMessages) {
            CharSequence _sendMessage = this.sendMessage(m, pc.getName(), portClassName, conj);
            _builder.append((Object)_sendMessage);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append("// ");
        if (conj) {
            _builder.append("conjugated ");
        }
        _builder.append("replicated port class");
        _builder.newLineIfNotEmpty();
        _builder.append("//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append(replPortClassName);
        _builder.append("::");
        _builder.append(replPortClassName);
        _builder.append("(IInterfaceItemOwner* actor, const String& name, int localId) :");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("ReplicatedPortBase(actor, name, localId)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        if (conj) {
            _builder.append("// incoming messages");
            _builder.newLine();
            List _allIncomingMessages = this._roomHelpers.getAllIncomingMessages(pc);
            for (Message m_1 : _allIncomingMessages) {
                CharSequence _messageSignatureDefinition = this.messageSignatureDefinition(m_1, replPortClassName, false);
                _builder.append((Object)_messageSignatureDefinition);
                _builder.append("{");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("for (Vector<etRuntime::InterfaceItemBase*>::iterator it = getItems().begin(); it != getItems().end(); ++it) {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("(dynamic_cast<");
                _builder.append(portClassName, "\t\t");
                _builder.append("*>(*it))->");
                CharSequence _messageCall = this.messageCall(m_1, false);
                _builder.append((Object)_messageCall, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
        } else {
            _builder.append("// outgoing messages");
            _builder.newLine();
            List _allOutgoingMessages = this._roomHelpers.getAllOutgoingMessages(pc);
            for (Message m_2 : _allOutgoingMessages) {
                CharSequence _messageSignatureDefinition_1 = this.messageSignatureDefinition(m_2, replPortClassName, false);
                _builder.append((Object)_messageSignatureDefinition_1);
                _builder.append("{");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("for (Vector<etRuntime::InterfaceItemBase*>::iterator it = getItems().begin(); it != getItems().end(); ++it) {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("(dynamic_cast<");
                _builder.append(portClassName, "\t\t");
                _builder.append("*>(*it))->");
                CharSequence _messageCall_1 = this.messageCall(m_2, false);
                _builder.append((Object)_messageCall_1, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateConstructorInitalizerList(PortClass pc, String index) {
        CharSequence _xblockexpression = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("PortBase(actor, name, localId, ");
        _builder.append(index);
        _builder.append(")");
        initList.add(_builder.toString());
        if (pc != null) {
            Functions.Function1 _function = it -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name = it.getName();
                _builder_1.append(_name);
                _builder_1.append("(");
                String _initializerListValue = initHelper.getInitializerListValue((Attribute)it);
                _builder_1.append(_initializerListValue);
                _builder_1.append(")");
                return _builder_1.toString();
            };
            List _map = ListExtensions.map((List)pc.getAttributes(), (Functions.Function1)_function);
            Iterables.addAll((Collection)initList, (Iterable)_map);
        }
        _xblockexpression = initHelper.generateCtorInitializerList(initList);
        return _xblockexpression;
    }

    protected CharSequence messageCall(Message m, boolean impl) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = m.getName();
        _builder.append(_name);
        if (impl) {
            _builder.append("_impl");
        }
        _builder.append("(");
        MessageData _data = m.getData();
        boolean bl = _tripleNotEquals = _data != null;
        if (_tripleNotEquals) {
            _builder.append(" ");
            _builder.append("transitionData");
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence messageSignature(Message m, boolean impl) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        if (m.isPriv() || impl) {
            _builder.append("private:");
        } else {
            _builder.append("public:");
        }
        _builder.append(" void ");
        String _name = m.getName();
        _builder.append(_name);
        if (impl) {
            _builder.append("_impl");
        }
        _builder.append("(");
        MessageData _data = m.getData();
        boolean bl = _tripleNotEquals = _data != null;
        if (_tripleNotEquals) {
            String _typeSignature = this.stdExt.getTypeSignature(m.getData().getRefType());
            _builder.append(_typeSignature);
            _builder.append(" ");
            _builder.append("transitionData");
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence messageSignatureDefinition(Message m, String classPrefix, boolean impl) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        _builder.append(classPrefix);
        _builder.append("::");
        String _name = m.getName();
        _builder.append(_name);
        if (impl) {
            _builder.append("_impl");
        }
        _builder.append("(");
        MessageData _data = m.getData();
        boolean bl = _tripleNotEquals = _data != null;
        if (_tripleNotEquals) {
            String _typeSignature = this.stdExt.getTypeSignature(m.getData().getRefType());
            _builder.append(_typeSignature);
            _builder.append(" ");
            _builder.append("transitionData");
        }
        _builder.append(")");
        return _builder;
    }

    protected CharSequence sendMessage(Message m, String portClassName, String classPrefix, boolean conj) {
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = conj ? "IN" : "OUT";
        String dir = _xifexpression;
        MessageHandler hdlr = this.roomExt.getSendHandler(m, conj);
        String _xifexpression_1 = null;
        MessageData _data = m.getData();
        boolean bl = _tripleNotEquals = _data != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(", ");
            _builder.append("transitionData");
            _xifexpression_1 = _builder.toString();
        }
        String dataArg = _xifexpression_1;
        String _xifexpression_2 = null;
        if (m.getData() != null && !m.getData().getRefType().isRef()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("DataMessage<");
            String _typeName = this._typeHelpers.typeName(m.getData().getRefType().getType());
            _builder_1.append(_typeName);
            _builder_1.append(">");
            _xifexpression_2 = _builder_1.toString();
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Message");
            _xifexpression_2 = _builder_2.toString();
        }
        String messageType = _xifexpression_2;
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("new (buffer) ");
        _builder_3.append(messageType);
        _builder_3.append("(getPeerAddress(), ");
        _builder_3.append(portClassName);
        _builder_3.append("::");
        _builder_3.append(dir);
        _builder_3.append("_");
        String _name = m.getName();
        _builder_3.append(_name);
        String _elvis = null;
        _elvis = dataArg != null ? dataArg : "";
        _builder_3.append(_elvis);
        _builder_3.append(")");
        String message = _builder_3.toString();
        StringConcatenation _builder_4 = new StringConcatenation();
        CharSequence _messageSignatureDefinition = this.messageSignatureDefinition(m, classPrefix, false);
        _builder_4.append((Object)_messageSignatureDefinition);
        _builder_4.append(" {");
        _builder_4.newLineIfNotEmpty();
        if (hdlr != null) {
            _builder_4.append("\t");
            EList _lines = hdlr.getDetailCode().getLines();
            for (String command : _lines) {
                _builder_4.append("\t");
                _builder_4.append(command, "\t");
                _builder_4.newLineIfNotEmpty();
            }
        } else {
            _builder_4.append("\t");
            CharSequence _messageCall = this.messageCall(m, true);
            _builder_4.append((Object)_messageCall, "\t");
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
        }
        _builder_4.append("}");
        _builder_4.newLine();
        _builder_4.newLine();
        CharSequence _messageSignatureDefinition_1 = this.messageSignatureDefinition(m, classPrefix, true);
        _builder_4.append((Object)_messageSignatureDefinition_1);
        _builder_4.append(" {");
        _builder_4.newLineIfNotEmpty();
        boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (_isGenerateMSCInstrumentation) {
            _builder_4.append("\t");
            _builder_4.append("DebuggingService::getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(),");
            _builder_4.newLine();
            _builder_4.append("\t");
            _builder_4.append("\t");
            _builder_4.append(portClassName, "\t\t");
            _builder_4.append("::getMessageString(");
            _builder_4.append(portClassName, "\t\t");
            _builder_4.append("::");
            _builder_4.append(dir, "\t\t");
            _builder_4.append("_");
            String _name_1 = m.getName();
            _builder_4.append(_name_1, "\t\t");
            _builder_4.append(").c_str());");
            _builder_4.newLineIfNotEmpty();
        }
        _builder_4.append("\t");
        _builder_4.append("if (getPeerAddress().isValid()) {");
        _builder_4.newLine();
        _builder_4.append("\t\t");
        _builder_4.append("Message* buffer = dynamic_cast<IMessageService*>(getPeerMsgReceiver())->getMessageBuffer(sizeof(");
        _builder_4.append(messageType, "\t\t");
        _builder_4.append("));");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("if (buffer) {");
        _builder_4.newLine();
        _builder_4.append("\t\t\t");
        _builder_4.append("getPeerMsgReceiver()->receive(");
        _builder_4.append(message, "\t\t\t");
        _builder_4.append(");");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("}");
        _builder_4.newLine();
        _builder_4.append("\t");
        _builder_4.append("}");
        _builder_4.newLine();
        _builder_4.append("}");
        _builder_4.newLine();
        _xblockexpression = _builder_4;
        return _xblockexpression;
    }

    protected CharSequence generateDataDrivenHeaderFile(Root root, ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = m -> {
            MessageData _data = m.getData();
            return _data != null;
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Header File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin((RoomClass)pc, "");
        _builder.append((Object)_generateIncludeGuardBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"common/etDatatypesCpp.hpp\"");
        _builder.newLine();
        _builder.append("#include \"common/modelbase/DataPort.h\"");
        _builder.newLine();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)pc);
        for (DataClass dataClass : _referencedDataClasses) {
            _builder.append("#include \"");
            String _path = this.roomExt.getPath((RoomClass)dataClass);
            _builder.append(_path);
            String _name_1 = dataClass.getName();
            _builder.append(_name_1);
            _builder.append(".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(pc.getUserCode1());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _name_2 = pc.getName();
        _builder.append(_name_2);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _userCode_1 = this.helpers.userCode(pc.getUserCode2());
        _builder.append((Object)_userCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// send port holds data");
        _builder.newLine();
        _builder.append("class ");
        String _portClassName = this.roomExt.getPortClassName(pc, true);
        _builder.append(_portClassName);
        _builder.append(" : public etRuntime::DataSendPort {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _portClassName_1 = this.roomExt.getPortClassName(pc, true);
        _builder.append(_portClassName_1, "\t");
        _builder.append("(etRuntime::IRTObject* parent, const etRuntime::String& name, int localId);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// getters and setters");
        _builder.newLine();
        for (Message msg : sentMsgs) {
            _builder.append("\t");
            _builder.append("void ");
            String _name_3 = msg.getName();
            _builder.append(_name_3, "\t");
            _builder.append("(");
            String _typeName = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            _builder.append(_typeName, "\t");
            _builder.append(" ");
            String _name_4 = msg.getName();
            _builder.append(_name_4, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("m_");
            String _name_5 = msg.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append(" = ");
            String _name_6 = msg.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            String _typeName_1 = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            _builder.append(_typeName_1, "\t");
            _builder.append(" ");
            String _name_7 = msg.getName();
            _builder.append(_name_7, "\t");
            _builder.append("() const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return m_");
            String _name_8 = msg.getName();
            _builder.append(_name_8, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        for (Message msg_1 : sentMsgs) {
            _builder.append("\t");
            String _typeName_2 = this._typeHelpers.typeName(msg_1.getData().getRefType().getType());
            _builder.append(_typeName_2, "\t");
            _builder.append(" m_");
            String _name_9 = msg_1.getName();
            _builder.append(_name_9, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// receive port accesses send port");
        _builder.newLine();
        _builder.append("class ");
        String _portClassName_2 = this.roomExt.getPortClassName(pc, false);
        _builder.append(_portClassName_2);
        _builder.append(" : public etRuntime::DataReceivePort {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _portClassName_3 = this.roomExt.getPortClassName(pc, false);
        _builder.append(_portClassName_3, "\t");
        _builder.append("(etRuntime::IRTObject* parent, const etRuntime::String& name, int localId);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// getters");
        _builder.newLine();
        for (Message msg_2 : sentMsgs) {
            _builder.append("\t");
            String _typeName_3 = this._typeHelpers.typeName(msg_2.getData().getRefType().getType());
            _builder.append(_typeName_3, "\t");
            _builder.append(" ");
            String _name_10 = msg_2.getName();
            _builder.append(_name_10, "\t");
            _builder.append("() const;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void connect(etRuntime::DataSendPort* dataSendPort);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t");
        String _portClassName_4 = this.roomExt.getPortClassName(pc, true);
        _builder.append(_portClassName_4, "\t");
        _builder.append("* m_peer;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd((RoomClass)pc, "");
        _builder.append((Object)_generateIncludeGuardEnd);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateDataDrivenSourceFile(Root root, ProtocolClass pc) {
        StringConcatenation _xblockexpression = null;
        Functions.Function1 _function = m -> {
            MessageData _data = m.getData();
            return _data != null;
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author generated by eTrice");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Source File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"");
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)pc);
        _builder.append(_cppHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("using namespace etRuntime;");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceBegin = this.stdExt.generateNamespaceBegin((RoomClass)pc);
        _builder.append(_generateNamespaceBegin);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _userCode = this.helpers.userCode(pc.getUserCode3());
        _builder.append((Object)_userCode);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// send port holds data");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// constructor");
        _builder.newLine();
        String _portClassName = this.roomExt.getPortClassName(pc, true);
        _builder.append(_portClassName);
        _builder.append("::");
        String _portClassName_1 = this.roomExt.getPortClassName(pc, true);
        _builder.append(_portClassName_1);
        _builder.append("(IRTObject* parent, const String& name, int localId) :");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("DataSendPort(parent, name, localId)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// receive port accesses send port");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// constructor");
        _builder.newLine();
        String _portClassName_2 = this.roomExt.getPortClassName(pc, false);
        _builder.append(_portClassName_2);
        _builder.append("::");
        String _portClassName_3 = this.roomExt.getPortClassName(pc, false);
        _builder.append(_portClassName_3);
        _builder.append("(IRTObject* parent, const String& name, int localId) :");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("DataReceivePort(parent, name, localId),");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("m_peer(0)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// getters");
        _builder.newLine();
        for (Message msg : sentMsgs) {
            String _typeName = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            _builder.append(_typeName);
            _builder.append(" ");
            String _portClassName_4 = this.roomExt.getPortClassName(pc, false);
            _builder.append(_portClassName_4);
            _builder.append("::");
            String _name_1 = msg.getName();
            _builder.append(_name_1);
            _builder.append("() const {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("// TODO needs default value");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//if (m_peer == 0)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/*\treturn ");
            String _defaultValue = this.stdExt.defaultValue(msg.getData().getRefType().getType());
            _builder.append(_defaultValue, "\t");
            _builder.append("; */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return m_peer->");
            String _name_2 = msg.getName();
            _builder.append(_name_2, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("void ");
        String _portClassName_5 = this.roomExt.getPortClassName(pc, false);
        _builder.append(_portClassName_5);
        _builder.append("::connect(DataSendPort* dataSendPort) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _portClassName_6 = this.roomExt.getPortClassName(pc, true);
        _builder.append(_portClassName_6, "\t");
        _builder.append("* peer = dynamic_cast<");
        String _portClassName_7 = this.roomExt.getPortClassName(pc, true);
        _builder.append(_portClassName_7, "\t");
        _builder.append("*>(dataSendPort);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (peer != 0)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("m_peer = peer;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        String _generateNamespaceEnd = this.stdExt.generateNamespaceEnd((RoomClass)pc);
        _builder.append(_generateNamespaceEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String getMessageID(Message msg, InterfaceItem item) {
        if (item instanceof Port) {
            String _xifexpression = null;
            boolean _isConjugated = ((Port)item).isConjugated();
            _xifexpression = _isConjugated ? "OUT_" : "IN_";
            String direction = _xifexpression;
            String _name = ((Port)item).getProtocol().getName();
            String _name_1 = msg.getName();
            String _plus = direction + _name_1;
            return this.enumInUse(_name, _plus);
        }
        if (item instanceof SAP) {
            String _name_2 = ((SAP)item).getProtocol().getName();
            String _name_3 = msg.getName();
            String _plus_1 = "OUT_" + _name_3;
            return this.enumInUse(_name_2, _plus_1);
        }
        if (item instanceof SPP) {
            String _name_4 = ((SPP)item).getProtocol().getName();
            String _name_5 = msg.getName();
            String _plus_2 = "IN_" + _name_5;
            return this.enumInUse(_name_4, _plus_2);
        }
        return "unknown interface item";
    }

    protected String enumInUse(String namespace, String member) {
        return namespace + "::" + member;
    }
}

