/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    private final NodeComparator nodeComparator = new NodeComparator();

    public CharSequence genExtra(GraphContainer gc, boolean generateImplementation) {
        StringConcatenation _xblockexpression = null;
        ModelComponent ac = gc.getComponent();
        String clsName = ac.getComponentName();
        List orderedStateNodes = IterableExtensions.sortWith((Iterable)IteratorExtensions.toList((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph())), (Comparator)this.nodeComparator);
        StringConcatenation _xifexpression = null;
        if (generateImplementation) {
            boolean _isGenerateWithVerboseOutput;
            StringConcatenation _builder = new StringConcatenation();
            if (this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) || this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
                _builder.append("// state names");
                _builder.newLine();
                _builder.append("const String ");
                _builder.append(clsName);
                _builder.append("::s_stateStrings[] = {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\"<no state>\",");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\"<top>\",");
                _builder.newLine();
                boolean _hasElements = false;
                for (Node state : orderedStateNodes) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)",", "\t");
                    }
                    _builder.append("\t");
                    _builder.append("\"");
                    StateGraphNode _stateGraphNode = state.getStateGraphNode();
                    String _genStatePathName = this._codegenHelpers.getGenStatePathName((State)_stateGraphNode);
                    _builder.append(_genStatePathName, "\t");
                    _builder.append("\"");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("};");
                _builder.newLine();
            }
            _builder.append("const int ");
            _builder.append(clsName);
            _builder.append("::s_numberOfStates = ");
            int _size = orderedStateNodes.size();
            int _plus = 2 + _size;
            _builder.append((Object)_plus);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("void ");
            _builder.append(clsName);
            _builder.append("::setState(int new_state) {");
            _builder.newLineIfNotEmpty();
            boolean _isGenerateMSCInstrumentation = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (_isGenerateMSCInstrumentation) {
                _builder.append("\t");
                _builder.append("DebuggingService::getInstance().addActorState(*this, s_stateStrings[new_state].c_str());");
                _builder.newLine();
            }
            if (_isGenerateWithVerboseOutput = this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
                _builder.append("\t");
                _builder.append("if (s_stateStrings[new_state] != \"Idle\") {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::cout << getInstancePath().c_str() << \" -> \" << s_stateStrings[new_state].c_str() << std::endl;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("m_state = new_state;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            if (this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) || this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
                _builder_1.append("static const String s_stateStrings[];");
                _builder_1.newLine();
            }
            _builder_1.append("static const int s_numberOfStates;");
            _builder_1.newLine();
            _builder_1.newLine();
            _builder_1.append("int history[");
            int _size_1 = orderedStateNodes.size();
            int _plus_1 = 2 + _size_1;
            _builder_1.append((Object)_plus_1);
            _builder_1.append("];");
            _builder_1.newLineIfNotEmpty();
            _builder_1.newLine();
            _builder_1.append("void setState(int new_state);");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String stateType() {
        return "etInt16";
    }

    public String boolType() {
        return "etBool";
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            int _inheritanceLevel_1;
            boolean _equals;
            int _inheritanceLevel = o1.getInheritanceLevel();
            boolean bl = _equals = _inheritanceLevel == (_inheritanceLevel_1 = o2.getInheritanceLevel());
            if (_equals) {
                if (FsmGenExtensions.isLeaf((Node)o1) && FsmGenExtensions.isLeaf((Node)o2)) {
                    return 0;
                }
                boolean _isLeaf = FsmGenExtensions.isLeaf((Node)o1);
                if (_isLeaf) {
                    return 1;
                }
                boolean _isLeaf_1 = FsmGenExtensions.isLeaf((Node)o2);
                if (_isLeaf_1) {
                    return -1;
                }
                return 0;
            }
            return Integer.compare(o1.getInheritanceLevel(), o1.getInheritanceLevel());
        }
    }
}

