/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.fsm;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.SimpleState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionBase;
import org.eclipse.etrice.core.fsm.util.FSMHelpers;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.FsmGenFactory;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class BasicFsmGenBuilder {
    @Extension
    protected FSMHelpers fsmHelpers;
    protected final FsmGenFactory factory = FsmGenFactory.eINSTANCE;
    private int inheritanceLevel = 0;
    private final HashMap<ArrayList<?>, GraphContainer> _createCache_createContainer = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Graph> _createCache_createGraph = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Link> _createCache_createLink = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Node> _createCache_createNode = CollectionLiterals.newHashMap();

    public BasicFsmGenBuilder(FSMHelpers fsmHelpers) {
        this.fsmHelpers = fsmHelpers;
    }

    public GraphContainer createTransformedModel(ModelComponent mc) {
        return this.createContainer(mc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphContainer createContainer(ModelComponent mc) {
        GraphContainer _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ModelComponent[]{mc});
        HashMap<ArrayList<?>, GraphContainer> hashMap = this._createCache_createContainer;
        synchronized (hashMap) {
            GraphContainer _createGraphContainer;
            if (this._createCache_createContainer.containsKey(_cacheKey)) {
                return this._createCache_createContainer.get(_cacheKey);
            }
            _result = _createGraphContainer = this.factory.createGraphContainer();
            this._createCache_createContainer.put(_cacheKey, _result);
        }
        this._init_createContainer(_result, mc);
        return _result;
    }

    private void _init_createContainer(GraphContainer it, ModelComponent mc) {
        it.setComponent(mc);
        it.setGraph(this.createStateMachine(mc));
    }

    private Graph createStateMachine(ModelComponent mc) {
        Graph _xblockexpression = null;
        StateGraph superFSM = this.fsmHelpers.getSuperStateMachine(mc);
        Graph _xifexpression = null;
        if (superFSM != null) {
            Graph _xblockexpression_1 = null;
            Graph baseGraph = this.createStateMachine(this.fsmHelpers.getModelComponent((EObject)superFSM));
            ++this.inheritanceLevel;
            _xifexpression = _xblockexpression_1 = this.mergeGraph(baseGraph, this.fsmHelpers.getActualStateMachine(mc));
        } else {
            boolean _tripleNotEquals;
            Graph _xifexpression_1 = null;
            StateGraph _actualStateMachine = this.fsmHelpers.getActualStateMachine(mc);
            boolean bl = _tripleNotEquals = _actualStateMachine != null;
            if (_tripleNotEquals) {
                StateGraph _actualStateMachine_1 = this.fsmHelpers.getActualStateMachine(mc);
                Graph _createGraph = null;
                if (_actualStateMachine_1 != null) {
                    _createGraph = this.createGraph(_actualStateMachine_1);
                }
                _xifexpression_1 = _createGraph;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private Graph mergeGraph(Graph graph, StateGraph sg) {
        Consumer<Node> _function = it -> it.setInherited(true);
        graph.getNodes().forEach(_function);
        Consumer<Link> _function_1 = it -> it.setInherited(true);
        graph.getLinks().forEach(_function_1);
        this.createContents(graph, sg);
        graph.setStateGraph(sg);
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph createGraph(StateGraph sg) {
        Graph _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new StateGraph[]{sg});
        HashMap<ArrayList<?>, Graph> hashMap = this._createCache_createGraph;
        synchronized (hashMap) {
            Graph _createGraph;
            if (this._createCache_createGraph.containsKey(_cacheKey)) {
                return this._createCache_createGraph.get(_cacheKey);
            }
            _result = _createGraph = this.factory.createGraph();
            this._createCache_createGraph.put(_cacheKey, _result);
        }
        this._init_createGraph(_result, sg);
        return _result;
    }

    private void _init_createGraph(Graph it, StateGraph sg) {
        it.setStateGraph(sg);
        this.createContents(it, sg);
    }

    private void createContents(Graph graph, StateGraph sg) {
        Functions.Function1 _function = it -> this.createNode((EObject)it);
        graph.getNodes().addAll((Collection)ListExtensions.map((List)sg.getChPoints(), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> this.createNode((EObject)it);
        graph.getNodes().addAll((Collection)ListExtensions.map((List)sg.getTrPoints(), (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> this.createNode((EObject)it);
        Iterables.addAll(graph.getNodes(), (Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)sg.getStates(), SimpleState.class), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> this.createLink((Transition)it);
        graph.getLinks().addAll((Collection)ListExtensions.map((List)sg.getTransitions(), (Functions.Function1)_function_3));
        Consumer<RefinedState> _function_4 = it -> this.handleRefinedState((RefinedState)it);
        Iterables.filter((Iterable)sg.getStates(), RefinedState.class).forEach(_function_4);
        Consumer<RefinedTransition> _function_5 = it -> this.handleRefinedTransition((RefinedTransition)it);
        sg.getRefinedTransitions().forEach(_function_5);
    }

    private void handleRefinedState(RefinedState s) {
        boolean _tripleNotEquals;
        Node refinedNode = this.createNode((EObject)this.fsmHelpers.getFinalTarget(s));
        StateGraph _subgraph = s.getSubgraph();
        boolean bl = _tripleNotEquals = _subgraph != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            Graph _subgraph_1 = refinedNode.getSubgraph();
            boolean bl2 = _tripleNotEquals_1 = _subgraph_1 != null;
            if (_tripleNotEquals_1) {
                this.mergeGraph(refinedNode.getSubgraph(), s.getSubgraph());
            } else {
                refinedNode.setSubgraph(this.createGraph(s.getSubgraph()));
            }
        }
        Node target = refinedNode;
        target.setStateGraphNode((StateGraphNode)s);
    }

    private void handleRefinedTransition(RefinedTransition t) {
        Link _createLink = this.createLink(t.getTarget());
        _createLink.setTransition((TransitionBase)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Link createLink(Transition tr) {
        Link _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Transition[]{tr});
        HashMap<ArrayList<?>, Link> hashMap = this._createCache_createLink;
        synchronized (hashMap) {
            Link _createLink;
            if (this._createCache_createLink.containsKey(_cacheKey)) {
                return this._createCache_createLink.get(_cacheKey);
            }
            _result = _createLink = this.factory.createLink();
            this._createCache_createLink.put(_cacheKey, _result);
        }
        this._init_createLink(_result, tr);
        return _result;
    }

    private void _init_createLink(Link it, Transition tr) {
        it.setTransition((TransitionBase)tr);
        Node _xifexpression = null;
        if (tr instanceof NonInitialTransition) {
            _xifexpression = this.createNode((EObject)((NonInitialTransition)tr).getFrom());
        }
        it.setSource(_xifexpression);
        it.setTarget(this.createNode((EObject)tr.getTo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _createNode(StateGraphNode s) {
        Node _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new StateGraphNode[]{s});
        HashMap<ArrayList<?>, Node> hashMap = this._createCache_createNode;
        synchronized (hashMap) {
            Node _createNode;
            if (this._createCache_createNode.containsKey(_cacheKey)) {
                return this._createCache_createNode.get(_cacheKey);
            }
            _result = _createNode = this.factory.createNode();
            this._createCache_createNode.put(_cacheKey, _result);
        }
        this._init_createNode(_result, s);
        return _result;
    }

    private void _init_createNode(Node it, StateGraphNode s) {
        it.setStateGraphNode(s);
        it.setInheritanceLevel(this.inheritanceLevel);
        Graph _xifexpression = null;
        if (s instanceof State) {
            StateGraph _subgraph = ((State)s).getSubgraph();
            Graph _createGraph = null;
            if (_subgraph != null) {
                _createGraph = this.createGraph(_subgraph);
            }
            _xifexpression = _createGraph;
        }
        it.setSubgraph(_xifexpression);
    }

    private Node _createNode(ChoicepointTerminal tt) {
        return this.createNode((EObject)tt.getCp());
    }

    private Node _createNode(TrPointTerminal tt) {
        return this.createNode((EObject)tt.getTrPoint());
    }

    private Node _createNode(StateTerminal tt) {
        return this.createNode((EObject)tt.getState());
    }

    private Node _createNode(SubStateTrPointTerminal tt) {
        return this.createNode((EObject)tt.getTrPoint());
    }

    private Node createNode(EObject tt) {
        if (tt instanceof ChoicepointTerminal) {
            return this._createNode((ChoicepointTerminal)tt);
        }
        if (tt instanceof StateGraphNode) {
            return this._createNode((StateGraphNode)tt);
        }
        if (tt instanceof StateTerminal) {
            return this._createNode((StateTerminal)tt);
        }
        if (tt instanceof SubStateTrPointTerminal) {
            return this._createNode((SubStateTrPointTerminal)tt);
        }
        if (tt instanceof TrPointTerminal) {
            return this._createNode((TrPointTerminal)tt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tt).toString());
    }
}

