#!/usr/bin/env sh

#
# Copyright 2015 the original author or authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

##############################################################################
##
##  org.eclipse.etrice.generator.cpp start up script for UN*X
##
##############################################################################

# Attempt to set APP_HOME
# Resolve links: $0 may be a link
PRG="$0"
# Need this for relative symlinks.
while [ -h "$PRG" ] ; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '/.*' > /dev/null; then
        PRG="$link"
    else
        PRG=`dirname "$PRG"`"/$link"
    fi
done
SAVED="`pwd`"
cd "`dirname \"$PRG\"`/.." >/dev/null
APP_HOME="`pwd -P`"
cd "$SAVED" >/dev/null

APP_NAME="org.eclipse.etrice.generator.cpp"
APP_BASE_NAME=`basename "$0"`

# Add default JVM options here. You can also use JAVA_OPTS and ORG_ECLIPSE_ETRICE_GENERATOR_CPP_OPTS to pass JVM options to this script.
DEFAULT_JVM_OPTS=""

# Use the maximum available, or set MAX_FD != -1 to use that value.
MAX_FD="maximum"

warn () {
    echo "$*"
}

die () {
    echo
    echo "$*"
    echo
    exit 1
}

# OS specific support (must be 'true' or 'false').
cygwin=false
msys=false
darwin=false
nonstop=false
case "`uname`" in
  CYGWIN* )
    cygwin=true
    ;;
  Darwin* )
    darwin=true
    ;;
  MINGW* )
    msys=true
    ;;
  NONSTOP* )
    nonstop=true
    ;;
esac

CLASSPATH=$APP_HOME/lib/org.eclipse.etrice.generator.cpp-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.generator.config-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.generator-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.core.etmap-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.core.genmodel-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.core.config-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.core.room-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.core.etphys-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.abstractexec.behavior-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.generator.fsm-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.core.genmodel.fsm-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.core.fsm-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.core.common-3.0.0.jar:$APP_HOME/lib/org.eclipse.etrice.generator.base-3.0.0.jar:$APP_HOME/lib/org.eclipse.xtext-2.15.0.jar:$APP_HOME/lib/org.eclipse.xtext.util-2.15.0.jar:$APP_HOME/lib/org.eclipse.xtend.lib-2.15.0.jar:$APP_HOME/lib/org.eclipse.core.resources-3.12.0.jar:$APP_HOME/lib/org.eclipse.core.expressions-3.6.500.jar:$APP_HOME/lib/org.eclipse.core.runtime-3.12.0.jar:$APP_HOME/lib/org.eclipse.xtend.lib.macro-2.15.0.jar:$APP_HOME/lib/org.eclipse.xtext.xbase.lib-2.15.0.jar:$APP_HOME/lib/log4j-1.2.16.jar:$APP_HOME/lib/org.eclipse.core.jobs-3.10.500.jar:$APP_HOME/lib/org.eclipse.core.contenttype-3.7.400.jar:$APP_HOME/lib/org.eclipse.equinox.app-1.4.300.jar:$APP_HOME/lib/org.eclipse.core.filesystem-1.7.500.jar:$APP_HOME/lib/org.eclipse.equinox.registry-3.8.500.jar:$APP_HOME/lib/org.eclipse.equinox.preferences-3.7.500.jar:$APP_HOME/lib/org.eclipse.equinox.common-3.9.0.jar:$APP_HOME/lib/org.eclipse.osgi-3.12.100.jar:$APP_HOME/lib/org.eclipse.emf.common-2.12.0.jar:$APP_HOME/lib/org.eclipse.emf.ecore.xmi-2.12.0.jar:$APP_HOME/lib/guice-3.0.jar:$APP_HOME/lib/antlr-runtime-3.2.jar:$APP_HOME/lib/guava-21.0.jar:$APP_HOME/lib/commons-io-2.5.jar:$APP_HOME/lib/org.eclipse.emf.ecore-2.12.0.jar:$APP_HOME/lib/javax.inject-1.jar:$APP_HOME/lib/aopalliance-1.0.jar

# Determine the Java command to use to start the JVM.
if [ -n "$JAVA_HOME" ] ; then
    if [ -x "$JAVA_HOME/jre/sh/java" ] ; then
        # IBM's JDK on AIX uses strange locations for the executables
        JAVACMD="$JAVA_HOME/jre/sh/java"
    else
        JAVACMD="$JAVA_HOME/bin/java"
    fi
    if [ ! -x "$JAVACMD" ] ; then
        die "ERROR: JAVA_HOME is set to an invalid directory: $JAVA_HOME

Please set the JAVA_HOME variable in your environment to match the
location of your Java installation."
    fi
else
    JAVACMD="java"
    which java >/dev/null 2>&1 || die "ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.

Please set the JAVA_HOME variable in your environment to match the
location of your Java installation."
fi

# Increase the maximum file descriptors if we can.
if [ "$cygwin" = "false" -a "$darwin" = "false" -a "$nonstop" = "false" ] ; then
    MAX_FD_LIMIT=`ulimit -H -n`
    if [ $? -eq 0 ] ; then
        if [ "$MAX_FD" = "maximum" -o "$MAX_FD" = "max" ] ; then
            MAX_FD="$MAX_FD_LIMIT"
        fi
        ulimit -n $MAX_FD
        if [ $? -ne 0 ] ; then
            warn "Could not set maximum file descriptor limit: $MAX_FD"
        fi
    else
        warn "Could not query maximum file descriptor limit: $MAX_FD_LIMIT"
    fi
fi

# For Darwin, add options to specify how the application appears in the dock
if $darwin; then
    GRADLE_OPTS="$GRADLE_OPTS \"-Xdock:name=$APP_NAME\" \"-Xdock:icon=$APP_HOME/media/gradle.icns\""
fi

# For Cygwin, switch paths to Windows format before running java
if $cygwin ; then
    APP_HOME=`cygpath --path --mixed "$APP_HOME"`
    CLASSPATH=`cygpath --path --mixed "$CLASSPATH"`
    JAVACMD=`cygpath --unix "$JAVACMD"`

    # We build the pattern for arguments to be converted via cygpath
    ROOTDIRSRAW=`find -L / -maxdepth 1 -mindepth 1 -type d 2>/dev/null`
    SEP=""
    for dir in $ROOTDIRSRAW ; do
        ROOTDIRS="$ROOTDIRS$SEP$dir"
        SEP="|"
    done
    OURCYGPATTERN="(^($ROOTDIRS))"
    # Add a user-defined pattern to the cygpath arguments
    if [ "$GRADLE_CYGPATTERN" != "" ] ; then
        OURCYGPATTERN="$OURCYGPATTERN|($GRADLE_CYGPATTERN)"
    fi
    # Now convert the arguments - kludge to limit ourselves to /bin/sh
    i=0
    for arg in "$@" ; do
        CHECK=`echo "$arg"|egrep -c "$OURCYGPATTERN" -`
        CHECK2=`echo "$arg"|egrep -c "^-"`                                 ### Determine if an option

        if [ $CHECK -ne 0 ] && [ $CHECK2 -eq 0 ] ; then                    ### Added a condition
            eval `echo args$i`=`cygpath --path --ignore --mixed "$arg"`
        else
            eval `echo args$i`="\"$arg\""
        fi
        i=$((i+1))
    done
    case $i in
        (0) set -- ;;
        (1) set -- "$args0" ;;
        (2) set -- "$args0" "$args1" ;;
        (3) set -- "$args0" "$args1" "$args2" ;;
        (4) set -- "$args0" "$args1" "$args2" "$args3" ;;
        (5) set -- "$args0" "$args1" "$args2" "$args3" "$args4" ;;
        (6) set -- "$args0" "$args1" "$args2" "$args3" "$args4" "$args5" ;;
        (7) set -- "$args0" "$args1" "$args2" "$args3" "$args4" "$args5" "$args6" ;;
        (8) set -- "$args0" "$args1" "$args2" "$args3" "$args4" "$args5" "$args6" "$args7" ;;
        (9) set -- "$args0" "$args1" "$args2" "$args3" "$args4" "$args5" "$args6" "$args7" "$args8" ;;
    esac
fi

# Escape application args
save () {
    for i do printf %s\\n "$i" | sed "s/'/'\\\\''/g;1s/^/'/;\$s/\$/' \\\\/" ; done
    echo " "
}
APP_ARGS=$(save "$@")

# Collect all arguments for the java command, following the shell quoting and substitution rules
eval set -- $DEFAULT_JVM_OPTS $JAVA_OPTS $ORG_ECLIPSE_ETRICE_GENERATOR_CPP_OPTS -classpath "\"$CLASSPATH\"" org.eclipse.etrice.generator.cpp.Main "$APP_ARGS"

# by default we should be in the correct project dir, but when run from Finder on Mac, the cwd is wrong
if [ "$(uname)" = "Darwin" ] && [ "$HOME" = "$PWD" ]; then
  cd "$(dirname "$0")"
fi

exec "$JAVACMD" "$@"
